/*
 * Decompiled with CFR 0.152.
 */
package er.rest;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation._NSUtilities;
import er.rest.BeanInfoClassDescription;
import er.rest.MapClassDescription;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRestClassDescriptionFactory {
    private static Map<Class<?>, EOClassDescription> _classDescriptionByClass = new ConcurrentHashMap();
    private static Map<String, Class<?>> _classByName = new ConcurrentHashMap();

    public static String _guessMismatchedCaseEntityName(String mismatchedCaseEntityName) {
        String guessedEntityName = null;
        for (EOModel model : EOModelGroup.defaultGroup().models()) {
            for (EOEntity entity : model.entities()) {
                if (!entity.name().equalsIgnoreCase(mismatchedCaseEntityName)) continue;
                guessedEntityName = entity.name();
                break;
            }
            if (guessedEntityName == null) continue;
            break;
        }
        if (guessedEntityName != null) {
            for (String entityName : _classByName.keySet()) {
                if (!entityName.equalsIgnoreCase(mismatchedCaseEntityName)) continue;
                guessedEntityName = entityName;
            }
        }
        return guessedEntityName;
    }

    public static void registerClassDescription(EOClassDescription classDescription, Class<?> clazz) {
        _classDescriptionByClass.put(clazz, classDescription);
    }

    public static EOClassDescription classDescriptionForObject(Object obj) {
        EOClassDescription classDescription;
        if (obj == null) {
            classDescription = null;
        } else if (obj instanceof EOEnterpriseObject) {
            classDescription = ERXRestClassDescriptionFactory.classDescriptionForEntityName(((EOEnterpriseObject)obj).entityName());
        } else if (obj instanceof Map) {
            classDescription = new MapClassDescription((Map)obj);
        } else {
            Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            classDescription = ERXRestClassDescriptionFactory.classDescriptionForClass(clazz, true);
            if (classDescription == null) {
                classDescription = ERXRestClassDescriptionFactory.classDescriptionForEntityName(clazz.getSimpleName());
            }
            if (classDescription == null) {
                classDescription = new BeanInfoClassDescription(clazz);
            }
        }
        return classDescription;
    }

    public static EOClassDescription classDescriptionForEntityName(String entityName) {
        Object classDescription = EOClassDescription.classDescriptionForEntityName((String)entityName);
        if (classDescription == null) {
            if (entityName == null) {
                throw new NullPointerException("You did not specify an entityName.");
            }
            Class<?> clazz = _classByName.get(entityName);
            if (clazz == null && (clazz = _NSUtilities.classWithName((String)entityName)) == null) {
                try {
                    clazz = Class.forName(entityName);
                }
                catch (ClassNotFoundException e) {
                    clazz = null;
                }
            }
            classDescription = clazz != null ? ERXRestClassDescriptionFactory.classDescriptionForClass(clazz, true) : null;
        }
        return classDescription;
    }

    public static EOClassDescription classDescriptionForClass(Class clazz, boolean forceNonEntity) {
        EOClassDescription classDescription = _classDescriptionByClass.get(clazz);
        if (classDescription == null && !forceNonEntity) {
            classDescription = ERXRestClassDescriptionFactory.classDescriptionForEntityName(clazz.getSimpleName());
        }
        if (classDescription == null) {
            classDescription = new BeanInfoClassDescription(clazz);
        }
        return classDescription;
    }

    public static EOClassDescription registerClass(Class clazz) {
        return ERXRestClassDescriptionFactory.registerClassForEntityNamed(clazz, clazz.getSimpleName());
    }

    public static EOClassDescription registerClassForEntityNamed(Class clazz, String entityName) {
        EOClassDescription classDescription = ERXRestClassDescriptionFactory.classDescriptionForClass(clazz, false);
        ERXRestClassDescriptionFactory.registerClassDescription(classDescription, clazz);
        _classByName.put(entityName, clazz);
        return classDescription;
    }
}

