/*
 * Decompiled with CFR 0.152.
 */
package er.rest.entityDelegates;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXApplication;
import er.extensions.eof.ERXEC;
import er.rest.ERXRestRequestNode;
import er.rest.entityDelegates.ERXDefaultRestDelegate;
import er.rest.entityDelegates.ERXJSONRestResponseWriter;
import er.rest.entityDelegates.ERXPListRestResponseWriter;
import er.rest.entityDelegates.ERXRestContext;
import er.rest.entityDelegates.ERXRestKey;
import er.rest.entityDelegates.ERXRestNotFoundException;
import er.rest.entityDelegates.ERXRestRequest;
import er.rest.entityDelegates.ERXRestSecurityException;
import er.rest.entityDelegates.ERXStandardRestEntityDelegate;
import er.rest.entityDelegates.ERXUnsafeReadOnlyRestEntityDelegate;
import er.rest.entityDelegates.ERXUnsafeRestAuthenticationDelegate;
import er.rest.entityDelegates.ERXUnsafeRestEntityDelegate;
import er.rest.entityDelegates.ERXXmlRestResponseWriter;
import er.rest.entityDelegates.IERXRestAuthenticationDelegate;
import er.rest.entityDelegates.IERXRestDelegate;
import er.rest.entityDelegates.IERXRestResponseWriter;
import er.rest.format.ERXRestFormatDelegate;
import er.rest.format.ERXWORestRequest;
import er.rest.format.ERXWORestResponse;
import er.rest.format.ERXXmlRestParser;
import er.rest.format.IERXRestParser;
import org.apache.log4j.Logger;

public class ERXRestRequestHandler
extends WORequestHandler {
    public static final Logger log = Logger.getLogger(ERXRestRequestHandler.class);
    public static final String Key = "rest";
    private IERXRestAuthenticationDelegate _authenticationDelegate;
    private IERXRestDelegate _delegate;
    private IERXRestResponseWriter _defaultResponseWriter;
    private IERXRestParser _defaultRequestParser;
    private NSMutableDictionary<String, IERXRestResponseWriter> _responseWriters;
    private NSMutableDictionary<String, IERXRestParser> _requestParsers;

    public ERXRestRequestHandler(IERXRestAuthenticationDelegate authenticationDelegate, IERXRestDelegate delegate) {
        this(authenticationDelegate, delegate, new ERXXmlRestResponseWriter(), new ERXXmlRestParser());
    }

    public ERXRestRequestHandler(IERXRestAuthenticationDelegate authenticationDelegate, IERXRestDelegate delegate, IERXRestResponseWriter defaultResponseWriter, IERXRestParser defaultRequestParser) {
        this._authenticationDelegate = authenticationDelegate;
        this._delegate = delegate;
        this._responseWriters = new NSMutableDictionary();
        this._requestParsers = new NSMutableDictionary();
        this._defaultResponseWriter = defaultResponseWriter;
        this._defaultRequestParser = defaultRequestParser;
    }

    public IERXRestDelegate delegate() {
        return this._delegate;
    }

    public void setResponseWriterForType(IERXRestResponseWriter responseWriter, String type) {
        this._responseWriters.setObjectForKey((Object)responseWriter, (Object)type);
    }

    public void removeResponseWriterForType(String type) {
        this._responseWriters.removeObjectForKey((Object)type);
    }

    protected IERXRestResponseWriter responseWriterForType(String type) {
        IERXRestResponseWriter responseWriter = (IERXRestResponseWriter)this._responseWriters.objectForKey((Object)type);
        if (responseWriter == null) {
            responseWriter = this._defaultResponseWriter;
        }
        return responseWriter;
    }

    public void setRequestParserForType(IERXRestParser requestParser, String type) {
        this._requestParsers.setObjectForKey((Object)requestParser, (Object)type);
    }

    public void removeRequestParserForType(String type) {
        this._requestParsers.removeObjectForKey((Object)type);
    }

    protected IERXRestParser requestParserForType(String type) {
        IERXRestParser requestParser = (IERXRestParser)this._requestParsers.objectForKey((Object)type);
        if (requestParser == null) {
            requestParser = this._defaultRequestParser;
        }
        return requestParser;
    }

    protected EOEditingContext newEditingContext() {
        return ERXEC.newEditingContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse handleRequest(WORequest request) {
        WOApplication application = WOApplication.application();
        WOContext woContext = application.createContextForRequest(request);
        WOResponse response = application.createResponseInContext(woContext);
        String path = request._uriDecomposed().requestHandlerPath();
        int dotIndex = path.lastIndexOf(46);
        String type = "xml";
        if (dotIndex >= 0) {
            type = path.substring(dotIndex + 1);
            path = path.substring(0, dotIndex);
        }
        String wosid = null;
        wosid = request.cookieValueForKey("wosid");
        woContext._setRequestSessionID(wosid);
        WOSession session = null;
        if (woContext._requestSessionID() != null) {
            session = WOApplication.application().restoreSessionWithID(wosid, woContext);
        }
        if (session != null) {
            session.awake();
        }
        try {
            if (woContext._session() != null) {
                WOSession contextSession = woContext._session();
                if (wosid == null) {
                    boolean storesIDsInCookies = contextSession.storesIDsInCookies();
                    try {
                        contextSession.setStoresIDsInCookies(true);
                        contextSession._appendCookieToResponse(response);
                    }
                    finally {
                        contextSession.setStoresIDsInCookies(storesIDsInCookies);
                    }
                } else {
                    contextSession._appendCookieToResponse(response);
                }
            }
            EOEditingContext editingContext = this.newEditingContext();
            ERXRestContext restContext = new ERXRestContext(woContext, editingContext, this._delegate);
            editingContext.lock();
            try {
                if (!this._authenticationDelegate.authenticate(restContext)) {
                    throw new ERXRestSecurityException("Authenticated failed.");
                }
                IERXRestParser requestParser = this.requestParserForType(type);
                ERXWORestRequest woRestRequest = new ERXWORestRequest(request);
                ERXRestRequestNode rootNode = requestParser.parseRestRequest(woRestRequest, new ERXRestFormatDelegate());
                ERXRestRequest restRequest = new ERXRestRequest(restContext, rootNode, path);
                String method = request.method();
                if ("GET".equalsIgnoreCase(method)) {
                    ERXRestKey responseKey = this._delegate.view(restRequest, restContext);
                    IERXRestResponseWriter restResponseWriter = this.responseWriterForType(type);
                    restResponseWriter.appendToResponse(restContext, new ERXWORestResponse(response), responseKey);
                    editingContext.saveChanges();
                } else if ("DELETE".equalsIgnoreCase(method)) {
                    this._delegate.delete(restRequest, restContext);
                    editingContext.saveChanges();
                } else if ("PUT".equalsIgnoreCase(method)) {
                    this._delegate.update(restRequest, restContext);
                    editingContext.saveChanges();
                } else if ("POST".equalsIgnoreCase(method)) {
                    ERXRestKey responseKey = this._delegate.insert(restRequest, restContext);
                    editingContext.saveChanges();
                    IERXRestResponseWriter restResponseWriter = this.responseWriterForType(type);
                    restResponseWriter.appendToResponse(restContext, new ERXWORestResponse(response), responseKey);
                    response.setStatus(201);
                }
            }
            finally {
                editingContext.unlock();
            }
            if (response != null) {
                response._finalizeInContext(woContext);
                response.disableClientCaching();
            }
        }
        catch (ERXRestNotFoundException e) {
            response.setStatus(404);
            response.setContent(e.getMessage() + "\n");
            log.error((Object)"Request failed.", (Throwable)e);
        }
        catch (ERXRestSecurityException e) {
            response.setStatus(403);
            response.setContent(e.getMessage() + "\n");
            log.error((Object)"Request failed.", (Throwable)e);
        }
        catch (Exception e) {
            response.setStatus(500);
            response.setContent(e.getMessage() + "\n");
            log.error((Object)"Request failed.", (Throwable)e);
        }
        finally {
            try {
                if (session != null) {
                    session.sleep();
                }
            }
            finally {
                if (woContext._session() != null) {
                    WOApplication.application().saveSessionForContext(woContext);
                }
            }
        }
        return response;
    }

    public static final ERXRestRequestHandler createUnsafeRequestHandler(boolean readOnly, boolean displayToMany) {
        if (!ERXApplication.isDevelopmentModeSafe()) {
            throw new RuntimeException("You attempted to create an unsafe request handler when you were not in development mode!");
        }
        ERXStandardRestEntityDelegate defaultEntityDelegate = readOnly ? new ERXUnsafeReadOnlyRestEntityDelegate() : new ERXUnsafeRestEntityDelegate();
        ERXDefaultRestDelegate restDelegate = new ERXDefaultRestDelegate(defaultEntityDelegate, true);
        ERXUnsafeRestAuthenticationDelegate authenticationDelegate = new ERXUnsafeRestAuthenticationDelegate();
        ERXXmlRestResponseWriter responseWriter = new ERXXmlRestResponseWriter(true, displayToMany);
        ERXXmlRestParser requestParser = new ERXXmlRestParser();
        return new ERXRestRequestHandler(authenticationDelegate, restDelegate, responseWriter, requestParser);
    }

    public static void register(ERXRestRequestHandler requestHandler) {
        WOApplication.application().registerRequestHandler((WORequestHandler)requestHandler, Key);
    }

    public static void register(IERXRestAuthenticationDelegate authenticationDelegate, IERXRestDelegate delegate) {
        ERXRestRequestHandler requestHandler = new ERXRestRequestHandler(authenticationDelegate, delegate);
        requestHandler.setResponseWriterForType(new ERXJSONRestResponseWriter(), "json");
        requestHandler.setResponseWriterForType(new ERXPListRestResponseWriter(), "plist");
        requestHandler.setResponseWriterForType(new ERXXmlRestResponseWriter(), "xml");
        ERXRestRequestHandler.register(requestHandler);
    }

    public static ERXDefaultRestDelegate register(IERXRestAuthenticationDelegate authenticationDelegate) {
        ERXDefaultRestDelegate restDelegate = new ERXDefaultRestDelegate();
        ERXRestRequestHandler.register(authenticationDelegate, restDelegate);
        return restDelegate;
    }

    public static final ERXRestRequestHandler register(IERXRestAuthenticationDelegate authenticationDelegate, boolean displayAllProperties, boolean displayAllToMany) {
        ERXRestRequestHandler requestHandler = new ERXRestRequestHandler(authenticationDelegate, new ERXDefaultRestDelegate(), new ERXXmlRestResponseWriter(displayAllProperties, displayAllToMany), new ERXXmlRestParser());
        requestHandler.setResponseWriterForType(new ERXJSONRestResponseWriter(displayAllProperties, displayAllToMany), "json");
        requestHandler.setResponseWriterForType(new ERXPListRestResponseWriter(displayAllProperties, displayAllToMany), "plist");
        requestHandler.setResponseWriterForType(new ERXXmlRestResponseWriter(displayAllProperties, displayAllToMany), "xml");
        ERXRestRequestHandler.register(requestHandler);
        return requestHandler;
    }
}

