/*
 * Decompiled with CFR 0.152.
 */
package er.rest.entityDelegates;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.eof.ERXKeyFilter;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.rest.ERXRestException;
import er.rest.entityDelegates.ERXAbstractRestResponseWriter;
import er.rest.entityDelegates.ERXRestContext;
import er.rest.entityDelegates.ERXRestKey;
import er.rest.entityDelegates.ERXRestNotFoundException;
import er.rest.entityDelegates.ERXRestSecurityException;
import er.rest.format.IERXRestResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXXmlRestResponseWriter
extends ERXAbstractRestResponseWriter {
    public ERXXmlRestResponseWriter() {
        this(false, false);
    }

    public ERXXmlRestResponseWriter(boolean displayAllProperties, boolean displayAllToMany) {
        super(displayAllProperties, displayAllToMany);
    }

    public ERXXmlRestResponseWriter(ERXKeyFilter filter) {
        super(filter);
    }

    @Override
    public void appendToResponse(ERXRestContext context, IERXRestResponse response, ERXRestKey result) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        response.setHeader("text/xml", "Content-Type");
        response.appendContentString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        super.appendToResponse(context, response, result);
    }

    protected void appendTypeToResponse(IERXRestResponse response, Object value) {
        if (!(value instanceof String) && !ERXProperties.booleanForKeyWithDefault((String)"ERXRest.suppressTypeAttributesForSimpleTypes", (boolean)false)) {
            if (value instanceof NSTimestamp) {
                response.appendContentString(" type = \"datetime\"");
            } else if (value instanceof Integer) {
                response.appendContentString(" type = \"integer\"");
            } else if (value instanceof Long) {
                response.appendContentString(" type = \"long\"");
            } else if (value instanceof Short) {
                response.appendContentString(" type = \"short\"");
            } else if (value instanceof Double) {
                response.appendContentString(" type = \"double\"");
            } else if (value instanceof Float) {
                response.appendContentString(" type = \"float\"");
            } else if (value instanceof Boolean) {
                response.appendContentString(" type = \"boolean\"");
            } else if (value instanceof BigDecimal) {
                response.appendContentString(" type = \"bigint\"");
            } else if (value instanceof Enum) {
                response.appendContentString(" type = \"enum\"");
            }
        }
    }

    @Override
    protected void appendArrayToResponse(ERXRestContext context, IERXRestResponse response, ERXRestKey result, String arrayName, String entityName, NSArray valueKeys, int indent, NSMutableSet<Object> visitedObjects) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        this.indent(response, indent);
        response.appendContentString("<");
        response.appendContentString(arrayName);
        response.appendContentString(" type = \"");
        response.appendContentString(entityName);
        response.appendContentString("\"");
        response.appendContentString(">");
        response.appendContentString("\n");
        Enumeration valueKeysEnum = valueKeys.objectEnumerator();
        while (valueKeysEnum.hasMoreElements()) {
            ERXRestKey eoKey = (ERXRestKey)valueKeysEnum.nextElement();
            this.appendToResponse(context, response, eoKey, indent + 1, visitedObjects);
        }
        this.indent(response, indent);
        response.appendContentString("</");
        response.appendContentString(arrayName);
        response.appendContentString(">");
        response.appendContentString("\n");
    }

    @Override
    protected void appendVisitedToResponse(ERXRestContext context, IERXRestResponse response, EOEntity entity, EOEnterpriseObject eo, String objectName, String entityName, Object id, int indent) {
        this.indent(response, indent);
        response.appendContentString("<");
        response.appendContentString(objectName);
        if (!objectName.equals(entityName)) {
            response.appendContentString(" type = \"");
            response.appendContentString(entityName);
            response.appendContentString("\"");
        }
        response.appendContentString(" id = \"");
        response.appendContentString(String.valueOf(id));
        response.appendContentString("\"");
        response.appendContentString("/>");
        response.appendContentString("\n");
    }

    @Override
    protected void appendNoDetailsToResponse(ERXRestContext context, IERXRestResponse response, EOEntity entity, EOEnterpriseObject eo, String objectName, String entityName, Object id, int indent) {
        this.indent(response, indent);
        response.appendContentString("<");
        response.appendContentString(objectName);
        if (!objectName.equals(entityName)) {
            response.appendContentString(" type = \"");
            response.appendContentString(entityName);
            response.appendContentString("\"");
        }
        response.appendContentString(" id = \"");
        response.appendContentString(String.valueOf(id));
        response.appendContentString("\"");
        response.appendContentString("/>");
        response.appendContentString("\n");
    }

    @Override
    protected void appendDetailsToResponse(ERXRestContext context, IERXRestResponse response, EOEntity entity, EOEnterpriseObject eo, String objectName, String entityName, Object id, NSArray displayKeys, int indent, NSMutableSet<Object> visitedObjects) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        this.indent(response, indent);
        response.appendContentString("<");
        response.appendContentString(objectName);
        if (!objectName.equals(entityName)) {
            response.appendContentString(" type = \"");
            response.appendContentString(entityName);
            response.appendContentString("\"");
        }
        response.appendContentString(">");
        response.appendContentString("\n");
        this.indent(response, indent + 1);
        response.appendContentString("<id");
        this.appendTypeToResponse(response, id);
        response.appendContentString(">");
        response.appendContentString(String.valueOf(id));
        response.appendContentString("</id>");
        response.appendContentString("\n");
        Enumeration displayKeysEnum = displayKeys.objectEnumerator();
        while (displayKeysEnum.hasMoreElements()) {
            ERXRestKey displayKey = (ERXRestKey)displayKeysEnum.nextElement();
            String propertyName = displayKey.key();
            Object propertyValue = displayKey.value();
            if (propertyValue instanceof NSArray) {
                this.appendToResponse(context, response, displayKey, indent + 1, visitedObjects);
                continue;
            }
            if (propertyValue instanceof EOEnterpriseObject) {
                this.appendToResponse(context, response, displayKey, indent + 1, visitedObjects);
                continue;
            }
            String formattedPropertyValue = context.delegate().entityDelegate(entity).formatAttributeValue(entity, eo, propertyName, propertyValue);
            if (formattedPropertyValue == null) continue;
            String propertyAlias = displayKey.keyAlias();
            this.indent(response, indent + 1);
            response.appendContentString("<");
            response.appendContentString(propertyAlias);
            if (propertyValue instanceof String) {
                this.appendTypeToResponse(response, ERXStringUtilities.escapeNonBasicLatinChars((String)((String)propertyValue)));
            } else {
                this.appendTypeToResponse(response, propertyValue);
            }
            response.appendContentString(">");
            String attributeValueStr = ERXStringUtilities.escapeNonXMLChars((String)formattedPropertyValue);
            response.appendContentString(attributeValueStr);
            response.appendContentString("</");
            response.appendContentString(propertyAlias);
            response.appendContentString(">");
            response.appendContentString("\n");
        }
        this.indent(response, indent);
        response.appendContentString("</");
        response.appendContentString(objectName);
        response.appendContentString(">");
        response.appendContentString("\n");
    }

    @Override
    protected void appendPrimitiveToResponse(ERXRestContext context, IERXRestResponse response, ERXRestKey result, int indent, Object value) throws ERXRestException {
        this.indent(response, indent);
        response.appendContentString(String.valueOf(value));
    }
}

