/*
 * Decompiled with CFR 0.152.
 */
package er.rest.format;

import com.webobjects.eocontrol.EOClassDescription;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXKeyFilter;
import er.rest.ERXRestRequestNode;
import er.rest.IERXRestDelegate;
import er.rest.format.ERXJSONRestParser;
import er.rest.format.ERXJSONRestWriter;
import er.rest.format.ERXPListRestParser;
import er.rest.format.ERXPListRestWriter;
import er.rest.format.ERXRestFormatDelegate;
import er.rest.format.ERXSimpleRestWriter;
import er.rest.format.ERXSproutCoreRestWriter;
import er.rest.format.ERXStringRestRequest;
import er.rest.format.ERXXmlRestParser;
import er.rest.format.ERXXmlRestWriter;
import er.rest.format.IERXRestParser;
import er.rest.format.IERXRestWriter;
import er.rest.gianduia.ERXGianduiaRestParser;
import er.rest.gianduia.ERXGianduiaRestWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRestFormat {
    private static Map<String, ERXRestFormat> _formats = new ConcurrentHashMap<String, ERXRestFormat>();
    public static ERXRestFormat JSON = ERXRestFormat.registerFormatNamed(new ERXJSONRestParser(), new ERXJSONRestWriter(), new ERXRestFormatDelegate(), "json", "application/json");
    public static ERXRestFormat JS = ERXRestFormat.registerFormatNamed(new ERXJSONRestParser(), new ERXJSONRestWriter(), new ERXRestFormatDelegate(), "js", "text/js");
    public static ERXRestFormat PLIST = ERXRestFormat.registerFormatNamed(new ERXPListRestParser(), new ERXPListRestWriter(), new ERXRestFormatDelegate(), "plist", "text/plist");
    public static ERXRestFormat RAILS = ERXRestFormat.registerFormatNamed(new ERXXmlRestParser(), new ERXXmlRestWriter(), new ERXRestFormatDelegate("id", "type", "nil", true, true, true, true), "rails", "application/xml", "text/xml");
    public static ERXRestFormat XML = ERXRestFormat.registerFormatNamed(new ERXXmlRestParser(), new ERXXmlRestWriter(), new ERXRestFormatDelegate(), "xml", "application/xml", "text/xml");
    public static ERXRestFormat HTML = ERXRestFormat.registerFormatNamed(null, new ERXSimpleRestWriter(), new ERXRestFormatDelegate(), "html", "text/html");
    public static ERXRestFormat GIANDUIA_JSON = ERXRestFormat.registerFormatNamed(new ERXJSONRestParser(), new ERXGianduiaRestWriter(false), new ERXRestFormatDelegate(), "gndj", "application/gndj");
    public static ERXRestFormat GIANDUIA_PERSISTENT_STORE = ERXRestFormat.registerFormatNamed(new ERXGianduiaRestParser(), new ERXGianduiaRestWriter(true), new ERXRestFormatDelegate(), "gndp", "application/gndp");
    public static ERXRestFormat SPROUTCORE = ERXRestFormat.registerFormatNamed(new ERXJSONRestParser(), new ERXSproutCoreRestWriter(), new ERXRestFormatDelegate("guid", "type", "nil", true, true, true, false), "sc", "application/sc");
    private String _name;
    private IERXRestParser _parser;
    private IERXRestWriter _writer;
    private Delegate _delegate;

    public ERXRestFormat(String name, IERXRestParser parser, IERXRestWriter writer, Delegate delegate) {
        this._name = name;
        this._parser = parser;
        this._writer = writer;
        this._delegate = delegate;
    }

    public String name() {
        return this._name;
    }

    public IERXRestParser parser() {
        return this._parser;
    }

    public IERXRestWriter writer() {
        return this._writer;
    }

    public Delegate delegate() {
        return this._delegate;
    }

    public ERXRestRequestNode parse(String str) {
        return this.parser().parseRestRequest(new ERXStringRestRequest(str), this._delegate);
    }

    public String toString(Object obj) {
        return ERXRestRequestNode.requestNodeWithObjectAndFilter(obj, ERXKeyFilter.filterWithAllRecursive(), IERXRestDelegate.Factory.delegateForEntityNamed(IERXRestDelegate.Factory.entityNameForObject(obj), ERXEC.newEditingContext())).toString(this);
    }

    public String toString(Object obj, IERXRestDelegate delegate) {
        return ERXRestRequestNode.requestNodeWithObjectAndFilter(obj, ERXKeyFilter.filterWithAllRecursive(), delegate).toString(this);
    }

    public String toString(Object obj, ERXKeyFilter filter, IERXRestDelegate delegate) {
        return ERXRestRequestNode.requestNodeWithObjectAndFilter(obj, filter, delegate).toString(this);
    }

    public String toString(EOClassDescription classDescription, List<?> list, ERXKeyFilter filter, IERXRestDelegate delegate) {
        return ERXRestRequestNode.requestNodeWithObjectAndFilter(classDescription, list, filter, delegate).toString(this);
    }

    public String toString() {
        return "[ERXRestFormat: " + this._name + "]";
    }

    public static ERXRestFormat formatNamed(String name) {
        ERXRestFormat format = _formats.get(name.toLowerCase());
        if (format == null) {
            format = new ERXRestFormat(name, null, null, new NoOpDelegate());
        }
        return format;
    }

    public static ERXRestFormat registerFormatNamed(IERXRestParser parser, IERXRestWriter writer, Delegate delegate, String ... names) {
        ERXRestFormat format = new ERXRestFormat(names[0], parser, writer, delegate);
        for (String name : names) {
            ERXRestFormat.registerFormatNamed(format, name);
        }
        return format;
    }

    public static ERXRestFormat registerFormatNamed(ERXRestFormat format, String name) {
        _formats.put(name.toLowerCase(), format);
        return format;
    }

    public static class NoOpDelegate
    implements Delegate {
        public void nodeDidParse(ERXRestRequestNode node) {
        }

        public void nodeWillWrite(ERXRestRequestNode node) {
        }
    }

    public static interface Delegate {
        public void nodeDidParse(ERXRestRequestNode var1);

        public void nodeWillWrite(ERXRestRequestNode var1);
    }
}

