/*
 * Decompiled with CFR 0.152.
 */
package er.rest.format;

import com.webobjects.appserver.WORequest;
import er.rest.ERXRestNameRegistry;
import er.rest.ERXRestRequestNode;
import er.rest.format.ERXRestFormat;
import er.rest.format.ERXRestFormatDelegate;
import er.rest.format.ERXStringBufferRestResponse;
import er.rest.format.ERXStringRestRequest;
import er.rest.format.ERXXmlRestWriter;
import er.rest.format.IERXRestParser;
import er.rest.format.IERXRestRequest;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class ERXXmlRestParser
implements IERXRestParser {
    protected ERXRestRequestNode createRequestNodeForElement(Element element, boolean rootNode, ERXRestFormat.Delegate delegate) {
        String name = element.getTagName();
        ERXRestRequestNode requestNode = new ERXRestRequestNode(name, rootNode);
        String value = element.getNodeValue();
        NamedNodeMap attributeNodes = element.getAttributes();
        for (int attributeNum = 0; attributeNum < attributeNodes.getLength(); ++attributeNum) {
            Node attribute = attributeNodes.item(attributeNum);
            requestNode.setAttributeForKey(attribute.getNodeValue(), attribute.getNodeName());
        }
        NodeList childNodes = element.getChildNodes();
        for (int childNodeNum = 0; childNodeNum < childNodes.getLength(); ++childNodeNum) {
            String text;
            Node childNode = childNodes.item(childNodeNum);
            if (childNode instanceof Element) {
                Element childElement = (Element)childNode;
                ERXRestRequestNode childRequestNode = this.createRequestNodeForElement(childElement, false, delegate);
                if (childRequestNode == null) continue;
                String childRequestNodeName = childRequestNode.name();
                if (childRequestNodeName == null || Character.isUpperCase(childRequestNodeName.charAt(0))) {
                    childRequestNode.setRootNode(true);
                    requestNode.setArray(true);
                }
                requestNode.addChild(childRequestNode);
                continue;
            }
            if (!(childNode instanceof Text) || (text = childNode.getNodeValue()) == null) continue;
            if (!(childNode instanceof CDATASection)) {
                text = text.trim();
            }
            value = value == null ? text : value + text;
        }
        requestNode.setValue(value);
        delegate.nodeDidParse(requestNode);
        return requestNode;
    }

    @Deprecated
    public ERXRestRequestNode parseRestRequest(WORequest request, ERXRestFormat.Delegate delegate) {
        return this.parseRestRequest(request.contentString(), delegate);
    }

    @Deprecated
    public ERXRestRequestNode parseRestRequest(String contentStr, ERXRestFormat.Delegate delegate) {
        return this.parseRestRequest(new ERXStringRestRequest(contentStr), delegate);
    }

    public ERXRestRequestNode parseRestRequest(IERXRestRequest request, ERXRestFormat.Delegate delegate) {
        ERXRestRequestNode rootRequestNode = null;
        String contentString = request.stringContent();
        if (contentString != null && contentString.length() > 0) {
            if (!contentString.trim().startsWith("<")) {
                contentString = "<FakeWrapper>" + contentString.trim() + "</FakeWrapper>";
            }
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(contentString)));
                document.normalize();
                Element rootElement = document.getDocumentElement();
                rootRequestNode = this.createRequestNodeForElement(rootElement, true, delegate);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse request document.", e);
            }
        } else {
            rootRequestNode = new ERXRestRequestNode(null, true);
            rootRequestNode.setNull(true);
        }
        return rootRequestNode;
    }

    public static void main(String[] args) {
        String str = "<Company><id>100</id><type>Company</type><name>mDT</name><firstName nil=\"true\"/><employees><Employee id=\"101\" type=\"Employee\"/><Employee id=\"102\"><name>Mike</name></Employee></employees></Company>";
        ERXRestNameRegistry.registry().setExternalNameForInternalName("Super", "Company");
        ERXRestNameRegistry.registry().setExternalNameForInternalName("Super2", "Employee");
        ERXRestRequestNode n = new ERXXmlRestParser().parseRestRequest(new ERXStringRestRequest(str), (ERXRestFormat.Delegate)new ERXRestFormatDelegate());
        ERXStringBufferRestResponse response = new ERXStringBufferRestResponse();
        new ERXXmlRestWriter().appendToResponse(n, response, new ERXRestFormatDelegate());
        System.out.println("ERXXmlRestParser.main: " + response);
    }
}

