/*
 * Decompiled with CFR 0.152.
 */
package er.rest.gianduia;

import com.webobjects.appserver.WOApplication;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.rest.ERXRestRequestNode;
import er.rest.ERXRestUtils;
import er.rest.format.ERXRestFormat;
import er.rest.format.IERXRestResponse;
import er.rest.format.IERXRestWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXGianduiaRestWriter
implements IERXRestWriter {
    private String _persistentStoreName;
    private boolean _persistentStoreFormat;

    public ERXGianduiaRestWriter(boolean persistentStoreFormat) {
        this(persistentStoreFormat, ERXProperties.stringForKeyWithDefault((String)"ERXRest.gianduia.persistentStoreName", null));
    }

    public ERXGianduiaRestWriter(boolean persistentStoreFormat, String persistentStoreName) {
        WOApplication application;
        this._persistentStoreFormat = persistentStoreFormat;
        this._persistentStoreName = persistentStoreName == null ? ((application = WOApplication.application()) == null ? "ERRest" : application.name()) : persistentStoreName;
    }

    protected void appendObjectToResponse(Object object, Map<Object, ERXRestRequestNode> conversionMap, IERXRestResponse response) {
        if (object == null) {
            response.appendContentString("undefined");
        } else if (ERXRestUtils.isPrimitive(object)) {
            this.appendValueToResponse(object, conversionMap, response);
        } else if (object instanceof Map) {
            this.appendMapToResponse((Map)object, conversionMap, response);
        } else if (object instanceof List) {
            this.appendListToResponse((List)object, conversionMap, response);
        } else {
            throw new IllegalArgumentException("Unknown Gianduia object: " + object);
        }
    }

    protected void appendValueToResponse(Object value, Map<Object, ERXRestRequestNode> conversionMap, IERXRestResponse response) {
        if (value instanceof Number) {
            response.appendContentString(String.valueOf(value));
        } else if (value instanceof Date) {
            response.appendContentString("new Date(" + ((Date)value).getTime() + ")");
        } else if (value instanceof String) {
            response.appendContentString("\"" + ERXStringUtilities.escape((char[])new char[]{'\"'}, (char)'\\', (String)((String)value)) + "\"");
        } else {
            response.appendContentString("\"" + ERXRestUtils.coerceValueToString(value) + "\"");
        }
    }

    protected void appendListToResponse(List<Object> list, Map<Object, ERXRestRequestNode> conversionMap, IERXRestResponse response) {
        boolean persistentStoreFormat = false;
        Object id = null;
        if (this._persistentStoreFormat) {
            ERXRestRequestNode requestNode = conversionMap.get(list);
            id = requestNode.id();
            boolean bl = persistentStoreFormat = id != null;
        }
        if (persistentStoreFormat) {
            response.appendContentString("this.setResponseObjectsForRequestWithId(");
        }
        response.appendContentString("[");
        Iterator<Object> listIter = list.iterator();
        while (listIter.hasNext()) {
            Object obj = listIter.next();
            this.appendObjectToResponse(obj, conversionMap, response);
            if (!listIter.hasNext()) continue;
            response.appendContentString(", ");
        }
        response.appendContentString("]");
        if (persistentStoreFormat) {
            response.appendContentString(", \"" + id + "\")");
        }
    }

    protected void appendMapToResponse(Map<Object, Object> map, Map<Object, ERXRestRequestNode> conversionMap, IERXRestResponse response) {
        Map<Object, Object> cleanedMap = map;
        boolean persistentStoreFormat = false;
        if (this._persistentStoreFormat) {
            cleanedMap = new HashMap<Object, Object>(map);
            String type = (String)cleanedMap.remove("type");
            Object id = cleanedMap.remove("id");
            boolean bl = persistentStoreFormat = type != null && id != null;
            if (persistentStoreFormat) {
                response.appendContentString("this.objectWithURIRepresentation(\"x-coredata://" + this._persistentStoreName + "/" + type + "/p" + id + "\",");
            }
        }
        response.appendContentString("{");
        Iterator<Map.Entry<Object, Object>> mapIter = cleanedMap.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry<Object, Object> entry = mapIter.next();
            response.appendContentString(String.valueOf(entry.getKey()));
            response.appendContentString(":");
            this.appendObjectToResponse(entry.getValue(), conversionMap, response);
            if (!mapIter.hasNext()) continue;
            response.appendContentString(", ");
        }
        response.appendContentString("}");
        if (persistentStoreFormat) {
            response.appendContentString(")");
        }
    }

    @Override
    public void appendHeadersToResponse(ERXRestRequestNode node, IERXRestResponse response) {
        response.setHeader("application/json", "Content-Type");
    }

    @Override
    public void appendToResponse(ERXRestRequestNode node, IERXRestResponse response, ERXRestFormat.Delegate delegate) {
        this.appendHeadersToResponse(node, response);
        HashMap<Object, ERXRestRequestNode> conversionMap = new HashMap<Object, ERXRestRequestNode>();
        Object object = node.toJavaCollection(delegate, conversionMap);
        this.appendObjectToResponse(object, conversionMap, response);
        response.appendContentString("\n");
    }
}

