/*
 * Decompiled with CFR 0.152.
 */
package er.rest.routes;

import com.webobjects.appserver.WOAction;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver._private.WODirectActionRequestHandler;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import er.rest.ERXRestClassDescriptionFactory;
import er.rest.ERXRestNameRegistry;
import er.rest.IERXRestDelegate;
import er.rest.routes.ERXRoute;
import er.rest.routes.ERXRouteController;
import er.rest.routes.jsr311.DELETE;
import er.rest.routes.jsr311.GET;
import er.rest.routes.jsr311.HttpMethod;
import er.rest.routes.jsr311.POST;
import er.rest.routes.jsr311.PUT;
import er.rest.routes.jsr311.Path;
import er.rest.routes.jsr311.Paths;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRouteRequestHandler
extends WODirectActionRequestHandler {
    public static NameFormat RAILS = new NameFormat(true, true, NameFormat.Case.LowercaseUnderscore);
    public static NameFormat WO = new NameFormat(false, false, NameFormat.Case.CamelCase);
    public static NameFormat WO_LOWER = new NameFormat(false, false, NameFormat.Case.LowerCamelCase);
    public static final Logger log = Logger.getLogger(ERXRouteRequestHandler.class);
    public static final String Key = "ra";
    public static final String TypeKey = "ERXRouteRequestHandler.type";
    public static final String ExtensionKey = "ERXRouteRequestHandler.extension";
    public static final String PathKey = "ERXRouteRequestHandler.path";
    public static final String RouteKey = "ERXRouteRequestHandler.route";
    public static final String KeysKey = "ERXRouteRequestHandler.keys";
    private NameFormat _entityNameFormat;
    private NSMutableArray<ERXRoute> _routes;

    public ERXRouteRequestHandler() {
        this(new NameFormat(ERXProperties.booleanForKeyWithDefault((String)"ERXRest.pluralEntityNames", (boolean)true), ERXProperties.booleanForKeyWithDefault((String)"ERXRest.pluralEntityNames", (boolean)true), NameFormat.Case.valueOf(ERXProperties.stringForKeyWithDefault((String)"ERXRest.routeCase", (String)(ERXProperties.booleanForKeyWithDefault((String)"ERXRest.lowercaseEntityNames", (boolean)true) ? NameFormat.Case.LowerCamelCase.name() : NameFormat.Case.CamelCase.name())))));
    }

    public ERXRouteRequestHandler(NameFormat entityNameFormat) {
        this._entityNameFormat = entityNameFormat;
        this._routes = new NSMutableArray();
    }

    public void insertRoute(ERXRoute route) {
        this._routes.insertObjectAtIndex((Object)route, 0);
    }

    public void addRoute(ERXRoute route) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding route " + route));
        }
        this._routes.addObject((Object)route);
    }

    public void removeRoute(ERXRoute route) {
        this._routes.removeObject((Object)route);
    }

    public void _clearCaches() {
        for (ERXRoute route : this._routes) {
            route._clearCaches();
        }
    }

    public NSArray<ERXRoute> routes() {
        return this._routes.immutableClone();
    }

    public NSArray<ERXRoute> routesForControllerClass(Class<? extends ERXRouteController> routeController) {
        NSMutableArray routes = new NSMutableArray();
        for (ERXRoute route : this._routes) {
            if (route.controller() != routeController) continue;
            routes.add((Object)route);
        }
        return routes;
    }

    public Class<? extends ERXRouteController> routeControllerClassForEntityNamed(String entityName) {
        String pluralControllerName;
        String controllerName = entityName + "Controller";
        Class controllerClass = _NSUtilities.classWithName((String)controllerName);
        if (controllerClass == null && (controllerClass = _NSUtilities.classWithName((String)(pluralControllerName = ERXLocalizer.englishLocalizer().plurifiedString(entityName, 2) + "Controller"))) == null) {
            throw new IllegalArgumentException("There is no controller named '" + controllerName + "' or '" + pluralControllerName + "'.");
        }
        return controllerClass.asSubclass(ERXRouteController.class);
    }

    public void addRoutes(String entityName) {
        this.addRoutes(entityName, this.routeControllerClassForEntityNamed(entityName));
    }

    public void addRoutes(String entityName, Class<? extends ERXRouteController> routeControllerClass) {
        this.addDeclaredRoutes(entityName, routeControllerClass, true);
    }

    protected void addDeclaredRoutes(String entityName, Class<? extends ERXRouteController> routeControllerClass, boolean addDefaultRoutesIfNoDeclaredRoutesFound) {
        boolean declaredRoutesFound = false;
        try {
            Method addRoutesMethod = routeControllerClass.getMethod("addRoutes", String.class, ERXRouteRequestHandler.class);
            addRoutesMethod.invoke(null, new Object[]{entityName, this});
            declaredRoutesFound = true;
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to add routes for " + routeControllerClass + ".", t);
        }
        for (Method routeMethod : routeControllerClass.getDeclaredMethods()) {
            Annotation methodAnnotation;
            String routeMethodName = routeMethod.getName();
            if (!routeMethodName.endsWith("Action")) continue;
            String actionName = routeMethodName.substring(0, routeMethodName.length() - "Action".length());
            Path pathAnnotation = routeMethod.getAnnotation(Path.class);
            Paths pathsAnnotation = routeMethod.getAnnotation(Paths.class);
            if (pathAnnotation == null && pathsAnnotation == null) continue;
            declaredRoutesFound = false;
            ERXRoute.Method method = null;
            for (Annotation annotation : routeMethod.getAnnotations()) {
                HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
                if (httpMethod == null) continue;
                if (method == null) {
                    method = httpMethod.value();
                    continue;
                }
                throw new IllegalArgumentException(routeControllerClass.getSimpleName() + "." + routeMethod.getName() + " is annotated as more than one http method.");
            }
            if (method == null) {
                method = ERXRoute.Method.Get;
            }
            if ((methodAnnotation = routeMethod.getAnnotation(GET.class)) == null && (methodAnnotation = routeMethod.getAnnotation(POST.class)) == null && (methodAnnotation = routeMethod.getAnnotation(PUT.class)) == null) {
                methodAnnotation = routeMethod.getAnnotation(DELETE.class);
            }
            if (methodAnnotation != null) {
                method = methodAnnotation.annotationType().getAnnotation(HttpMethod.class).value();
            }
            if (pathAnnotation != null) {
                this.addRoute(new ERXRoute(entityName, pathAnnotation.value(), method, routeControllerClass, actionName));
                declaredRoutesFound = true;
            }
            if (pathsAnnotation == null) continue;
            for (Path path : pathsAnnotation.value()) {
                this.addRoute(new ERXRoute(entityName, path.value(), method, routeControllerClass, actionName));
            }
            declaredRoutesFound = true;
        }
        if (addDefaultRoutesIfNoDeclaredRoutesFound && !declaredRoutesFound) {
            log.warn((Object)("No 'addRoutes(entityName, routeRequetHandler)' method and no @Path designations found on '" + routeControllerClass.getSimpleName() + "'. Registering default routes instead."));
            this.addDefaultRoutes(entityName, routeControllerClass);
        }
    }

    public void addDefaultRoutes(String entityName) {
        this.addDefaultRoutes(entityName, this.routeControllerClassForEntityNamed(entityName));
    }

    public void addDefaultRoutes(String entityName, Class<? extends ERXRouteController> controllerClass) {
        EOClassDescription classDescription = ERXRestClassDescriptionFactory.classDescriptionForEntityName(entityName);
        boolean numericPKs = IERXRestDelegate.Factory.delegateForEntityNamed(entityName, null).__hasNumericPrimaryKeys(classDescription);
        this.addDefaultRoutes(entityName, numericPKs, controllerClass);
    }

    public String controllerPathForEntityNamed(String entityName) {
        return this._entityNameFormat.formatEntityNamed(ERXRestNameRegistry.registry().externalNameForInternalName(entityName), true);
    }

    public void addDefaultRoutes(String entityName, boolean numericPKs, Class<? extends ERXRouteController> controllerClass) {
        this.addDefaultRoutes(entityName, entityName, numericPKs, controllerClass);
    }

    public void addDefaultRoutes(String entityName, String entityType, boolean numericPKs, Class<? extends ERXRouteController> controllerClass) {
        NSArray<ERXRoute> existingRoutes = this.routesForControllerClass(controllerClass);
        if (existingRoutes.isEmpty()) {
            this.addDeclaredRoutes(entityName, controllerClass, false);
        }
        String variableName = ERXStringUtilities.uncapitalize((String)entityName);
        String externalName = ERXRestNameRegistry.registry().externalNameForInternalName(entityName);
        String singularExternalName = this._entityNameFormat.formatEntityNamed(externalName, false);
        String pluralExternalName = this._entityNameFormat.formatEntityNamed(externalName, true);
        if (this._entityNameFormat.pluralRouteName()) {
            this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName, ERXRoute.Method.Options, controllerClass, "options"));
        }
        this.addRoute(new ERXRoute(entityName, "/" + singularExternalName, ERXRoute.Method.Options, controllerClass, "options"));
        if (this._entityNameFormat.pluralRouteName()) {
            this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName, ERXRoute.Method.Head, controllerClass, "head"));
        }
        this.addRoute(new ERXRoute(entityName, "/" + singularExternalName, ERXRoute.Method.Head, controllerClass, "head"));
        if (this._entityNameFormat.pluralRouteName()) {
            this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName, ERXRoute.Method.Post, controllerClass, "create"));
        }
        this.addRoute(new ERXRoute(entityName, "/" + singularExternalName, ERXRoute.Method.Post, controllerClass, "create"));
        if (this._entityNameFormat.pluralRouteName()) {
            this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName, ERXRoute.Method.All, controllerClass, "index"));
        } else {
            this.addRoute(new ERXRoute(entityName, "/" + singularExternalName, ERXRoute.Method.All, controllerClass, "index"));
        }
        if (numericPKs) {
            this.addRoute(new ERXRoute(entityName, "/" + singularExternalName + "/{action:identifier}", ERXRoute.Method.Get, controllerClass));
            if (this._entityNameFormat.pluralRouteName()) {
                this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName + "/{action:identifier}", ERXRoute.Method.Get, controllerClass));
            }
        } else {
            this.addRoute(new ERXRoute(entityName, "/" + singularExternalName + "/new", ERXRoute.Method.All, controllerClass, "new"));
            if (this._entityNameFormat.pluralRouteName()) {
                this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName + "/new", ERXRoute.Method.All, controllerClass, "new"));
            }
        }
        if (this._entityNameFormat.pluralRouteName()) {
            this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName + "/{" + variableName + ":" + entityType + "}", ERXRoute.Method.Get, controllerClass, "show"));
        }
        this.addRoute(new ERXRoute(entityName, "/" + singularExternalName + "/{" + variableName + ":" + entityType + "}", ERXRoute.Method.Get, controllerClass, "show"));
        if (this._entityNameFormat.pluralRouteName()) {
            this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName + "/{" + variableName + ":" + entityType + "}", ERXRoute.Method.Put, controllerClass, "update"));
        }
        this.addRoute(new ERXRoute(entityName, "/" + singularExternalName + "/{" + variableName + ":" + entityType + "}", ERXRoute.Method.Put, controllerClass, "update"));
        if (this._entityNameFormat.pluralRouteName()) {
            this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName + "/{" + variableName + ":" + entityType + "}", ERXRoute.Method.Delete, controllerClass, "destroy"));
        }
        this.addRoute(new ERXRoute(entityName, "/" + singularExternalName + "/{" + variableName + ":" + entityType + "}", ERXRoute.Method.Delete, controllerClass, "destroy"));
        if (this._entityNameFormat.pluralRouteName()) {
            this.addRoute(new ERXRoute(entityName, "/" + pluralExternalName + "/{" + variableName + ":" + entityType + "}/{action:identifier}", ERXRoute.Method.All, controllerClass));
        }
        this.addRoute(new ERXRoute(entityName, "/" + singularExternalName + "/{" + variableName + ":" + entityType + "}/{action:identifier}", ERXRoute.Method.All, controllerClass));
    }

    public ERXRoute routeForMethodAndPath(String method, String path, NSMutableDictionary<String, Object> userInfo) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        int dotIndex = path.lastIndexOf(46);
        String requestedType = null;
        if (dotIndex >= 0) {
            String type = path.substring(dotIndex + 1);
            if (type.length() > 0) {
                requestedType = type;
                userInfo.setObjectForKey((Object)type, (Object)ExtensionKey);
            }
            path = path.substring(0, dotIndex);
        }
        ERXRoute.Method routeMethod = ERXRoute.Method.valueOf(ERXStringUtilities.capitalize((String)method.toLowerCase()));
        ERXRoute matchingRoute = null;
        NSDictionary<ERXRoute.Key, String> keys = null;
        for (ERXRoute route : this._routes) {
            keys = route.keys(path, routeMethod);
            if (keys == null) continue;
            matchingRoute = route;
            break;
        }
        if (matchingRoute != null) {
            if (requestedType != null) {
                userInfo.setObjectForKey((Object)requestedType, (Object)TypeKey);
            }
            userInfo.setObjectForKey((Object)path, (Object)PathKey);
            userInfo.setObjectForKey(matchingRoute, (Object)RouteKey);
            userInfo.setObjectForKey(keys, (Object)KeysKey);
        }
        return matchingRoute;
    }

    public ERXRoute setupRequestWithRouteForMethodAndPath(WORequest request, String method, String path) {
        NSDictionary userInfo = request.userInfo();
        NSMutableDictionary mutableUserInfo = userInfo instanceof NSMutableDictionary ? (NSMutableDictionary)userInfo : (userInfo != null ? userInfo.mutableClone() : new NSMutableDictionary());
        ERXRoute matchingRoute = this.routeForMethodAndPath(method, path, (NSMutableDictionary<String, Object>)mutableUserInfo);
        if (mutableUserInfo != userInfo) {
            request.setUserInfo((NSDictionary)mutableUserInfo);
        }
        return matchingRoute;
    }

    public void setupRouteControllerFromUserInfo(ERXRouteController controller, NSDictionary<String, Object> userInfo) {
        controller._setRequestHandler(this);
        if (userInfo != null) {
            ERXRoute route = (ERXRoute)userInfo.objectForKey((Object)RouteKey);
            controller._setRoute(route);
            NSDictionary keys = (NSDictionary)userInfo.objectForKey((Object)KeysKey);
            controller._setRouteKeys((NSDictionary<ERXRoute.Key, String>)keys);
        }
    }

    public NSArray getRequestHandlerPathForRequest(WORequest request) {
        NSMutableArray requestHandlerPath = new NSMutableArray();
        try {
            String path = request._uriDecomposed().requestHandlerPath();
            ERXRoute matchingRoute = this.setupRequestWithRouteForMethodAndPath(request, request.method(), path);
            if (matchingRoute != null) {
                NSDictionary keys = (NSDictionary)request.userInfo().objectForKey((Object)KeysKey);
                String controller = (String)keys.objectForKey((Object)ERXRoute.ControllerKey);
                String actionName = (String)keys.objectForKey((Object)ERXRoute.ActionKey);
                requestHandlerPath.addObject((Object)controller);
                requestHandlerPath.addObject((Object)actionName);
            } else {
                requestHandlerPath.addObject((Object)ERXProperties.stringForKeyWithDefault((String)"ERXRest.missingControllerName", (String)"ERXMissingRouteController"));
                requestHandlerPath.addObject((Object)"missing");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to process the requested route.", t);
        }
        return requestHandlerPath;
    }

    public Object[] getRequestActionClassAndNameForPath(NSArray requestHandlerPath) {
        String requestActionClassName = (String)requestHandlerPath.objectAtIndex(0);
        String requestActionName = (String)requestHandlerPath.objectAtIndex(1);
        return new Object[]{requestActionClassName, requestActionName, _NSUtilities.classWithName((String)requestActionClassName)};
    }

    public WOAction getActionInstance(Class class1, Class[] aclass, Object[] aobj) {
        ERXRouteController controller = (ERXRouteController)super.getActionInstance(class1, aclass, aobj);
        WORequest request = (WORequest)aobj[0];
        this.setupRouteControllerFromUserInfo(controller, (NSDictionary<String, Object>)request.userInfo());
        return controller;
    }

    public <T extends ERXRouteController> T controller(String entityName, WORequest request, WOContext context) {
        return (T)((Object)this.controller(this.routeControllerClassForEntityNamed(entityName), request, context));
    }

    public <T extends ERXRouteController> T controller(Class<T> controllerClass, WOContext context) {
        return this.controller(controllerClass, null, context);
    }

    public <T extends ERXRouteController> T controller(Class<T> controllerClass, WORequest request, WOContext context) {
        try {
            ERXRouteController controller = (ERXRouteController)((Object)controllerClass.getConstructor(WORequest.class).newInstance(request));
            controller._setRequestHandler(this);
            controller._setContext(context);
            return (T)((Object)controller);
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public void _putComponentsToSleepInContext(WOContext wocontext) {
        super._putComponentsToSleepInContext(wocontext);
        ERXRouteController._disposeControllersForRequest(wocontext.request());
    }

    public static void register(ERXRouteRequestHandler requestHandler) {
        WOApplication.application().registerRequestHandler((WORequestHandler)requestHandler, Key);
    }

    public static class NameFormat {
        private boolean _pluralControllerName;
        private boolean _pluralRouteName;
        private Case _routeCase;

        public NameFormat(boolean pluralControllerName, boolean pluralRouteName, Case routeCase) {
            this._pluralControllerName = pluralControllerName;
            this._pluralRouteName = pluralRouteName;
            this._routeCase = routeCase;
        }

        public boolean pluralControllerName() {
            return this._pluralControllerName;
        }

        public boolean pluralRouteName() {
            return this._pluralRouteName;
        }

        public Case routeCase() {
            return this._routeCase;
        }

        protected String caseifyEntityNamed(String entityName) {
            String formattedStr;
            if (this._routeCase == Case.CamelCase) {
                formattedStr = entityName;
            } else if (this._routeCase == Case.LowerCamelCase) {
                formattedStr = ERXStringUtilities.uncapitalize((String)entityName);
            } else if (this._routeCase == Case.Lowercase) {
                formattedStr = entityName.toLowerCase();
            } else if (this._routeCase == Case.LowercaseUnderscore) {
                formattedStr = ERXStringUtilities.camelCaseToUnderscore((String)entityName, (boolean)true);
            } else {
                throw new IllegalArgumentException("Unknown case: " + (Object)((Object)this._routeCase));
            }
            return formattedStr;
        }

        public String formatEntityNamed(String entityName, boolean pluralizeIfNecessary) {
            String singularEntityName = this.caseifyEntityNamed(entityName);
            String controllerPath = pluralizeIfNecessary && this.pluralRouteName() ? ERXLocalizer.englishLocalizer().plurifiedString(singularEntityName, 2) : singularEntityName;
            return controllerPath;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Case {
            CamelCase,
            LowerCamelCase,
            Lowercase,
            LowercaseUnderscore;

        }
    }
}

