/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOArrayDataSource;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EODelayedObserver;
import com.webobjects.eocontrol.EODelayedObserverQueue;
import com.webobjects.eocontrol.EODetailDataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOKeyValueArchiver;
import com.webobjects.eocontrol.EOKeyValueArchiving;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.eocontrol.EOObserverCenter;
import com.webobjects.eocontrol.EOObserverProxy;
import com.webobjects.eocontrol.EOObserving;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.eocontrol._EOFlatMutableDictionary;
import com.webobjects.eocontrol._EOMutableDefaultValueDictionary;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSUndoManager;
import com.webobjects.foundation.NSValidation;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.foundation._NSDelegate;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;

public class WODisplayGroup
implements NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling,
NSDisposable,
EOKeyValueArchiving,
EOKeyValueArchiving.Awaking,
Serializable {
    static final long serialVersionUID = -4371292869421265023L;
    private static final NSSelector SetQualifier = new NSSelector("setQualifier", new Class[]{EOQualifier.class});
    private static final NSSelector SetAuxiliaryQualifier = new NSSelector("setAuxiliaryQualifier", new Class[]{EOQualifier.class});
    private static final NSSelector SetQualifierBindings = new NSSelector("setQualifierBindings", new Class[]{NSDictionary.class});
    private static NSSelector _selectObjects = new NSSelector("selectObjectsIdenticalTo", new Class[]{NSArray.class});
    private static NSSelector _insertObject = new NSSelector("_insertObjectAtIndex", new Class[]{Object.class});
    private static NSSelector _deleteObject = new NSSelector("_deleteObject", new Class[]{Object.class});
    private static final String shouldRefetch = "displayGroupShouldRefetchForInvalidatedAllObjects";
    private static final String shouldChangeSelection = "displayGroupShouldChangeSelectionToIndexes";
    private static final String didChangeSelectedObjects = "displayGroupDidChangeSelectedObjects";
    private static final String didChangeSelection = "displayGroupDidChangeSelection";
    private static final String shouldFetch = "displayGroupShouldFetch";
    private static final String didFetch = "displayGroupDidFetchObjects";
    private static final String displayArray = "displayGroupDisplayArrayForObjects";
    private static final String createObjectFailed = "displayGroupCreateObjectFailedForDataSource";
    private static final String shouldInsertObject = "displayGroupShouldInsertObject";
    private static final String didInsertObject = "displayGroupDidInsertObject";
    private static final String shouldDeleteObject = "displayGroupShouldDeleteObject";
    private static final String didDeleteObject = "displayGroupDidDeleteObject";
    private static final String didChangeDataSource = "displayGroupDidChangeDataSource";
    private static final String shouldDisplayAlert = "displayGroupShouldDisplayAlert";
    private static final String DataSourceFieldKey = "dataSource";
    private static final String DelegateFieldKey = "delegate";
    private static final String SortOrderingFieldKey = "sortOrdering";
    private static final String QualifierFieldKey = "qualifier";
    private static final String FlagsFieldKey = "flags";
    private static final String NumberObjectsPerBatchFieldKey = "numObjectsPerBatch";
    private static final String BatchIndexFieldKey = "batchIndex";
    private static final String LocalKeysFieldKey = "localKeys";
    private static final String AllObjectsFieldKey = "allObjects";
    private static final String DisplayedObjectsFieldKey = "displayedObjects";
    private static final String SelectionFieldKey = "selection";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("dataSource", EODataSource.class), new ObjectStreamField("delegate", _NSDelegate.class), new ObjectStreamField("sortOrdering", NSArray.class), new ObjectStreamField("qualifier", EOQualifier.class), new ObjectStreamField("flags", [Z.class), new ObjectStreamField("numObjectsPerBatch", Integer.TYPE), new ObjectStreamField("batchIndex", Integer.TYPE), new ObjectStreamField("localKeys", NSArray.class), new ObjectStreamField("allObjects", NSMutableArray.class), new ObjectStreamField("displayedObjects", NSMutableArray.class), new ObjectStreamField("selection", NSArray.class)};
    private EODataSource _dataSource;
    private transient boolean _customDataSourceClass;
    private NSMutableArray _allObjects;
    private NSMutableArray _displayedObjects;
    private _NSDelegate _delegate;
    private NSArray _selection;
    private NSArray _sortOrdering;
    private EOQualifier _qualifier;
    private NSArray _localKeys;
    private transient NSMutableArray _selectedObjects;
    private transient EOObserverProxy _observerNotificationBeginProxy;
    private transient EOObserverProxy _observerNotificationEndProxy;
    private transient int _updatedObjectIndex;
    private transient NSDictionary _insertedObjectDefaultValues;
    private transient NSMutableArray _savedAllObjects;
    private transient _EOFlatMutableDictionary _queryMatch;
    private transient _EOFlatMutableDictionary _queryMin;
    private transient _EOFlatMutableDictionary _queryMax;
    private transient _EOMutableDefaultValueDictionary _queryOperator;
    private transient String _defaultStringMatchOperator;
    private transient char[] _defaultStringMatchFormat;
    private transient int _DSMFindexOfObject;
    private transient NSMutableDictionary _queryBindings;
    private boolean _flags_selectsFirstObjectAfterFetch;
    private transient boolean _flags_didChangeContents;
    private transient boolean _flags_didChangeSelection;
    private boolean _flags_autoFetch;
    private transient boolean _flags_haveFetched;
    private boolean _flags_validateImmediately;
    private boolean _flags_queryMode;
    private transient boolean _flags_fetchAll;
    private transient boolean _flags_initialized;
    private transient boolean _wasDisposed = false;
    int _numberOfObjectsPerBatch;
    int _batchIndex = 1;
    private static NSArray _stringQualifierOperators;
    private static NSArray _allQualifierOperators;
    private static final int WODISPLAYGROUP_VERSION = 29;
    private static final String QUERYOPERATOR_DEFAULTSTRING = "";
    private static final char QUERYOPERATOR_WILDCARD = '*';
    private static final String QUERYMATCH_DEFAULTSTRING = "%@*";
    private static String _globalDefaultStringMatchFormat;
    private static String _globalDefaultStringMatchOperator;
    private static boolean _globalDefaultForValidatesChangesImmediately;
    public static final String DisplayGroupWillFetchNotification = "WODisplayGroupWillFetch";

    public static String globalDefaultStringMatchOperator() {
        return _globalDefaultStringMatchOperator;
    }

    public static void setGlobalDefaultStringMatchOperator(String string) {
        _globalDefaultStringMatchOperator = string;
    }

    public static String globalDefaultStringMatchFormat() {
        return _globalDefaultStringMatchFormat;
    }

    public static void setGlobalDefaultStringMatchFormat(String string) {
        _globalDefaultStringMatchFormat = string;
    }

    public static boolean globalDefaultForValidatesChangesImmediately() {
        return _globalDefaultForValidatesChangesImmediately;
    }

    public static void setGlobalDefaultForValidatesChangesImmediately(boolean bl) {
        _globalDefaultForValidatesChangesImmediately = bl;
    }

    private void _init(boolean bl) {
        if (!bl) {
            this._selection = NSArray.EmptyArray;
            this._allObjects = new NSMutableArray();
            this._displayedObjects = new NSMutableArray();
            this._delegate = new _NSDelegate(Delegate.class);
            this._numberOfObjectsPerBatch = 0;
            this.setCurrentBatchIndex(1);
        }
        this._queryMatch = new _EOFlatMutableDictionary();
        this._queryMax = new _EOFlatMutableDictionary();
        this._queryMin = new _EOFlatMutableDictionary();
        this._queryOperator = new _EOMutableDefaultValueDictionary();
        this._queryOperator.setDefaultValue((Object)QUERYOPERATOR_DEFAULTSTRING);
        this._queryBindings = new NSMutableDictionary();
        this._insertedObjectDefaultValues = NSDictionary.EmptyDictionary;
        this.setDefaultStringMatchFormat(_globalDefaultStringMatchFormat);
        this._defaultStringMatchOperator = _globalDefaultStringMatchOperator;
        this.setSelectsFirstObjectAfterFetch(true);
    }

    private boolean _isCustomDataSourceClass(Class clazz) {
        return clazz != EODetailDataSource.class && clazz != EOArrayDataSource.class;
    }

    private void _setUpForNewDataSource() {
        if (this._dataSource != null) {
            this._customDataSourceClass = this._isCustomDataSourceClass(this._dataSource.getClass());
            EOEditingContext eOEditingContext = this._dataSource.editingContext();
            if (eOEditingContext != null) {
                NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("objectsChangedInEditingContext", new Class[]{NSNotification._CLASS}), "EOObjectsChangedInEditingContextNotification", (Object)eOEditingContext);
                NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("objectsInvalidatedInEditingContext", new Class[]{NSNotification._CLASS}), "EOInvalidatedAllObjectsInStoreNotification", (Object)eOEditingContext);
            }
        }
    }

    protected void finishInitialization() {
        if (this._flags_initialized) {
            return;
        }
        this._setUpForNewDataSource();
        this._flags_initialized = true;
    }

    public WODisplayGroup() {
        this._init(false);
        this.finishInitialization();
    }

    public void dispose() {
        if (!this._wasDisposed) {
            this._delegate = null;
            NSNotificationCenter.defaultCenter().removeObserver((Object)this);
            EOObserverCenter.removeObserver((EOObserving)this._observerNotificationBeginProxy, (Object)this);
            EODelayedObserverQueue.defaultObserverQueue().dequeueObserver((EODelayedObserver)this._observerNotificationBeginProxy);
            this._observerNotificationBeginProxy = null;
            EOObserverCenter.removeObserver((EOObserving)this._observerNotificationEndProxy, (Object)this);
            EODelayedObserverQueue.defaultObserverQueue().dequeueObserver((EODelayedObserver)this._observerNotificationEndProxy);
            this._observerNotificationEndProxy = null;
            if (this.undoManager() != null) {
                this.undoManager().removeAllActionsWithTarget((Object)this);
            }
            this.setDataSource(null);
            this._selection = null;
            this._selectedObjects = null;
            this._sortOrdering = null;
            this._allObjects = null;
            this._displayedObjects = null;
            this._insertedObjectDefaultValues = null;
            this._queryMin = null;
            this._queryMax = null;
            this._queryMatch = null;
            this._queryOperator = null;
            this._queryBindings = null;
            this._savedAllObjects = null;
            this._defaultStringMatchOperator = null;
            this._defaultStringMatchFormat = null;
            this._localKeys = null;
        }
        this._wasDisposed = true;
    }

    public Object initWithCoder(NSCoder nSCoder) {
        this._init(true);
        this.setDataSource((EODataSource)nSCoder.decodeObject());
        this.setDelegate(nSCoder.decodeObject());
        this.setSortOrderings((NSArray)nSCoder.decodeObject());
        this.setQualifier((EOQualifier)nSCoder.decodeObject());
        this._flags_autoFetch = nSCoder.decodeBoolean();
        this._flags_validateImmediately = nSCoder.decodeBoolean();
        this._flags_selectsFirstObjectAfterFetch = nSCoder.decodeBoolean();
        this._flags_queryMode = nSCoder.decodeBoolean();
        this._numberOfObjectsPerBatch = nSCoder.decodeInt();
        this.setCurrentBatchIndex(nSCoder.decodeInt());
        this.setLocalKeys((NSArray)nSCoder.decodeObject());
        this._allObjects = null;
        this._displayedObjects = null;
        this._selection = null;
        this._selectedObjects = null;
        this._allObjects = (NSMutableArray)nSCoder.decodeObject();
        this._displayedObjects = (NSMutableArray)nSCoder.decodeObject();
        this._selection = (NSArray)nSCoder.decodeObject();
        return this;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put(DataSourceFieldKey, this._dataSource);
        putField.put(DelegateFieldKey, this._delegate);
        putField.put(SortOrderingFieldKey, this._sortOrdering);
        putField.put(QualifierFieldKey, this._qualifier);
        boolean[] blArray = new boolean[]{this._flags_autoFetch, this._flags_validateImmediately, this._flags_selectsFirstObjectAfterFetch, this._flags_queryMode};
        putField.put(FlagsFieldKey, blArray);
        putField.put(NumberObjectsPerBatchFieldKey, this._numberOfObjectsPerBatch);
        putField.put(BatchIndexFieldKey, this.currentBatchIndex());
        putField.put(LocalKeysFieldKey, this._localKeys);
        putField.put(AllObjectsFieldKey, this._allObjects);
        putField.put(DisplayedObjectsFieldKey, this._displayedObjects);
        putField.put(SelectionFieldKey, this._selection);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._init(true);
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this._dataSource = (EODataSource)getField.get(DataSourceFieldKey, null);
        this._delegate = (_NSDelegate)getField.get(DelegateFieldKey, null);
        this._sortOrdering = (NSArray)getField.get(SortOrderingFieldKey, null);
        this._qualifier = (EOQualifier)getField.get(QualifierFieldKey, null);
        boolean[] blArray = (boolean[])getField.get(FlagsFieldKey, null);
        if (blArray != null) {
            int n = 0;
            this._flags_autoFetch = blArray[n++];
            this._flags_validateImmediately = blArray[n++];
            this._flags_selectsFirstObjectAfterFetch = blArray[n++];
            this._flags_queryMode = blArray[n++];
        }
        this._numberOfObjectsPerBatch = getField.get(NumberObjectsPerBatchFieldKey, 0);
        this.setCurrentBatchIndex(getField.get(BatchIndexFieldKey, 1));
        this._localKeys = (NSArray)getField.get(LocalKeysFieldKey, null);
        this._allObjects = (NSMutableArray)getField.get(AllObjectsFieldKey, null);
        this._displayedObjects = (NSMutableArray)getField.get(DisplayedObjectsFieldKey, null);
        this._selection = (NSArray)getField.get(SelectionFieldKey, null);
        this.finishInitialization();
    }

    public void encodeWithCoder(NSCoder nSCoder) {
        nSCoder.encodeObject((Object)this._dataSource);
        nSCoder.encodeObject((Object)this._delegate);
        nSCoder.encodeObject((Object)this._sortOrdering);
        nSCoder.encodeObject((Object)this._qualifier);
        nSCoder.encodeBoolean(this._flags_autoFetch);
        nSCoder.encodeBoolean(this._flags_validateImmediately);
        nSCoder.encodeBoolean(this._flags_selectsFirstObjectAfterFetch);
        nSCoder.encodeBoolean(this._flags_queryMode);
        nSCoder.encodeInt(this._numberOfObjectsPerBatch);
        nSCoder.encodeInt(this.currentBatchIndex());
        nSCoder.encodeObject((Object)this.localKeys());
        nSCoder.encodeObject((Object)this._allObjects);
        nSCoder.encodeObject((Object)this._displayedObjects);
        nSCoder.encodeObject((Object)this._selection);
    }

    public boolean selectsFirstObjectAfterFetch() {
        return this._flags_selectsFirstObjectAfterFetch;
    }

    public void setSelectsFirstObjectAfterFetch(boolean bl) {
        this._flags_selectsFirstObjectAfterFetch = bl;
    }

    public void setValidatesChangesImmediately(boolean bl) {
        this._flags_validateImmediately = bl;
    }

    public boolean validatesChangesImmediately() {
        return this._flags_validateImmediately;
    }

    public void setFetchesOnLoad(boolean bl) {
        this._flags_autoFetch = bl;
    }

    public boolean fetchesOnLoad() {
        return this._flags_autoFetch;
    }

    public NSArray allObjects() {
        return this._allObjects;
    }

    public NSArray displayedObjects() {
        int n;
        if (this._numberOfObjectsPerBatch == 0) {
            return this._displayedObjects;
        }
        NSMutableArray nSMutableArray = new NSMutableArray(this._numberOfObjectsPerBatch);
        int n2 = 0;
        int n3 = this._displayedObjects.count();
        if (n3 > (n = this.currentBatchIndex()) * this._numberOfObjectsPerBatch) {
            n3 = n * this._numberOfObjectsPerBatch;
        }
        for (int i = (n - 1) * this._numberOfObjectsPerBatch; i < n3; ++i) {
            nSMutableArray.insertObjectAtIndex(this._displayedObjects.objectAtIndex(i), n2++);
        }
        return nSMutableArray;
    }

    public void setQualifier(EOQualifier eOQualifier) {
        this._qualifier = eOQualifier;
    }

    public EOQualifier qualifier() {
        return this._qualifier;
    }

    public void setSortOrderings(NSArray nSArray) {
        this._sortOrdering = nSArray;
    }

    public NSArray sortOrderings() {
        return this._sortOrdering;
    }

    public void updateDisplayedObjects() {
        NSMutableArray nSMutableArray = (NSMutableArray)this.selectedObjects();
        NSMutableArray nSMutableArray2 = this._allObjects;
        if (this._delegate.respondsTo(displayArray)) {
            nSMutableArray2 = (NSArray)this._delegate.perform(displayArray, (Object)this, (Object)nSMutableArray2);
        } else {
            if (this._qualifier != null) {
                nSMutableArray2 = EOQualifier.filteredArrayWithQualifier((NSArray)nSMutableArray2, (EOQualifier)this._qualifier);
            }
            if (this._sortOrdering != null) {
                nSMutableArray2 = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)nSMutableArray2, (NSArray)this._sortOrdering);
            }
        }
        this._displayedObjects = new NSMutableArray((NSArray)nSMutableArray2);
        this.selectObjectsIdenticalToSelectFirstOnNoMatch((NSArray)nSMutableArray, false);
        this.redisplay();
    }

    public void setObjectArray(NSArray nSArray) {
        NSMutableArray nSMutableArray = (NSMutableArray)this.selectedObjects();
        this._allObjects = nSArray != null ? new NSMutableArray(nSArray) : new NSMutableArray();
        this.updateDisplayedObjects();
        this.selectObjectsIdenticalToSelectFirstOnNoMatch((NSArray)nSMutableArray, this.selectsFirstObjectAfterFetch());
        this.redisplay();
    }

    public void setDataSource(EODataSource eODataSource) {
        EOEditingContext eOEditingContext;
        if (this._dataSource == eODataSource) {
            return;
        }
        if (this._dataSource != null && (eOEditingContext = this._dataSource.editingContext()) != null) {
            eOEditingContext.removeEditor((Object)this);
            if (eOEditingContext.messageHandler() == this) {
                eOEditingContext.setMessageHandler(null);
            }
        }
        this._dataSource = eODataSource;
        this._setUpForNewDataSource();
        this.setObjectArray(null);
        this._notifyWith(didChangeDataSource, this);
    }

    public EODataSource dataSource() {
        return this._dataSource;
    }

    public void setDelegate(Object object) {
        this._delegate.setDelegate(object);
    }

    public Object delegate() {
        return this._delegate.delegate();
    }

    public NSArray localKeys() {
        if (this._localKeys == null) {
            this._localKeys = NSArray.EmptyArray;
        }
        return this._localKeys;
    }

    public void setLocalKeys(NSArray nSArray) {
        this._localKeys = nSArray;
    }

    public void objectsChangedInEditingContext(NSNotification nSNotification) {
        int n;
        boolean bl = true;
        NSArray nSArray = (NSArray)nSNotification.userInfo().objectForKey((Object)"deleted");
        int n2 = n = nSArray != null ? nSArray.count() : 0;
        if (n != 0) {
            int n3;
            NSMutableSet nSMutableSet = new NSMutableSet((NSArray)this._allObjects);
            NSMutableSet nSMutableSet2 = null;
            NSMutableSet nSMutableSet3 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (n3 = 0; n3 < n; ++n3) {
                Object object = nSArray.objectAtIndex(n3);
                if (!nSMutableSet.containsObject(object)) continue;
                nSMutableSet.removeObject(object);
                bl2 = true;
                if (nSMutableSet2 == null) {
                    nSMutableSet2 = new NSMutableSet((NSArray)this._displayedObjects);
                }
                if (!nSMutableSet2.containsObject(object)) continue;
                nSMutableSet2.removeObject(object);
                bl3 = true;
                if (nSMutableSet3 == null) {
                    nSMutableSet3 = new NSMutableSet((NSArray)this._selectedObjects);
                }
                if (!nSMutableSet3.containsObject(object)) continue;
                nSMutableSet3.removeObject(object);
                bl4 = true;
            }
            if (bl2) {
                this._allObjects = new NSMutableArray(nSMutableSet.allObjects());
                if (bl3) {
                    for (n3 = this._displayedObjects.count() - 1; n3 >= 0; --n3) {
                        Object object = this._displayedObjects.objectAtIndex(n3);
                        if (nSMutableSet2.containsObject(object)) continue;
                        this._displayedObjects.removeObjectAtIndex(n3);
                    }
                    if (bl4) {
                        this._selectedObjects = new NSMutableArray(nSMutableSet3.allObjects());
                    }
                    this._selection = _NSArrayUtilities.indexesForObjectsIndenticalTo((NSArray)this._displayedObjects, (NSArray)this._selectedObjects);
                }
            }
        }
        if (bl || n != 0) {
            this.redisplay();
        }
    }

    public void objectsInvalidatedInEditingContext(NSNotification nSNotification) {
        boolean bl = true;
        if (this._delegate.respondsTo(shouldRefetch)) {
            bl = this._delegate.booleanPerform(shouldRefetch, (Object)this, (Object)nSNotification);
        }
        if (bl) {
            this.fetch();
        }
    }

    public NSUndoManager undoManager() {
        return this._dataSource != null && this._dataSource.editingContext() != null ? this._dataSource.editingContext().undoManager() : null;
    }

    private Object _notifyWith(String string, Object object) {
        if (this._delegate != null && this._delegate.respondsTo(string)) {
            this._delegate.perform(string, object);
        }
        return this;
    }

    private Object _notifyWithWith(String string, Object object, Object object2) {
        if (this._delegate != null && this._delegate.respondsTo(string)) {
            this._delegate.perform(string, object, object2);
        }
        return this;
    }

    private void _notifyRowChanged(int n) {
        if (this._updatedObjectIndex != n) {
            this._updatedObjectIndex = this._updatedObjectIndex == -2 ? n : -1;
        }
        this._flags_didChangeContents = true;
        this.willChange();
    }

    private void _notifySelectionChanged() {
        this._flags_didChangeSelection = true;
        if (this._delegate.respondsTo(didChangeSelection)) {
            this._delegate.perform(didChangeSelection, (Object)this);
        }
        this.willChange();
    }

    public void _beginObserverNotification(Object object) {
        if (!this._flags_haveFetched && this._flags_autoFetch) {
            this.fetch();
        }
    }

    public void _lastObserverNotified(Object object) {
        this._flags_didChangeSelection = false;
        this._flags_didChangeContents = false;
        this._updatedObjectIndex = -2;
        EOObserverCenter.notifyObserversObjectWillChange(null);
    }

    private int _selectionIndex() {
        if (this._selection.count() != 0) {
            return (Integer)this._selection.objectAtIndex(0);
        }
        return -1;
    }

    public NSArray selectionIndexes() {
        return this._selection;
    }

    public NSArray selectedObjects() {
        if (this._selectedObjects == null) {
            this._selectedObjects = (NSMutableArray)_NSArrayUtilities.objectsAtIndexes((NSArray)this._displayedObjects, (NSArray)this._selection);
        }
        return this._selectedObjects;
    }

    public void setSelectedObjects(NSArray nSArray) {
        this._selectedObjects = new NSMutableArray(nSArray);
        this._selection = _NSArrayUtilities.indexesForObjectsIndenticalTo((NSArray)this._displayedObjects, (NSArray)this._selectedObjects);
    }

    public Object selectedObject() {
        NSArray nSArray = this.selectedObjects();
        if (nSArray.count() != 0) {
            return nSArray.objectAtIndex(0);
        }
        return null;
    }

    public void setSelectedObject(Object object) {
        if (object != null) {
            this.setSelectedObjects(new NSArray(object));
        } else {
            this.clearSelection();
        }
    }

    public boolean endEditing() {
        return true;
    }

    public boolean setSelectionIndexes(NSArray nSArray) {
        boolean bl;
        NSArray nSArray2 = null;
        if (nSArray.count() > 1) {
            try {
                nSArray2 = nSArray.sortedArrayUsingComparator(NSComparator.AscendingNumberComparator);
            }
            catch (NSComparator.ComparisonException comparisonException) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)comparisonException);
            }
        } else {
            nSArray2 = this._displayedObjects.count() < 1 ? NSArray.EmptyArray : new NSArray(nSArray);
        }
        NSMutableArray nSMutableArray = (NSMutableArray)_NSArrayUtilities.objectsAtIndexes((NSArray)this._displayedObjects, (NSArray)nSArray2);
        boolean bl2 = !nSMutableArray.equals((Object)this.selectedObjects());
        boolean bl3 = bl = !nSArray2.equals((Object)this._selection);
        if (!bl2 && !bl) {
            return true;
        }
        if (!this.endEditing()) {
            return false;
        }
        if (this._delegate.respondsTo(shouldChangeSelection) && !this._delegate.booleanPerform(shouldChangeSelection, (Object)this, (Object)nSArray)) {
            return false;
        }
        if (bl) {
            this._selection = nSArray2;
        }
        if (bl2) {
            this._selectedObjects = nSMutableArray;
        }
        if (bl2 && this._delegate.respondsTo(didChangeSelectedObjects)) {
            this._delegate.perform(didChangeSelectedObjects, (Object)this);
        }
        if (bl2 || bl) {
            this._notifySelectionChanged();
        }
        return true;
    }

    public boolean selectObject(Object object) {
        return this.selectObjectsIdenticalTo(new NSArray(object));
    }

    public boolean selectObjectsIdenticalTo(NSArray nSArray) {
        NSArray nSArray2 = _NSArrayUtilities.indexesForObjectsIndenticalTo((NSArray)this._displayedObjects, (NSArray)nSArray);
        boolean bl = this.setSelectionIndexes(nSArray2);
        if (nSArray.count() > 0 && nSArray2.count() == 0) {
            return false;
        }
        return bl;
    }

    public boolean selectObjectsIdenticalToSelectFirstOnNoMatch(NSArray nSArray, boolean bl) {
        NSArray nSArray2 = _NSArrayUtilities.indexesForObjectsIndenticalTo((NSArray)this._displayedObjects, (NSArray)nSArray);
        if (nSArray2.count() == 0) {
            nSArray2 = bl && this._displayedObjects.count() != 0 ? new NSArray((Object)new Integer(0)) : _NSArrayUtilities.closestMatchingIndexes((NSArray)this._selection, (int)this._displayedObjects.count(), (boolean)bl);
        }
        return this.setSelectionIndexes(nSArray2);
    }

    public Object selectNext() {
        Integer n;
        if (this._displayedObjects.count() == 0) {
            return null;
        }
        Integer n2 = this._selection.count() == 0 ? _NSUtilities.IntegerForInt((int)0) : ((n = (Integer)this._selection.objectAtIndex(0)) == this._displayedObjects.count() - 1 ? _NSUtilities.IntegerForInt((int)0) : _NSUtilities.IntegerForInt((int)(n + 1)));
        NSArray nSArray = new NSArray((Object)n2);
        this.setSelectionIndexes(nSArray);
        return null;
    }

    public Object selectPrevious() {
        Integer n;
        if (this._displayedObjects.count() == 0) {
            return null;
        }
        Integer n2 = this._selection.count() == 0 ? _NSUtilities.IntegerForInt((int)0) : ((n = (Integer)this._selection.objectAtIndex(0)) == 0 ? _NSUtilities.IntegerForInt((int)(this._displayedObjects.count() - 1)) : _NSUtilities.IntegerForInt((int)(n - 1)));
        NSArray nSArray = new NSArray((Object)n2);
        this.setSelectionIndexes(nSArray);
        return null;
    }

    public boolean clearSelection() {
        return this.setSelectionIndexes(NSArray.EmptyArray);
    }

    public void redisplay() {
        this._notifyRowChanged(-1);
    }

    public boolean _deleteObject(Object object) {
        if (this._delegate != null && this._delegate.respondsTo(shouldDeleteObject) && !this._delegate.booleanPerform(shouldDeleteObject, (Object)this, object)) {
            return false;
        }
        try {
            if (this._dataSource != null) {
                this._dataSource.deleteObject(object);
            }
        }
        catch (Throwable throwable) {
            NSLog._conditionallyLogPrivateException((Throwable)throwable);
            this._presentAlertWithTitleMessage("Error Deleting Object", throwable.toString());
            return false;
        }
        if (this.undoManager() != null) {
            this.undoManager().registerUndoWithTarget((Object)this, _selectObjects, (Object)this.selectedObjects());
            this.undoManager().registerUndoWithTarget((Object)this, _insertObject, (Object)new Object[]{object, _NSUtilities.IntegerForInt((int)this._displayedObjects.indexOfIdenticalObject(object))});
        }
        this._displayedObjects.removeIdenticalObject(object);
        this._allObjects.removeIdenticalObject(object);
        this.selectObjectsIdenticalToSelectFirstOnNoMatch(this.selectedObjects(), false);
        this._notifyWithWith(didDeleteObject, this, object);
        this.redisplay();
        return true;
    }

    private boolean _deleteObjectsAtIndexes(NSArray nSArray) {
        int n;
        int n2 = nSArray.count();
        NSMutableArray nSMutableArray = new NSMutableArray(n2);
        for (n = 0; n < n2; ++n) {
            nSMutableArray.addObject(this._displayedObjects.objectAtIndex(((Integer)nSArray.objectAtIndex(n)).intValue()));
        }
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            if (this._deleteObject(nSMutableArray.objectAtIndex(n))) continue;
            bl = false;
        }
        return bl;
    }

    public boolean deleteSelection() {
        this.endEditing();
        return this._deleteObjectsAtIndexes(this.selectionIndexes());
    }

    public boolean deleteObjectAtIndex(int n) {
        this.endEditing();
        return this._deleteObject(this._allObjects.objectAtIndex(n));
    }

    public void setInsertedObjectDefaultValues(NSDictionary nSDictionary) {
        if (nSDictionary == null) {
            throw new IllegalArgumentException("The inserted object default values dictionary on a WODisplayGroup may not be set to NULL.  Try NSDictionary.EmptyDictionary instead.");
        }
        this._insertedObjectDefaultValues = nSDictionary;
    }

    public NSDictionary insertedObjectDefaultValues() {
        return this._insertedObjectDefaultValues;
    }

    public void _insertObjectAtIndex(Object object) {
        Object object2 = Array.get(object, 0);
        int n = (Integer)Array.get(object, 1);
        this.insertObjectAtIndex(object2, n);
    }

    public void insertObjectAtIndex(Object object, int n) {
        if (!this.endEditing()) {
            return;
        }
        if (n > this._displayedObjects.count()) {
            throw new IllegalArgumentException("WODisplayGroup::insertObjectAtIndex() " + n + " beyond the bounds of " + this._displayedObjects.count());
        }
        if (this._delegate.respondsTo(shouldInsertObject) && !this._delegate.booleanPerform(shouldInsertObject, (Object)this, object, (Object)_NSUtilities.IntegerForInt((int)n))) {
            return;
        }
        try {
            if (this._dataSource != null) {
                this._dataSource.insertObject(object);
            }
        }
        catch (Throwable throwable) {
            NSLog._conditionallyLogPrivateException((Throwable)throwable);
            this._presentAlertWithTitleMessage("Error Inserting Object", throwable.toString());
            return;
        }
        if (this.undoManager() != null) {
            try {
                this.undoManager().registerUndoWithTarget((Object)this, _selectObjects, (Object)this.selectedObjects());
                this.undoManager().registerUndoWithTarget((Object)this, _deleteObject, object);
            }
            catch (Exception exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
        }
        this._displayedObjects.insertObjectAtIndex(object, n);
        this._allObjects.insertObjectAtIndex(object, n);
        this.redisplay();
        this._notifyWithWith(didInsertObject, this, object);
        this.selectObjectsIdenticalTo(new NSArray(object));
    }

    public Object insertNewObjectAtIndex(int n) {
        Object object;
        if (!this.endEditing()) {
            return null;
        }
        Object object2 = object = this._dataSource != null ? this._dataSource.createObject() : null;
        if (object == null) {
            if (this._delegate.respondsTo(createObjectFailed)) {
                this._delegate.perform(createObjectFailed, (Object)this, (Object)this._dataSource);
            } else {
                this._presentAlertWithTitleMessage(QUERYOPERATOR_DEFAULTSTRING, "Data source unable to provide new object.");
            }
            return null;
        }
        NSArray nSArray = this._insertedObjectDefaultValues.allKeys();
        int n2 = nSArray.count();
        while (n2-- > 0) {
            String string = (String)nSArray.objectAtIndex(n2);
            NSKeyValueCodingAdditions.Utility.takeValueForKeyPath((Object)object, (Object)this._insertedObjectDefaultValues.valueForKey(string), (String)string);
        }
        this.insertObjectAtIndex(object, n);
        return object;
    }

    public Object fetch() {
        this._flags_haveFetched = true;
        if (this._dataSource == null) {
            return null;
        }
        if (!this.endEditing()) {
            return null;
        }
        if (this._delegate.respondsTo(shouldFetch) && !this._delegate.booleanPerform(shouldFetch, (Object)this)) {
            return null;
        }
        NSNotificationCenter.defaultCenter().postNotification(DisplayGroupWillFetchNotification, (Object)this);
        if (this.undoManager() != null) {
            this.undoManager().removeAllActionsWithTarget((Object)this);
        }
        if (this._customDataSourceClass && SetQualifierBindings.implementedByObject((Object)this._dataSource)) {
            try {
                SetQualifierBindings.invoke((Object)this._dataSource, (Object)this._queryBindings);
            }
            catch (Exception exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
        }
        NSArray nSArray = this._dataSource.fetchObjects();
        this.setObjectArray(nSArray);
        this._notifyWithWith(didFetch, this, this._allObjects);
        return null;
    }

    private EOQualifier _qualifierForKeyValueOperator(String string, Object object, NSSelector nSSelector) {
        NSSelector nSSelector2;
        try {
            EOClassDescription eOClassDescription = this._dataSource != null ? this._dataSource.classDescriptionForObjects() : null;
            object = eOClassDescription != null ? eOClassDescription.validateValueForKey(object, string) : object;
        }
        catch (NSValidation.ValidationException validationException) {
            NSLog._conditionallyLogPrivateException((Throwable)validationException);
        }
        if (nSSelector == EOQualifier.QualifierOperatorEqual) {
            String string2 = (String)this._queryOperator.objectForKey((Object)string);
            if (string2 == null) {
                string2 = QUERYOPERATOR_DEFAULTSTRING;
            }
            if (!(object instanceof String)) {
                if (string2.compareTo(QUERYOPERATOR_DEFAULTSTRING) == 0) {
                    string2 = "=";
                }
            } else {
                String string3 = (String)object;
                int n = string3.length();
                if (n == 0) {
                    return null;
                }
                if (string2.compareTo("is") == 0) {
                    string2 = "=";
                } else {
                    StringBuffer stringBuffer = new StringBuffer(n + 4);
                    if (string2.compareTo(QUERYOPERATOR_DEFAULTSTRING) == 0) {
                        if (this._DSMFindexOfObject > 0) {
                            stringBuffer.append(this._defaultStringMatchFormat, 0, this._DSMFindexOfObject);
                        }
                        stringBuffer.append(string3);
                        int n2 = this._DSMFindexOfObject + 2;
                        if (n2 < this._defaultStringMatchFormat.length) {
                            stringBuffer.append(this._defaultStringMatchFormat, n2, this._defaultStringMatchFormat.length - n2);
                        }
                        object = new String(stringBuffer);
                        string2 = this._defaultStringMatchOperator;
                    } else if (string2.compareTo("starts with") == 0) {
                        stringBuffer.append(string3);
                        stringBuffer.append('*');
                        object = new String(stringBuffer);
                        string2 = this._defaultStringMatchOperator;
                    } else if (string2.compareTo("ends with") == 0) {
                        stringBuffer.append('*');
                        stringBuffer.append(string3);
                        object = new String(stringBuffer);
                        string2 = this._defaultStringMatchOperator;
                    } else if (string2.compareTo("contains") == 0) {
                        stringBuffer.append('*');
                        stringBuffer.append(string3);
                        stringBuffer.append('*');
                        object = new String(stringBuffer);
                        string2 = this._defaultStringMatchOperator;
                    }
                    stringBuffer = null;
                }
            }
            nSSelector2 = EOQualifier.operatorSelectorForString((String)string2);
        } else {
            nSSelector2 = nSSelector;
        }
        if (nSSelector2 == null) {
            NSLog.err.appendln((Object)("***Error: unknown operator. Discarding query parameter " + string + " " + this._queryOperator.objectForKey((Object)string) + " " + object));
            return null;
        }
        return new EOKeyValueQualifier(string, nSSelector2, object);
    }

    private void _addQualifiersToArrayForValuesOperator(NSMutableArray nSMutableArray, NSDictionary nSDictionary, NSSelector nSSelector) {
        Enumeration enumeration = nSDictionary.keyEnumerator();
        while (enumeration.hasMoreElements()) {
            EOQualifier eOQualifier;
            String string = (String)enumeration.nextElement();
            Object object = nSDictionary.valueForKey(string);
            if (object == null || (eOQualifier = this._qualifierForKeyValueOperator(string, object, nSSelector)) == null) continue;
            nSMutableArray.addObject((Object)eOQualifier);
        }
    }

    public String defaultStringMatchOperator() {
        return this._defaultStringMatchOperator;
    }

    public void setDefaultStringMatchOperator(String string) {
        this._defaultStringMatchOperator = string;
    }

    public String defaultStringMatchFormat() {
        return new String(this._defaultStringMatchFormat);
    }

    public void setDefaultStringMatchFormat(String string) {
        int n;
        if (string == null) {
            string = QUERYMATCH_DEFAULTSTRING;
        }
        if ((n = string.indexOf("%@")) < 0) {
            throw new IllegalArgumentException("DisplayGroup.setDefaultStringMatchFormat() : illegal format string \"" + string + "\".  It must contain \"%@\".");
        }
        this._defaultStringMatchFormat = string.toCharArray();
        this._DSMFindexOfObject = n;
    }

    public EOQualifier qualifierFromQueryValues() {
        NSMutableArray nSMutableArray = new NSMutableArray();
        this._addQualifiersToArrayForValuesOperator(nSMutableArray, (NSDictionary)this._queryMax, EOQualifier.QualifierOperatorLessThanOrEqualTo);
        this._addQualifiersToArrayForValuesOperator(nSMutableArray, (NSDictionary)this._queryMin, EOQualifier.QualifierOperatorGreaterThanOrEqualTo);
        this._addQualifiersToArrayForValuesOperator(nSMutableArray, (NSDictionary)this._queryMatch, EOQualifier.QualifierOperatorEqual);
        int n = nSMutableArray.count();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return (EOQualifier)nSMutableArray.objectAtIndex(0);
        }
        return new EOAndQualifier((NSArray)nSMutableArray);
    }

    public void qualifyDisplayGroup() {
        this.setInQueryMode(false);
        this.setQualifier(this.qualifierFromQueryValues());
        this.updateDisplayedObjects();
    }

    public void qualifyDataSource() {
        this.endEditing();
        this.setInQueryMode(false);
        NSSelector nSSelector = null;
        if (this._customDataSourceClass) {
            if (SetAuxiliaryQualifier.implementedByObject((Object)this._dataSource)) {
                nSSelector = SetAuxiliaryQualifier;
            } else if (SetQualifier.implementedByObject((Object)this._dataSource)) {
                nSSelector = SetQualifier;
            }
        }
        if (nSSelector != null) {
            try {
                nSSelector.invoke((Object)this._dataSource, (Object)this.qualifierFromQueryValues());
            }
            catch (Exception exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
        }
        this.fetch();
        this.setCurrentBatchIndex(1);
    }

    public void setInQueryMode(boolean bl) {
        if (bl != this.inQueryMode()) {
            if (bl) {
                this._savedAllObjects = this._allObjects;
                this.setObjectArray(new NSArray((Object)this._queryMatch));
                this.selectObject(this._queryMatch);
            } else {
                NSMutableArray nSMutableArray = this._savedAllObjects;
                this._savedAllObjects = null;
                this.setObjectArray((NSArray)nSMutableArray);
            }
        }
    }

    public boolean inQueryMode() {
        return this._savedAllObjects != null;
    }

    private void _presentAlertWithTitleMessage(String string, String string2) {
        NSLog.err.appendln((Object)("<" + this.getClass().getName() + " " + string + ":" + string2 + QUERYOPERATOR_DEFAULTSTRING));
    }

    public void encodeWithKeyValueArchiver(EOKeyValueArchiver eOKeyValueArchiver) {
        eOKeyValueArchiver.encodeInt(this._numberOfObjectsPerBatch, "numberOfObjectsPerBatch");
        eOKeyValueArchiver.encodeBool(this.fetchesOnLoad(), "fetchesOnLoad");
        eOKeyValueArchiver.encodeBool(this.validatesChangesImmediately(), "validatesChangesImmediately");
        eOKeyValueArchiver.encodeBool(this.selectsFirstObjectAfterFetch(), "selectsFirstObjectAfterFetch");
        eOKeyValueArchiver.encodeObject((Object)this.localKeys(), LocalKeysFieldKey);
        eOKeyValueArchiver.encodeObject((Object)this._dataSource, DataSourceFieldKey);
        eOKeyValueArchiver.encodeObject((Object)this._sortOrdering, SortOrderingFieldKey);
        eOKeyValueArchiver.encodeObject((Object)this._qualifier, QualifierFieldKey);
        eOKeyValueArchiver.encodeObject((Object)this.defaultStringMatchFormat(), "formatForLikeQualifier");
        eOKeyValueArchiver.encodeObject((Object)this._insertedObjectDefaultValues, "insertedObjectDefaultValues");
    }

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver eOKeyValueUnarchiver) {
        return new WODisplayGroup(eOKeyValueUnarchiver);
    }

    private WODisplayGroup(EOKeyValueUnarchiver eOKeyValueUnarchiver) {
        this._init(false);
        this.setNumberOfObjectsPerBatch(eOKeyValueUnarchiver.decodeIntForKey("numberOfObjectsPerBatch"));
        this.setFetchesOnLoad(eOKeyValueUnarchiver.decodeBoolForKey("fetchesOnLoad"));
        this.setValidatesChangesImmediately(eOKeyValueUnarchiver.decodeBoolForKey("validatesChangesImmediately"));
        this.setSelectsFirstObjectAfterFetch(eOKeyValueUnarchiver.decodeBoolForKey("selectsFirstObjectAfterFetch"));
        this.setLocalKeys((NSArray)eOKeyValueUnarchiver.decodeObjectForKey(LocalKeysFieldKey));
        this._dataSource = (EODataSource)eOKeyValueUnarchiver.decodeObjectForKey(DataSourceFieldKey);
        this.setSortOrderings((NSArray)eOKeyValueUnarchiver.decodeObjectForKey(SortOrderingFieldKey));
        this.setQualifier((EOQualifier)eOKeyValueUnarchiver.decodeObjectForKey(QualifierFieldKey));
        this.setDefaultStringMatchFormat((String)eOKeyValueUnarchiver.decodeObjectForKey("formatForLikeQualifier"));
        NSDictionary nSDictionary = (NSDictionary)eOKeyValueUnarchiver.decodeObjectForKey("insertedObjectDefaultValues");
        if (nSDictionary == null) {
            nSDictionary = NSDictionary.EmptyDictionary;
        }
        this.setInsertedObjectDefaultValues(nSDictionary);
        this.finishInitialization();
    }

    public void awakeFromKeyValueUnarchiver(EOKeyValueUnarchiver eOKeyValueUnarchiver) {
        if (this._dataSource != null) {
            eOKeyValueUnarchiver.ensureObjectAwake((Object)this._dataSource);
        }
        if (this.fetchesOnLoad()) {
            this.fetch();
        }
    }

    public NSArray relationalQualifierOperators() {
        return EOQualifier.relationalQualifierOperators();
    }

    public NSArray allQualifierOperators() {
        return _allQualifierOperators;
    }

    public NSArray stringQualifierOperators() {
        return _stringQualifierOperators;
    }

    public void setNumberOfObjectsPerBatch(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("WODisplayGroup.setNumberOfObjectsPerBatch(): invalid count " + n);
        }
        if (this._numberOfObjectsPerBatch != n) {
            this.clearSelection();
        }
        this._numberOfObjectsPerBatch = n;
        this._batchIndex = 1;
    }

    public int numberOfObjectsPerBatch() {
        return this._numberOfObjectsPerBatch;
    }

    public Object displayNextBatch() {
        if (this._numberOfObjectsPerBatch == 0) {
            return null;
        }
        this.setCurrentBatchIndex(this._batchIndex + 1);
        this.clearSelection();
        return null;
    }

    public Object displayPreviousBatch() {
        if (this._numberOfObjectsPerBatch == 0) {
            return null;
        }
        this.setCurrentBatchIndex(this._batchIndex - 1);
        this.clearSelection();
        return null;
    }

    public int batchCount() {
        if (this._numberOfObjectsPerBatch == 0) {
            return 0;
        }
        if (this._displayedObjects.count() == 0) {
            return 1;
        }
        return (this._displayedObjects.count() - 1) / this._numberOfObjectsPerBatch + 1;
    }

    public boolean hasMultipleBatches() {
        return this.batchCount() > 1;
    }

    public int currentBatchIndex() {
        return this._batchIndex;
    }

    public void setCurrentBatchIndex(int n) {
        if (this._numberOfObjectsPerBatch == 0) {
            return;
        }
        int n2 = this.batchCount();
        this._batchIndex = n > n2 ? 1 : (n < 1 ? (n2 > 0 ? n2 : 1) : n);
    }

    public int indexOfFirstDisplayedObject() {
        return this._numberOfObjectsPerBatch * (this.currentBatchIndex() - 1) + 1;
    }

    public int indexOfLastDisplayedObject() {
        int n = this._numberOfObjectsPerBatch * this.currentBatchIndex();
        int n2 = this.allObjects().count();
        if (this._numberOfObjectsPerBatch == 0) {
            return n2;
        }
        return n2 < n ? n2 : n;
    }

    public Object displayBatchContainingSelectedObject() {
        int n = 1;
        int n2 = this._selectionIndex();
        if (this.batchCount() > 0) {
            n = n2 / this._numberOfObjectsPerBatch + 1;
        }
        if (this._batchIndex != n) {
            this.setCurrentBatchIndex(n);
            return null;
        }
        return QUERYOPERATOR_DEFAULTSTRING;
    }

    public NSMutableDictionary queryMatch() {
        return this._queryMatch;
    }

    public NSMutableDictionary queryOperator() {
        return this._queryOperator;
    }

    public NSMutableDictionary queryMax() {
        return this._queryMax;
    }

    public NSMutableDictionary queryMin() {
        return this._queryMin;
    }

    public NSMutableDictionary queryBindings() {
        return this._queryBindings;
    }

    public void editingContextPresentErrorMessage(EOEditingContext eOEditingContext, String string) {
        this._presentAlertWithTitleMessage("EditingContext Error", string);
    }

    public Object insert() {
        int n = this._selectionIndex();
        if (n < 0) {
            Object object = this.insertNewObjectAtIndex(this._displayedObjects.count());
        } else {
            Object object = this.insertNewObjectAtIndex(n + 1);
        }
        this.displayBatchContainingSelectedObject();
        return null;
    }

    public Object delete() {
        this.deleteSelection();
        this.displayBatchContainingSelectedObject();
        return null;
    }

    public String detailKey() {
        if (this.hasDetailDataSource()) {
            return ((EODetailDataSource)this._dataSource).detailKey();
        }
        return null;
    }

    public void setDetailKey(String string) {
        if (this.hasDetailDataSource()) {
            ((EODetailDataSource)this._dataSource).setDetailKey(string);
        }
    }

    public Object masterObject() {
        if (this.hasDetailDataSource()) {
            return ((EODetailDataSource)this._dataSource).masterObject();
        }
        return null;
    }

    public void setMasterObject(Object object) {
        String string = this.detailKey();
        if (string != null) {
            this._dataSource.qualifyWithRelationshipKey(string, object);
            if (this.fetchesOnLoad()) {
                this.fetch();
            }
        }
    }

    public boolean hasDetailDataSource() {
        return this._dataSource instanceof EODetailDataSource;
    }

    public void willChange() {
        EOObserverCenter.notifyObserversObjectWillChange((Object)this);
        EOObserverCenter.notifyObserversObjectWillChange(null);
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object handleQueryWithUnboundKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)string);
    }

    public void handleTakeValueForUnboundKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)object, (String)string);
    }

    public void unableToSetNullForKey(String string) {
        if (string.equals("numberOfObjectsPerBatch")) {
            this.setNumberOfObjectsPerBatch(0);
        } else {
            NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" dataSource=" + this._dataSource);
        stringBuffer.append(" delegate=" + this._delegate);
        stringBuffer.append(" sortOrdering=" + this._sortOrdering);
        stringBuffer.append(" qualifier=" + this._qualifier);
        stringBuffer.append(" localKeys=" + this._localKeys);
        stringBuffer.append(" insertedObjectDefaultValues=" + this._insertedObjectDefaultValues);
        stringBuffer.append(" numberOfObjectsPerBatch=" + this._numberOfObjectsPerBatch);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    static {
        _globalDefaultStringMatchFormat = QUERYMATCH_DEFAULTSTRING;
        _globalDefaultStringMatchOperator = "caseInsensitiveLike";
        _globalDefaultForValidatesChangesImmediately = false;
        _stringQualifierOperators = new NSArray((Object[])new String[]{"starts with", "contains", "ends with", "is", "like"});
        _allQualifierOperators = _stringQualifierOperators.arrayByAddingObjectsFromArray(EOQualifier.relationalQualifierOperators());
    }

    public static interface Delegate {
        public boolean displayGroupShouldRefetchForInvalidatedAllObjects(WODisplayGroup var1, NSNotification var2);

        public boolean displayGroupShouldChangeSelectionToIndexes(WODisplayGroup var1, NSArray var2);

        public void displayGroupDidChangeSelectedObjects(WODisplayGroup var1);

        public void displayGroupDidChangeSelection(WODisplayGroup var1);

        public boolean displayGroupShouldFetch(WODisplayGroup var1);

        public void displayGroupDidFetchObjects(WODisplayGroup var1, NSArray var2);

        public NSArray displayGroupDisplayArrayForObjects(WODisplayGroup var1, NSArray var2);

        public void displayGroupCreateObjectFailedForDataSource(WODisplayGroup var1, EODataSource var2);

        public boolean displayGroupShouldInsertObject(WODisplayGroup var1, Object var2, int var3);

        public void displayGroupDidInsertObject(WODisplayGroup var1, Object var2);

        public boolean displayGroupShouldDeleteObject(WODisplayGroup var1, Object var2);

        public void displayGroupDidDeleteObject(WODisplayGroup var1, Object var2);

        public void displayGroupDidChangeDataSource(WODisplayGroup var1);

        public boolean displayGroupShouldDisplayAlert(WODisplayGroup var1, String var2, String var3);
    }
}

