/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOAdaptor;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOCookie;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WOMultipartIterator;
import com.webobjects.appserver._CookieParser;
import com.webobjects.appserver._private.WOComponentRequestHandler;
import com.webobjects.appserver._private.WODynamicURL;
import com.webobjects.appserver._private.WOEncodingDetector;
import com.webobjects.appserver._private.WOFileUploadSupport;
import com.webobjects.appserver._private.WOInputStreamData;
import com.webobjects.appserver._private.WOProperties;
import com.webobjects.appserver._private.WOShared;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.appserver._private.WOURLFormatException;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNumberFormatter;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Enumeration;

public class WORequest
extends WOMessage
implements Cloneable {
    private String _method;
    private WODynamicURL _uriDecomposed;
    private String _uri;
    private String _defaultFormValueEncoding;
    private String _formValueEncoding;
    private NSMutableDictionary _formValues;
    private NSDictionary _cookie;
    private String _applicationURLPrefix;
    private NSArray _requestHandlerPathArray;
    private NSArray _browserLanguages;
    private int _requestType;
    private boolean _isUsingWebServer;
    private boolean _formValueEncodingDetectionEnabled;
    private int _applicationNumber;
    private int NOT_SET = 0;
    private String CookieHeader = "cookie";
    private String CookieHeaderIIS = "http_cookie";
    private InetAddress _originatingAddress = null;
    private int _originatingPort = -1;
    private WOContext _context;
    private boolean _finishedParsingMultipartFormData = false;
    private boolean _firstFormValueInvocation = true;
    boolean _legacyMultipart = false;
    boolean _setLegacyMultipart = false;
    WOMultipartIterator _multipartIterator = null;
    public static final String SessionIDKey = "wosid";
    public static final String InstanceKey = "woinst";
    public static final String DataKey = "wodata";
    public static final String ContextIDKey = "wocid";
    public static final String SenderIDKey = "woeid";
    public static final String PageNameKey = "wopage";
    public static final String _IsmapCoords = "WOIsmapCoords";
    public static final String SingleInstanceIDString = "-1";
    public static final int SingleInstanceID = -1;
    private static String _defaultLanguageFamily = "en";
    private boolean _iteratorUsed = false;
    private boolean _formValuesUsed = false;
    private boolean _streamUsed = false;

    public WORequest(String string, String string2, String string3, NSDictionary nSDictionary, NSData nSData, NSDictionary nSDictionary2) {
        if (string == null) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + ">: Can not initialize a WORequest with a null method.");
        }
        if (this.getClass().isAssignableFrom(WORequest.class) && !string.equals("GET") && !string.equals("POST") && !string.equals("HEAD")) {
            NSLog.err.appendln((Object)("<WORequest>: Method '" + string + "' is not supported. To support '" + string + "', you will have to implement a subclass of WORequest, and force WebObjects to instantiate it by implementing WOApplication's createRequest() method in your subclass of WOApplication."));
            throw new IllegalArgumentException("<WORequest>: Method '" + string + "' is not supported.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + ">: No URL was provided.");
        }
        this._method = string;
        if (string3 == null) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + ">: No HTTP-version was provided.");
        }
        if (!string3.startsWith("HTTP/")) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + ">: '" + string3 + "' is not a valid HTTP-version");
        }
        this.setHTTPVersion(string3);
        this.setHeaders(nSDictionary);
        if (nSData == null) {
            nSData = new NSData();
        }
        if (nSData instanceof WOInputStreamData) {
            this._contentData = (NSMutableData)nSData;
        } else {
            this.appendContentData(nSData);
        }
        this.setUserInfo(nSDictionary2);
        this._defaultFormValueEncoding = WOMessage.defaultEncoding();
        this._formValueEncodingDetectionEnabled = false;
        this._formValueEncoding = WOMessage.defaultEncoding();
        this._formValues = null;
        this._cookie = null;
        this._applicationURLPrefix = null;
        this._requestHandlerPathArray = null;
        this._requestType = 0;
        this._applicationNumber = this.NOT_SET;
        if (this.headerForKey("x-webobjects-adaptor-version") != null) {
            this._setIsUsingWebServer(true);
        } else {
            this._setIsUsingWebServer(false);
        }
        this._uri = string2;
    }

    public InetAddress _originatingAddress() {
        return this._originatingAddress;
    }

    public void _setOriginatingAddress(InetAddress inetAddress) {
        this._originatingAddress = inetAddress;
    }

    public int _originatingPort() {
        return this._originatingPort;
    }

    public void _setOriginatingPort(int n) {
        this._originatingPort = n;
    }

    protected WOContext _context() {
        return this._context;
    }

    protected void _setContext(WOContext wOContext) {
        this._context = wOContext;
    }

    public Object clone() {
        WORequest wORequest = null;
        try {
            wORequest = WOApplication.application().createRequest(this._method, this._uriDecomposed.toString(), this._httpVersion, (NSDictionary)this._headers, (NSData)this._contentData, this._userInfo);
            wORequest.setDefaultFormValueEncoding(this._defaultFormValueEncoding);
            wORequest.setFormValueEncodingDetectionEnabled(this._formValueEncodingDetectionEnabled);
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<" + this.getClass().getName() + "> Exception occurred while cloning (returning null) : " + exception.toString()));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                NSLog.debug.appendln((Throwable)exception);
            }
            wORequest = null;
        }
        return wORequest;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " (" + super.toString() + ") method=" + this._method + " uri=" + this.uri() + " defaultFormValueEncoding=" + this._defaultFormValueEncoding + " formValueEncodingDetectionEnabled=" + (this._formValueEncodingDetectionEnabled ? "YES" : "NO") + " formValueEncoding=" + this._formValueEncoding + " formValues=" + this.formValues() + " >";
    }

    public InputStream contentInputStream() {
        if (this.content() instanceof WOInputStreamData && this._streamAllowed()) {
            return ((WOInputStreamData)this.content()).inputStream();
        }
        return null;
    }

    private static NSArray _cleanAbbreviationArray(NSArray nSArray) {
        NSMutableArray nSMutableArray = new NSMutableArray(nSArray.count());
        int n = nSArray.count();
        String string = null;
        for (int i = 0; i < n; ++i) {
            string = ((String)nSArray.objectAtIndex(i)).trim();
            int n2 = string.indexOf(45);
            if (n2 == -1) {
                n2 = string.indexOf(59);
            }
            if (n2 == -1) {
                nSMutableArray.addObject((Object)string);
                continue;
            }
            nSMutableArray.addObject((Object)string.substring(0, n2));
        }
        return nSMutableArray;
    }

    public String method() {
        return this._method;
    }

    public String uri() {
        return this._uri;
    }

    public String requestHandlerKey() {
        String string = this._uriDecomposed().requestHandlerKey();
        return string;
    }

    public NSArray requestHandlerPathArray() {
        String string = this._uriDecomposed().requestHandlerPath();
        if (this._requestHandlerPathArray == null && string != null) {
            this._requestHandlerPathArray = NSArray.componentsSeparatedByString((String)string, (String)"/");
        }
        return this._requestHandlerPathArray;
    }

    public NSArray browserLanguages() {
        if (this._browserLanguages == null) {
            NSArray nSArray = null;
            String string = this.headerForKey("accept-language");
            if (string != null) {
                NSArray nSArray2 = NSArray.componentsSeparatedByString((String)string, (String)",");
                nSArray = WORequest._cleanAbbreviationArray(nSArray2);
            }
            this._browserLanguages = WOProperties.TheLanguageDictionary.objectsForKeys(nSArray, null);
        }
        return this._browserLanguages;
    }

    public String adaptorPrefix() {
        return this._uriDecomposed().prefix();
    }

    public String applicationName() {
        return this._uriDecomposed().applicationName();
    }

    private int _applicationNumberFromURI() {
        String string = this._uriDecomposed().applicationNumber();
        int n = -1;
        if (string != null && string.length() != 0) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public int applicationNumber() {
        if (this._applicationNumber == this.NOT_SET) {
            if (WORequest._lookForIDsInCookiesFirst()) {
                String string = this.cookieValueForKey(InstanceKey);
                this._applicationNumber = string != null ? Integer.parseInt(string) : this._applicationNumberFromURI();
            } else {
                String string;
                this._applicationNumber = this._applicationNumberFromURI();
                if (this._applicationNumber == -1 && (string = this.cookieValueForKey(InstanceKey)) != null) {
                    this._applicationNumber = Integer.parseInt(string);
                }
            }
        }
        return this._applicationNumber;
    }

    public void _setApplicationNumber(int n, boolean bl) {
        if (bl || this._applicationNumber == this.NOT_SET) {
            this._applicationNumber = n;
        }
    }

    public String requestHandlerPath() {
        return this._uriDecomposed().requestHandlerPath();
    }

    public String queryString() {
        return this._uriDecomposed().queryString();
    }

    private char[] _formDataFromQueryString() {
        char[] cArray = null;
        String string = this.queryString();
        if (string != null) {
            cArray = string.toCharArray();
        }
        return cArray;
    }

    private char[] _formDataFromContent() {
        String string = this.contentString();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    private static void _extractValuesFromFormData(NSMutableDictionary nSMutableDictionary, char[] cArray, String string) {
        WORequest._extractValuesFromFormData(nSMutableDictionary, cArray, string, -1);
    }

    private static void _extractValuesFromFormData(NSMutableDictionary nSMutableDictionary, char[] cArray, String string, int n) {
        block15: {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(256);
                ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream;
                int n2 = 0;
                for (int i = n <= 0 ? cArray.length : n; i >= 0; --i) {
                    if (i == 0 || cArray[n2] == '&') {
                        String string2 = byteArrayOutputStream == byteArrayOutputStream3 ? _IsmapCoords : byteArrayOutputStream.toString(string);
                        String string3 = byteArrayOutputStream3.toString(string);
                        NSMutableArray nSMutableArray = (NSMutableArray)nSMutableDictionary.objectForKey((Object)string2);
                        if (nSMutableArray != null) {
                            nSMutableArray.addObject((Object)string3);
                        } else {
                            NSMutableArray nSMutableArray2 = new NSMutableArray((Object)string3);
                            nSMutableDictionary.setObjectForKey((Object)nSMutableArray2, (Object)string2);
                        }
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream2.reset();
                        byteArrayOutputStream3 = byteArrayOutputStream;
                    } else if (cArray[n2] == '=') {
                        byteArrayOutputStream3 = byteArrayOutputStream2;
                    } else if (cArray[n2] == '+') {
                        byteArrayOutputStream3.write(32);
                    } else if (cArray[n2] == '%') {
                        char c;
                        if (i > 2) {
                            --i;
                            c = cArray[++n2];
                            int n3 = Character.digit(c, 16);
                            --i;
                            c = cArray[++n2];
                            n3 = n3 * 16 + Character.digit(c, 16);
                            c = (char)n3;
                        } else {
                            c = '0';
                        }
                        byteArrayOutputStream3.write(c);
                    } else {
                        byteArrayOutputStream3.write(cArray[n2]);
                    }
                    ++n2;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)128L)) break block15;
                NSLog.err.appendln((Throwable)unsupportedEncodingException);
            }
        }
    }

    public void setDefaultFormValueEncoding(String string) {
        if (string != null && string != this._defaultFormValueEncoding) {
            this._formValueEncoding = this._defaultFormValueEncoding = string;
            this._formValues = null;
        }
    }

    public String defaultFormValueEncoding() {
        return this._defaultFormValueEncoding;
    }

    public void setFormValueEncodingDetectionEnabled(boolean bl) {
        this._formValueEncodingDetectionEnabled = bl;
    }

    public boolean isFormValueEncodingDetectionEnabled() {
        return this._formValueEncodingDetectionEnabled;
    }

    public String formValueEncoding() {
        return this._formValueEncoding;
    }

    public NSArray formValueKeys() {
        NSDictionary nSDictionary = this.formValues();
        if (nSDictionary != null) {
            return nSDictionary.allKeys();
        }
        return null;
    }

    public Enumeration _formValueKeyEnumerator() {
        NSDictionary nSDictionary = this.formValues();
        if (nSDictionary != null) {
            return nSDictionary.keyEnumerator();
        }
        return new NSMutableArray().objectEnumerator();
    }

    public NSArray formValuesForKey(String string) {
        NSMutableArray nSMutableArray = null;
        if (string != null) {
            NSDictionary nSDictionary = null;
            nSDictionary = this.formValues();
            Object object = null;
            if (nSDictionary != null && (object = nSDictionary.objectForKey((Object)string)) != null) {
                nSMutableArray = object instanceof NSMutableArray ? (NSMutableArray)object : new NSMutableArray(object);
            }
        }
        return nSMutableArray;
    }

    public Object formValueForKey(String string) {
        Object object = null;
        NSArray nSArray = this.formValuesForKey(string);
        if (nSArray != null && nSArray.count() != 0) {
            object = nSArray.objectAtIndex(0);
        }
        return object;
    }

    public String stringFormValueForKey(String string) {
        String string2;
        Object object = this.formValueForKey(string);
        String string3 = string2 = object != null ? object.toString() : null;
        if (string2 != null && string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public Number numericFormValueForKey(String string, NSNumberFormatter nSNumberFormatter) {
        Number number;
        block3: {
            String string2 = this.stringFormValueForKey(string);
            number = null;
            if (string2 != null && nSNumberFormatter != null) {
                try {
                    number = (Number)nSNumberFormatter.parseObject(string2);
                }
                catch (ParseException parseException) {
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)128L)) break block3;
                    NSLog.err.appendln((Throwable)parseException);
                }
            }
        }
        return number;
    }

    public NSTimestamp dateFormValueForKey(String string, NSTimestampFormatter nSTimestampFormatter) {
        NSTimestamp nSTimestamp;
        block3: {
            String string2 = this.stringFormValueForKey(string);
            nSTimestamp = null;
            if (string2 != null && nSTimestampFormatter != null) {
                try {
                    nSTimestamp = (NSTimestamp)nSTimestampFormatter.parseObject(string2);
                }
                catch (ParseException parseException) {
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)128L)) break block3;
                    NSLog.err.appendln((Throwable)parseException);
                }
            }
        }
        return nSTimestamp;
    }

    private String _cookieDescription() {
        String string = this.headerForKey(this.CookieHeader);
        if (string == null) {
            string = this.headerForKey(this.CookieHeaderIIS);
        }
        return string;
    }

    private NSDictionary _cookieDictionary() {
        if (this._cookie == null) {
            this._cookie = _CookieParser.parse(this._cookieDescription());
        }
        return this._cookie;
    }

    public NSArray cookieValuesForKey(String string) {
        NSDictionary nSDictionary = this._cookieDictionary();
        return (NSArray)nSDictionary.objectForKey((Object)string);
    }

    public String cookieValueForKey(String string) {
        NSDictionary nSDictionary = this.cookieValues();
        NSArray nSArray = (NSArray)nSDictionary.objectForKey((Object)string);
        if (nSArray != null && nSArray.count() > 0) {
            return nSArray.objectAtIndex(0).toString();
        }
        return null;
    }

    public NSDictionary cookieValues() {
        NSDictionary nSDictionary = this._cookieDictionary();
        return nSDictionary;
    }

    public NSArray cookies() {
        if (this._cookies == null) {
            Enumeration enumeration;
            this._initCookies();
            NSDictionary nSDictionary = this._cookieDictionary();
            Enumeration enumeration2 = enumeration = nSDictionary != null ? nSDictionary.keyEnumerator() : null;
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this._cookies.addObject((Object)new WOCookie(string, nSDictionary.objectForKey((Object)string).toString()));
                }
            }
        }
        return this._cookies;
    }

    protected void _setIsUsingWebServer(boolean bl) {
        this._isUsingWebServer = bl;
    }

    public boolean isUsingWebServer() {
        return this._isUsingWebServer;
    }

    public WODynamicURL _uriDecomposed() {
        if (this._uriDecomposed == null) {
            try {
                try {
                    this._uriDecomposed = new WODynamicURL(this._uri);
                    this._uriDecomposed.check();
                }
                catch (WOURLFormatException wOURLFormatException) {
                    int n = -1;
                    String string = null;
                    String string2 = null;
                    if (!this.isUsingWebServer()) {
                        WOApplication wOApplication = WOApplication.application();
                        if (this._uriDecomposed != null) {
                            string = this._uriDecomposed.prefix();
                            string2 = this._uriDecomposed.queryString();
                        }
                        if (string != null) {
                            this._uriDecomposed = new WODynamicURL(string);
                        } else {
                            String string3 = wOApplication.cgiAdaptorURL();
                            int n2 = string3.indexOf("//");
                            if (n2 > 0 && string3.length() - n2 > 2) {
                                n = string3.indexOf(47, n2 + 2);
                            }
                            if (n > 0) {
                                this._uriDecomposed = new WODynamicURL(string3.substring(n));
                            }
                        }
                        if (n > 0 || string != null) {
                            this._uriDecomposed.setApplicationName(wOApplication.name());
                            if (string2 != null) {
                                this._uriDecomposed.setQueryString(string2);
                            }
                            this._uriDecomposed.check();
                        }
                    }
                    if (this.isUsingWebServer() || n < 0 && string == null) {
                        throw new WOURLFormatException("<" + this.getClass().getName() + ">: URI '" + this._uriDecomposed + "' is invalid:\n" + wOURLFormatException.toString());
                    }
                }
            }
            catch (WOURLFormatException wOURLFormatException) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)wOURLFormatException);
            }
        }
        return this._uriDecomposed;
    }

    public static boolean _lookForIDsInCookiesFirst() {
        return false;
    }

    public boolean _hasFormValues() {
        boolean bl = true;
        if (this.isMultipartFormData()) {
            return this._contentLengthHeader() > 0;
        }
        NSDictionary nSDictionary = this.formValues();
        if (nSDictionary == null) {
            bl = false;
        } else {
            int n = nSDictionary.count();
            switch (n) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    Enumeration enumeration = this.formValueKeys().objectEnumerator();
                    String string = (String)enumeration.nextElement();
                    if (string.endsWith(".x") || string.endsWith(".X") || string.endsWith(".y") || string.endsWith(".Y")) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private String _getWOURLEncoding() {
        String string = this.queryString();
        int n = string.indexOf("WOURLEncoding=");
        if (n >= 0) {
            int n2 = n + "WOURLEncoding".length() + 1;
            int n3 = string.indexOf(38, n2 + 1);
            if (n3 >= 0) {
                return string.substring(n2, n3);
            }
            return string.substring(n2);
        }
        return WOURLEncoder.WO_URL_ENCODING;
    }

    private boolean _isRequestFromFormSubmission() {
        return this._context != null && this._context._wasFormSubmitted() && this._context.isInForm();
    }

    private void _getFormValuesFromURLEncoding() {
        String string = this.defaultFormValueEncoding();
        String string2 = this.defaultFormValueEncoding();
        this._formValues = new NSMutableDictionary();
        char[] cArray = this._formDataFromQueryString();
        if (cArray != null && cArray.length > 0) {
            if (!this._isRequestFromFormSubmission()) {
                string = this._getWOURLEncoding();
            }
            if (string == null) {
                string = this._formValueEncodingFromFormData(cArray);
            }
            WORequest._extractValuesFromFormData(this._formValues, cArray, string);
        }
        if ((cArray = this._formDataFromContent()) != null && cArray.length > 0) {
            int n = cArray.length;
            if (cArray[n - 2] == '\r' && cArray[n - 1] == '\n') {
                n -= 2;
            }
            string2 = this._formValueEncodingFromFormData(cArray);
            WORequest._extractValuesFromFormData(this._formValues, cArray, string2, n);
        }
        if (this._method.equalsIgnoreCase("GET") || this._method.equalsIgnoreCase("HEAD")) {
            this._formValueEncoding = string;
        } else if (this._method.equalsIgnoreCase("POST")) {
            this._formValueEncoding = string2;
        }
    }

    private String _formValueEncodingFromFormData(char[] cArray) {
        String string = this.defaultFormValueEncoding();
        if (this._formValueEncodingDetectionEnabled) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
            char[] cArray2 = cArray;
            int n = 0;
            for (int i = cArray.length; i > 0; --i) {
                char c = cArray2[n];
                if (c == '+') {
                    byteArrayOutputStream.write(32);
                } else if (c == '%') {
                    char c2;
                    if (i > 1) {
                        --i;
                        c2 = cArray2[++n];
                    } else {
                        c2 = '0';
                    }
                    int n2 = Character.digit(c2, 16);
                    if (i > 1) {
                        --i;
                        c2 = cArray2[++n];
                    } else {
                        c2 = '0';
                    }
                    n2 = n2 * 16 + Character.digit(c2, 16);
                    c2 = (char)n2;
                    byteArrayOutputStream.write(c2);
                } else {
                    byteArrayOutputStream.write(c);
                }
                ++n;
            }
            NSData nSData = new NSData(byteArrayOutputStream.toByteArray());
            string = WOEncodingDetector.detectEncodingWithDefaultEncoding(nSData, this.defaultFormValueEncoding());
        }
        return string;
    }

    public NSDictionary formValues() {
        if (this._formValues == null || !this._finishedParsingMultipartFormData || this._firstFormValueInvocation) {
            this._firstFormValueInvocation = false;
            this._finishedParsingMultipartFormData = true;
            String string = this._contentType();
            if (string != null) {
                if (string.equalsIgnoreCase("application/x-www-form-urlencoded")) {
                    this._getFormValuesFromURLEncoding();
                } else if (string.equalsIgnoreCase("multipart/form-data")) {
                    this._getFormValuesFromMultipartFormData();
                } else {
                    this._formValues = null;
                }
            } else {
                this._getFormValuesFromURLEncoding();
            }
        }
        return this._formValues;
    }

    protected NSMutableDictionary _formValues() {
        if (this._formValues == null) {
            this._formValues = new NSMutableDictionary();
        }
        return this._formValues;
    }

    public String applicationURLPrefix() {
        if (this._applicationURLPrefix == null) {
            WODynamicURL wODynamicURL = (WODynamicURL)this._uriDecomposed().clone();
            wODynamicURL.setRequestHandlerKey(null);
            wODynamicURL.setRequestHandlerPath(null);
            wODynamicURL.setQueryString(null);
            this._applicationURLPrefix = wODynamicURL.toString();
        }
        return this._applicationURLPrefix;
    }

    public String _serverName() {
        String string = this.headerForKey("x-webobjects-servlet-server-name");
        if (string == null) {
            if (this.isUsingWebServer()) {
                string = this.headerForKey("x-webobjects-server-name");
                if (string == null) {
                    string = this.headerForKey("server_name");
                }
                if (string == null) {
                    string = this.headerForKey("host");
                }
                if (string == null) {
                    throw new NSForwardException((Throwable)new WOURLFormatException("<" + this.getClass().getName() + ">: Unable to build complete url as no server name was provided in the headers of the request."));
                }
            } else {
                string = WOApplication.application().host();
            }
        }
        return string;
    }

    public String _remoteAddress() {
        String string = this.headerForKey("remote_addr");
        if (string == null) {
            string = this.headerForKey("x-webobjects-remote-addr");
        }
        return string;
    }

    public String _serverPort() {
        String string = this.headerForKey("x-webobjects-servlet-server-port");
        if (string == null) {
            if (this.isUsingWebServer()) {
                string = this.headerForKey("x-webobjects-server-port");
            } else {
                NSArray nSArray = WOApplication.application().adaptors();
                if (nSArray.count() > 0) {
                    string = WOShared.unsignedIntString(((WOAdaptor)nSArray.objectAtIndex(0)).port());
                }
            }
        }
        return string;
    }

    public void _completeURLPrefix(StringBuffer stringBuffer, boolean bl, int n) {
        String string = this._serverName();
        String string2 = n == 0 ? (bl ? "443" : this._serverPort()) : WOShared.unsignedIntString(n);
        if (bl) {
            stringBuffer.append("https://");
        } else {
            stringBuffer.append("http://");
        }
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(':');
            stringBuffer = stringBuffer.append(string2);
        }
    }

    public boolean isFromClientComponent() {
        throw new IllegalStateException("<WORequest> isFromClientComponent() is deprecated as the Client Side Components are not supported anymore.");
    }

    public String sessionID() {
        String string;
        WOApplication wOApplication = WOApplication.application();
        if (wOApplication.componentRequestHandlerKey().equals(this.requestHandlerKey())) {
            NSDictionary nSDictionary = WOComponentRequestHandler.requestHandlerValuesForRequest(this);
            string = (String)nSDictionary.objectForKey((Object)SessionIDKey);
        } else {
            string = this._getSessionIDFromValuesOrCookie();
        }
        return string;
    }

    private boolean _isSessionIDinFormValues() {
        if (WOApplication.application().streamActionRequestHandlerKey().equals(this.requestHandlerKey())) {
            return false;
        }
        return this.formValueForKey(SessionIDKey) != null;
    }

    private boolean _isSessionIDinCookies() {
        return this.cookieValueForKey(SessionIDKey) != null;
    }

    private String _getSessionIDFromValuesOrCookie() {
        return this._getSessionIDFromValuesOrCookie(WORequest._lookForIDsInCookiesFirst());
    }

    protected String _getSessionIDFromValuesOrCookie(boolean bl) {
        boolean bl2 = WOApplication.application().streamActionRequestHandlerKey().equals(this.requestHandlerKey());
        String string = null;
        if (bl) {
            string = this.cookieValueForKey(SessionIDKey);
            if (string == null && !bl2) {
                string = this.stringFormValueForKey(SessionIDKey);
            }
        } else {
            if (!bl2) {
                string = this.stringFormValueForKey(SessionIDKey);
            }
            if (string == null) {
                string = this.cookieValueForKey(SessionIDKey);
            }
        }
        return string;
    }

    public boolean isSessionIDInRequest() {
        return this._isSessionIDinCookies() || this._isSessionIDinFormValues();
    }

    private String _contentType() {
        String string = null;
        String string2 = this.headerForKey("content-type");
        if (string2 != null) {
            int n = string2.indexOf(59);
            string = n == -1 ? string2 : string2.substring(0, n);
        }
        return string;
    }

    public int _contentLengthHeader() {
        String string = this.headerForKey("content-length");
        try {
            return string != null ? Integer.parseInt(string) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean isMultipartFormData() {
        String string = this._contentType();
        return string != null && string.equalsIgnoreCase("multipart/form-data");
    }

    private boolean _useLegacyMultipart() {
        if (!this._setLegacyMultipart) {
            this._legacyMultipart = NSPropertyListSerialization.booleanForString((String)NSProperties.getProperty((String)"WOUseLegacyMultipartParser"));
        }
        return this._legacyMultipart;
    }

    private void _getFormValuesFromMultipartFormData() {
        if (this._useLegacyMultipart()) {
            this._formValues = (NSMutableDictionary)WOFileUploadSupport.getFormValuesFromMultipartContent(this);
            this._finishedParsingMultipartFormData = true;
        } else {
            if (!this._formValuesAllowed()) {
                throw new IllegalStateException("Form values cannot be used once the content stream is accessed.");
            }
            if (this._formValues == null) {
                this._formValues = new NSMutableDictionary();
            }
            WOMultipartIterator wOMultipartIterator = this._multipartIterator();
            WOMultipartIterator.WOFormData wOFormData = null;
            boolean bl = false;
            while (!bl) {
                wOFormData = wOMultipartIterator._currentFormData();
                if (wOFormData != null && wOFormData.isFileUpload() && wOFormData.isStreamValid()) {
                    bl = true;
                    continue;
                }
                wOMultipartIterator._invalidateFormData(wOFormData);
                wOFormData = wOMultipartIterator._nextFormData();
                if (wOFormData == null) {
                    bl = true;
                    continue;
                }
                if (wOFormData.isFileUpload() && wOFormData.isStreamValid()) {
                    wOMultipartIterator._pushFormData(wOFormData);
                    bl = true;
                    continue;
                }
                wOMultipartIterator._addFormData(wOFormData);
            }
            this._finishedParsingMultipartFormData = wOFormData == null;
        }
    }

    public WOMultipartIterator multipartIterator() {
        if (!this._useLegacyMultipart() && this.isMultipartFormData() && this._iteratorAllowed()) {
            return this._multipartIterator();
        }
        return null;
    }

    public WOMultipartIterator _multipartIterator() {
        if (this._multipartIterator == null) {
            this._multipartIterator = new WOMultipartIterator(this);
        }
        return this._multipartIterator;
    }

    private boolean _iteratorAllowed() {
        if (this._streamUsed) {
            return false;
        }
        this._iteratorUsed = true;
        return true;
    }

    private boolean _formValuesAllowed() {
        if (this._streamUsed) {
            return false;
        }
        this._formValuesUsed = true;
        return true;
    }

    private boolean _streamAllowed() {
        if (this._formValuesUsed || this._iteratorUsed) {
            return false;
        }
        this._streamUsed = true;
        return true;
    }
}

