/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private.WODeployedBundle;
import com.webobjects.appserver._private.WOEncodingDetector;
import com.webobjects.appserver._private.WOImageInfo;
import com.webobjects.appserver._private.WOProjectBundle;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.appserver._private.WOURLValuedElementData;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class WOResourceManager {
    private final _NSThreadsafeMutableDictionary _frameworkProjectBundles;
    private final _NSThreadsafeMutableDictionary _urlValuedElementsData;
    private volatile NSMutableArray _frameworkClassPaths;
    private final _NSThreadsafeMutableDictionary _imageInfoDictionary;
    private WODeployedBundle TheAppProjectBundle;
    private final _NSThreadsafeMutableDictionary TheStringsTableDictionary = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
    private final NSDictionary TheContentTypes;
    private final Object TheNotFoundMarker = "NotFoundMarker";

    protected WOResourceManager() {
        this.TheAppProjectBundle = WOResourceManager._initAppBundle();
        this.TheContentTypes = WOResourceManager._initContentTypes();
        this._frameworkProjectBundles = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(128));
        this._urlValuedElementsData = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(128));
        this._imageInfoDictionary = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(128));
        this._initFrameworkProjectBundles();
    }

    public String toString() {
        return "<" + this.getClass().getName() + " frameworkProjectBundles=" + this._frameworkProjectBundles + " urlValuedElementsData=" + this._urlValuedElementsData + " frameworkClassPaths=" + this._frameworkClassPaths + " imageInfoDictionary=" + this._imageInfoDictionary + " >";
    }

    private static NSMutableDictionary _initContentTypes() {
        String string = "MIME.plist";
        NSMutableDictionary nSMutableDictionary = null;
        try {
            NSBundle nSBundle = NSBundle.bundleForName((String)"JavaWebObjects");
            String string2 = nSBundle.resourcePathForLocalizedResourceNamed(string, "");
            if (string2 == null) {
                throw new FileNotFoundException("<WOResourceManager>: Problem locating " + string + " needed for serving resources");
            }
            NSData nSData = new NSData(nSBundle.bytesForResourcePath(string2));
            nSMutableDictionary = (NSMutableDictionary)NSPropertyListSerialization.propertyListFromData((NSData)nSData);
            if (nSMutableDictionary == null) {
                throw new IllegalStateException("<WOResourceManager>: Problem reading MIME mapping file '" + string + "'");
            }
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<WOResourceManager> Unable to initialize content types list for reason:" + exception.toString()));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)36L)) {
                NSLog.debug.appendln((Throwable)exception);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
        return nSMutableDictionary;
    }

    private static WODeployedBundle _initAppBundle() {
        WODeployedBundle wODeployedBundle = null;
        try {
            WODeployedBundle wODeployedBundle2 = WODeployedBundle.deployedBundle();
            wODeployedBundle = wODeployedBundle2.projectBundle();
            if (wODeployedBundle != null) {
                NSLog.err.appendln((Object)("Application project found: Will locate resources in '" + ((WOProjectBundle)wODeployedBundle).projectPath() + "' rather than '" + wODeployedBundle2.bundlePath() + "' ."));
            } else {
                wODeployedBundle = wODeployedBundle2;
            }
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<WOResourceManager> Unable to initialize AppProjectBundle for reason:" + exception.toString()));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)36L)) {
                NSLog.debug.appendln((Throwable)exception);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
        return wODeployedBundle;
    }

    public String contentTypeForResourceNamed(String string) {
        String string2 = NSPathUtilities.pathExtension((String)string);
        String string3 = null;
        if (string2 != null && string2.length() != 0) {
            string3 = (String)this.TheContentTypes.objectForKey((Object)string2.toLowerCase());
        }
        if (string3 == null) {
            string3 = "text/plain";
        }
        return string3;
    }

    private static WODeployedBundle _bundleWithNSBundle(NSBundle nSBundle) {
        WODeployedBundle wODeployedBundle = null;
        WODeployedBundle wODeployedBundle2 = WODeployedBundle.bundleWithNSBundle(nSBundle);
        WOProjectBundle wOProjectBundle = wODeployedBundle2.projectBundle();
        if (wOProjectBundle != null) {
            WOApplication.application().debugString("Framework project found: Will locate resources in '" + wOProjectBundle.bundlePath() + "' rather than '" + wODeployedBundle2.bundlePath() + "' .");
            wODeployedBundle = wOProjectBundle;
        } else {
            wODeployedBundle = wODeployedBundle2;
        }
        return wODeployedBundle;
    }

    private static WODeployedBundle _locateBundleForFrameworkNamed(String string) {
        NSBundle nSBundle;
        WODeployedBundle wODeployedBundle = null;
        Object var2_2 = null;
        wODeployedBundle = WODeployedBundle.deployedBundleForFrameworkNamed(string);
        if (wODeployedBundle == null && (nSBundle = NSBundle.bundleForName((String)string)) != null) {
            wODeployedBundle = WOResourceManager._bundleWithNSBundle(nSBundle);
        }
        return wODeployedBundle;
    }

    public WODeployedBundle _cachedBundleForFrameworkNamed(String string) {
        WODeployedBundle wODeployedBundle = null;
        if (string != null && (wODeployedBundle = (WODeployedBundle)this._frameworkProjectBundles.objectForKey((Object)string)) == null && (wODeployedBundle = WOResourceManager._locateBundleForFrameworkNamed(string)) != null) {
            this._frameworkProjectBundles.setObjectForKey((Object)wODeployedBundle, (Object)string);
        }
        if (wODeployedBundle == null) {
            wODeployedBundle = this.TheAppProjectBundle;
        }
        return wODeployedBundle;
    }

    private void _initFrameworkProjectBundles() {
        NSBundle nSBundle = null;
        NSArray nSArray = NSBundle.allFrameworks();
        Enumeration enumeration = nSArray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            nSBundle = (NSBundle)enumeration.nextElement();
            this._cachedBundleForFrameworkNamed(nSBundle.name());
        }
    }

    public NSArray _frameworkProjectBundles() {
        return this._frameworkProjectBundles.immutableClone().allValues();
    }

    public InputStream inputStreamForResourceNamed(String string, String string2, NSArray nSArray) {
        InputStream inputStream = null;
        WODeployedBundle wODeployedBundle = this._cachedBundleForFrameworkNamed(string2);
        if (wODeployedBundle != null) {
            inputStream = wODeployedBundle.inputStreamForResourceNamed(string, nSArray);
        }
        return inputStream;
    }

    public byte[] bytesForResourceNamed(String string, String string2, NSArray nSArray) {
        InputStream inputStream = this.inputStreamForResourceNamed(string, string2, nSArray);
        byte[] byArray = null;
        if (inputStream != null) {
            byArray = _NSStringUtilities.bytesFromInputStream((InputStream)inputStream);
        }
        return byArray;
    }

    public String pathForResourceNamed(String string, String string2, NSArray nSArray) {
        WODeployedBundle wODeployedBundle = this._cachedBundleForFrameworkNamed(string2);
        String string3 = wODeployedBundle._absolutePathForResource(string, nSArray);
        return string3;
    }

    public URL pathURLForResourceNamed(String string, String string2, NSArray nSArray) {
        URL uRL = null;
        WODeployedBundle wODeployedBundle = this._cachedBundleForFrameworkNamed(string2);
        if (wODeployedBundle != null) {
            uRL = wODeployedBundle.pathURLForResourceNamed(string, nSArray);
        }
        return uRL;
    }

    private String _cachedURLForResource(String string, String string2, NSArray nSArray) {
        String string3 = null;
        if (string2 != null) {
            WODeployedBundle wODeployedBundle = this._cachedBundleForFrameworkNamed(string2);
            if (wODeployedBundle != null) {
                string3 = wODeployedBundle.urlForResource(string, nSArray);
            }
            if (string3 == null) {
                string3 = "/ERROR/NOT_FOUND/framework=" + string2 + "/filename=" + (string != null ? string : "*null*");
            }
        } else {
            string3 = this.TheAppProjectBundle.urlForResource(string, nSArray);
            if (string3 == null) {
                String string4 = WOApplication.application().name();
                string3 = "/ERROR/NOT_FOUND/app=" + string4 + "/filename=" + (string != null ? string : "*null*");
            }
        }
        return string3;
    }

    public String _completeURLForResourceNamed(String string, String string2, NSArray nSArray, WORequest wORequest, boolean bl, int n) {
        String string3 = this.urlForResourceNamed(string, string2, nSArray, wORequest);
        if (wORequest != null && wORequest.isUsingWebServer() && string3 != null) {
            StringBuffer stringBuffer = new StringBuffer(256);
            wORequest._completeURLPrefix(stringBuffer, bl, n);
            stringBuffer.append(string3);
            string3 = new String(stringBuffer);
        }
        return string3;
    }

    public String urlForResourceNamed(String string, String string2, NSArray nSArray, WORequest wORequest) {
        String string3 = null;
        if (wORequest == null || wORequest != null && wORequest.isUsingWebServer() && !WOApplication.application()._rapidTurnaroundActiveForAnyProject()) {
            string3 = this._cachedURLForResource(string, string2, nSArray);
        } else {
            Object object;
            String string4;
            URL uRL = this.pathURLForResourceNamed(string, string2, nSArray);
            String string5 = null;
            if (uRL == null) {
                string5 = "ERROR_NOT_FOUND_framework_" + (string2 != null ? string2 : "*null*") + "_filename_" + (string != null ? string : "*null*");
            } else {
                string5 = uRL.toString();
                if (null == this.cachedDataForKey(string5)) {
                    string4 = this.contentTypeForResourceNamed(string5);
                    object = new WOURLValuedElementData(null, string4, string5);
                    this._urlValuedElementsData.setObjectForKey(object, (Object)string5);
                }
            }
            string4 = _NSStringUtilities.concat((String)"wodata", (String)"=", (String)WOURLEncoder.encode(string5));
            object = null;
            String string6 = WOApplication.application().resourceRequestHandlerKey();
            if (wORequest != null) {
                object = wORequest._context();
            }
            if (object != null) {
                string3 = ((WOContext)object).urlWithRequestHandlerKey(string6, null, string4);
            } else {
                StringBuffer stringBuffer = new StringBuffer(wORequest.applicationURLPrefix());
                stringBuffer.append('/');
                stringBuffer.append(string6);
                stringBuffer.append('?');
                stringBuffer.append(string4);
                string3 = stringBuffer.toString();
            }
        }
        return string3;
    }

    public String errorMessageUrlForResourceNamed(String string, String string2) {
        String string3 = null;
        String string4 = string = string == null ? "null" : string;
        if (string2 != null) {
            string3 = "/ERROR/NOT_FOUND/framework=" + string2 + "/filename=" + string;
        } else {
            String string5 = WOApplication.application().name();
            string3 = "/ERROR/NOT_FOUND/app=" + string5 + "/filename=" + string;
        }
        return string3;
    }

    public WOImageInfo _imageInfoForUrl(String string, String string2, String string3, NSArray nSArray) {
        Object object = this._imageInfoDictionary.objectForKey((Object)string);
        if (object == null) {
            block8: {
                String string4;
                URL uRL = this.pathURLForResourceNamed(string2, string3, nSArray);
                String string5 = string4 = uRL != null ? uRL.toString() : null;
                if (string4 != null && WOImageInfo.pathHasSupportedExtension(string4)) {
                    try {
                        object = new WOImageInfo(uRL);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        object = this.TheNotFoundMarker;
                        NSLog.err.appendln((Object)("<WOImage>: Image not found at " + string + " / " + string2 + " / " + string3));
                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8192L)) {
                            NSLog.debug.appendln((Throwable)fileNotFoundException);
                        }
                        break block8;
                    }
                    catch (IOException iOException) {
                        object = this.TheNotFoundMarker;
                        NSLog.err.appendln((Object)("<WOImage>: Coudn't read Image at " + string + " / " + string2 + " / " + string3));
                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8192L)) {
                            NSLog.debug.appendln((Throwable)iOException);
                        }
                        break block8;
                    }
                }
                object = this.TheNotFoundMarker;
            }
            this._imageInfoDictionary.setObjectForKey(object, (Object)string);
        }
        if (object == this.TheNotFoundMarker) {
            object = null;
        }
        return (WOImageInfo)object;
    }

    private NSDictionary _stringsTable(String string, String string2, String string3) {
        WODeployedBundle wODeployedBundle;
        NSDictionary nSDictionary = null;
        if (string != null && (wODeployedBundle = this._cachedBundleForFrameworkNamed(string2)) != null) {
            try {
                URL uRL = wODeployedBundle.pathURLForResourceNamed(string.concat(".strings"), string3);
                NSData nSData = null;
                if (uRL != null) {
                    nSData = new NSData(uRL);
                }
                if (nSData != null) {
                    String string4 = WOEncodingDetector.sharedInstance().guessEncodingForData(nSData);
                    nSDictionary = (NSDictionary)NSPropertyListSerialization.propertyListFromData((NSData)nSData, (String)string4);
                }
            }
            catch (IOException iOException) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)iOException);
            }
        }
        return nSDictionary;
    }

    private NSMutableDictionary _cachedStringsTable(String string, String string2, String string3) {
        Object object = null;
        if (string != null) {
            String string4;
            String string5 = string3 != null ? string3 : "none";
            String string6 = _NSStringUtilities.concat((String)string, (String)"_", (String)string5, (String)"_", (String)(string4 = string2 != null ? string2 : "none"));
            object = this.TheStringsTableDictionary.objectForKey((Object)string6);
            if (null == object) {
                object = this._stringsTable(string, string2, string3);
                if (null == object) {
                    object = this.TheNotFoundMarker;
                }
                this.TheStringsTableDictionary.setObjectForKey(object, (Object)string6);
            }
            if (object == this.TheNotFoundMarker) {
                object = null;
            }
        }
        return (NSMutableDictionary)object;
    }

    private String _cachedStringForKey(String string, String string2, String string3, String string4) {
        NSMutableDictionary nSMutableDictionary = this._cachedStringsTable(string2, string3, string4);
        String string5 = null;
        if (nSMutableDictionary != null && string != null) {
            string5 = (String)nSMutableDictionary.objectForKey((Object)string);
        }
        return string5;
    }

    private String _stringForKey(String string, String string2, String string3, NSArray nSArray) {
        if (null == string2) {
            string2 = "Localizable";
        }
        if (nSArray != null) {
            int n = nSArray.count();
            for (int i = 0; i < n; ++i) {
                String string4 = (String)nSArray.objectAtIndex(i);
                String string5 = this._cachedStringForKey(string, string2, string3, string4);
                if (string5 == null) continue;
                return string5;
            }
        }
        return this._cachedStringForKey(string, string2, string3, null);
    }

    public String stringForKey(String string, String string2, String string3, String string4, NSArray nSArray) {
        String string5 = this._stringForKey(string, string2, string4, nSArray);
        if (string5 == null) {
            string5 = string3;
        }
        return string5;
    }

    public NSDictionary _contentTypesDictionary() {
        return this.TheContentTypes;
    }

    public void _cacheData(WOURLValuedElementData wOURLValuedElementData) {
        if (wOURLValuedElementData != null) {
            this._urlValuedElementsData.setObjectForKey((Object)wOURLValuedElementData, (Object)wOURLValuedElementData.key());
        }
    }

    public WOURLValuedElementData _cachedDataForKey(String string) {
        WOURLValuedElementData wOURLValuedElementData = null;
        if (string != null) {
            wOURLValuedElementData = this.cachedDataForKey(string);
        }
        return wOURLValuedElementData;
    }

    private WOURLValuedElementData cachedDataForKey(String string) {
        return (WOURLValuedElementData)this._urlValuedElementsData.objectForKey((Object)string);
    }

    public URL _pathURLForJavaClass(String string) {
        URL uRL = null;
        if (string != null) {
            String string2 = "WebServerResources/Java/".concat(string);
            String string3 = "Contents/WebServerResources/Java/".concat(string);
            String string4 = null;
            Enumeration enumeration = NSBundle._allBundlesReally().objectEnumerator();
            while (enumeration.hasMoreElements() && uRL == null) {
                NSBundle nSBundle = (NSBundle)enumeration.nextElement();
                string4 = nSBundle._isCFBundle() ? string3 : string2;
                uRL = nSBundle._urlForRelativePath(string4);
            }
        }
        return uRL;
    }

    protected String _pathForResourceNamed(String string, String string2, String string3, boolean bl) {
        String string4 = null;
        WODeployedBundle wODeployedBundle = this._cachedBundleForFrameworkNamed(string2);
        if (wODeployedBundle != null) {
            string4 = wODeployedBundle._absolutePathForResource(string, string3, bl);
        }
        return string4;
    }

    protected URL _pathURLForResourceNamed(String string, String string2, String string3, boolean bl) {
        URL uRL = null;
        WODeployedBundle wODeployedBundle = this._cachedBundleForFrameworkNamed(string2);
        if (wODeployedBundle != null) {
            uRL = wODeployedBundle.pathURLForResourceNamed(string, string3, bl);
        }
        return uRL;
    }

    public void setData(NSData nSData, String string, String string2, WOSession wOSession) {
        WOURLValuedElementData wOURLValuedElementData = new WOURLValuedElementData(nSData, string2, string);
        this._cacheData(wOURLValuedElementData);
    }

    public void removeDataForKey(String string, WOSession wOSession) {
        if (string != null) {
            this._urlValuedElementsData.removeObjectForKey((Object)string);
        }
    }

    public void flushDataCache() {
        this._urlValuedElementsData.removeAllObjects();
    }

    public WODeployedBundle _appProjectBundle() {
        return this.TheAppProjectBundle;
    }
}

