/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.eocontrol.EOEvent;

public class WOStopWatch
extends EOEvent {
    private String _name;
    private long _accumulatedTime;
    private long _currentStartTime;
    private int _startCount;
    private boolean _isRunning;

    public WOStopWatch(String string) {
        this._name = string;
    }

    public int count() {
        return this._startCount;
    }

    public double accumulatedTime() {
        if (this._isRunning) {
            throw new IllegalStateException((Object)((Object)this) + ": Attempt to access accumulatedTime while running.");
        }
        return (double)this._accumulatedTime / 1000.0;
    }

    public double averageTime() {
        long l = 0L;
        if (this._isRunning) {
            throw new IllegalStateException((Object)((Object)this) + ":Attempt to access averageTime while running.");
        }
        l = this._startCount != 0 ? this._accumulatedTime / (long)this._startCount : 0L;
        return (double)l / 1000.0;
    }

    public double currentRunningTime() {
        long l = 0L;
        if (!this._isRunning) {
            throw new IllegalStateException((Object)((Object)this) + ": Attempt to access currentRunningTime when not running.");
        }
        l = System.currentTimeMillis() - this._currentStartTime;
        return (double)l / 1000.0;
    }

    public void start() {
        if (this._isRunning) {
            throw new IllegalStateException((Object)((Object)this) + ": Attempt to start when already running.");
        }
        this._currentStartTime = System.currentTimeMillis();
        ++this._startCount;
        this._isRunning = true;
    }

    public void stop() {
        if (this._isRunning) {
            double d = this.currentRunningTime();
            this._accumulatedTime = (long)((double)this._accumulatedTime + 1000.0 * d);
            this._currentStartTime = 0L;
            this._isRunning = false;
        }
    }

    public void reset() {
        this._accumulatedTime = 0L;
        this._currentStartTime = 0L;
        this._startCount = 0;
        this._isRunning = false;
    }

    public String toString() {
        return "<" + ((Object)((Object)this)).getClass().getName() + " " + this._name + ">";
    }
}

