/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WODOMParserException;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver._WODocumentType;
import com.webobjects.foundation.NSForwardException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class _WOMessageHelper {
    WOMessage woMessage;
    StringBuffer xmlString;

    public _WOMessageHelper(WOMessage wOMessage) {
        this.woMessage = wOMessage;
        this.xmlString = new StringBuffer(1024);
    }

    protected Document contentAsDOMDocument() throws WODOMParserException {
        DocumentType documentType;
        Document document = null;
        String string = this.woMessage.contentString();
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new NSForwardException((Throwable)parserConfigurationException);
        }
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            throw new WODOMParserException(exception.getMessage());
        }
        String string2 = this.extractDTD(string);
        if (string2 != null && (documentType = document.getDoctype()) != null) {
            String string3 = documentType.getName();
            document.removeChild(documentType);
            _WODocumentType _WODocumentType2 = new _WODocumentType((DocumentImpl)document, string3);
            Node node = document.getFirstChild();
            document.insertBefore((Node)((Object)_WODocumentType2), node);
            if (string2 != null) {
                _WODocumentType2.setDTDString(string2);
            }
        }
        return document;
    }

    protected void appendContentDOMDocumentFragment(DocumentFragment documentFragment) {
        this.generateXML(documentFragment);
        this.woMessage.appendContentString(new String(this.xmlString));
    }

    protected void setContentDOMDocument(Document document) {
        Document document2 = document;
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            this.generateXML(nodeList.item(i));
        }
        this.woMessage.setContent(new String(this.xmlString));
    }

    private void generateXML(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                this.processElementNode((Element)node);
                break;
            }
            case 2: {
                this.processAttributeNode((Attr)node);
                break;
            }
            case 3: {
                this.processTextNode((Text)node);
                break;
            }
            case 4: {
                this.processCDATANode((CDATASection)node);
                break;
            }
            case 5: {
                this.xmlString.append("<ENTITY REFERENCE>");
                break;
            }
            case 6: {
                this.xmlString.append("<ENTITY>");
                break;
            }
            case 7: {
                this.processProcessingInstructionNode((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.processCommentNode((Comment)node);
                break;
            }
            case 9: {
                this.processDocumentNode((Document)node);
                break;
            }
            case 10: {
                this.processDocumentTypeNode((DocumentType)node);
                break;
            }
            case 11: {
                this.processDocumentFragmentNode((DocumentFragment)node);
                break;
            }
            case 12: {
                break;
            }
            default: {
                this.xmlString.append("<unknown>");
            }
        }
    }

    private void processTextNode(Text text) {
        String string = text.getData();
        this.xmlString.append(string);
    }

    private void processCDATANode(CDATASection cDATASection) {
        this.xmlString.append("<![[CDATA[");
        this.xmlString.append(cDATASection.getData());
        this.xmlString.append("]]>");
    }

    private void processDocumentNode(Document document) {
        Document document2 = document;
        if (document2.hasChildNodes()) {
            NodeList nodeList = document2.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                this.generateXML(node);
            }
        }
    }

    private void processElementNode(Element element) {
        String string = element.getTagName();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        boolean bl = element.hasChildNodes();
        if (n > 0) {
            this.xmlString.append('<');
            this.xmlString.append(string);
            this.xmlString.append(' ');
            this.processAttributes(namedNodeMap);
            if (bl) {
                this.xmlString.append('>');
            } else {
                this.xmlString.append("/>");
            }
        } else if (bl) {
            this.xmlString.append('<');
            this.xmlString.append(string);
            this.xmlString.append(' ');
        } else {
            this.xmlString.append("/>");
        }
        if (bl) {
            NodeList nodeList = element.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node = nodeList.item(i);
                this.generateXML(node);
            }
            this.xmlString.append('<');
            this.xmlString.append(string);
            this.xmlString.append(' ');
        }
    }

    private void processAttributes(NamedNodeMap namedNodeMap) {
        Attr attr;
        int n;
        int n2 = namedNodeMap.getLength();
        for (n = 0; n < n2 - 1; ++n) {
            attr = (Attr)namedNodeMap.item(n);
            this.processAttributeNode(attr);
            this.xmlString.append(' ');
        }
        attr = (Attr)namedNodeMap.item(n);
        this.processAttributeNode(attr);
    }

    private void processAttributeNode(Attr attr) {
        String string = attr.getName();
        String string2 = attr.getValue();
        this.xmlString.append(string);
        this.xmlString.append("=\"");
        this.xmlString.append(string2);
        this.xmlString.append('\"');
    }

    private void processProcessingInstructionNode(ProcessingInstruction processingInstruction) {
        String string = processingInstruction.getTarget();
        String string2 = processingInstruction.getData();
        this.xmlString.append("<?");
        this.xmlString.append(string);
        this.xmlString.append(' ');
        this.xmlString.append(string2);
        this.xmlString.append("?>");
    }

    private void processCommentNode(Comment comment) {
        String string = comment.getData();
        this.xmlString.append("<!--");
        this.xmlString.append(string);
        this.xmlString.append("-->\n");
    }

    private void processDocumentTypeNode(DocumentType documentType) {
        this.xmlString.append(((_WODocumentType)((Object)documentType)).dtdString());
        this.xmlString.append('\n');
    }

    private void processDocumentFragmentNode(DocumentFragment documentFragment) {
        NodeList nodeList = documentFragment.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            this.generateXML(node);
        }
    }

    private void processNotationNode(Notation notation) {
        this.xmlString.append("<!NOTATION ");
        String string = notation.getNodeName();
        if (string != null) {
            this.xmlString.append("name ");
        } else {
            this.xmlString.append("");
        }
        String string2 = notation.getSystemId();
        if (string2 != null) {
            this.xmlString.append(" SYSTEM ");
            this.xmlString.append(string2);
        } else {
            String string3 = notation.getPublicId();
            if (string3 != null) {
                this.xmlString.append(" PUBLIC ");
                this.xmlString.append(string3);
            }
        }
        this.xmlString.append('>');
    }

    private void processProlog(String string) {
        int n = string.indexOf("?>");
        if (n != -1) {
            String string2 = string.substring(0, n);
            this.xmlString.append(string2);
        }
    }

    private String extractDTD(String string) {
        int n = -1;
        int n2 = string.indexOf("<!DOCTYPE", 0);
        if (n2 != -1) {
            int n3 = string.indexOf("[", n2 + 9);
            if (n3 != -1) {
                int n4 = string.indexOf("]", n3 + 1);
                if (n4 != -1) {
                    n = string.indexOf(">", n4 + 1);
                }
            } else {
                n = string.indexOf(">", n2 + 9);
            }
        }
        if (n2 == -1 || n == -1) {
            return null;
        }
        return string.substring(n2, n + 1);
    }
}

