/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WODeclaration;
import com.webobjects.appserver._private.WODeclarationFormatException;
import com.webobjects.appserver._private.WOShared;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSStringUtilities;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class WODeclarationParser {
    private NSMutableDictionary _quotedStrings = new NSMutableDictionary();
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INSIDE_COMMENT = 2;
    private static final String ESCAPED_QUOTE_STRING = "_WO_ESCAPED_QUOTE_";

    public static NSDictionary declarationsWithString(String string) throws WODeclarationFormatException {
        WODeclarationParser wODeclarationParser = new WODeclarationParser();
        NSDictionary nSDictionary = wODeclarationParser.parseDeclarations(string);
        return nSDictionary;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " quotedStrings=" + this._quotedStrings.toString() + ">";
    }

    public NSDictionary parseDeclarations(String string) throws WODeclarationFormatException {
        String string2 = this._removeOldStyleCommentsFromString(string);
        string2 = this._removeNewStyleCommentsAndQuotedStringsFromString(string2);
        NSDictionary nSDictionary = this.parseDeclarationsWithoutComments(string2);
        return nSDictionary;
    }

    private String _removeOldStyleCommentsFromString(String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        int n = 0;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                switch (n) {
                    case 0: {
                        if (string2.equals("/")) {
                            string2 = stringTokenizer.nextToken();
                            if (string2.startsWith("*")) {
                                n = 2;
                                stringBuffer2.append('/');
                                stringBuffer2.append(string2);
                                break;
                            }
                            stringBuffer.append('/');
                            stringBuffer.append(string2);
                            break;
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    case 2: {
                        stringBuffer2.append(string2);
                        String string3 = new String(stringBuffer2);
                        if (!string3.endsWith("*/") || string3.equals("/*/")) break;
                        n = 0;
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            NSLog._conditionallyLogPrivateException((Throwable)noSuchElementException);
        }
        return _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer);
    }

    private String _removeNewStyleCommentsAndQuotedStringsFromString(String string) {
        String string2 = _NSStringUtilities.replaceAllInstancesOfString((String)string, (String)"\\\"", (String)ESCAPED_QUOTE_STRING);
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/\"", true);
        boolean bl = false;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken("/\"");
                if (string3.equals("/")) {
                    string3 = stringTokenizer.nextToken("\n");
                    if (string3.startsWith("/")) {
                        string3 = _NSStringUtilities.replaceAllInstancesOfString((String)string3, (String)ESCAPED_QUOTE_STRING, (String)"\\\"");
                        stringBuffer2.append('/');
                        stringBuffer2.append(string3);
                        stringBuffer2.append('\n');
                        stringBuffer.append('\n');
                        stringTokenizer.nextToken();
                        continue;
                    }
                    stringBuffer.append('/');
                    stringBuffer.append(string3);
                    continue;
                }
                if (string3.equals("\"")) {
                    string3 = stringTokenizer.nextToken("\"");
                    if (string3.equals("\"")) {
                        string3 = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    StringBuffer stringBuffer3 = new StringBuffer(16);
                    stringBuffer3.append("_WODP_");
                    stringBuffer3.append(String.valueOf(this._quotedStrings.count()));
                    String string4 = new String(stringBuffer3);
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x800200L)) {
                        NSLog.debug.appendln((Object)("Found a quoted string: " + string4 + "='" + string3 + "';"));
                    }
                    string3 = _NSStringUtilities.replaceAllInstancesOfString((String)string3, (String)ESCAPED_QUOTE_STRING, (String)"\"");
                    this._quotedStrings.setObjectForKey((Object)string3, (Object)string4);
                    stringBuffer.append(string4);
                    continue;
                }
                stringBuffer.append(string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            NSLog._conditionallyLogPrivateException((Throwable)noSuchElementException);
        }
        return _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer);
    }

    private NSDictionary parseDeclarationsWithoutComments(String string) throws WODeclarationFormatException {
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
        NSMutableDictionary nSMutableDictionary2 = this._rawDeclarationsWithoutComment(string);
        Enumeration enumeration = nSMutableDictionary2.keyEnumerator();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)nSMutableDictionary2.objectForKey((Object)string2);
            int n = string2.indexOf(58);
            if (n < 0) {
                throw new WODeclarationFormatException("<" + this.getClass().getName() + "> Missing ':' for declaration:\n" + string2 + " " + string3);
            }
            String string4 = string2.substring(0, n).trim();
            if (string4.length() == 0) {
                throw new WODeclarationFormatException("<" + this.getClass().getName() + "> Missing tag name for declaration:\n" + string2 + " " + string3);
            }
            if (nSMutableDictionary.objectForKey((Object)string4) != null) {
                throw new WODeclarationFormatException("<" + this.getClass().getName() + "> Duplicate tag name '" + string4 + "' in declaration:\n" + string3);
            }
            String string5 = string2.substring(n + 1).trim();
            if (string5.length() == 0) {
                throw new WODeclarationFormatException("<" + this.getClass().getName() + "> Missing element name for declaration:\n" + string2 + " " + string3);
            }
            NSMutableDictionary nSMutableDictionary3 = this._associationsForDictionaryString(string2, string3);
            WODeclaration wODeclaration = new WODeclaration(string4, string5, (NSDictionary)nSMutableDictionary3);
            nSMutableDictionary.setObjectForKey((Object)wODeclaration, (Object)string4);
        }
        return nSMutableDictionary;
    }

    private NSMutableDictionary _associationsForDictionaryString(String string, String string2) throws WODeclarationFormatException {
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
        String string3 = string2.trim();
        if (!string3.startsWith("{") && !string3.endsWith("}")) {
            throw new WODeclarationFormatException("<" + this.getClass().getName() + "> Internal inconsistency : invalid dictionary for declaration:\n" + string + " " + string2);
        }
        int n = string3.length();
        if (n <= 2) {
            return nSMutableDictionary;
        }
        string3 = string3.substring(1, n - 1).trim();
        NSArray nSArray = NSArray.componentsSeparatedByString((String)string3, (String)";");
        Enumeration enumeration = nSArray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            String string4 = ((String)enumeration.nextElement()).trim();
            if (string4.length() == 0) continue;
            int n2 = string4.indexOf(61);
            if (n2 < 0) {
                throw new WODeclarationFormatException("<" + this.getClass().getName() + "> Invalid line. No equal in line:\n" + string4 + "\nfor declaration:\n" + string + " " + string2);
            }
            String string5 = string4.substring(0, n2).trim();
            if (string5.length() == 0) {
                throw new WODeclarationFormatException("<" + this.getClass().getName() + "> Missing binding in line:\n" + string4 + "\nfor declaration:\n" + string + " " + string2);
            }
            String string6 = string4.substring(n2 + 1).trim();
            if (string6.length() == 0) {
                throw new WODeclarationFormatException("<" + this.getClass().getName() + "> Missing value in line:\n" + string4 + "\nfor declaration:\n" + string + " " + string2);
            }
            WOAssociation wOAssociation = this._associationWithKey(string6);
            String string7 = (String)this._quotedStrings.objectForKey((Object)string5);
            if (string7 != null) {
                nSMutableDictionary.setObjectForKey((Object)wOAssociation, (Object)string7);
                continue;
            }
            nSMutableDictionary.setObjectForKey((Object)wOAssociation, (Object)string5);
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x800200L)) {
            NSLog.debug.appendln((Object)("<WODeclarationParser> Parsed '" + string + "' declarations:\n" + nSMutableDictionary + "\n--------"));
        }
        return nSMutableDictionary;
    }

    private WOAssociation _associationWithKey(String string) {
        WOAssociation wOAssociation = null;
        String string2 = (String)this._quotedStrings.objectForKey((Object)string);
        if (string2 != null) {
            wOAssociation = WOAssociation.associationWithValue(string2);
        } else if (_NSStringUtilities.isNumber((String)string)) {
            Integer n = WOShared.unsignedIntNumber(Integer.parseInt(string));
            wOAssociation = WOAssociation.associationWithValue(n);
        } else {
            wOAssociation = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") ? WOConstantValueAssociation.TRUE : (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("nil") || string.equalsIgnoreCase("null") ? WOConstantValueAssociation.FALSE : WOAssociation.associationWithKeyPath(string));
        }
        return wOAssociation;
    }

    private NSMutableDictionary _rawDeclarationsWithoutComment(String string) {
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
        StringBuffer stringBuffer = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{", true);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken("{");
                if (string2.equals("{")) {
                    string2 = stringTokenizer.nextToken("}");
                    if (string2.equals("}")) {
                        string2 = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    String string3 = _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer);
                    if (string3.startsWith(";")) {
                        string3 = string3.substring(1);
                    }
                    nSMutableDictionary.setObjectForKey((Object)("{" + string2 + "}"), (Object)string3.trim());
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            NSLog._conditionallyLogPrivateException((Throwable)noSuchElementException);
        }
        return nSMutableDictionary;
    }
}

