/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver._private.WOProjectBundle;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class WODeployedBundle {
    private final NSMutableDictionary _absolutePaths;
    private final NSMutableDictionary _pathURLs;
    protected final String _bundlePath;
    protected final boolean _isFramework;
    protected final String _projectName;
    private final _NSThreadsafeMutableDictionary _relativePaths;
    private boolean _resourcesHaveBeenPreloaded;
    private final NSMutableDictionary _URLs;
    protected final String _wrapperName;
    private final NSMutableSet _expectedLanguages;
    private boolean _isJar;
    private NSBundle _nsBundle;
    private static final NSMutableDictionary TheBundles = new NSMutableDictionary(NSBundle.frameworkBundles().count());
    private static final String TheNotFoundMarker = "NotFoundMarker";
    private static final boolean _allowRapidTurnaround = NSProperties.booleanForKey((String)"WOAllowRapidTurnaround");
    private static final String _webServerResources = "/WebServerResources";
    private static final String _resources = "/Resources";
    private static final String _cvs = "/CVS";
    private static final String _versions = "/Versions";
    private static final String _contentsWebServerResourcesPathKey = "Contents/WebServerResources/";
    private static final String _webServerResourcesPathKey = "WebServerResources/";

    public WODeployedBundle(NSBundle nSBundle) {
        this(null, nSBundle);
    }

    public WODeployedBundle(String string, NSBundle nSBundle) {
        if (nSBundle == null) {
            throw new IllegalStateException("Cannot create WODeployedBundle without corresponding NSBundle!");
        }
        this._nsBundle = nSBundle;
        this._isJar = this._nsBundle.isJar();
        if (string == null) {
            string = this._nsBundle.bundlePath();
        }
        this._bundlePath = this._initBundlePath(string);
        this._wrapperName = NSBundle.mainBundle() == this._nsBundle || !this._nsBundle.isFramework() && !this._nsBundle.name().endsWith(".woa") ? this._nsBundle.name() + ".woa" : (this._nsBundle.isFramework() && !this._nsBundle.name().endsWith(".framework") ? this._nsBundle.name() + ".framework" : this._nsBundle.name());
        this._projectName = this._initProjectName(this._wrapperName);
        NSBundle nSBundle2 = NSBundle.bundleForName((String)this._projectName);
        this._isFramework = NSBundle.mainBundle() == this._nsBundle ? false : this._nsBundle.isFramework();
        this._absolutePaths = new NSMutableDictionary(128);
        this._pathURLs = new NSMutableDictionary(128);
        this._relativePaths = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(128));
        this._URLs = new NSMutableDictionary();
        this._expectedLanguages = new NSMutableSet(16);
        this._resourcesHaveBeenPreloaded = false;
    }

    public static WODeployedBundle deployedBundle() {
        return WODeployedBundle.bundleWithNSBundle(NSBundle.mainBundle());
    }

    private void _newAddToRelativePaths(File file, int n, int n2) {
        String string = file.getAbsolutePath();
        String string2 = NSPathUtilities._standardizedPath((String)string.substring(n2));
        String string3 = string.substring(n);
        Object object = this._relativePaths.objectForKey((Object)string2);
        if (object != null) {
            if (object instanceof NSMutableDictionary && ((NSMutableDictionary)object).objectForKey((Object)"Default") == null) {
                ((NSMutableDictionary)object).setObjectForKey((Object)NSPathUtilities._standardizedPath((String)string3), (Object)"Default");
            }
        } else {
            this._relativePaths.setObjectForKey((Object)NSPathUtilities._standardizedPath((String)string3), (Object)string2);
        }
    }

    private void _jarAddToRelativePaths(String string) {
        String string2;
        int n = string.indexOf("!/");
        n = n != -1 ? (n += 2) : 0;
        String string3 = string2 = string.substring(n);
        string3 = string2.startsWith("WebServerResources") ? string2.substring(19) : (string2.startsWith("Resources") ? string2.substring(10) : NSPathUtilities.lastPathComponent((String)string2));
        Object object = this._relativePaths.objectForKey((Object)string3);
        if (object != null) {
            if (object instanceof NSMutableDictionary && ((NSMutableDictionary)object).objectForKey((Object)"Default") == null) {
                ((NSMutableDictionary)object).setObjectForKey((Object)string2, (Object)"Default");
            }
        } else {
            this._relativePaths.setObjectForKey((Object)string2, (Object)string3);
        }
    }

    private void _newPreloadAllResourcesInLanguageDirectory(File file, int n, int n2) {
        String string = NSPathUtilities.lastPathComponent((String)NSPathUtilities.stringByDeletingPathExtension((String)file.getName()));
        int n3 = n2 + string.length() + 7;
        NSMutableArray nSMutableArray = new NSMutableArray(64);
        this._newPreloadAllResourcesInSubDirectory(file, n, n2, nSMutableArray);
        int n4 = nSMutableArray.count();
        for (int i = 0; i < n4; ++i) {
            String string2 = (String)nSMutableArray.objectAtIndex(i);
            String string3 = NSPathUtilities._standardizedPath((String)string2).substring(n3);
            Object object = this._relativePaths.objectForKey((Object)string3);
            if (object != null) {
                if (object instanceof String) {
                    Object object2 = object;
                    object = new NSMutableDictionary();
                    ((NSMutableDictionary)object).setObjectForKey(object2, (Object)"Default");
                    this._relativePaths.setObjectForKey(object, (Object)string3);
                }
            } else {
                object = new NSMutableDictionary();
                this._relativePaths.setObjectForKey(object, (Object)string3);
            }
            if (((NSMutableDictionary)object).objectForKey((Object)string) != null) continue;
            String string4 = string2.substring(n);
            ((NSMutableDictionary)object).setObjectForKey((Object)string4, (Object)string);
        }
    }

    private void _jarPreloadAllResourcesInLanguageDirectory(String string) {
        String string2 = NSPathUtilities.lastPathComponent((String)NSPathUtilities.stringByDeletingPathExtension((String)string));
        NSMutableArray nSMutableArray = new NSMutableArray(64);
        this._jarPreloadAllResourcesInSubDirectory(string, nSMutableArray);
        int n = nSMutableArray.count();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)nSMutableArray.objectAtIndex(i);
            String string4 = NSPathUtilities.lastPathComponent((String)string3);
            Object object = this._relativePaths.objectForKey((Object)string4);
            if (object != null) {
                if (object instanceof String) {
                    Object object2 = object;
                    object = new NSMutableDictionary();
                    ((NSMutableDictionary)object).setObjectForKey(object2, (Object)"Default");
                    this._relativePaths.setObjectForKey(object, (Object)string4);
                }
            } else {
                object = new NSMutableDictionary();
                this._relativePaths.setObjectForKey(object, (Object)string4);
            }
            if (((NSMutableDictionary)object).objectForKey((Object)string2) != null) continue;
            int n2 = string3.indexOf("!/");
            n2 = n2 != -1 ? (n2 += 2) : 0;
            String string5 = string3.substring(n2);
            ((NSMutableDictionary)object).setObjectForKey((Object)string5, (Object)string2);
        }
    }

    protected void _newPreloadAllResourcesInSubDirectory(File file, int n, int n2, NSMutableArray nSMutableArray) {
        String[] stringArray = file.list();
        File file2 = null;
        if (stringArray != null) {
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                String string = stringArray[i];
                file2 = new File(file, string);
                if (nSMutableArray == null) {
                    this._newAddToRelativePaths(file2, n, n2);
                } else {
                    nSMutableArray.addObject((Object)file2.getAbsolutePath());
                }
                if (!file2.isDirectory() || string.endsWith(".wo") || string.equals("CVS")) continue;
                this._newPreloadAllResourcesInSubDirectory(file2, n, n2, nSMutableArray);
            }
        }
    }

    protected void _jarPreloadAllResourcesInSubDirectory(String string, NSMutableArray nSMutableArray) {
        Object object;
        NSMutableArray nSMutableArray2 = new NSMutableArray();
        NSMutableArray nSMutableArray3 = new NSMutableArray();
        this._nsBundle._simplePathsInDirectoryInJar(string, "", nSMutableArray2, "", nSMutableArray3);
        Enumeration enumeration = nSMutableArray3.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (nSMutableArray == null) {
                this._jarAddToRelativePaths(_NSStringUtilities.concat((String)string, (String)"/", (String)object));
                continue;
            }
            nSMutableArray.addObject((Object)_NSStringUtilities.concat((String)string, (String)"/", (String)object));
        }
        object = nSMutableArray2.objectEnumerator();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            if (nSMutableArray == null) {
                this._jarAddToRelativePaths(_NSStringUtilities.concat((String)string, (String)"/", (String)string2));
            } else {
                nSMutableArray.addObject((Object)_NSStringUtilities.concat((String)string, (String)"/", (String)string2));
            }
            if (string2.endsWith(".wo") || string2.equals("CVS")) continue;
            this._jarPreloadAllResourcesInSubDirectory(_NSStringUtilities.concat((String)string, (String)"/", (String)string2), nSMutableArray);
        }
    }

    private void _newPreloadAllResourcesInTopDirectory(String string) {
        File file = new File(this.bundlePath(), string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            File file2 = null;
            int n = stringArray.length;
            int n2 = 0;
            int n3 = 0;
            n2 = file.getAbsolutePath().length() + 1;
            n3 = file.getAbsolutePath().lastIndexOf(string);
            if (string.equals(".")) {
                n3 += 2;
            }
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                file2 = new File(file, string2);
                String string3 = file2.getAbsolutePath();
                if (file2.isDirectory()) {
                    if (string3.endsWith(_webServerResources) || string3.endsWith(_resources) || string3.endsWith(".subproj") || string3.endsWith(_versions) || string3.endsWith(_cvs)) continue;
                    if (string3.endsWith(".lproj")) {
                        String string4 = NSPathUtilities.lastPathComponent((String)string3);
                        string4 = string4.substring(0, string4.length() - ".lproj".length());
                        this.addToExpectedLanguages(string4);
                        this._newPreloadAllResourcesInLanguageDirectory(file2, n3, n2);
                        continue;
                    }
                    if (string3.endsWith(".wo") || string3.endsWith(".eomodeld")) {
                        this._newAddToRelativePaths(file2, n3, n2);
                    }
                    if (NSPathUtilities.pathExtension((String)string3).length() > 0) {
                        this._newAddToRelativePaths(file2, n3, n2);
                    }
                    this._newPreloadAllResourcesInSubDirectory(file2, n3, n2, null);
                    continue;
                }
                this._newAddToRelativePaths(file2, n3, n2);
            }
        }
    }

    private void _jarPreloadAllResourcesInTopDirectory(String string) {
        Object object;
        NSMutableArray nSMutableArray = new NSMutableArray();
        NSMutableArray nSMutableArray2 = new NSMutableArray();
        this._nsBundle._simplePathsInDirectoryInJar(string, "", nSMutableArray, "", nSMutableArray2);
        String string2 = string.equals(".") ? "" : string.concat("/");
        Enumeration enumeration = nSMutableArray2.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this._jarAddToRelativePaths(string2.concat((String)object));
        }
        object = nSMutableArray.objectEnumerator();
        while (object.hasMoreElements()) {
            String string3 = (String)object.nextElement();
            String string4 = _NSStringUtilities.concat((String)string, (String)"/", (String)string3);
            if (string4.endsWith(_webServerResources) || string4.endsWith(_resources) || string4.endsWith(".subproj") || string4.endsWith(_versions) || string4.endsWith(_cvs) || string4.endsWith("META-INF")) continue;
            if (string4.endsWith(".lproj")) {
                String string5 = string3;
                string5 = string5.substring(0, string5.length() - ".lproj".length());
                this.addToExpectedLanguages(string5);
                this._jarPreloadAllResourcesInLanguageDirectory(string2.concat(string3));
                continue;
            }
            if (string4.endsWith(".eomodeld") || string4.endsWith(".wo")) {
                this._jarAddToRelativePaths(string2.concat(string3));
            }
            if (NSPathUtilities.pathExtension((String)string3).length() > 0) {
                this._jarAddToRelativePaths(string2.concat(string3));
            }
            this._jarPreloadAllResourcesInSubDirectory(string2.concat(string3), null);
        }
    }

    private void addToExpectedLanguages(String string) {
        this._expectedLanguages.addObject((Object)string);
    }

    private NSArray expectedLanguages() {
        return this._expectedLanguages.allObjects();
    }

    private boolean isLocalized() {
        return this._expectedLanguages.count() > 0;
    }

    private synchronized void _preloadAllResourcesIfNecessary() {
        if (!this._resourcesHaveBeenPreloaded) {
            if (this._isJar) {
                this._jarPreloadAllResourcesInTopDirectory("WebServerResources");
                this._jarPreloadAllResourcesInTopDirectory("Resources");
                this._jarPreloadAllResourcesInTopDirectory(".");
            } else {
                this._newPreloadAllResourcesInTopDirectory(_NSStringUtilities.concat((String)"Contents", (String)File.separator, (String)"WebServerResources"));
                this._newPreloadAllResourcesInTopDirectory(_NSStringUtilities.concat((String)"Contents", (String)File.separator, (String)"Resources"));
                this._newPreloadAllResourcesInTopDirectory("Contents");
                this._newPreloadAllResourcesInTopDirectory("WebServerResources");
                this._newPreloadAllResourcesInTopDirectory("Resources");
                this._newPreloadAllResourcesInTopDirectory(".");
            }
            if (this.isLocalized()) {
                WOApplication.application()._addToExpectedLanguages(this.expectedLanguages());
            }
            this._resourcesHaveBeenPreloaded = true;
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)32L)) {
                NSLog.debug.appendln((Object)(this._wrapperName + " " + this._relativePaths.delegate()));
            }
        }
    }

    public String relativePathForResource(String string, NSArray nSArray) {
        Object object = null;
        if (string != null) {
            this._preloadAllResourcesIfNecessary();
            object = this._relativePaths.objectForKey((Object)string);
            if (object != null) {
                if (object instanceof NSDictionary) {
                    NSMutableDictionary nSMutableDictionary = (NSMutableDictionary)object;
                    if (nSArray != null) {
                        int n = nSArray.count();
                        for (int i = 0; i < n; ++i) {
                            object = (String)nSMutableDictionary.objectForKey((Object)((String)nSArray.objectAtIndex(i)));
                            if (object == null) continue;
                            return (String)object;
                        }
                    }
                    object = nSMutableDictionary.objectForKey((Object)"Default");
                }
            } else {
                String string2 = NSPathUtilities._standardizedPath((String)string);
                if (!string2.equals(string) && (object = this.relativePathForResource(string2, nSArray)) != null && ((String)object).length() > 0) {
                    this._relativePaths.setObjectForKey(this._relativePaths.objectForKey((Object)string2), (Object)string);
                }
            }
        }
        return (String)object;
    }

    public String relativePathForResource(String string, String string2) {
        this._preloadAllResourcesIfNecessary();
        Object object = this._relativePaths.objectForKey((Object)string);
        if (object instanceof NSMutableDictionary) {
            NSMutableDictionary nSMutableDictionary = (NSMutableDictionary)object;
            object = string2 != null ? nSMutableDictionary.objectForKey((Object)string2) : nSMutableDictionary.objectForKey((Object)"Default");
        }
        return (String)object;
    }

    private String _cachedAbsolutePath(String string) {
        String string2 = null;
        if (string != null && (string2 = (String)this._absolutePaths.objectForKey((Object)string)) == null) {
            if (this._isJar) {
                string2 = this._nsBundle._bundleURLPrefix().concat(string);
            } else {
                string2 = NSPathUtilities.stringByAppendingPathComponent((String)this.bundlePath(), (String)string);
                string2 = NSPathUtilities.stringByStandardizingPath((String)string2);
            }
            this._absolutePaths.setObjectForKey((Object)string2, (Object)string);
        }
        return string2;
    }

    private URL _cachedPathURL(String string) {
        URL uRL = null;
        if (string != null && (uRL = (URL)this._pathURLs.objectForKey((Object)string)) == null && (uRL = this._nsBundle._urlForRelativePath(string)) != null) {
            this._pathURLs.setObjectForKey((Object)uRL, (Object)string);
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _absolutePathForRelativePath(String string) {
        String string2 = null;
        NSMutableDictionary nSMutableDictionary = this._absolutePaths;
        synchronized (nSMutableDictionary) {
            string2 = this._cachedAbsolutePath(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL _pathURLForRelativePath(String string) {
        URL uRL = null;
        NSMutableDictionary nSMutableDictionary = this._pathURLs;
        synchronized (nSMutableDictionary) {
            uRL = this._cachedPathURL(string);
        }
        return uRL;
    }

    public String _absolutePathForResource(String string, NSArray nSArray) {
        String string2 = this.relativePathForResource(string, nSArray);
        return this._absolutePathForRelativePath(string2);
    }

    public String _absolutePathForResource(String string, String string2, boolean bl) {
        return this._absolutePathForResource(string, string2);
    }

    public String _absolutePathForResource(String string, String string2) {
        String string3 = this.relativePathForResource(string, string2);
        return this._absolutePathForRelativePath(string3);
    }

    public InputStream inputStreamForResourceNamed(String string, NSArray nSArray) {
        InputStream inputStream = null;
        URL uRL = this.pathURLForResourceNamed(string, nSArray);
        if (uRL != null) {
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    public InputStream inputStreamForResourceNamed(String string, String string2) {
        InputStream inputStream = null;
        URL uRL = this.pathURLForResourceNamed(string, string2);
        if (uRL != null) {
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    public URL pathURLForResourceNamed(String string, String string2, boolean bl) {
        return this.pathURLForResourceNamed(string, string2);
    }

    public URL pathURLForResourceNamed(String string, String string2) {
        String string3 = this.relativePathForResource(string, string2);
        return this._pathURLForRelativePath(string3);
    }

    public URL pathURLForResourceNamed(String string, NSArray nSArray) {
        String string2 = this.relativePathForResource(string, nSArray);
        return this._pathURLForRelativePath(string2);
    }

    private String _cachedURL(String string) {
        String string2 = null;
        if (string != null && (string2 = (String)this._URLs.objectForKey((Object)string)) == null) {
            String string3 = null;
            string3 = this.isFramework() ? WOApplication.application().frameworksBaseURL() : WOApplication.application().applicationBaseURL();
            String string4 = this.wrapperName();
            if (string3 != null && string4 != null) {
                string2 = _NSStringUtilities.concat((String)string3, (String)File.separator, (String)string4, (String)File.separator, (String)string);
                string2 = NSPathUtilities._standardizedPath((String)string2);
                this._URLs.setObjectForKey((Object)string2, (Object)string);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String urlForResource(String string, NSArray nSArray) {
        String string2 = this.relativePathForResource(string, nSArray);
        String string3 = null;
        NSMutableDictionary nSMutableDictionary = this._URLs;
        synchronized (nSMutableDictionary) {
            string3 = this._cachedURL(string2);
        }
        return string3;
    }

    public String bundlePath() {
        return this._bundlePath;
    }

    protected String _initBundlePath(String string) {
        if (!this._isJar) {
            return NSPathUtilities.stringByNormalizingExistingPath((String)string);
        }
        return string;
    }

    protected URL _initBundleURL(URL uRL) {
        return uRL;
    }

    protected String _initProjectName(String string) {
        return NSPathUtilities.stringByDeletingPathExtension((String)string);
    }

    public String projectName() {
        return this._projectName;
    }

    public String wrapperName() {
        return this._wrapperName;
    }

    public boolean isFramework() {
        return this._isFramework;
    }

    public boolean isAggregate() {
        return false;
    }

    public boolean isJar() {
        return this._isJar;
    }

    public NSBundle nsBundle() {
        return this._nsBundle;
    }

    public WOProjectBundle projectBundle() {
        WOProjectBundle wOProjectBundle = null;
        if (_allowRapidTurnaround) {
            String string = this.projectName();
            boolean bl = this.isFramework();
            wOProjectBundle = WOProjectBundle.projectBundleForProject(string, bl);
        }
        return wOProjectBundle;
    }

    public static synchronized WODeployedBundle bundleWithPath(String string) {
        NSBundle nSBundle = NSBundle.bundleWithPath((String)string);
        if (nSBundle == null) {
            return null;
        }
        return WODeployedBundle.bundleWithNSBundle(nSBundle);
    }

    public static synchronized WODeployedBundle bundleWithNSBundle(NSBundle nSBundle) {
        Object object = TheBundles.objectForKey((Object)nSBundle);
        if (object == null) {
            WODeployedBundle wODeployedBundle = new WODeployedBundle(nSBundle);
            if (wODeployedBundle != null) {
                if (_allowRapidTurnaround && WOProjectBundle._isProjectBundlePath(nSBundle.bundlePath())) {
                    try {
                        object = new WOProjectBundle(nSBundle.bundlePath(), wODeployedBundle);
                    }
                    catch (Exception exception) {
                        if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                            NSLog.debug.appendln((Object)("<WOProjectBundle>: Warning - Unable to find project at path " + nSBundle.bundlePath() + " - Ignoring project."));
                            NSLog.debug.appendln((Throwable)exception);
                        }
                        object = wODeployedBundle;
                    }
                } else {
                    object = wODeployedBundle;
                }
            }
            TheBundles.setObjectForKey(object, (Object)nSBundle);
        }
        return (WODeployedBundle)object;
    }

    private boolean _isWebServerResource(String string) {
        this._preloadAllResourcesIfNecessary();
        Object object = this._relativePaths.objectForKey((Object)string);
        if (object != null) {
            if (object instanceof String) {
                if (this._isAnyWebServerResource((String)object)) {
                    return true;
                }
            } else {
                NSArray nSArray = ((NSDictionary)object).allValues();
                int n = nSArray.count();
                for (int i = 0; i < n; ++i) {
                    if (!this._isAnyWebServerResource((String)nSArray.objectAtIndex(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean _isAnyWebServerResource(String string) {
        return string.startsWith(_webServerResourcesPathKey) || string.startsWith(_contentsWebServerResourcesPathKey);
    }

    public NSArray _allResourceNamesWithExtension(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Extension needs to be specified in _allResourceNamesWithExtension");
        }
        this._preloadAllResourcesIfNecessary();
        NSMutableArray nSMutableArray = new NSMutableArray(16);
        NSArray nSArray = this._relativePaths.allKeys();
        int n = nSArray.count();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)nSArray.objectAtIndex(i);
            String string3 = NSPathUtilities.pathExtension((String)string2);
            if (string3 == null || !string.equals(string3) || bl && !this._isWebServerResource(string2)) continue;
            nSMutableArray.addObject((Object)string2);
        }
        return nSMutableArray;
    }

    public static synchronized WODeployedBundle deployedBundleForFrameworkNamed(String string) {
        WODeployedBundle wODeployedBundle = null;
        NSArray nSArray = TheBundles.allValues();
        int n = TheBundles.count();
        NSBundle nSBundle = NSBundle.bundleForName((String)string);
        if (nSBundle == null) {
            nSBundle = NSBundle.bundleWithPath((String)string);
        }
        if (nSBundle != null) {
            for (int i = 0; i < n; ++i) {
                WOProjectBundle wOProjectBundle;
                WODeployedBundle wODeployedBundle2 = (WODeployedBundle)nSArray.objectAtIndex(i);
                if (!nSBundle.equals(wODeployedBundle2.nsBundle())) continue;
                wODeployedBundle = wODeployedBundle2;
                if (!(wODeployedBundle instanceof WODeployedBundle) || (wOProjectBundle = wODeployedBundle.projectBundle()) == null) break;
                wODeployedBundle = wOProjectBundle;
                break;
            }
        }
        return wODeployedBundle;
    }

    public String toString() {
        return "<" + this.getClass().getName() + ": bundlePath='" + this._bundlePath + "'>";
    }
}

