/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAction;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOActionRequestHandler;
import com.webobjects.appserver._private.WODynamicURL;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSProperties;

public class WODirectActionRequestHandler
extends WOActionRequestHandler {
    private final boolean displayExceptionPages;
    private WOResponse nullResponse = null;
    private boolean _allowsContentInputStream = false;

    protected String defaultActionClassName() {
        return "DirectAction";
    }

    public static WORequestHandler handler() {
        return new WODirectActionRequestHandler();
    }

    public WODirectActionRequestHandler() {
        this("DirectAction", "default", true);
    }

    public WODirectActionRequestHandler(String string, String string2, boolean bl) {
        super(string, string2, bl);
        if (this.actionClassClass == null) {
            this.actionClassClass = WODirectAction.class;
        }
        WOAction._preloadAllActionsOnClass(this.actionClassClass, "Action");
        this.displayExceptionPages = NSProperties.booleanForKey((String)"WODisplayExceptionPages");
    }

    public void setAllowsContentInputStream(boolean bl) {
        this._allowsContentInputStream = bl;
    }

    public boolean allowsContentInputStream() {
        return this._allowsContentInputStream;
    }

    private String _submitButtonsActionPathFromRequest(WORequest wORequest) {
        if (this._allowsContentInputStream) {
            return null;
        }
        String string = null;
        NSArray nSArray = wORequest.formValuesForKey("WOSubmitAction");
        if (nSArray != null) {
            int n = nSArray.count();
            int n2 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                String string2 = (String)nSArray.objectAtIndex(n2);
                if (wORequest.formValuesForKey(string2) != null) {
                    string = string2;
                    break;
                }
                String string3 = string2.concat(".x");
                if (wORequest.formValuesForKey(string3) == null) continue;
                string = string2;
                break;
            }
        }
        return string;
    }

    public WOResponse nullResponse() {
        if (this.nullResponse == null) {
            this.nullResponse = WOApplication.application().createResponseInContext(null);
            this.nullResponse.setStatus(500);
            this.nullResponse.appendContentString("<html><head><title>Error</title></head><body>Your request produced an error.</body></html>");
        }
        return this.nullResponse;
    }

    public void registerWillHandleActionRequest() {
        WOApplication.application().statisticsStore().applicationWillHandleDirectActionRequest();
    }

    public void registerDidHandleActionRequestWithActionNamed(String string) {
        WOApplication.application().statisticsStore().applicationDidHandleDirectActionRequestWithActionNamed(string);
    }

    public NSArray getRequestHandlerPathForRequest(WORequest wORequest) {
        String string = this._submitButtonsActionPathFromRequest(wORequest);
        NSArray nSArray = null;
        nSArray = string == null ? wORequest.requestHandlerPathArray() : NSArray.componentsSeparatedByString((String)string, (String)"/");
        return nSArray;
    }

    public WOResponse generateErrorResponse(Exception exception, WOContext wOContext) {
        WOResponse wOResponse = null;
        if (this.displayExceptionPages) {
            wOResponse = WOApplication.application().handleException(exception, wOContext);
        }
        return wOResponse;
    }

    public WOResponse generateRequestRefusal(WORequest wORequest) {
        WODynamicURL wODynamicURL = wORequest._uriDecomposed();
        String string = "Sorry, your request could not immediately be processed. Please try this URL: <a href=\"" + wODynamicURL + "\">" + wODynamicURL + "</a>";
        wODynamicURL.setApplicationNumber("-1");
        WOResponse wOResponse = WOApplication.application().createResponseInContext(null);
        WOResponse._redirectResponse(wOResponse, wODynamicURL.toString(), string);
        return wOResponse;
    }
}

