/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WODynamicGroup;
import com.webobjects.appserver._private.WOHTMLAttribute;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSStringUtilities;
import java.util.Enumeration;

public abstract class WOHTMLDynamicElement
extends WODynamicGroup {
    protected String _dyneltName;
    private NSMutableDictionary _nonURLAttributeAssociations;
    private NSMutableDictionary _urlAttributeAssociations;
    protected volatile String _constantAttributesRepresentation;
    protected NSMutableDictionary _associations;
    protected volatile boolean _finishedInitialization;

    protected static boolean escapeHTML() {
        return false;
    }

    private static boolean _needQuote(String string) {
        int n = string.length();
        return n <= 0 || string.charAt(0) != '\"' || string.charAt(n - 1) != '\"';
    }

    public WOHTMLDynamicElement(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super(null, null, wOElement);
        this._dyneltName = string;
        if (nSDictionary == null) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + "> Attempt to instantiate dynamic element without associations.");
        }
        this._associations = nSDictionary.mutableClone();
        this._finishedInitialization = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _finishInitialization() {
        WOHTMLDynamicElement wOHTMLDynamicElement = this;
        synchronized (wOHTMLDynamicElement) {
            if (this._finishedInitialization) {
                return;
            }
            this._nonURLAttributeAssociations = null;
            this._urlAttributeAssociations = null;
            StringBuffer stringBuffer = new StringBuffer(256);
            if (this._dyneltName != null && this._associations != null && this._associations.count() != 0) {
                Enumeration enumeration = this._associations.keyEnumerator();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    String string = (String)enumeration.nextElement();
                    WOAssociation wOAssociation = (WOAssociation)this._associations.objectForKey((Object)string);
                    if (wOAssociation instanceof WOConstantValueAssociation && !WOHTMLDynamicElement.escapeHTML()) {
                        String string2;
                        object = wOAssociation.valueInComponent(null);
                        String string3 = string2 = object != null ? object.toString() : "";
                        if (string.equals("otherTagString")) {
                            stringBuffer.append(' ');
                            stringBuffer.append(string2);
                        } else {
                            stringBuffer.append(' ');
                            stringBuffer.append(string);
                            stringBuffer.append('=');
                            if (WOHTMLDynamicElement._needQuote(string2) || string2.length() == 0) {
                                stringBuffer.append('\"');
                                stringBuffer.append(string2);
                                stringBuffer.append('\"');
                            } else {
                                stringBuffer.append(string2);
                            }
                        }
                        this._associations.removeObjectForKey((Object)string);
                        continue;
                    }
                    object = WOHTMLAttribute.urlAttributesForElementNamed(this._dyneltName);
                    boolean bl = false;
                    if (object != null) {
                        int n = object.count();
                        for (int i = 0; i < n && !bl; ++i) {
                            bl = string.equalsIgnoreCase((String)object.objectAtIndex(i));
                        }
                    }
                    if (!bl) continue;
                    if (this._urlAttributeAssociations == null) {
                        this._urlAttributeAssociations = new NSMutableDictionary();
                    }
                    this._urlAttributeAssociations.setObjectForKey((Object)wOAssociation, (Object)string);
                    this._associations.removeObjectForKey((Object)string);
                }
                if (this._associations.count() != 0) {
                    this._nonURLAttributeAssociations = this._associations;
                }
            }
            this._constantAttributesRepresentation = stringBuffer.length() != 0 ? _NSStringUtilities.stringFromBuffer((StringBuffer)stringBuffer) : null;
            this._associations = null;
        }
        this._finishedInitialization = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<" + this.getClass().getName() + ">");
        try {
            if (this.elementName() != null) {
                stringBuffer.append("Name : " + this.elementName() + " ");
            }
        }
        catch (Exception exception) {
            NSLog._conditionallyLogPrivateException((Throwable)exception);
        }
        if (this._constantAttributesRepresentation != null) {
            stringBuffer.append(" Constant Attributes : \"" + this._constantAttributesRepresentation + "\" ");
        }
        if (this._urlAttributeAssociations != null) {
            stringBuffer.append("URL Dynamic Attributes : " + this._urlAttributeAssociations + " ");
        }
        if (this._nonURLAttributeAssociations != null) {
            stringBuffer.append("non-URL Dynamic Attributes : " + this._nonURLAttributeAssociations + " ");
        }
        if (this.hasChildrenElements()) {
            stringBuffer.append("Children : " + this.childrenElements());
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public String elementName() {
        return this._dyneltName;
    }

    protected NSMutableDictionary urlAttributeAssociations() {
        if (!this._finishedInitialization) {
            this._finishInitialization();
        }
        return this._urlAttributeAssociations;
    }

    protected NSMutableDictionary nonUrlAttributeAssociations() {
        if (!this._finishedInitialization) {
            this._finishInitialization();
        }
        return this._nonURLAttributeAssociations;
    }

    protected String constantAttributesRepresentation() {
        if (!this._finishedInitialization) {
            this._finishInitialization();
        }
        return this._constantAttributesRepresentation;
    }

    protected static String _frameworkNameInComponent(WOAssociation wOAssociation, WOComponent wOComponent) {
        String string = null;
        if (wOAssociation != null) {
            string = (String)wOAssociation.valueInComponent(wOComponent);
            if (string != null) {
                if (string.equalsIgnoreCase("app")) {
                    string = null;
                }
            } else {
                if (wOComponent != null) {
                    string = wOComponent.frameworkName();
                }
                WOApplication.application().debugString((wOComponent == null ? "" : wOComponent.toString()) + " 'framework' evaluated to null. Defaulting to " + (string == null ? "app" : string));
            }
        } else if (wOComponent != null) {
            string = wOComponent.frameworkName();
        }
        return string;
    }

    protected String computeActionStringInContext(WOAssociation wOAssociation, WOAssociation wOAssociation2, WOContext wOContext) {
        WOComponent wOComponent = wOContext.component();
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        if (wOAssociation != null && !((object = wOAssociation.valueInComponent(wOComponent)) instanceof String)) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + "> Value for attribute named \"" + "actionClass" + "\" must be a string.  Received " + object);
        }
        if (wOAssociation2 != null && !((object2 = wOAssociation2.valueInComponent(wOComponent)) instanceof String)) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + "> Value for attribute named \"" + "directActionName" + "\" must be a string.  Received " + object2);
        }
        if (object != null && object2 != null) {
            object3 = object.equals("DirectAction") ? object2 : object + "/" + object2;
        } else if (object != null) {
            object3 = object;
        } else if (object2 != null) {
            object3 = object2;
        } else {
            throw new IllegalStateException("<" + this.getClass().getName() + "> Both 'actionClass' and 'directActionName' are either absent or evaluated to null. Cannot generate dynamic url without an actionClass or directActionName.");
        }
        return (String)object3;
    }

    protected NSDictionary computeQueryDictionaryInContext(WOAssociation wOAssociation, WOAssociation wOAssociation2, WOAssociation wOAssociation3, boolean bl, NSDictionary nSDictionary, WOContext wOContext) {
        Object object;
        WOComponent wOComponent = wOContext.component();
        WOSession wOSession = wOContext._session();
        String string = null;
        NSMutableDictionary nSMutableDictionary = null;
        if (wOAssociation3 != null) {
            object = (NSDictionary)wOAssociation3.valueInComponent(wOComponent);
            nSMutableDictionary = object instanceof NSMutableDictionary ? (NSMutableDictionary)object : object.mutableClone();
        }
        if (nSMutableDictionary == null) {
            nSMutableDictionary = new NSMutableDictionary();
        }
        if (wOSession != null) {
            string = wOSession.sessionID();
        } else if (wOContext.request() != null) {
            string = wOContext.request().stringFormValueForKey("wosid");
        }
        if (!(string == null || wOAssociation2 == null && wOAssociation == null || wOSession != null && wOSession.storesIDsInCookies() && !wOSession.storesIDsInURLs())) {
            nSMutableDictionary.setObjectForKey((Object)string, (Object)"wosid");
        }
        if (nSDictionary != null) {
            Enumeration enumeration = nSDictionary.keyEnumerator();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                WOAssociation wOAssociation4 = (WOAssociation)nSDictionary.objectForKey(object);
                Object object2 = wOAssociation4.valueInComponent(wOComponent);
                if (object2 != null && (((String)object).equals("wosid") || object2 != Boolean.FALSE)) {
                    nSMutableDictionary.setObjectForKey(object2, object);
                    continue;
                }
                nSMutableDictionary.removeObjectForKey(object);
            }
        }
        return nSMutableDictionary;
    }

    protected void appendConstantAttributesToResponse(WOResponse wOResponse, WOContext wOContext) {
        String string = this.constantAttributesRepresentation();
        if (string != null) {
            wOResponse.appendContentString(string);
        }
    }

    protected void _appendAttributesFromAssociationsToResponse(WOResponse wOResponse, WOContext wOContext, NSDictionary nSDictionary) {
        if (nSDictionary != null && nSDictionary.count() != 0) {
            Enumeration enumeration = nSDictionary.keyEnumerator();
            WOComponent wOComponent = wOContext.component();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                WOAssociation wOAssociation = (WOAssociation)nSDictionary.objectForKey((Object)string);
                Object object = wOAssociation.valueInComponent(wOComponent);
                if (object == null) continue;
                String string2 = object.toString();
                if (string.equals("otherTagString")) {
                    wOResponse.appendContentCharacter(' ');
                    wOResponse.appendContentString(string2);
                    continue;
                }
                wOResponse._appendTagAttributeAndValue(string, string2, false);
            }
        }
    }

    protected void appendNonURLAttributesToResponse(WOResponse wOResponse, WOContext wOContext) {
        NSMutableDictionary nSMutableDictionary = this.nonUrlAttributeAssociations();
        this._appendAttributesFromAssociationsToResponse(wOResponse, wOContext, (NSDictionary)this.nonUrlAttributeAssociations());
    }

    protected void appendURLAttributesToResponse(WOResponse wOResponse, WOContext wOContext) {
        NSMutableDictionary nSMutableDictionary = this.urlAttributeAssociations();
        if (nSMutableDictionary != null && nSMutableDictionary.count() != 0) {
            WOComponent wOComponent = wOContext.component();
            Enumeration enumeration = nSMutableDictionary.keyEnumerator();
            String string = null;
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                WOAssociation wOAssociation = (WOAssociation)nSMutableDictionary.objectForKey((Object)string3);
                Object object = wOAssociation.valueInComponent(wOComponent);
                if (object != null) {
                    string = object.toString();
                    string2 = wOContext._urlForResourceNamed(string, null, true);
                } else {
                    WOApplication.application().debugString(this.toString() + ": '" + string3 + "' evaluated to null in component " + wOComponent.toString() + ".\nInserted null resource in html tag...");
                }
                if (string2 != null) {
                    wOResponse._appendTagAttributeAndValue(string3, string2, false);
                    continue;
                }
                wOResponse.appendContentCharacter(' ');
                wOResponse._appendContentAsciiString(string3);
                wOResponse._appendContentAsciiString("=\"");
                wOResponse._appendContentAsciiString(wOComponent.baseURL());
                wOResponse.appendContentCharacter('/');
                wOResponse._appendContentAsciiString(string);
                wOResponse.appendContentCharacter('\"');
            }
        }
    }

    public void appendAttributesToResponse(WOResponse wOResponse, WOContext wOContext) {
        this.appendConstantAttributesToResponse(wOResponse, wOContext);
        this.appendNonURLAttributesToResponse(wOResponse, wOContext);
        this.appendURLAttributesToResponse(wOResponse, wOContext);
    }

    protected void _appendOpenTagToResponse(WOResponse wOResponse, WOContext wOContext) {
        wOResponse.appendContentCharacter('<');
        wOResponse._appendContentAsciiString(this.elementName());
        this.appendAttributesToResponse(wOResponse, wOContext);
        wOResponse.appendContentCharacter('>');
    }

    protected void _appendCloseTagToResponse(WOResponse wOResponse, WOContext wOContext) {
        wOResponse._appendContentAsciiString("</");
        wOResponse._appendContentAsciiString(this.elementName());
        wOResponse.appendContentCharacter('>');
    }

    public void appendToResponse(WOResponse wOResponse, WOContext wOContext) {
        if (wOContext == null || wOResponse == null) {
            return;
        }
        String string = this.elementName();
        if (string != null) {
            this._appendOpenTagToResponse(wOResponse, wOContext);
        }
        this.appendChildrenToResponse(wOResponse, wOContext);
        if (string != null) {
            this._appendCloseTagToResponse(wOResponse, wOContext);
        }
    }
}

