/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver._private.WODeclarationFormatException;
import com.webobjects.appserver._private.WOHTMLFormatException;
import com.webobjects.appserver._private.WOHTMLParserDelegate;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation._NSStringUtilities;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class WOHTMLParser {
    private WOHTMLParserDelegate _client;
    private String _string;
    private StringBuffer _contentText;
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INSIDE_COMMENT = 3;
    private static final String JS_START_TAG = "<script";
    private static final String JS_END_TAG = "</script";

    public WOHTMLParser(WOHTMLParserDelegate wOHTMLParserDelegate, String string) {
        this._client = wOHTMLParserDelegate;
        this._string = string;
        this._contentText = new StringBuffer(128);
    }

    public void parseHTML() throws WOHTMLFormatException, WODeclarationFormatException, ClassNotFoundException {
        Object var4_1 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this._string, "<");
        boolean bl = true;
        int n = 0;
        String string = this._string.startsWith("<") || !stringTokenizer.hasMoreTokens() ? null : stringTokenizer.nextToken("<");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                switch (n) {
                    case 0: {
                        if (string != null) {
                            if (string.startsWith(">")) {
                                string = string.substring(1);
                            }
                            this._contentText.append(string);
                        }
                        if ((string = stringTokenizer.nextToken(">")).toLowerCase().startsWith("<webobject")) {
                            if (string.endsWith("/")) {
                                this.startOfWebObjectTag(string.substring(0, string.length() - 1));
                                this.endOfWebObjectTag("/");
                                break;
                            }
                            this.startOfWebObjectTag(string);
                            break;
                        }
                        int n2 = string.toLowerCase().indexOf("<webobject");
                        if (n2 > 1) {
                            this._contentText.append(string.substring(0, string.lastIndexOf("<")));
                            this.startOfWebObjectTag(string.substring(n2, string.length()));
                            break;
                        }
                        if (string.toLowerCase().startsWith("</webobject")) {
                            this.endOfWebObjectTag(string);
                            break;
                        }
                        if (string.toLowerCase().startsWith(JS_START_TAG)) {
                            this.didParseText();
                            this._contentText.append(string);
                            this._contentText.append('>');
                            bl = false;
                            break;
                        }
                        if (string.toLowerCase().startsWith(JS_END_TAG)) {
                            this.didParseText();
                            this._contentText.append(string);
                            this._contentText.append('>');
                            bl = true;
                            break;
                        }
                        if (string.startsWith("<!--") && bl) {
                            this.didParseText();
                            this._contentText.append(string);
                            if (string.endsWith("--")) {
                                this._contentText.append('>');
                                this.didParseComment();
                                break;
                            }
                            n = 3;
                            break;
                        }
                        this._contentText.append(string);
                        this._contentText.append('>');
                        break;
                    }
                    case 3: {
                        string = stringTokenizer.nextToken(">");
                        this._contentText.append(string);
                        this._contentText.append('>');
                        if (!string.endsWith("--")) break;
                        this.didParseComment();
                        n = 0;
                    }
                }
                string = null;
                if (n != 0) continue;
                string = stringTokenizer.nextToken("<");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            NSLog._conditionallyLogPrivateException((Throwable)noSuchElementException);
            this.didParseText();
            return;
        }
        if (string != null) {
            if (string.startsWith(">")) {
                string = string.substring(1);
            }
            this._contentText.append(string);
        }
        this.didParseText();
    }

    private void startOfWebObjectTag(String string) throws WOHTMLFormatException {
        this.didParseText();
        this._contentText.append(string);
        this.didParseOpeningWebObjectTag();
    }

    private void endOfWebObjectTag(String string) throws WODeclarationFormatException, WOHTMLFormatException, ClassNotFoundException {
        this.didParseText();
        this._contentText.append(string);
        this.didParseClosingWebObjectTag();
    }

    private void didParseText() {
        if (this._contentText != null) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x800000L)) {
                NSLog.debug.appendln((Object)("<WOHTMLParser> Parsed Text (" + this._contentText.length() + ") : " + this._contentText));
            }
            if (this._contentText.length() > 0) {
                this._client.didParseText(_NSStringUtilities.stringFromBuffer((StringBuffer)this._contentText), this);
                this._contentText.setLength(0);
            }
        }
    }

    private void didParseOpeningWebObjectTag() throws WOHTMLFormatException {
        if (this._contentText != null) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x800000L)) {
                NSLog.debug.appendln((Object)("<WOHTMLParser> Parsed Opening WebObject (" + this._contentText.length() + ") : " + this._contentText));
            }
            if (this._contentText.length() > 0) {
                this._client.didParseOpeningWebObjectTag(_NSStringUtilities.stringFromBuffer((StringBuffer)this._contentText), this);
                this._contentText.setLength(0);
            }
        }
    }

    private void didParseClosingWebObjectTag() throws WODeclarationFormatException, WOHTMLFormatException, ClassNotFoundException, ClassNotFoundException {
        if (this._contentText != null) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x800000L)) {
                NSLog.debug.appendln((Object)("<WOHTMLParser> Parsed Closing WebObject (" + this._contentText.length() + ") : " + this._contentText));
            }
            if (this._contentText.length() > 0) {
                this._client.didParseClosingWebObjectTag(_NSStringUtilities.stringFromBuffer((StringBuffer)this._contentText), this);
                this._contentText.setLength(0);
            }
        }
    }

    private void didParseComment() {
        if (this._contentText != null) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x800000L)) {
                NSLog.debug.appendln((Object)("<WOHTMLParser> Parsed Comment (" + this._contentText.length() + ") : " + this._contentText));
            }
            if (this._contentText.length() > 0) {
                this._client.didParseComment(_NSStringUtilities.stringFromBuffer((StringBuffer)this._contentText), this);
                this._contentText.setLength(0);
            }
        }
    }
}

