/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOPageNotFoundException;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOHTMLDynamicElement;
import com.webobjects.appserver._private.WONoContentElement;
import com.webobjects.appserver._private.WOStaticURLUtilities;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSDictionaryUtilities;

public class WOHyperlink
extends WOHTMLDynamicElement {
    protected WOAssociation _action;
    protected WOAssociation _string;
    protected WOAssociation _pageName;
    protected WOAssociation _href;
    protected WOAssociation _disabled;
    protected WOAssociation _fragmentIdentifier;
    protected WOAssociation _secure;
    private final WOAssociation _queryDictionary;
    final WOAssociation _actionClass;
    final WOAssociation _directActionName;
    private NSDictionary _otherQueryAssociations;

    public WOHyperlink(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super("a", nSDictionary, wOElement);
        this._otherQueryAssociations = _NSDictionaryUtilities.extractObjectsForKeysWithPrefix((NSMutableDictionary)this._associations, (String)"?", (boolean)true);
        this._otherQueryAssociations = this._otherQueryAssociations != null && this._otherQueryAssociations.count() > 0 ? this._otherQueryAssociations : null;
        this._action = (WOAssociation)this._associations.removeObjectForKey((Object)"action");
        this._string = (WOAssociation)this._associations.removeObjectForKey((Object)"string");
        this._href = (WOAssociation)this._associations.removeObjectForKey((Object)"href");
        this._disabled = (WOAssociation)this._associations.removeObjectForKey((Object)"disabled");
        this._queryDictionary = (WOAssociation)this._associations.removeObjectForKey((Object)"queryDictionary");
        this._actionClass = (WOAssociation)this._associations.removeObjectForKey((Object)"actionClass");
        this._directActionName = (WOAssociation)this._associations.removeObjectForKey((Object)"directActionName");
        this._pageName = (WOAssociation)this._associations.removeObjectForKey((Object)"pageName");
        this._secure = (WOAssociation)this._associations.removeObjectForKey((Object)"secure");
        this._fragmentIdentifier = (WOAssociation)this._associations.removeObjectForKey((Object)"fragmentIdentifier");
        if (this._action == null && this._href == null && this._pageName == null && this._directActionName == null && this._actionClass == null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> Missing required attribute: 'action' or 'href' or 'pageName' or 'directActionName' or 'actionClass'");
        }
        if (this._action != null && this._href != null || this._action != null && this._pageName != null || this._href != null && this._pageName != null || this._action != null && this._directActionName != null || this._href != null && this._directActionName != null || this._pageName != null && this._directActionName != null || this._action != null && this._actionClass != null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> At least two of these conflicting attributes are present: 'action', 'href', 'pageName', 'directActionName', 'actionClass'.");
        }
        if (this._action != null && this._action.isValueConstant()) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> 'action' is a constant.");
        }
    }

    public String toString() {
        return "<" + this.getClass().getName() + " action: " + this._action + " actionClass: " + this._actionClass + " href: " + this._href + " string: " + this._string + " queryDictionary: " + this._queryDictionary + " otherQueryAssociations: " + this._otherQueryAssociations + " pageName: " + this._pageName + " fragmentIdentifier: " + this._fragmentIdentifier + " disabled: " + this._disabled + " secure: " + this._secure + ">";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WOActionResults invokeAction(WORequest wORequest, WOContext wOContext) {
        void var4_8;
        void var4_10;
        String string = null;
        Object var4_4 = null;
        WOComponent wOComponent = wOContext.component();
        if (!wOContext.elementID().equals(wOContext.senderID())) return var4_10;
        if (this._disabled == null || !this._disabled.booleanValueInComponent(wOComponent)) {
            Object object;
            if (this._pageName != null && (object = this._pageName.valueInComponent(wOComponent)) != null) {
                string = object.toString();
            }
            if (this._action != null) {
                WOActionResults wOActionResults = (WOActionResults)this._action.valueInComponent(wOComponent);
            } else {
                if (this._pageName == null) {
                    throw new IllegalStateException("<" + this.getClass().getName() + "> : Missing page name.");
                }
                if (string == null) throw new WOPageNotFoundException("<" + this.getClass().getName() + "> : cannot find page.");
                WOComponent wOComponent2 = WOApplication.application().pageWithName(string, wOContext);
            }
        } else {
            WONoContentElement wONoContentElement = new WONoContentElement();
        }
        if (var4_8 != null) return var4_10;
        WOComponent wOComponent3 = wOContext.page();
        return var4_10;
    }

    protected void _appendOpenTagToResponse(WOResponse wOResponse, WOContext wOContext) {
        if (!this.isDisabled(wOContext)) {
            super._appendOpenTagToResponse(wOResponse, wOContext);
        }
    }

    protected void _appendCloseTagToResponse(WOResponse wOResponse, WOContext wOContext) {
        if (!this.isDisabled(wOContext)) {
            super._appendCloseTagToResponse(wOResponse, wOContext);
        }
    }

    protected void _appendQueryStringToResponse(WOResponse wOResponse, WOContext wOContext, boolean bl) {
        boolean bl2 = this._actionClass != null;
        NSDictionary nSDictionary = this.computeQueryDictionaryInContext(this._actionClass, this._directActionName, this._queryDictionary, bl2, this._otherQueryAssociations, wOContext);
        if (nSDictionary.count() > 0) {
            String string = WOURLEncoder.encodeAsCGIFormValues(nSDictionary);
            wOResponse.appendContentCharacter('?');
            if (bl) {
                wOResponse.appendContentHTMLAttributeValue(string);
            } else {
                wOResponse.appendContentString(string);
            }
        }
    }

    protected void _appendFragmentToResponse(WOResponse wOResponse, WOContext wOContext) {
        Object object;
        if (this._fragmentIdentifier != null && (object = this._fragmentIdentifier.valueInComponent(wOContext.component())) != null) {
            wOResponse.appendContentCharacter('#');
            wOResponse.appendContentString(object.toString());
        }
    }

    protected void _appendCGIActionURLToResponse(WOResponse wOResponse, WOContext wOContext, boolean bl) {
        String string = this.computeActionStringInContext(this._actionClass, this._directActionName, wOContext);
        boolean bl2 = this._actionClass != null;
        NSDictionary nSDictionary = this.computeQueryDictionaryInContext(this._actionClass, this._directActionName, this._queryDictionary, bl2, this._otherQueryAssociations, wOContext);
        NSMutableDictionary nSMutableDictionary = nSDictionary instanceof NSMutableDictionary ? (NSMutableDictionary)nSDictionary : nSDictionary.mutableClone();
        if (this._secure != null) {
            wOContext._generateCompleteURLs();
        }
        String string2 = wOContext._directActionURL(string, (NSDictionary)nSMutableDictionary, this._secure != null && this._secure.booleanValueInComponent(wOContext.component()));
        if (this._secure != null) {
            wOContext._generateRelativeURLs();
        }
        if (bl) {
            wOResponse.appendContentHTMLAttributeValue(string2);
        } else {
            wOResponse.appendContentString(string2);
        }
        this._appendFragmentToResponse(wOResponse, wOContext);
    }

    public void appendAttributesToResponse(WOResponse wOResponse, WOContext wOContext) {
        Object object = null;
        Object object2 = null;
        String string = null;
        String string2 = null;
        super.appendAttributesToResponse(wOResponse, wOContext);
        WOComponent wOComponent = wOContext.component();
        if (this._href != null) {
            object = this._href.valueInComponent(wOComponent);
        }
        if (this._actionClass != null || this._directActionName != null) {
            wOResponse.appendContentCharacter(' ');
            wOResponse._appendContentAsciiString("href");
            wOResponse.appendContentCharacter('=');
            wOResponse.appendContentCharacter('\"');
            this._appendCGIActionURLToResponse(wOResponse, wOContext, false);
            wOResponse.appendContentCharacter('\"');
        } else if (this._action != null || this._pageName != null) {
            wOResponse.appendContentCharacter(' ');
            wOResponse._appendContentAsciiString("href");
            wOResponse.appendContentCharacter('=');
            wOResponse.appendContentCharacter('\"');
            if (this._secure != null) {
                wOContext._generateCompleteURLs();
            }
            wOResponse.appendContentString(wOContext._componentActionURL(this._secure != null && this._secure.booleanValueInComponent(wOContext.component())));
            if (this._secure != null) {
                wOContext._generateRelativeURLs();
            }
            this._appendQueryStringToResponse(wOResponse, wOContext, true);
            this._appendFragmentToResponse(wOResponse, wOContext);
            wOResponse.appendContentCharacter('\"');
        } else if (object != null) {
            string2 = object.toString();
            wOResponse.appendContentCharacter(' ');
            wOResponse._appendContentAsciiString("href");
            wOResponse.appendContentCharacter('=');
            wOResponse.appendContentCharacter('\"');
            if (WOStaticURLUtilities.isRelativeURL(string2) && !WOStaticURLUtilities.isFragmentURL(string2)) {
                string = wOContext._urlForResourceNamed(string2, null, false);
                if (string != null) {
                    wOResponse.appendContentString(string);
                } else {
                    wOResponse._appendContentAsciiString(wOComponent.baseURL());
                    wOResponse.appendContentCharacter('/');
                    wOResponse.appendContentString(string2);
                }
            } else {
                wOResponse.appendContentString(string2);
            }
            this._appendQueryStringToResponse(wOResponse, wOContext, true);
            this._appendFragmentToResponse(wOResponse, wOContext);
            wOResponse.appendContentCharacter('\"');
        } else if (this._fragmentIdentifier != null && (object2 = this._fragmentIdentifier.valueInComponent(wOComponent)) != null) {
            wOResponse.appendContentCharacter(' ');
            wOResponse._appendContentAsciiString("href");
            wOResponse.appendContentCharacter('=');
            wOResponse.appendContentCharacter('\"');
            this._appendQueryStringToResponse(wOResponse, wOContext, true);
            wOResponse.appendContentCharacter('#');
            wOResponse.appendContentString(object2.toString());
            wOResponse.appendContentCharacter('\"');
        }
    }

    public void appendContentStringToResponse(WOResponse wOResponse, WOContext wOContext) {
        Object object;
        if (this._string != null && (object = this._string.valueInComponent(wOContext.component())) != null) {
            wOResponse.appendContentHTMLString(object.toString());
        }
    }

    public void appendChildrenToResponse(WOResponse wOResponse, WOContext wOContext) {
        super.appendChildrenToResponse(wOResponse, wOContext);
        this.appendContentStringToResponse(wOResponse, wOContext);
    }

    private boolean isDisabled(WOContext wOContext) {
        return this._disabled != null && this._disabled.booleanValueInComponent(wOContext.component());
    }
}

