/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.ListIterator;

public class WONoCopyPushbackInputStream
extends FilterInputStream {
    LinkedList buffers = new LinkedList();
    byte[] oneByteArray = new byte[1];
    int readMax;
    int originalReadMax;
    boolean prematureTermination = false;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public WONoCopyPushbackInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n < 0) {
            n = 0;
        }
        this.readMax = n;
        this.originalReadMax = n;
    }

    public int read() throws IOException {
        int n = this.read(this.oneByteArray);
        if (n == -1) {
            return n;
        }
        return this.oneByteArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        PushbackBuffer pushbackBuffer = null;
        ListIterator listIterator = this.buffers.listIterator(0);
        while (listIterator.hasNext() && n2 > 0) {
            pushbackBuffer = (PushbackBuffer)listIterator.next();
            int n4 = pushbackBuffer.length;
            if (n2 < n4) {
                n4 = n2;
            }
            System.arraycopy(pushbackBuffer.buf, pushbackBuffer.pos, byArray, n, n4);
            n3 += n4;
            pushbackBuffer.pos += n4;
            pushbackBuffer.length -= n4;
            n += n4;
            n2 -= n4;
            if (pushbackBuffer.length != 0) continue;
            listIterator.remove();
        }
        if (n2 > 0) {
            if (this.readMax <= 0) {
                if (n3 > 0) {
                    return n3;
                }
                return -1;
            }
            if (n2 > this.readMax) {
                n2 = this.readMax;
            }
            try {
                n2 = super.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                this.prematureTermination = true;
                throw iOException;
            }
            if (n2 == -1) {
                if (n3 == 0) {
                    if (this.readMax > 0) {
                        this.prematureTermination = true;
                        throw new IOException("Connection reset by peer: Amount read didn't match content-length");
                    }
                    return -1;
                }
                return n3;
            }
            this.readMax -= n2;
            return n3 + n2;
        }
        return n3;
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        PushbackBuffer pushbackBuffer = new PushbackBuffer(byArray, n, n2);
        this.buffers.addFirst(pushbackBuffer);
    }

    public void unread(byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    public int available() throws IOException {
        this.ensureOpen();
        int n = 0;
        ListIterator listIterator = this.buffers.listIterator(0);
        while (listIterator.hasNext()) {
            n += ((PushbackBuffer)listIterator.next()).length;
        }
        return n + super.available();
    }

    public int theoreticallyAvailable() {
        int n = 0;
        ListIterator listIterator = this.buffers.listIterator(0);
        while (listIterator.hasNext()) {
            n += ((PushbackBuffer)listIterator.next()).length;
        }
        return n + this.readMax;
    }

    public long skip(long l) throws IOException {
        long l2;
        this.ensureOpen();
        if (l <= 0L) {
            return 0L;
        }
        long l3 = 0L;
        PushbackBuffer pushbackBuffer = null;
        ListIterator listIterator = this.buffers.listIterator(0);
        while (listIterator.hasNext() && l > 0L) {
            pushbackBuffer = (PushbackBuffer)listIterator.next();
            l2 = pushbackBuffer.length;
            if (l < l2) {
                l2 = l;
            }
            l -= l2;
            l3 += l2;
            pushbackBuffer.pos = (int)((long)pushbackBuffer.pos + l2);
            pushbackBuffer.length = (int)((long)pushbackBuffer.length - l2);
            if (pushbackBuffer.length != 0) continue;
            listIterator.remove();
        }
        if (l > 0L) {
            if (l > (long)this.readMax) {
                l = this.readMax;
            }
            l2 = 0L;
            try {
                l2 = super.skip(l);
            }
            catch (IOException iOException) {
                this.prematureTermination = true;
                throw iOException;
            }
            if (l2 == -1L) {
                if (l3 == 0L) {
                    if (this.readMax > 0) {
                        this.prematureTermination = true;
                        throw new IOException("Connection reset by peer: Amount read didn't match content-length");
                    }
                } else {
                    return l3;
                }
            }
            this.readMax = (int)((long)this.readMax - l2);
            l3 += l2;
        }
        return l3;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        this.buffers = null;
    }

    public void drain() throws IOException {
        this.buffers = null;
        int n = 0;
        byte[] byArray = new byte[2048];
        for (long i = (long)this.readMax; i > 0L && (n = this.in.read(byArray)) != -1; i -= (long)n) {
        }
    }

    public int readMax() {
        return this.readMax;
    }

    public int originalReadMax() {
        return this.originalReadMax;
    }

    public boolean wasPrematurelyTerminated() {
        return this.prematureTermination;
    }

    class PushbackBuffer {
        byte[] buf;
        int pos;
        int length;

        PushbackBuffer(byte[] byArray, int n, int n2) {
            this.buf = byArray;
            this.pos = n;
            this.length = n2;
        }
    }
}

