/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver._private.WOImageHeaderScanner;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import java.io.IOException;

public class WOPNGHeaderScanner
extends WOImageHeaderScanner {
    private int mNumberOfChunks = 0;
    private PNGChunk[] mChunks = new PNGChunk[10];

    public void scan() throws IOException {
        this._readSignature();
        this._readChunks();
        this._parseIHDRChunk();
    }

    private void _readSignature() throws IOException {
        long l = this.inputStream.readLong();
        if (l != -8552249625308161526L) {
            throw new IOException("PNG signature not found!");
        }
    }

    private void _parseIHDRChunk() {
        PNGChunk pNGChunk = this._getChunk("IHDR");
        if (pNGChunk != null) {
            this.width = pNGChunk.getInt4(0);
            this.height = pNGChunk.getInt4(4);
        } else {
            NSLog.err.appendln((Object)"<WOPNGheaderScanner>:Couldn't find a header chunk for the image.");
        }
    }

    private void _readChunks() throws IOException {
        boolean bl = true;
        try {
            PNGChunk pNGChunk;
            do {
                pNGChunk = this._readChunk();
                this._addChunk(pNGChunk);
            } while (!pNGChunk.getTypeString().equals("IEND") && !pNGChunk.getTypeString().equals("IHDR"));
        }
        catch (Exception exception) {
            throw new NSForwardException((Throwable)exception, "I/O reading image file");
        }
    }

    private PNGChunk _readChunk() throws IOException {
        int n = this.inputStream.readInt();
        int n2 = this.inputStream.readInt();
        byte[] byArray = new byte[n];
        this.inputStream.readFully(byArray);
        int n3 = this.inputStream.readInt();
        return new PNGChunk(n, n2, byArray, n3);
    }

    private void _addChunk(PNGChunk pNGChunk) {
        this.mChunks[this.mNumberOfChunks++] = pNGChunk;
        if (this.mNumberOfChunks >= this.mChunks.length) {
            PNGChunk[] pNGChunkArray = new PNGChunk[this.mChunks.length + 10];
            System.arraycopy(this.mChunks, 0, pNGChunkArray, 0, this.mChunks.length);
            this.mChunks = pNGChunkArray;
        }
    }

    private PNGChunk _getChunk(String string) {
        for (int i = 0; i < this.mNumberOfChunks; ++i) {
            if (!this.mChunks[i].getTypeString().equals(string)) continue;
            return this.mChunks[i];
        }
        return null;
    }

    class PNGChunk {
        int length;
        int type;
        byte[] data;
        int crc;
        String typeString;

        public PNGChunk(int n, int n2, byte[] byArray, int n3) {
            this.length = n;
            this.type = n2;
            this.data = byArray;
            this.crc = n3;
            char[] cArray = new char[]{(char)(this.type >> 24), (char)(this.type >> 16 & 0xFF), (char)(this.type >> 8 & 0xFF), (char)(this.type & 0xFF)};
            this.typeString = new String(cArray);
        }

        public int getLength() {
            return this.length;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeString() {
            return this.typeString;
        }

        public byte[] getData() {
            return this.data;
        }

        public byte getByte(int n) {
            return this.data[n];
        }

        public int getInt1(int n) {
            return this.data[n] & 0xFF;
        }

        public int getInt2(int n) {
            return (this.data[n] & 0xFF) << 8 | this.data[n + 1] & 0xFF;
        }

        public int getInt4(int n) {
            return (this.data[n] & 0xFF) << 24 | (this.data[n + 1] & 0xFF) << 16 | (this.data[n + 2] & 0xFF) << 8 | this.data[n + 3] & 0xFF;
        }

        public String getString4(int n) {
            char[] cArray = new char[]{(char)this.data[n], (char)this.data[n + 1], (char)this.data[n + 2], (char)this.data[n + 3]};
            String string = new String(cArray);
            return string;
        }

        public boolean isType(String string) {
            return this.typeString.equals(string);
        }
    }
}

