/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver._private.WOGeometricRegion;
import com.webobjects.appserver._private.WOPoint;
import com.webobjects.foundation.NSMutableArray;

public class WOPolygonRegion
extends WOGeometricRegion {
    int _size;
    private int _maxIndex;
    double[] _slopes;
    double[] _intercepts;
    int[][] _points;
    private WOPoint _topLeft;
    private WOPoint _bottomRight;
    private static final int MAXVERTS = 100;
    private static final int X = 0;
    private static final int Y = 1;

    public WOPolygonRegion(String string, NSMutableArray nSMutableArray, String string2) {
        super(string, nSMutableArray, string2);
        int n;
        if (null == nSMutableArray) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + ">: The coordinates received are in an invalid state. There might be a problem with the imagemap file.");
        }
        this._size = nSMutableArray.count();
        if (this._size > 100 || this._size < 3) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + ">: Expected at least three and at most " + 100 + " coordinates for defining the polygon region. Received " + this._size);
        }
        this._topLeft = new WOPoint((String)nSMutableArray.objectAtIndex(0));
        this._bottomRight = new WOPoint((String)nSMutableArray.objectAtIndex(0));
        this._maxIndex = this._size - 1;
        this._points = new int[this._size][2];
        this._slopes = new double[this._size];
        this._intercepts = new double[this._size];
        for (n = 0; n < this._size; ++n) {
            WOPoint wOPoint = new WOPoint((String)nSMutableArray.objectAtIndex(n));
            this._points[n][0] = wOPoint.x;
            this._points[n][1] = wOPoint.y;
            if (wOPoint.x < this._topLeft.x) {
                this._topLeft.x = wOPoint.x;
            } else if (wOPoint.x > this._bottomRight.x) {
                this._bottomRight.x = wOPoint.x;
            }
            if (wOPoint.y < this._topLeft.y) {
                this._topLeft.y = wOPoint.y;
                continue;
            }
            if (wOPoint.y <= this._bottomRight.y) continue;
            this._bottomRight.y = wOPoint.y;
        }
        for (n = 0; n < this._size; ++n) {
            this._slopes[n] = (float)(this._points[(n + 1) % this._size][1] - this._points[n][1]) / (float)(this._points[(n + 1) % this._size][0] - this._points[n][0]);
            if (Double.isNaN(this._slopes[n])) {
                this._slopes[n] = Double.POSITIVE_INFINITY;
            }
            this._intercepts[n] = Double.isInfinite(this._slopes[n]) ? Double.NaN : (double)this._points[n][1] - this._slopes[n] * (double)this._points[n][0];
        }
    }

    public boolean hitTest(int n, int n2) {
        int n3;
        if (n < this._topLeft.x || n > this._bottomRight.x || n2 < this._topLeft.y || n2 > this._bottomRight.y) {
            return false;
        }
        for (n3 = 0; n3 < this._size; ++n3) {
            if (this._points[n3][0] != n || this._points[n3][1] != n2) continue;
            return true;
        }
        n3 = 0;
        boolean[] blArray = new boolean[this._size];
        for (int i = 0; i < this._size; ++i) {
            if (n == this._points[i][0] || n == this._points[(i + 1) % this._size][0]) {
                blArray[i] = true;
                continue;
            }
            if (n > this._points[i][0] && n < this._points[(i + 1) % this._size][0] || n < this._points[i][0] && n > this._points[(i + 1) % this._size][0]) {
                blArray[i] = true;
                continue;
            }
            if ((n <= this._points[i][0] || n <= this._points[(i + 1) % this._size][0]) && (n >= this._points[i][0] || n >= this._points[(i + 1) % this._size][0])) continue;
            blArray[i] = false;
        }
        double d = 0.0;
        boolean bl = false;
        for (int i = 0; i < this._size; ++i) {
            if (!blArray[i]) continue;
            if (n != this._points[i][0] && n != this._points[(i + 1) % this._size][0]) {
                d = this._slopes[i] * (double)n + this._intercepts[i];
                if (Math.abs((double)n2 - d) < 0.5) {
                    return true;
                }
                if (!(-1.0 < d) || !(d < (double)n2)) continue;
                ++n3;
                continue;
            }
            if (n == this._points[i][0] && 0 == i) {
                int n4;
                for (n4 = this._maxIndex; n4 > 0 && n == this._points[n4][0]; --n4) {
                    blArray[n4] = false;
                }
                bl = this._points[n4][0] < n;
                int n5 = n4;
                do {
                    if (Double.isInfinite(this._slopes[n4]) && (this._points[n4][1] < n2 && this._points[(n4 + 1) % this._size][1] > n2 || this._points[n4][1] > n2 && this._points[(n4 + 1) % this._size][1] < n2)) {
                        return true;
                    }
                    if ((n4 = (n4 + 1) % this._size) != n5) continue;
                    return false;
                } while (n == this._points[(n4 + 1) % this._size][0]);
                if (this._points[n4][1] < n2 && (bl && this._points[(n4 + 1) % this._size][0] > n || !bl && this._points[(n4 + 1) % this._size][0] < n)) {
                    ++n3;
                }
                i = n4;
                continue;
            }
            if (n != this._points[(i + 1) % this._size][0]) continue;
            boolean bl2 = bl = this._points[i][0] < n;
            while (this._maxIndex > i && n == this._points[(i + 1) % this._size][0]) {
                if (Double.isInfinite(this._slopes[i]) && (this._points[i][1] < n2 && this._points[(i + 1) % this._size][1] > n2 || this._points[i][1] > n2 && this._points[(i + 1) % this._size][1] < n2)) {
                    return true;
                }
                ++i;
            }
            if (this._points[i][1] >= n2 || (!bl || this._points[(i + 1) % this._size][0] <= n) && (bl || this._points[(i + 1) % this._size][0] >= n)) continue;
            ++n3;
        }
        return 1 == n3 % 2;
    }

    protected String _subclassDescription() {
        return "[polygonal region number of points=" + this._size + "]";
    }
}

