/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODefaultAdaptor;
import com.webobjects.appserver._private.WOHttpIO;
import com.webobjects.foundation.NSDelayedCallbackCenter;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLException;

public class WOWorkerThread
implements Runnable {
    private static String _requestIdKey = "x-webobjects-request-id";
    private int _selfId;
    private WOApplication _app;
    private WODefaultAdaptor _mtAdaptor;
    private ServerSocket _serverSocket;
    private Socket _currentSocket;
    private int _maxSocketIdleTime;
    private WOHttpIO _httpio;
    private boolean _errorOnRead = false;
    private boolean _dispatchError = false;
    private Thread t;
    volatile boolean _runFlag = true;
    volatile boolean _processingRequest = false;
    private static long _WO_requestWindow = WOApplication.licensedRequestWindow();
    private static int _WO_requestLimit = 0;
    private static boolean _restricted = false;
    private static long _expTime;
    private static int _reqCount;
    private static Object _licenseLock;
    private static boolean _logOnce;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOWorkerThread(WODefaultAdaptor wODefaultAdaptor, ServerSocket serverSocket, int n, boolean bl, int n2) {
        this._selfId = n2;
        this._app = WOApplication.application();
        this._mtAdaptor = wODefaultAdaptor;
        this._serverSocket = serverSocket;
        this._maxSocketIdleTime = n;
        this._httpio = new WOHttpIO();
        _restricted = bl;
        if (_restricted) {
            _WO_requestLimit = WOApplication.licensedRequestLimit();
            Object object = _licenseLock;
            synchronized (object) {
                _expTime = System.currentTimeMillis() + _WO_requestWindow;
                _reqCount = _WO_requestLimit;
            }
        }
        this.t = new Thread((Runnable)this, "WorkerThread" + this._selfId);
        this.t.start();
    }

    public int id() {
        return this._selfId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnce() {
        boolean bl;
        WOResponse wOResponse;
        WORequest wORequest;
        block43: {
            wORequest = null;
            wOResponse = null;
            bl = false;
            if (!this._runFlag) {
                return;
            }
            if (this._currentSocket == null) {
                return;
            }
            this._errorOnRead = false;
            try {
                this._currentSocket.setSoTimeout(this._maxSocketIdleTime);
                wORequest = this._httpio.readRequestFromSocket(this._currentSocket);
            }
            catch (SSLException sSLException) {
                this._errorOnRead = true;
                NSLog.err.appendln((Object)(this.toString() + " SSL connection closed: " + sSLException + "; dropping connection"));
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8196L)) {
                    NSLog.debug.appendln((Throwable)sSLException);
                }
            }
            catch (SocketException socketException) {
                this._errorOnRead = true;
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8208L)) {
                    NSLog.debug.appendln((Object)(this.toString() + " Persistent connection dropped (exception ignored): " + socketException));
                }
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)8208L)) {
                    NSLog.debug.appendln((Throwable)socketException);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                this._errorOnRead = true;
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8208L)) {
                    NSLog.debug.appendln((Object)(this.toString() + " Timed-out reading from socket (exception ignored): " + interruptedIOException + "; dropping connection"));
                }
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)8208L)) {
                    NSLog.debug.appendln((Throwable)interruptedIOException);
                }
            }
            catch (IOException iOException) {
                this._errorOnRead = true;
                NSLog.err.appendln((Object)(this.toString() + " Exception while reading request: " + iOException + "; dropping connection"));
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8196L)) {
                    NSLog.debug.appendln((Throwable)iOException);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._errorOnRead = true;
                NSLog.err.appendln((Object)(this.toString() + " Exception while creating request: " + illegalArgumentException + "; dropping connection"));
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8196L)) break block43;
                NSLog.debug.appendln((Throwable)illegalArgumentException);
            }
        }
        if (this._errorOnRead || wORequest == null || !this._runFlag || !WOApplication.application().isDirectConnectEnabled() && !wORequest.isUsingWebServer() && !"womp".equals(wORequest.requestHandlerKey())) {
            this._closeSocket();
            return;
        }
        try {
            String string;
            if (_restricted) {
                string = wORequest.requestHandlerKey();
                if (!this._app.resourceRequestHandlerKey().equals(string)) {
                    String string2;
                    String string3 = string2 = WOApplication._checksForSpecialHeaders() ? wORequest.headerForKey("content-type") : null;
                    if (string2 == null || !string2.equals("x-eojavaclient-unlimited")) {
                        Object object = _licenseLock;
                        synchronized (object) {
                            if (--_reqCount == 0) {
                                long l;
                                block44: {
                                    l = System.currentTimeMillis();
                                    long l2 = _expTime - l;
                                    if (l2 > 0L) {
                                        if (_logOnce) {
                                            _logOnce = false;
                                            NSLog.err.appendln((Object)("Exceeded license request limit - request processing temporarily stalled. RequestLimit = " + _WO_requestLimit + " TPM]. This message appears only once."));
                                        }
                                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)20L)) {
                                            NSLog.debug.appendln((Object)("MTA: Worker Object[" + this._selfId + "]: request limit hit: stalling"));
                                        }
                                        try {
                                            Thread.sleep(l2);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8212L)) break block44;
                                            NSLog.debug.appendln((Object)(this.toString() + " InterruptedException occurred while sleeping. "));
                                        }
                                    }
                                }
                                _expTime = l + _WO_requestWindow;
                                _reqCount = _WO_requestLimit;
                            }
                        }
                    }
                }
            }
            this._processingRequest = true;
            this._dispatchError = false;
            try {
                wOResponse = this._app.dispatchRequest(wORequest);
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)(this.toString() + " Exception occurred while responding to client: " + exception.toString()));
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8212L)) {
                    NSLog.debug.appendln((Throwable)exception);
                }
                this._dispatchError = true;
                wOResponse = WODefaultAdaptor._lastDitchErrorResponse;
            }
            NSDelayedCallbackCenter.defaultCenter().eventEnded();
            if (wOResponse != null) {
                string = wORequest.headerForKey(_requestIdKey);
                if (string != null) {
                    wOResponse.setHeader(string, _requestIdKey);
                }
                try {
                    bl = this._httpio.sendResponse(wOResponse, this._currentSocket, wORequest);
                }
                catch (IOException iOException) {
                    NSLog.err.appendln((Object)(this.toString() + " Exception while sending response: " + iOException));
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8208L)) {
                        NSLog.debug.appendln((Throwable)iOException);
                    }
                    this._closeSocket();
                }
            } else {
                this._closeSocket();
            }
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)(this.toString() + " Exception occurred while responding to client: " + exception.toString()));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8212L)) {
                NSLog.debug.appendln((Throwable)exception);
            }
            this._closeSocket();
        }
        finally {
            this._processingRequest = false;
        }
        if (!bl || this._dispatchError) {
            this._closeSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _closeSocket() {
        if (this._currentSocket != null) {
            try {
                this._currentSocket.close();
            }
            catch (IOException iOException) {
                NSLog.err.appendln((Object)(this.toString() + " Exception occurred " + iOException.toString() + " while closing current client socket."));
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8196L)) {
                    NSLog.debug.appendln((Throwable)iOException);
                }
            }
            finally {
                this._currentSocket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {}
            catch (Throwable throwable) {
                NSLog.err.appendln((Object)(this.toString() + " Throwable occurred: " + throwable.toString()));
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)8212L)) throw NSForwardException._runtimeExceptionForThrowable((Throwable)throwable);
                NSLog.debug.appendln(throwable);
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)throwable);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this._closeSocket();
            this.t = null;
            if (!this._runFlag) throw throwable;
            if (this._serverSocket == null) throw throwable;
            int n2 = this._selfId + 10000;
            NSLog.err.appendln((Object)(this.toString() + " Workerthread exiting due to error, respawning with ID " + n2 + "..."));
            this._selfId = n2;
            this.t = new Thread((Runnable)this, "WorkerThread" + this._selfId);
            this.t.start();
            throw throwable;
        }
        while (this._runFlag && this._serverSocket != null) {
            if (this._currentSocket == null) {
                try {
                    this._currentSocket = this._serverSocket.accept();
                    if (this._currentSocket != null) {
                        this._currentSocket.setTcpNoDelay(true);
                    }
                }
                catch (IOException iOException) {
                    NSLog.err.appendln((Object)(this.toString() + " IOException occurred while accepting server socket: " + iOException.toString()));
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)8212L)) {
                        NSLog.debug.appendln((Throwable)iOException);
                    }
                    this._closeSocket();
                }
            }
            this._mtAdaptor.incrementActiveThreads();
            try {
                while (this._runFlag && this._currentSocket != null) {
                    this.runOnce();
                }
            }
            finally {
                this._mtAdaptor.decrementActiveThreads();
                this._closeSocket();
            }
        }
        Object var4_4 = null;
        this._closeSocket();
        this.t = null;
        if (!this._runFlag) return;
        if (this._serverSocket == null) return;
        int n = this._selfId + 10000;
        NSLog.err.appendln((Object)(this.toString() + " Workerthread exiting due to error, respawning with ID " + n + "..."));
        this._selfId = n;
        this.t = new Thread((Runnable)this, "WorkerThread" + this._selfId);
        this.t.start();
    }

    public String toString() {
        return "<WOWorkerThread id=" + this._selfId + " socket=" + this._currentSocket + ">";
    }

    static {
        _licenseLock = new Object();
        _logOnce = true;
    }
}

