/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EODetailDataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol._EOCheapCopyMutableArray;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class EOArrayDataSource
extends EODataSource
implements Serializable {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOArrayDataSource");
    private NSMutableArray _objects = new NSMutableArray();
    private EOEditingContext _context;
    private EOClassDescription _classDescription;
    static final long serialVersionUID = -6181620478668683931L;
    private static final String ObjectsFieldKey = "objects";
    private static final String ContextFieldKey = "editingContext";
    private static final String EntityNameFieldKey = "entityName";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("objects", NSMutableArray._CLASS), new ObjectStreamField("editingContext", EOEditingContext._CLASS), new ObjectStreamField("entityName", _NSUtilities._StringClass)};

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put(ObjectsFieldKey, this._objects);
        fields.put(ContextFieldKey, this._context);
        if (this._classDescription != null) {
            fields.put(EntityNameFieldKey, this._classDescription.entityName());
        }
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this._objects = (NSMutableArray)fields.get(ObjectsFieldKey, null);
        this._objects = this._objects == null ? new NSMutableArray(0) : this._objects;
        this._context = (EOEditingContext)fields.get(ContextFieldKey, null);
        String entityName = (String)fields.get(EntityNameFieldKey, null);
        this._classDescription = entityName == null || entityName.length() < 1 ? null : EOClassDescription.classDescriptionForEntityName(entityName);
    }

    public EOArrayDataSource(EOClassDescription desc, EOEditingContext ec) {
        this._classDescription = desc;
        this._context = ec;
    }

    public void setArray(NSArray array) {
        this._objects = new _EOCheapCopyMutableArray(array);
    }

    public Object createObject() {
        Object eo = super.createObject();
        if (eo != null) {
            this._objects.addObject(eo);
        }
        return eo;
    }

    public void insertObject(Object eo) {
        this._objects.addObject(eo);
    }

    public void deleteObject(Object eo) {
        this._objects.removeObject(eo);
    }

    public NSArray fetchObjects() {
        return this._objects.immutableClone();
    }

    void setEditingContext(EOEditingContext editingContext) {
        this._context = editingContext;
    }

    public EOEditingContext editingContext() {
        return this._context;
    }

    public void qualifyWithRelationshipKey(String key, Object source) {
    }

    public EODataSource dataSourceQualifiedByKey(String key) {
        return new EODetailDataSource(this, key);
    }

    public EOClassDescription classDescriptionForObjects() {
        return this._classDescription;
    }
}

