/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOAccountEvent;
import com.webobjects.eocontrol.EOAggregateEvent;
import com.webobjects.eocontrol.EOEventCenter;
import com.webobjects.eocontrol._EOEventDurationComparator;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URL;

public class EOEvent
implements Serializable {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOEvent");
    static final long serialVersionUID = 2883722137277310801L;
    private static final String SerializationInfoFieldKey = "info";
    private static final String SerializationTypeFieldKey = "type";
    private static final String SerializationCallStackFieldKey = "callStack";
    private static final String SerializationEncounteredFieldKey = "encountered";
    private static final String SerializationDurationFieldKey = "duration";
    private static final String SerializationParentFieldKey = "parent";
    private static final String SerializationChildFieldKey = "child";
    private static final String SerializationNextFieldKey = "next";
    private static final Class _EOEventClass = new EOEvent().getClass();
    protected Object _info = null;
    protected String _type = null;
    protected NSArray _callStack;
    protected long _encountered;
    protected long _duration = 0L;
    protected EOEvent _parent;
    protected EOEvent _child;
    protected EOEvent _next;
    public static final int BasicEventSignature = 0;
    public static final String EventGroupName = "EOEventGroupName";
    static final NSMutableDictionary descs = new NSMutableDictionary(32);
    static final _EOEventDurationComparator AscendingDurationComparator = new _EOEventDurationComparator();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("info", _NSUtilities._ObjectClass), new ObjectStreamField("type", _NSUtilities._StringClass), new ObjectStreamField("callStack", NSArray.EmptyArray.getClass()), new ObjectStreamField("encountered", Long.TYPE), new ObjectStreamField("duration", Long.TYPE), new ObjectStreamField("parent", _EOEventClass), new ObjectStreamField("child", _EOEventClass), new ObjectStreamField("next", _EOEventClass)};

    protected static String _descriptionFileName(String aName) {
        NSArray className = NSArray.componentsSeparatedByString((String)aName, (String)".");
        String name = className.lastObject().toString();
        NSArray noInnerClassName = NSArray.componentsSeparatedByString((String)name, (String)"$");
        return noInnerClassName.objectAtIndex(0).toString() + "Event.description";
    }

    public static NSDictionary eventTypeDescriptions(Class aClass) {
        String name = aClass.getName();
        NSDictionary dict = (NSDictionary)descs.objectForKey((Object)name);
        if (dict != null) {
            return dict;
        }
        try {
            String fname = EOEvent._descriptionFileName(name);
            URL url = _NSUtilities._pathURLForResourceWithName((Class)aClass, (String)fname, null);
            dict = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)_NSStringUtilities.stringFromPathURL((URL)url));
        }
        catch (Exception e) {
            NSLog._conditionallyLogPrivateException((Throwable)e);
            dict = null;
        }
        if (dict == null) {
            dict = new NSDictionary((Object)name, (Object)EventGroupName);
        }
        descs.setObjectForKey((Object)dict, (Object)name);
        return dict;
    }

    protected static String _eventDescriptionForEventType(Class aClass, String type) {
        NSDictionary descs = EOEvent.eventTypeDescriptions(aClass);
        String ret = (String)descs.objectForKey((Object)type);
        if (ret == null) {
            return aClass.getName();
        }
        return ret;
    }

    public String title() {
        return EOEvent._eventDescriptionForEventType(this.getClass(), this.type());
    }

    public void setInfo(Object info) {
        this._info = info;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String signatureOfType(int tag) {
        switch (tag) {
            case 0: {
                return this.title() + "-" + this.comment();
            }
        }
        return null;
    }

    public void markStartWithInfo(Object info) {
        this.setInfo(info);
        this._encountered = EOEventCenter._time();
        this._duration = -2L;
    }

    public void markAtomicWithInfo(Object info) {
        this.markStartWithInfo(info);
        this._duration = -1L;
    }

    public void markEnd() {
    }

    public EOEvent parentEvent() {
        return this._parent;
    }

    public String type() {
        return this._type;
    }

    public Object info() {
        return this._info;
    }

    public String toString() {
        if (!EOEvent.isAtomic(this._duration)) {
            return this.getClass().getName() + " " + this.title() + " - " + this.comment() + ", duration " + this.duration() + "ms";
        }
        return this.getClass().getName() + " " + this.title() + " - " + this.comment() + " at " + this.startDate();
    }

    public String description() {
        return this.toString();
    }

    public static String classDescription(Class aClass) {
        return EOEvent._eventDescriptionForEventType(aClass, EventGroupName);
    }

    public NSTimestamp startDate() {
        return new NSTimestamp(this._encountered);
    }

    public long duration() {
        long duration = this._preciseDuration();
        if (EOEvent.isClosedBranch(duration)) {
            return duration;
        }
        return 0L;
    }

    public long durationWithoutSubevents() {
        long duration = this._preciseDurationWithoutSubevents();
        if (EOEvent.isClosedBranch(duration)) {
            return duration;
        }
        return 0L;
    }

    public NSArray subevents() {
        NSMutableArray result = new NSMutableArray();
        EOEvent n = this._child;
        while (n != null) {
            result.addObject((Object)n);
            n = n._next;
        }
        return result;
    }

    public String comment() {
        return this._info != null ? this._info.toString() : "";
    }

    public String displayComponentName() {
        return "WOEventRow";
    }

    public static NSArray groupEvents(NSArray events, int tag) {
        return EOEvent._aggregatedEvents(events, tag, EOAccountEvent._CLASS);
    }

    public static NSArray aggregateEvents(NSArray events, int tag) {
        return EOEvent._aggregatedEvents(events, tag, EOAggregateEvent._CLASS);
    }

    protected final void _appendEvent(EOEvent event) {
        if (EOEvent.isOpenBranch(this._duration)) {
            event._parent = this;
            this._child = event;
        } else {
            EOEvent parent = this._parent;
            EOEvent child = this;
            while (parent != null && EOEvent.isClosedBranch(parent._duration)) {
                child = parent;
                parent = parent._parent;
            }
            event._parent = parent;
            child._next = event;
        }
    }

    protected final EOEvent _cancelEvent(EOEvent event) {
        if (this._child == event) {
            this._child = null;
            return this;
        }
        EOEvent next = this._child;
        EOEvent last = null;
        while (next != null) {
            if (next._next == event) {
                next._next = null;
                last = next;
                break;
            }
            next = next._next;
        }
        return last;
    }

    private final void _deepDescriptionsWithPrefix(String prefix, String unit, NSMutableArray all) {
        all.addObject((Object)(prefix + this.toString()));
        if (!EOEvent.isAtomic(this._duration)) {
            EOEvent next = this._child;
            String doublePrefix = prefix + unit;
            while (next != null) {
                next._deepDescriptionsWithPrefix(doublePrefix, unit, all);
                next = next._next;
            }
        }
    }

    private String _deepDescription() {
        StringBuffer all = new StringBuffer();
        NSMutableArray kids = new NSMutableArray();
        this._deepDescriptionsWithPrefix("", "    ", kids);
        int n = kids.count();
        for (int i = 0; i < n; ++i) {
            all.append((String)kids.objectAtIndex(i));
            all.append('\n');
        }
        return new String(all);
    }

    public long _preciseDuration() {
        return this._duration;
    }

    public long _preciseDurationWithoutSubevents() {
        long duration = this._preciseDuration();
        if (!EOEvent.isClosedBranch(this._duration)) {
            return this._duration;
        }
        EOEvent next = this._child;
        while (next != null) {
            duration -= next._preciseDuration();
            next = next._next;
        }
        return duration;
    }

    private static NSArray _aggregatedEvents(NSArray events, int query, Class c) {
        if (query < 0) {
            return events;
        }
        int n = events.count();
        NSMutableDictionary eventMap = new NSMutableDictionary(n);
        for (int i = 0; i < n; ++i) {
            EOEvent e = (EOEvent)events.objectAtIndex(i);
            String signature = e.signatureOfType(query);
            if (signature == null) continue;
            EOAggregateEvent aggregate = (EOAggregateEvent)eventMap.objectForKey((Object)signature);
            if (aggregate == null) {
                try {
                    aggregate = (EOAggregateEvent)c.newInstance();
                }
                catch (Exception exc) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)exc);
                }
                eventMap.setObjectForKey((Object)aggregate, (Object)signature);
                aggregate._setAggregateTag(query);
            }
            aggregate.addEvent(e);
        }
        NSMutableArray result = new NSMutableArray(eventMap.allValues());
        try {
            result.sortUsingComparator((NSComparator)AscendingDurationComparator);
        }
        catch (NSComparator.ComparisonException exc) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exc);
        }
        return result;
    }

    private static NSArray _aggregateArrayOfEvents(NSArray events, int tag) {
        return EOEvent._aggregatedEvents(events, tag, EOAggregateEvent._CLASS);
    }

    public int _compareDuration(EOEvent other) {
        long durOther;
        long durThis = this.duration();
        if (durThis == (durOther = other.duration())) {
            return 0;
        }
        return durThis < durOther ? -1 : 1;
    }

    protected final void _markEndWithLastEvent(EOEvent last) {
        this.markEnd();
        EOEvent cutoff = !EOEvent.isOpenBranch(this._duration) ? this._parent : this;
        long timeCache = EOEventCenter._time();
        while (last != null && last != cutoff) {
            if (EOEvent.isOpenBranch(last._duration)) {
                last._duration = timeCache - last._encountered;
            }
            last = last._parent;
        }
        if (cutoff != null) {
            cutoff._duration = timeCache - cutoff._encountered;
        }
    }

    protected EOEvent _nextEvent() {
        return this._next;
    }

    protected EOEvent _childEvent() {
        return this._child;
    }

    protected void _setNextEvent(EOEvent next) {
        this._next = next;
    }

    static boolean isAtomic(long duration) {
        return duration == -1L;
    }

    static boolean isOpenBranch(long duration) {
        return duration == -2L;
    }

    static boolean isClosedBranch(long duration) {
        return duration >= 0L;
    }

    private void _subeventsOfClass(Class c, String type, NSMutableArray result) {
        if (!(type != null && type != this._type || c != null && !this.getClass().equals(c))) {
            result.addObject((Object)this);
        }
        if (!EOEvent.isAtomic(this._duration)) {
            EOEvent next = this._child;
            while (next != null) {
                next._subeventsOfClass(c, type, result);
                next = next._next;
            }
        }
    }

    protected NSArray _nestedEventsOfClass(Class c, String type) {
        NSMutableArray all = new NSMutableArray();
        this._subeventsOfClass(c, type, all);
        return all;
    }

    public int compare(EOEvent other) {
        long durOther;
        long durThis = this.duration();
        if (durThis == (durOther = other.duration())) {
            return 0;
        }
        return durThis < durOther ? -1 : 1;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationInfoFieldKey, this._info);
        fields.put(SerializationTypeFieldKey, this._type);
        fields.put(SerializationCallStackFieldKey, this._callStack);
        fields.put(SerializationEncounteredFieldKey, this._encountered);
        fields.put(SerializationDurationFieldKey, this._duration);
        fields.put(SerializationParentFieldKey, this._parent);
        fields.put(SerializationChildFieldKey, this._child);
        fields.put(SerializationNextFieldKey, this._next);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        this._info = fields.get(SerializationInfoFieldKey, null);
        this._type = (String)fields.get(SerializationTypeFieldKey, null);
        this._callStack = (NSArray)fields.get(SerializationCallStackFieldKey, null);
        this._encountered = fields.get(SerializationEncounteredFieldKey, 0);
        this._duration = fields.get(SerializationDurationFieldKey, 0);
        this._parent = (EOEvent)fields.get(SerializationParentFieldKey, null);
        this._child = (EOEvent)fields.get(SerializationChildFieldKey, null);
        this._next = (EOEvent)fields.get(SerializationNextFieldKey, null);
    }
}

