/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSNumberFormatter;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.woextensions._WOJExtensionsUtil;
import java.text.ParseException;

public class WOAnyField
extends WOComponent {
    protected static final String DEFAULT_DATE_FORMAT = "YYYY/MM/DD";
    protected static final String DEFAULT_NUMBER_FORMAT = "0";
    private String _relationshipKey;
    private String _selectedKey;
    private String _selectedOperator;
    private Object _value;
    private String _textFieldValue;
    private WODisplayGroup _displayGroup;
    public String selectedKeyItem;
    public String selectedOperatorItem;

    public WOAnyField(WOContext aContext) {
        super(aContext);
    }

    public String selectedOperatorItem() {
        return this.selectedOperatorItem;
    }

    public void setSelectedOperatorItem(String aSelectedOperatorItem) {
        this.selectedOperatorItem = aSelectedOperatorItem;
    }

    public String selectedKeyItem() {
        return this.selectedKeyItem;
    }

    public void setSelectedKeyItem(String aSelectedKeyItem) {
        this.setValueForBinding(aSelectedKeyItem, "key");
        this.selectedKeyItem = aSelectedKeyItem;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public boolean isStateless() {
        return true;
    }

    public String relationshipKey() {
        if (this._relationshipKey == null) {
            this._relationshipKey = (String)_WOJExtensionsUtil.valueForBindingOrNull("relationshipKey", this);
        }
        return this._relationshipKey;
    }

    public String selectedKey() {
        if (this._selectedKey == null) {
            this._selectedKey = (String)_WOJExtensionsUtil.valueForBindingOrNull("selectedKey", this);
        }
        return this._selectedKey;
    }

    public void setSelectedKey(String key) {
        this._selectedKey = key;
    }

    public String valueClassNameForKey(String key) {
        String entityName = (String)_WOJExtensionsUtil.valueForBindingOrNull("sourceEntityName", this);
        EOModelGroup modelGroup = EOModelGroup.defaultGroup();
        EOEntity entity = modelGroup.entityNamed(entityName);
        EOAttribute selectedAttribute = null;
        if (this.relationshipKey() != null && entity.relationshipNamed(this.relationshipKey()) != null) {
            EORelationship relationship = entity.relationshipNamed(this.relationshipKey());
            EOEntity destinationEntity = relationship.destinationEntity();
            selectedAttribute = destinationEntity.attributeNamed(key);
        } else {
            selectedAttribute = entity.attributeNamed(key);
        }
        return selectedAttribute.className();
    }

    public String formatterForKey(String key) {
        String formatter = null;
        if (this.hasBinding("formatter")) {
            this.setValueForBinding(key, "key");
            formatter = (String)_WOJExtensionsUtil.valueForBindingOrNull("formatter", this);
        }
        if (formatter == null) {
            String className = this.valueClassNameForKey(key);
            if (className.equals("com.webobjects.foundation.NSTimestamp")) {
                formatter = DEFAULT_DATE_FORMAT;
            } else if (className.equals("java.lang.Number") || className.equals("java.math.BigDecimal")) {
                formatter = DEFAULT_NUMBER_FORMAT;
            }
        }
        return formatter;
    }

    public WODisplayGroup displayGroup() {
        if (this._displayGroup == null) {
            this._displayGroup = (WODisplayGroup)_WOJExtensionsUtil.valueForBindingOrNull("displayGroup", this);
        }
        return this._displayGroup;
    }

    public String selectedOperator() {
        return this._selectedOperator;
    }

    public void setSelectedOperator(String anOperator) {
        this._selectedOperator = anOperator.equals("=") ? "" : anOperator;
    }

    public Object value() {
        if (this._value == null) {
            this._value = _WOJExtensionsUtil.valueForBindingOrNull("value", this);
        }
        return this._value;
    }

    public void setValue(Object newValue) {
        this._value = newValue;
        WODisplayGroup displayGroup = this.displayGroup();
        if (displayGroup != null) {
            displayGroup.queryMatch().removeAllObjects();
            if (this.relationshipKey() != null) {
                displayGroup.queryMatch().takeValueForKey(newValue, this.relationshipKey() + "." + this.selectedKey());
                if (newValue != null) {
                    displayGroup.queryOperator().takeValueForKey((Object)this.selectedOperator(), this.relationshipKey() + "." + this.selectedKey());
                }
            } else {
                displayGroup.queryMatch().takeValueForKey(newValue, this.selectedKey());
                if (newValue != null) {
                    displayGroup.queryOperator().takeValueForKey((Object)this.selectedOperator(), this.selectedKey());
                }
            }
        }
    }

    public String textFieldValue() {
        if (this._textFieldValue != null) {
            return this._textFieldValue;
        }
        Object value = this.value();
        this.setValue(value);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        NSTimestampFormatter formatter = null;
        String className = this.valueClassNameForKey(this.selectedKey());
        if (className.equals("com.webobjects.foundation.NSTimestamp")) {
            String dateFormatterString = this.formatterForKey(this.selectedKey());
            formatter = new NSTimestampFormatter(dateFormatterString);
        } else if (className.equals("java.lang.Number") || className.equals("java.math.BigDecimal")) {
            String numberFormatterString = this.formatterForKey(this.selectedKey());
            formatter = new NSNumberFormatter(numberFormatterString);
        }
        return formatter != null ? formatter.format(value) : value.toString();
    }

    public void setTextFieldValue(String value) {
        String className = this.valueClassNameForKey(this.selectedKey());
        if (className.equals("com.webobjects.foundation.NSTimestamp")) {
            Object objectValue;
            block8: {
                String dateFormatterString = this.formatterForKey(this.selectedKey());
                NSTimestampFormatter dateFormatter = new NSTimestampFormatter(dateFormatterString);
                objectValue = null;
                try {
                    objectValue = dateFormatter.parseObject(value != null ? value.toString() : "");
                }
                catch (ParseException e) {
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) break block8;
                    NSLog.debug.appendln((Throwable)e);
                }
            }
            this.setValue(objectValue);
        } else if (className.equals("java.lang.Number") || className.equals("java.math.BigDecimal")) {
            Object objectValue;
            block9: {
                String numberFormatterString = this.formatterForKey(this.selectedKey());
                NSNumberFormatter numberFormatter = new NSNumberFormatter(numberFormatterString);
                objectValue = null;
                try {
                    objectValue = numberFormatter.parseObject(value != null ? value.toString() : "");
                }
                catch (ParseException e) {
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) break block9;
                    NSLog.debug.appendln((Throwable)e);
                }
            }
            this.setValue(objectValue);
        } else {
            this.setValue(value);
        }
    }

    public void invalidateCaches() {
        this._relationshipKey = null;
        this._selectedKey = null;
        this._selectedOperator = null;
        this._value = null;
        this._textFieldValue = null;
        this._displayGroup = null;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.invalidateCaches();
    }

    public void reset() {
        this.invalidateCaches();
    }
}

