/*
 * Decompiled with CFR 0.152.
 */
package er.selenium.rc;

import com.webobjects.foundation.NSArray;
import er.extensions.foundation.ERXProperties;
import er.selenium.DefaultSeleniumTestFilesFinder;
import er.selenium.ERSelenium;
import er.selenium.SeleniumTest;
import er.selenium.SeleniumTestFileProcessor;
import er.selenium.filters.SeleniumCompositeTestFilter;
import er.selenium.filters.SeleniumIncludeTestFilter;
import er.selenium.filters.SeleniumOverrideOpenTestFilter;
import er.selenium.filters.SeleniumRepeatExpanderTestFilter;
import er.selenium.rc.SeleniumTestFailureException;
import er.selenium.rc.SeleniumTestRCRunner;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;

public class StandaloneRunner {
    private static final Logger log = Logger.getLogger(StandaloneRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Logger root = Logger.getRootLogger();
        ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"));
        appender.setTarget("System.err");
        LevelRangeFilter filter = new LevelRangeFilter();
        filter.setLevelMin(Level.DEBUG);
        filter.setLevelMax(Level.DEBUG);
        appender.addFilter((Filter)filter);
        appender.activateOptions();
        root.addAppender((Appender)appender);
        appender = new ConsoleAppender((Layout)new PatternLayout());
        appender.setTarget("System.out");
        filter = new LevelRangeFilter();
        filter.setLevelMin(Level.INFO);
        filter.setLevelMax(Level.FATAL);
        appender.addFilter((Filter)filter);
        appender.activateOptions();
        root.addAppender((Appender)appender);
        ERSelenium.registerImportersExporters();
        File testsRoot = new File(args[0]);
        NSArray<File> testsFiles = new DefaultSeleniumTestFilesFinder().findTests(testsRoot);
        log.debug(testsFiles);
        String appHost = args[1];
        String host = args[2];
        int port = args.length >= 4 ? Integer.parseInt(args[3]) : 4444;
        String browserType = args.length >= 5 ? args[4] : "*firefox";
        boolean takeScreenshots = ERXProperties.booleanForKeyWithDefault((String)"er.selenium.screenshotEnabled", (boolean)false);
        String screenshotPath = ERXProperties.stringForKeyWithDefault((String)"er.selenium.screenshotPath", (String)System.getProperty("java.io.tmpdir"));
        boolean failed = false;
        SeleniumTestRCRunner runner = new SeleniumTestRCRunner(host, port, browserType, appHost);
        runner.prepare();
        try {
            for (File testFile : testsFiles) {
                SeleniumTest test = null;
                try {
                    SeleniumCompositeTestFilter testFilter = new SeleniumCompositeTestFilter();
                    Object[] searchPaths = new File[]{testFile.getAbsoluteFile().getParentFile(), testsRoot.getAbsoluteFile()};
                    testFilter.addTestFilter(new SeleniumIncludeTestFilter((NSArray<File>)new NSArray(searchPaths)));
                    testFilter.addTestFilter(new SeleniumRepeatExpanderTestFilter());
                    testFilter.addTestFilter(new SeleniumOverrideOpenTestFilter(appHost));
                    test = new SeleniumTestFileProcessor(testFile, testFilter).process();
                    log.debug((Object)("running: " + testFile));
                    runner.run(test);
                    log.info((Object)String.format("test '%s' PASSED", testFile));
                    log.info((Object)"");
                }
                catch (SeleniumTestFailureException e) {
                    failed = true;
                    log.error((Object)String.format("test '%s' FAILED: %s", testFile, e));
                    log.error((Object)"test log:");
                    int curCommand = 0;
                    for (SeleniumTest.Element elem : test.elements()) {
                        if (!(elem instanceof SeleniumTest.Command)) continue;
                        if (curCommand++ > e.processedCommands()) break;
                        SeleniumTest.Command command = (SeleniumTest.Command)elem;
                        log.error((Object)String.format("%s|%s|%s", command.getName(), command.getTarget(), command.getValue()));
                    }
                    if (takeScreenshots) {
                        String pathPrefix = screenshotPath + "/" + testFile.getName();
                        log.error((Object)("Saving screenshot to " + pathPrefix + ".png"));
                        if ("*firefox".equals(browserType)) {
                            log.error((Object)("Saving full screenshot to " + pathPrefix + "-full.png"));
                            runner.captureEntirePageScreenshot(pathPrefix + "-full.png");
                        }
                        runner.captureScreenshot(pathPrefix + ".png");
                    }
                    log.error((Object)"");
                }
            }
        }
        finally {
            runner.finish();
        }
        System.exit(failed ? 1 : 0);
    }
}

