/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.repeaters;

import er.chronic.repeaters.RepeaterUnit;
import er.chronic.tags.Pointer;
import er.chronic.utils.Span;
import er.chronic.utils.Time;
import java.util.Calendar;

public class RepeaterWeekday
extends RepeaterUnit {
    public static final int WEEK_WEEKDAYS = 5;
    public static final int DAY_SECONDS = 86400;
    private Calendar _currentWeekdayStart;

    protected Span _nextSpan(Pointer.PointerType pointer) {
        if (this._currentWeekdayStart == null) {
            this._currentWeekdayStart = Time.ymd(this.getNow());
        }
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        this._currentWeekdayStart.add(5, direction);
        return new Span(this._currentWeekdayStart, 5, 1.0f);
    }

    protected Span _thisSpan(Pointer.PointerType pointer) {
        Calendar dayEnd;
        Calendar dayBegin;
        if (pointer == Pointer.PointerType.FUTURE) {
            dayBegin = Time.cloneAndAdd(Time.ymdh(this.getNow()), 10, 1.0f);
            dayEnd = Time.cloneAndAdd(Time.ymd(this.getNow()), 5, 1.0f);
        } else if (pointer == Pointer.PointerType.PAST) {
            dayBegin = Time.ymd(this.getNow());
            dayEnd = Time.ymdh(this.getNow());
        } else if (pointer == Pointer.PointerType.NONE) {
            dayBegin = Time.ymd(this.getNow());
            dayEnd = Time.cloneAndAdd(Time.ymdh(this.getNow()), 13, 86400.0f);
        } else {
            throw new IllegalArgumentException("Unable to handle pointer " + (Object)((Object)pointer) + ".");
        }
        return new Span(dayBegin, dayEnd);
    }

    public Span getOffset(Span span, float amount, Pointer.PointerType pointer) {
        int direction = pointer == Pointer.PointerType.FUTURE ? 1 : -1;
        return span.add((float)direction * amount * 86400.0f);
    }

    public int getWidth() {
        return 86400;
    }

    public String toString() {
        return super.toString() + "-day";
    }
}

