/*
 * Decompiled with CFR 0.152.
 */
package er.chronic.utils;

import java.util.Calendar;

public class Time {
    public static Calendar construct(int year) {
        return Time.construct(year, 1);
    }

    public static Calendar construct(int year, int month) {
        if (year <= 37) {
            year += 2000;
        } else if (year <= 137 && year >= 38) {
            year += 1900;
        }
        if (year <= 1900) {
            throw new IllegalArgumentException("Illegal year '" + year + "'");
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        return cal;
    }

    public static Calendar construct(int year, int month, int day) {
        Calendar cal = Time.construct(year, month);
        cal.set(5, day);
        return cal;
    }

    public static Calendar construct(int year, int month, int day, int hour) {
        Calendar cal = Time.construct(year, month, day);
        cal.set(11, hour);
        return cal;
    }

    public static Calendar construct(int year, int month, int day, int hour, int minute) {
        Calendar cal = Time.construct(year, month, day, hour);
        cal.set(12, minute);
        return cal;
    }

    public static Calendar construct(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = Time.construct(year, month, day, hour, minute);
        cal.set(13, second);
        return cal;
    }

    public static Calendar construct(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Calendar cal = Time.construct(year, month, day, hour, minute, second);
        cal.set(14, millisecond);
        return cal;
    }

    public static Calendar y(Calendar basis) {
        Calendar clone = Calendar.getInstance();
        clone.clear();
        clone.set(1, basis.get(1));
        return clone;
    }

    public static Calendar yJan1(Calendar basis) {
        Calendar clone = Time.y(basis, 1, 1);
        return clone;
    }

    public static Calendar y(Calendar basis, int month) {
        Calendar clone = Time.y(basis);
        clone.set(2, month - 1);
        return clone;
    }

    public static Calendar y(Calendar basis, int month, int day) {
        Calendar clone = Time.y(basis, month);
        clone.set(5, day);
        return clone;
    }

    public static Calendar ym(Calendar basis) {
        Calendar clone = Time.y(basis);
        clone.set(2, basis.get(2));
        return clone;
    }

    public static Calendar ymd(Calendar basis) {
        Calendar clone = Time.ym(basis);
        clone.set(5, basis.get(5));
        return clone;
    }

    public static Calendar ymdh(Calendar basis) {
        Calendar clone = Time.ymd(basis);
        clone.set(11, basis.get(11));
        return clone;
    }

    public static Calendar ymdhm(Calendar basis) {
        Calendar clone = Time.ymdh(basis);
        clone.set(12, basis.get(12));
        return clone;
    }

    public static Calendar cloneAndAdd(Calendar basis, int field, float amount) {
        Calendar next = (Calendar)basis.clone();
        double amountFloor = Math.floor(amount);
        if (amountFloor == (double)amount) {
            next.add(field, (int)amount);
        } else if (field == 1) {
            double remainder = (double)amount - amountFloor;
            next.add(1, (int)amountFloor);
            next.add(13, (int)(remainder * 365.0 * 24.0 * 60.0 * 60.0));
        } else if (field == 2) {
            double remainder = (double)amount - amountFloor;
            next.add(2, (int)amountFloor);
            next.add(13, (int)(remainder * 30.0 * 24.0 * 60.0 * 60.0));
        } else if (field == 5) {
            double remainder = (double)amount - amountFloor;
            next.add(5, (int)amountFloor);
            next.add(13, (int)(remainder * 24.0 * 60.0 * 60.0));
        } else if (field == 10) {
            next.add(14, (int)(amount * 60.0f * 60.0f * 1000.0f));
        } else if (field == 12) {
            next.add(14, (int)(amount * 60.0f * 1000.0f));
        } else if (field == 13) {
            next.add(14, (int)(amount * 1000.0f));
        } else if (field == 14) {
            throw new IllegalArgumentException("Fractional milliseconds (" + amount + ") are not supported.");
        }
        return next;
    }
}

