/*
 * Decompiled with CFR 0.152.
 */
package er.changenotification;

import com.webobjects.appserver.WOApplication;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.changenotification.ERCNConfiguration;
import er.changenotification.ERCNConnectionKeeper;
import er.changenotification.ERCNPublisher;
import er.changenotification.ERCNSubscriber;
import er.changenotification.ERCNSubscriberDelegate;
import javax.jms.Topic;
import javax.jms.TopicConnection;

public class ERCNNotificationCoordinator {
    static final String LOG_HEADER = "ERChangeNotification: ";
    private static final ERCNNotificationCoordinator _coordinator = new ERCNNotificationCoordinator();
    private ERCNConfiguration _configuration;
    private ERCNConnectionKeeper _connectionKeeper;
    private ERCNPublisher _publisher;
    private ERCNSubscriber _subscriber;
    private boolean _isInitialized = false;
    private boolean _isTerminated = false;

    private ERCNNotificationCoordinator() {
    }

    public static ERCNNotificationCoordinator coordinator() {
        return _coordinator;
    }

    protected String id() {
        WOApplication app = WOApplication.application();
        String host = app.host();
        Number port = app.port();
        String appName = app.name();
        return host + ":" + port + "/" + appName;
    }

    public synchronized void initialize(NSNotification notification) {
        if (this._isInitialized) {
            return;
        }
        NSLog.out.appendln((Object)"ERChangeNotification: Initializing ERChangeNotification framework");
        this._publisher = new ERCNPublisher(this);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("publishChange", new Class[]{NSNotification.class}), "EOObjectsChangedInStoreNotification", (Object)EOObjectStoreCoordinator.defaultCoordinator());
        this._subscriber = new ERCNSubscriber(this);
        this._connectionKeeper = new ERCNConnectionKeeper(this);
        this._connectionKeeper.openConnection(true);
        if (!this._connectionKeeper.isConnected()) {
            this._connectionKeeper.initiateRecoveryTask();
        }
        NSLog.out.appendln((Object)"ERChangeNotification: Finished initializing ERChangeNotificationJMS framework");
        this._isInitialized = true;
    }

    void didConnect(TopicConnection connection) {
        this._subscriber.subscribe(connection);
    }

    void didDisconnect(TopicConnection connection) {
        this._subscriber.unsubscribe();
    }

    public synchronized void terminate() {
        if (this._isTerminated) {
            return;
        }
        this._connectionKeeper.stopConnection(true);
        this._publisher.terminate();
        this._subscriber.terminate();
        NSLog.out.appendln((Object)"ERChangeNotification: Closing the JMS connection.");
        this._connectionKeeper.closeConnection(true);
        this._connectionKeeper.terminate();
        this._isTerminated = true;
    }

    public void finalize() throws Throwable {
        if (!this._isTerminated) {
            this.terminate();
        }
        super.finalize();
    }

    public void publishChange(NSNotification notification) {
        this._publisher.publishChange(notification);
    }

    public ERCNConfiguration configuration() {
        if (this._configuration == null) {
            this._configuration = ERCNConfiguration.getInstance();
        }
        return this._configuration;
    }

    public ERCNSubscriberDelegate subscriberDelegate() {
        return ERCNSubscriber.delegate();
    }

    public void setSubscriberDelegate(ERCNSubscriberDelegate delegate) {
        ERCNSubscriber.setDelegate(delegate);
    }

    Topic topic() {
        return this._connectionKeeper.topic();
    }

    TopicConnection connection() {
        return this._connectionKeeper.connection();
    }

    public boolean isConnected() {
        return this._connectionKeeper.isConnected();
    }

    public static EODatabaseContext databaseContextForEntityNamed(String entityName, EOEditingContext editingContext) {
        return EOUtilities.databaseContextForModelNamed((EOEditingContext)editingContext, (String)EOModelGroup.defaultGroup().entityNamed(entityName).model().name());
    }

    static {
        NSLog.debug.appendln((Object)"ERChangeNotification: Registering the observer to initialize ERChangeNotification Framework");
        NSNotificationCenter.defaultCenter().addObserver((Object)_coordinator, new NSSelector("initialize", new Class[]{NSNotification.class}), "ApplicationDidFinishLaunchingNotification", null);
    }
}

