/*
 * Decompiled with CFR 0.152.
 */
package er.reporting;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.components.ERXStatelessComponent;
import er.grouping.DRCriteria;
import er.grouping.DRGroup;
import er.grouping.DRMasterCriteria;
import er.grouping.DRReportModel;

public class WRNavigationControl
extends ERXStatelessComponent {
    public DRReportModel model;
    public DRGroup group;
    public DRGroup zGroup;
    public String listLabel;
    public NSMutableDictionary zCriteria;

    public WRNavigationControl(WOContext context) {
        super(context);
    }

    public void reset() {
        super.reset();
        this.group = null;
        this.listLabel = null;
        this.model = null;
        this.zCriteria = null;
    }

    public String currentZCriteriaLabel() {
        int srtdListCount;
        NSArray srtdList = this.zGroup.sortedCriteriaList();
        DRMasterCriteria mc = this.zGroup.masterCriteria();
        DRCriteria crt = (DRCriteria)this.zCriteria().objectForKey((Object)mc.label());
        if (crt == null) {
            return "ERROR";
        }
        int index = srtdList.indexOfObject((Object)crt);
        if (index > (srtdListCount = srtdList.count()) - 1) {
            crt = (DRCriteria)srtdList.objectAtIndex(srtdListCount - 1);
        }
        return crt.label();
    }

    public void updateZList(DRGroup group) {
        DRMasterCriteria mc = group.masterCriteria();
        NSArray srtdList = group.sortedCriteriaList();
        String mcLabel = mc.label();
        DRCriteria crit = (DRCriteria)this.zCriteria().objectForKey((Object)mcLabel);
        if (crit == null) {
            crit = (DRCriteria)srtdList.objectAtIndex(0);
            this.zCriteria().setObjectForKey((Object)crit, (Object)mcLabel);
        }
    }

    public void moveGroupToList(String dest) {
        if ("Z".equals(dest)) {
            this.model().addToZList(this.group);
            this.updateZList(this.group);
        } else if ("H".equals(dest)) {
            this.model().addToHList(this.group);
        } else {
            this.model().addToVList(this.group);
        }
    }

    public WOComponent down() {
        this.model().moveUpDimension(this.group, false, this.listLabel());
        return null;
    }

    public WOComponent up() {
        this.model().moveUpDimension(this.group, true, this.listLabel());
        return null;
    }

    public WOComponent left() {
        this.moveGroupToList(this.leftLabel());
        return null;
    }

    public WOComponent right() {
        this.moveGroupToList(this.rightLabel());
        return null;
    }

    public String listLabel() {
        if (this.listLabel == null) {
            this.listLabel = ((String)this.valueForBinding("listLabel")).toUpperCase();
        }
        return this.listLabel;
    }

    public DRReportModel model() {
        if (this.model == null) {
            this.model = (DRReportModel)this.valueForBinding("model");
        }
        return this.model;
    }

    public NSMutableDictionary zCriteria() {
        if (this.zCriteria == null) {
            this.zCriteria = (NSMutableDictionary)this.valueForBinding("zCriteria");
        }
        return this.zCriteria;
    }

    public NSArray list() {
        return this.model.dimensionForName(this.listLabel());
    }

    public String leftLabel() {
        String listLabel = this.listLabel();
        if ("V".equals(listLabel)) {
            return "Z";
        }
        if ("H".equals(listLabel)) {
            return "V";
        }
        return "H";
    }

    public String rightLabel() {
        String listLabel = this.listLabel();
        if ("V".equals(listLabel)) {
            return "H";
        }
        if ("H".equals(listLabel)) {
            return "Z";
        }
        return "V";
    }

    public WOComponent nextZ() {
        int count;
        NSArray srtdList = this.zGroup.sortedCriteriaList();
        DRMasterCriteria mc = this.zGroup.masterCriteria();
        int index = srtdList.indexOfObject(this.zCriteria().objectForKey((Object)mc.label()));
        int newIndex = index + 1;
        if (newIndex == (count = srtdList.count())) {
            newIndex = 0;
        }
        DRCriteria crt = (DRCriteria)srtdList.objectAtIndex(newIndex);
        this.zCriteria().setObjectForKey((Object)crt, (Object)mc.label());
        return null;
    }

    public WOComponent prevZ() {
        NSArray srtdList = this.zGroup.sortedCriteriaList();
        DRMasterCriteria mc = this.zGroup.masterCriteria();
        int index = srtdList.indexOfObject(this.zCriteria().objectForKey((Object)mc.label()));
        int count = srtdList.count();
        int newIndex = index - 1;
        if (newIndex < 0) {
            newIndex = count - 1;
        }
        DRCriteria crt = (DRCriteria)srtdList.objectAtIndex(newIndex);
        this.zCriteria().setObjectForKey((Object)crt, (Object)mc.label());
        return null;
    }

    public boolean showZDimensions() {
        return this.model().zList().count() > 0 && "Z".equals(this.listLabel());
    }

    public boolean showNavigation() {
        return this.valueForBooleanBinding("showNavigation");
    }
}

