/*
 * Decompiled with CFR 0.152.
 */
package er.memoryadaptor;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSUtilities;
import er.memoryadaptor.EREntityStore;
import er.memoryadaptor.ERJoinEntityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EREntityStoreFactory {
    private boolean _hasTransaction = false;
    private NSMutableDictionary<String, EREntityStore> _entityStores = new NSMutableDictionary();
    private NSMutableDictionary<String, EREntityStore> _transactionEntityStores;
    private final Class<? extends EREntityStore> _entityStoreClazz;
    public static final String RESET_ALL_ENTITIES = "EREntityStoreResetAllEntities";

    public EREntityStoreFactory(Class<? extends EREntityStore> clazz) {
        this._entityStoreClazz = clazz;
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("resetAllEntities", new Class[]{NSNotification.class}), RESET_ALL_ENTITIES, null);
    }

    public void resetAllEntities() {
        this._entityStores.removeAllObjects();
        if (this._transactionEntityStores != null) {
            this._transactionEntityStores.removeAllObjects();
        }
    }

    public void resetAllEntities(NSNotification object) {
        this.resetAllEntities();
    }

    public void resetEntity(EOEntity entity) {
        this._entityStores.removeObjectForKey((Object)entity);
        if (this._transactionEntityStores != null) {
            this._transactionEntityStores.removeObjectForKey((Object)entity);
        }
    }

    public EREntityStore _entityStoreForEntity(EOEntity entity) {
        return this._entityStoreForEntity(entity, this._hasTransaction);
    }

    public EREntityStore _entityStoreForEntity(EOEntity entity, boolean transactional) {
        NSSet<EOEntity> relatedEntities = this._relatedEntities(entity);
        EREntityStore store = this._entityStoreForExternalName(this._entityExternalName(entity), transactional);
        if (relatedEntities.count() > 0 && !(store instanceof EREntityStore.JoinEntityStore)) {
            NSMutableDictionary stores = new NSMutableDictionary((Object[])new EREntityStore[]{store}, (Object[])new EOEntity[]{entity});
            for (EOEntity related : relatedEntities) {
                store = this._entityStoreForExternalName(this._entityExternalName(related), transactional);
                stores.setObjectForKey((Object)store, (Object)related);
            }
            store = new ERJoinEntityStore((NSDictionary<EOEntity, EREntityStore>)stores, entity);
        }
        return store;
    }

    private String _entityExternalName(EOEntity entity) {
        String externalName = entity.externalName();
        if (externalName == null || externalName.trim().length() == 0) {
            externalName = entity.name();
        }
        return externalName;
    }

    private EREntityStore _entityStoreForExternalName(String name, boolean transactional) {
        EREntityStore store = (EREntityStore)this._entityStores.objectForKey((Object)name);
        if (store == null) {
            store = (EREntityStore)_NSUtilities.instantiateObject(this._entityStoreClazz, null, null, (boolean)false, (boolean)false);
            this._entityStores.setObjectForKey((Object)store, (Object)name);
        }
        if (transactional) {
            EREntityStore transactionStore = (EREntityStore)this._transactionEntityStores.objectForKey((Object)name);
            if (transactionStore == null) {
                transactionStore = store.transactionStore();
                this._transactionEntityStores.setObjectForKey((Object)transactionStore, (Object)name);
            }
            store = transactionStore;
        }
        return store;
    }

    public void beginTransaction() {
        if (!this._hasTransaction) {
            this._hasTransaction = true;
            this._transactionEntityStores = new NSMutableDictionary();
        }
    }

    public void commitTransaction() {
        if (this._hasTransaction) {
            this._hasTransaction = false;
            for (String entityName : this._transactionEntityStores.allKeys()) {
                EREntityStore transactionStore = (EREntityStore)this._transactionEntityStores.objectForKey((Object)entityName);
                EREntityStore entityStore = (EREntityStore)this._entityStores.objectForKey((Object)entityName);
                entityStore.commitFromTransactionStore(transactionStore);
            }
            this._transactionEntityStores = null;
        }
    }

    public void rollbackTransaction() {
        if (this._hasTransaction) {
            this._hasTransaction = false;
            this._transactionEntityStores = null;
        }
    }

    private NSSet<EOEntity> _relatedEntities(EOEntity entity) {
        NSMutableSet entities = new NSMutableSet();
        for (EOAttribute attrib : entity.attributesToFetch()) {
            if (!attrib.isDerived() || (attrib = entity._attributeForPath(attrib.definition())) == null) continue;
            entities.add((Object)attrib.entity());
        }
        return entities;
    }
}

