/*
 * Decompiled with CFR 0.152.
 */
package er.rest;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import er.extensions.eof.ERXKey;
import er.extensions.eof.ERXKeyFilter;
import er.extensions.qualifiers.ERXQualifierTraversal;

public class ERXFilteredQualifierTraversal
extends ERXQualifierTraversal {
    private EOEntity _entity;
    private ERXKeyFilter _filter;

    protected ERXFilteredQualifierTraversal(EOEntity entity, ERXKeyFilter filter) {
        this._entity = entity;
        this._filter = filter;
    }

    protected void checkKey(String key) throws SecurityException {
        if (!this._filter.matches(new ERXKey(key), ERXFilteredQualifierTraversal.typeForKeyInEntity(key, this._entity))) {
            throw new SecurityException("You do not have access to the key path '" + key + "'.");
        }
    }

    protected boolean traverseKeyComparisonQualifier(EOKeyComparisonQualifier q) {
        this.checkKey(q.leftKey());
        this.checkKey(q.rightKey());
        return super.traverseKeyComparisonQualifier(q);
    }

    protected boolean traverseKeyValueQualifier(EOKeyValueQualifier q) {
        this.checkKey(q.key());
        return super.traverseKeyValueQualifier(q);
    }

    protected boolean traverseUnknownQualifier(EOQualifierEvaluation q) {
        throw new SecurityException("Unknown qualifier: " + q);
    }

    public static ERXKey.Type typeForKeyInEntity(String key, EOEntity entity) {
        EORelationship relationship;
        EOAttribute attribute = entity._attributeForPath(key);
        Object type = attribute != null ? ERXKey.Type.Attribute : ((relationship = entity._relationshipForPath(key)) != null ? (relationship.isToMany() ? ERXKey.Type.ToManyRelationship : ERXKey.Type.ToOneRelationship) : null);
        return type;
    }

    public static void checkQualifierForEntityWithFilter(EOQualifier qualifier, EOEntity entity, ERXKeyFilter filter) throws SecurityException {
        new ERXFilteredQualifierTraversal(entity, filter).traverse((EOQualifierEvaluation)qualifier);
    }
}

