/*
 * Decompiled with CFR 0.152.
 */
package er.rest;

import er.extensions.localization.ERXLocalizer;
import java.util.HashMap;
import java.util.Map;

public class ERXRestNameRegistry {
    private static ERXRestNameRegistry _registry = new ERXRestNameRegistry();
    private Map<String, String> _internalNameForExternalName = new HashMap<String, String>();
    private Map<String, String> _externalNameForInternalName = new HashMap<String, String>();

    public static ERXRestNameRegistry registry() {
        return _registry;
    }

    protected ERXRestNameRegistry() {
    }

    public void setExternalNameForInternalName(String externalName, String internalName) {
        this._setExternalNameForInternalName(externalName, internalName);
        this._setExternalNameForInternalName(ERXLocalizer.englishLocalizer().plurifiedString(externalName, 2), ERXLocalizer.englishLocalizer().plurifiedString(internalName, 2));
    }

    protected void _setExternalNameForInternalName(String externalName, String internalName) {
        this._externalNameForInternalName.put(internalName, externalName);
        this._internalNameForExternalName.put(externalName, internalName);
        String lowerInternalName = internalName.toLowerCase();
        String lowerExternalName = externalName.toLowerCase();
        this._externalNameForInternalName.put(lowerInternalName, lowerExternalName);
        this._internalNameForExternalName.put(lowerExternalName, lowerInternalName);
    }

    public String externalNameForInternalName(String internalName) {
        String externalName = this._externalNameForInternalName.get(internalName);
        if (externalName == null) {
            externalName = internalName;
        }
        return externalName;
    }

    public String internalNameForExternalName(String externalName) {
        String internalName = this._internalNameForExternalName.get(externalName);
        if (internalName == null) {
            internalName = externalName;
        }
        return internalName;
    }
}

