/*
 * Decompiled with CFR 0.152.
 */
package er.rest;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntityClassDescription;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXValueUtilities;
import er.rest.ERXRestClassDescriptionFactory;
import er.rest.IERXRestDelegate;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ERXRestUtils {
    public static boolean isPrimitive(Object obj) {
        return obj == null || (obj instanceof Class ? ERXRestUtils.isPrimitive((Class)obj) : ERXRestUtils.isPrimitive(obj.getClass()));
    }

    public static boolean isPrimitive(Class valueType) {
        boolean primitive = false;
        if (String.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Boolean.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Character.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Byte.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (BigDecimal.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Integer.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Short.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Long.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Float.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Double.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Date.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Calendar.class.isAssignableFrom(valueType)) {
            primitive = true;
        } else if (Enum.class.isAssignableFrom(valueType)) {
            primitive = true;
        }
        return primitive;
    }

    public static String coerceValueToString(Object value) {
        String formattedValue;
        if (value == null) {
            formattedValue = null;
        } else if (value instanceof NSTimestamp) {
            NSTimestamp timestamp = (NSTimestamp)value;
            String rfcFormat = ERXProperties.stringForKeyWithDefault((String)"er.rest.rfcDateFormat", (String)"rfc822");
            if ("rfc3339".equals(rfcFormat)) {
                formattedValue = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(new Date(timestamp.getTime()));
                formattedValue = formattedValue.substring(0, formattedValue.length() - 2) + ":" + formattedValue.substring(formattedValue.length() - 2);
            } else {
                formattedValue = new NSTimestampFormatter(ERXRestUtils.timestampFormat(false)).format((Object)timestamp);
            }
        } else if (value instanceof Date) {
            Date date = (Date)value;
            formattedValue = new SimpleDateFormat(ERXRestUtils.dateFormat(false)).format(value);
        } else {
            formattedValue = value.toString();
        }
        return formattedValue;
    }

    protected static String timestampFormat(boolean spaces) {
        String dateFormat = ERXProperties.stringForKey((String)"er.rest.timestampFormat");
        if (dateFormat == null) {
            dateFormat = spaces ? ERXProperties.stringForKeyWithDefault((String)"er.rest.timestampFormat.secondary", (String)"%Y-%m-%d %H:%M:%S %Z") : ERXProperties.stringForKeyWithDefault((String)"er.rest.timestampFormat.primary", (String)"%Y-%m-%dT%H:%M:%SZ");
        }
        return dateFormat;
    }

    protected static String dateFormat(boolean spaces) {
        String timestampFormat = ERXProperties.stringForKey((String)"er.rest.dateFormat");
        if (timestampFormat == null) {
            timestampFormat = spaces ? ERXProperties.stringForKeyWithDefault((String)"er.rest.dateFormat.secondary", (String)"YYYY-MM-dd HH:mm:ss z") : ERXProperties.stringForKeyWithDefault((String)"er.rest.dateFormat.primary", (String)"YYYY-MM-dd\\THH:mm:ss\\Z");
        }
        return timestampFormat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object coerceValueToTypeNamed(Object value, String valueTypeName, IERXRestDelegate delegate) {
        Class valueType = _NSUtilities.classWithName((String)valueTypeName);
        if (ERXValueUtilities.isNull((Object)value)) {
            return null;
        }
        if (valueType != null && String.class.isAssignableFrom(valueType)) {
            return String.valueOf(value);
        }
        if (valueType != null && Boolean.class.isAssignableFrom(valueType)) {
            return ERXValueUtilities.BooleanValueWithDefault((Object)value, null);
        }
        if (valueType != null && Character.class.isAssignableFrom(valueType)) {
            return new Character(((String)value).charAt(0));
        }
        if (valueType != null && Byte.class.isAssignableFrom(valueType)) {
            return Byte.valueOf((String)value);
        }
        if (valueType != null && BigDecimal.class.isAssignableFrom(valueType)) {
            return ERXValueUtilities.DoubleValueWithDefault((Object)value, null);
        }
        if (valueType != null && Integer.class.isAssignableFrom(valueType)) {
            return ERXValueUtilities.IntegerValueWithDefault((Object)value, null);
        }
        if (valueType != null && Short.class.isAssignableFrom(valueType)) {
            return Short.valueOf((String)value);
        }
        if (valueType != null && Long.class.isAssignableFrom(valueType)) {
            return ERXValueUtilities.LongValueWithDefault((Object)value, null);
        }
        if (valueType != null && Float.class.isAssignableFrom(valueType)) {
            return ERXValueUtilities.FloatValueWithDefault((Object)value, null);
        }
        if (valueType != null && Double.class.isAssignableFrom(valueType)) {
            return ERXValueUtilities.DoubleValueWithDefault((Object)value, null);
        }
        if (valueType != null && NSTimestamp.class.isAssignableFrom(valueType)) {
            if (value instanceof NSTimestamp) {
                return value;
            }
            String strValue = (String)value;
            boolean spaces = strValue.indexOf(32) != -1;
            String rfcFormat = ERXProperties.stringForKeyWithDefault((String)"er.rest.rfcDateFormat", (String)"rfc822");
            if ("rfc3339".equals(rfcFormat)) {
                DateFormat formatter = null;
                Pattern pattern = Pattern.compile("(.*[\\-,\\+]{1}[0-9]{1,2}):([0-9]{1,2})");
                Matcher matcher = pattern.matcher(strValue);
                if (matcher.matches()) {
                    try {
                        strValue = matcher.group(1) + matcher.group(2);
                        Object parsedValue = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parseObject(strValue);
                        if (!(parsedValue instanceof Date)) return parsedValue;
                        return new NSTimestamp((Date)parsedValue);
                    }
                    catch (Throwable t) {
                        String msg = "Failed to parse '" + strValue + "' as a timestamp";
                        if (formatter != null) {
                            msg = msg + " (example: " + formatter.format((Date)new NSTimestamp()) + ")";
                        }
                        msg = msg + ".";
                        throw new IllegalArgumentException(msg, t);
                    }
                }
                strValue = null;
                throw new IllegalArgumentException(strValue + " didn't match the " + pattern.pattern() + " pattern", new Throwable());
            }
            NSTimestampFormatter formatter = null;
            try {
                formatter = new NSTimestampFormatter(ERXRestUtils.timestampFormat(spaces));
                return formatter.parseObject(strValue);
            }
            catch (Throwable t) {
                String msg = "Failed to parse '" + strValue + "' as a timestamp";
                if (formatter != null) {
                    msg = msg + " (example: " + formatter.format((Object)new NSTimestamp()) + ")";
                }
                msg = msg + ".";
                throw new IllegalArgumentException(msg, t);
            }
        }
        if (valueType != null && Date.class.isAssignableFrom(valueType)) {
            if (value instanceof NSTimestamp) {
                return value;
            }
            String strValue = (String)value;
            SimpleDateFormat formatter = null;
            try {
                boolean spaces = strValue.indexOf(32) != -1;
                formatter = new SimpleDateFormat(ERXRestUtils.dateFormat(spaces));
                return formatter.parseObject(strValue);
            }
            catch (Throwable t) {
                String msg = "Failed to parse '" + strValue + "' as a timestamp";
                if (formatter != null) {
                    msg = msg + " (example: " + formatter.format(new Date()) + ")";
                }
                msg = msg + ".";
                throw new IllegalArgumentException(msg, t);
            }
        }
        if (valueType != null && Enum.class.isAssignableFrom(valueType)) {
            return ERXValueUtilities.enumValueWithDefault((Object)value, (Class)valueType, null);
        }
        if (delegate == null) throw new IllegalArgumentException("Unable to parse the value '" + value + "' into a '" + valueTypeName + "'.");
        EOClassDescription entity = ERXRestClassDescriptionFactory.classDescriptionForEntityName(valueTypeName);
        if (entity == null) throw new IllegalArgumentException("Unknown value type '" + valueTypeName + "'.");
        return delegate.objectOfEntityWithID(entity, value);
    }

    public static Object coerceValueToAttributeType(Object value, EOClassDescription parentEntity, Object parentObject, String attributeName) {
        NSKeyValueCoding._KeyBinding binding = NSKeyValueCoding.DefaultImplementation._keyGetBindingForKey((Object)parentObject, (String)attributeName);
        Class valueType = binding.valueType();
        try {
            EOAttribute attribute;
            Object parsedValue = value == null || ERXValueUtilities.isNull((Object)value) || value instanceof String && ((String)value).length() == 0 ? (parentEntity != null ? (parentEntity instanceof EOEntityClassDescription ? ((attribute = ((EOEntityClassDescription)parentEntity).entity().attributeNamed(attributeName)) != null && !attribute.allowsNull() && String.class.isAssignableFrom(valueType) ? "" : EOKeyValueCoding.NullValue) : NSKeyValueCoding.NullValue) : NSKeyValueCoding.NullValue) : ERXRestUtils.coerceValueToTypeNamed(value, valueType.getName(), null);
            return parsedValue;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to parse attribute " + attributeName + " for entity " + (parentEntity == null ? "unknown" : parentEntity.entityName()), e);
        }
    }
}

