/*
 * Decompiled with CFR 0.152.
 */
package er.rest.format;

import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSPropertyListSerialization;
import er.rest.ERXRestRequestNode;
import er.rest.ERXRestUtils;
import er.rest.format.ERXRestFormat;
import er.rest.format.ERXStringRestRequest;
import er.rest.format.IERXRestParser;
import er.rest.format.IERXRestRequest;
import java.util.List;
import java.util.Map;

public class ERXPListRestParser
implements IERXRestParser {
    protected ERXRestRequestNode createRequestNodeForObject(String name, Object object, boolean rootNode, ERXRestFormat.Delegate delegate) {
        ERXRestRequestNode requestNode = new ERXRestRequestNode(name, rootNode);
        if (object != null) {
            if (object instanceof List) {
                requestNode.setArray(true);
                List list = (List)object;
                for (Object obj : list) {
                    if (ERXRestUtils.isPrimitive(obj)) {
                        ERXRestRequestNode primitiveChild = new ERXRestRequestNode(null, object, false);
                        requestNode.addChild(primitiveChild);
                        delegate.nodeDidParse(primitiveChild);
                        continue;
                    }
                    requestNode.addChild(this.createRequestNodeForObject(null, obj, true, delegate));
                }
            } else if (object instanceof Map) {
                Map map = (Map)object;
                for (Object key : map.keySet()) {
                    String strKey = (String)key;
                    Object value = map.get(key);
                    if (ERXRestUtils.isPrimitive(value)) {
                        ERXRestRequestNode primitiveChild = new ERXRestRequestNode(strKey, value, false);
                        requestNode.addChild(primitiveChild);
                        delegate.nodeDidParse(primitiveChild);
                        continue;
                    }
                    requestNode.addChild(this.createRequestNodeForObject(strKey, value, false, delegate));
                }
            } else {
                throw new IllegalArgumentException("Unknown PLIST value '" + object + "'.");
            }
        }
        delegate.nodeDidParse(requestNode);
        return requestNode;
    }

    @Deprecated
    public ERXRestRequestNode parseRestRequest(WORequest request, ERXRestFormat.Delegate delegate) {
        return this.parseRestRequest(request.contentString(), delegate);
    }

    @Deprecated
    public ERXRestRequestNode parseRestRequest(String contentStr, ERXRestFormat.Delegate delegate) {
        return this.parseRestRequest(new ERXStringRestRequest(contentStr), delegate);
    }

    public ERXRestRequestNode parseRestRequest(IERXRestRequest request, ERXRestFormat.Delegate delegate) {
        ERXRestRequestNode rootRequestNode = null;
        String contentString = request.stringContent();
        if (contentString != null && contentString.length() > 0) {
            Object rootObj = NSPropertyListSerialization.propertyListFromString((String)contentString);
            rootRequestNode = this.createRequestNodeForObject(null, rootObj, true, delegate);
        } else {
            rootRequestNode = new ERXRestRequestNode(null, true);
            rootRequestNode.setNull(true);
        }
        return rootRequestNode;
    }
}

