/*
 * Decompiled with CFR 0.152.
 */
package er.rest.format;

import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import er.rest.ERXRestNameRegistry;
import er.rest.ERXRestRequestNode;
import er.rest.format.ERXRestFormat;

public class ERXRestFormatDelegate
implements ERXRestFormat.Delegate {
    public static final String ID_KEY = "id";
    public static final String TYPE_KEY = "type";
    public static final String NIL_KEY = "nil";
    private String _idKey;
    private String _typeKey;
    private String _nilKey;
    private boolean _arrayTypes;
    private boolean _writeNilKey;
    private boolean _pluralNames;
    private boolean _underscoreNames;

    public ERXRestFormatDelegate() {
        this(ID_KEY, TYPE_KEY, NIL_KEY, true, ERXProperties.booleanForKeyWithDefault((String)"ERXRest.pluralEntityNames", (boolean)true), false, false);
    }

    public ERXRestFormatDelegate(String idKey, String typeKey, String nilKey, boolean writeNilKey, boolean pluralNames, boolean underscoreNames, boolean arrayTypes) {
        this._idKey = idKey;
        this._typeKey = typeKey;
        this._nilKey = nilKey;
        this._writeNilKey = writeNilKey;
        this._pluralNames = pluralNames;
        this._underscoreNames = underscoreNames;
        this._arrayTypes = arrayTypes;
    }

    public void nodeDidParse(ERXRestRequestNode node) {
        String name;
        Object nil;
        if (node.isRootNode()) {
            node.setName(ERXRestNameRegistry.registry().internalNameForExternalName(node.name()));
        }
        Object id = node.removeAttributeOrChildNodeNamed(this._idKey);
        node.setID(id);
        String externalType = (String)node.removeAttributeOrChildNodeNamed(this._typeKey);
        if (externalType != null) {
            if (this._arrayTypes && "array".equals(externalType)) {
                node.setArray(true);
            } else {
                String type = ERXRestNameRegistry.registry().internalNameForExternalName(externalType);
                if (this._underscoreNames) {
                    type = ERXStringUtilities.camelCaseToUnderscore((String)type, (boolean)false);
                }
                node.setType(type);
            }
        }
        if ((nil = node.removeAttributeOrChildNodeNamed(this._nilKey)) != null) {
            node.setNull("true".equals(nil) || Boolean.TRUE.equals(nil));
        }
        if (this._underscoreNames && (name = node.name()) != null) {
            name = ERXStringUtilities.underscoreToCamelCase((String)name, (boolean)node.isRootNode());
            node.setName(name);
        }
    }

    public void nodeWillWrite(ERXRestRequestNode node) {
        String name;
        String internalType;
        Object id;
        if (node.isRootNode()) {
            if (this._pluralNames) {
                node.setName(ERXRestNameRegistry.registry().externalNameForInternalName(ERXLocalizer.englishLocalizer().plurifiedString(node.name(), 2)));
            } else {
                node.setName(ERXRestNameRegistry.registry().externalNameForInternalName(node.name()));
            }
        }
        if ((id = node.id()) != null) {
            node.setAttributeForKey(id, this._idKey);
        }
        if ((internalType = node.type()) != null) {
            if (this._arrayTypes && node.isArray()) {
                node.setAttributeForKey("array", this._typeKey);
            } else {
                String type = ERXRestNameRegistry.registry().externalNameForInternalName(internalType);
                if (this._underscoreNames) {
                    type = ERXStringUtilities.camelCaseToUnderscore((String)type, (boolean)true);
                }
                node.setAttributeForKey(type, this._typeKey);
            }
        }
        if (node.isNull() && this._writeNilKey) {
            node.setAttributeForKey("true", this._nilKey);
        }
        if (this._underscoreNames && (name = node.name()) != null) {
            name = ERXStringUtilities.camelCaseToUnderscore((String)name, (boolean)true);
            node.setName(name);
        }
    }
}

