/*
 * Decompiled with CFR 0.152.
 */
package er.rest.util;

import com.webobjects.eocontrol.EOEditingContext;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRestTransaction {
    private int _minimumSequenceID = Integer.MAX_VALUE;
    private int _maximumSequenceID = Integer.MIN_VALUE;
    private boolean _hasCommit;
    private String _identifier;
    private EOEditingContext _editingContext;
    private Map<Integer, Object> _records;

    public ERXRestTransaction(String identifier, EOEditingContext editingContext) {
        this._identifier = identifier;
        this._editingContext = editingContext;
        this._records = new TreeMap<Integer, Object>();
    }

    public int minimumSequenceID() {
        return this._minimumSequenceID;
    }

    public int maximumSequenceID() {
        return this._maximumSequenceID;
    }

    public boolean hasCommit() {
        return this._hasCommit;
    }

    public int size() {
        return this._records.size();
    }

    public void addEvent(int sequenceID, State state, Object record) {
        if (sequenceID < this._minimumSequenceID) {
            this._minimumSequenceID = sequenceID;
        }
        if (sequenceID > this._maximumSequenceID) {
            this._maximumSequenceID = sequenceID;
        }
        if (state == State.Commit) {
            this._hasCommit = true;
        }
        this._records.put(sequenceID, record);
    }

    public Collection<Object> records() {
        return this._records.values();
    }

    public String identifier() {
        return this._identifier;
    }

    public EOEditingContext editingContext() {
        return this._editingContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Open,
        Commit;

    }
}

