/*
 * Decompiled with CFR 0.152.
 */
package er.plot;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXAssert;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.data.general.Dataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERPChart
extends ERXStatelessComponent {
    protected static final Logger log = Logger.getLogger(ERPChart.class);
    protected static final int DEFAULT_SIZE = 400;
    protected NSData _imageData;
    public String _imageKey;
    public String _imageMap;
    public String _imageMapName;
    protected NSArray<?> _items;
    protected String _name;
    protected String _chartType;
    protected String _imageType;
    protected String _nameKey;
    protected String _valueKey;
    protected int _width = 0;
    protected int _height = 0;
    protected Dataset _dataset;
    protected JFreeChart _chart;
    protected NSDictionary<String, ?> _configuration;

    public ERPChart(WOContext context) {
        super(context);
    }

    public NSArray<?> items() {
        if (this._items == null) {
            this._items = (NSArray)this.valueForBinding("items");
            ERXAssert.DURING.notNull("items", this._items);
        }
        return this._items;
    }

    public String nameKey() {
        if (this._nameKey == null) {
            this._nameKey = (String)this.valueForBinding("nameKey");
            ERXAssert.DURING.notNull("nameKey", (Object)this._nameKey);
        }
        return this._nameKey;
    }

    public String valueKey() {
        if (this._valueKey == null) {
            this._valueKey = (String)this.valueForBinding("valueKey");
            ERXAssert.DURING.notNull("valueKey", (Object)this._valueKey);
        }
        return this._valueKey;
    }

    public int width() {
        if (this._width == 0) {
            this._width = this.intValueForBinding("width", 400);
        }
        return this._width;
    }

    public int height() {
        if (this._height == 0) {
            this._height = this.intValueForBinding("height", 400);
        }
        return this._height;
    }

    public String chartType() {
        if (this._chartType == null) {
            this._chartType = (String)this.valueForBinding("chartType");
            ERXAssert.DURING.notNull("chartType", (Object)this._chartType);
            ERXAssert.DURING.isTrue("chartType " + this._chartType + " is not in supported types: " + this.supportedTypes(), this.supportedTypes().containsObject((Object)this._chartType));
        }
        return this._chartType;
    }

    public String imageType() {
        if (this._imageType == null) {
            this._imageType = this.stringValueForBinding("imageType", "image/png");
        }
        return this._imageType;
    }

    public boolean showLegends() {
        return this.booleanValueForBinding("showLegends", true);
    }

    public boolean showUrls() {
        return this.booleanValueForBinding("showUrls", false);
    }

    public boolean showToolTips() {
        return this.booleanValueForBinding("showToolTips", true);
    }

    public NSDictionary<String, ?> configuration() {
        if (this._configuration == null) {
            this._configuration = (NSDictionary)this.valueForBinding("configuration");
            if (this._configuration == null) {
                this._configuration = NSDictionary.EmptyDictionary;
            }
        }
        return this._configuration;
    }

    public void reset() {
        super.reset();
        this._imageData = null;
        this._imageKey = null;
        this._imageType = null;
        this._items = null;
        this._name = null;
        this._chartType = null;
        this._nameKey = null;
        this._valueKey = null;
        this._width = 0;
        this._height = 0;
        this._dataset = null;
        this._chart = null;
        this._configuration = null;
    }

    protected abstract JFreeChart createChart();

    protected abstract Dataset createDataset();

    protected abstract NSArray<String> supportedTypes();

    public Dataset dataset() {
        if (this._dataset == null) {
            if (this.hasBinding("dataset") && this.canGetValueForBinding("dataset")) {
                this._dataset = (Dataset)this.valueForBinding("dataset");
            }
            if (this._dataset == null) {
                this._dataset = this.createDataset();
                if (this.canSetValueForBinding("dataset")) {
                    this.setValueForBinding(this._dataset, "dataset");
                }
            }
        }
        return this._dataset;
    }

    public JFreeChart chart() {
        if (this._chart == null) {
            if (this.hasBinding("chart") && this.canGetValueForBinding("chart")) {
                this._chart = (JFreeChart)this.valueForBinding("chart");
            }
            if (this._chart == null) {
                this._chart = this.createChart();
                if (this.hasBinding("chart") && this.canSetValueForBinding("chart")) {
                    this.setValueForBinding(this._chart, "chart");
                }
                Enumeration keys = this.configuration().keyEnumerator();
                while (keys.hasMoreElements()) {
                    String keypath = (String)keys.nextElement();
                    Object value = this.configuration().objectForKey((Object)keypath);
                    NSKeyValueCodingAdditions.Utility.takeValueForKeyPath((Object)this._chart, (Object)value, (String)keypath);
                }
            }
        }
        return this._chart;
    }

    public NSData imageData() {
        if (this._imageData == null) {
            try {
                JFreeChart chart = this.chart();
                if (chart != null) {
                    ByteArrayOutputStream imageStream = new ByteArrayOutputStream();
                    ChartRenderingInfo info = null;
                    if (this.showToolTips() || this.showUrls()) {
                        info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                    }
                    if ("image/jpeg".equals(this.imageType())) {
                        ChartUtilities.writeChartAsJPEG((OutputStream)imageStream, (JFreeChart)chart, (int)this.width(), (int)this.height(), (ChartRenderingInfo)info);
                    } else {
                        ChartUtilities.writeChartAsPNG((OutputStream)imageStream, (JFreeChart)chart, (int)this.width(), (int)this.height(), (ChartRenderingInfo)info, (boolean)true, (int)0);
                    }
                    if (this.showToolTips() || this.showUrls()) {
                        this._imageMapName = "ERP" + System.identityHashCode(chart);
                        ToolTipTagFragmentGenerator toolTipGenerator = null;
                        URLTagFragmentGenerator urlTagFragmentGenerator = null;
                        if (this.showToolTips()) {
                            toolTipGenerator = new ToolTipTagFragmentGenerator(){

                                public String generateToolTipFragment(String toolTip) {
                                    return " title=\"" + toolTip + "\"";
                                }
                            };
                        }
                        if (this.showUrls()) {
                            urlTagFragmentGenerator = new URLTagFragmentGenerator(){

                                public String generateURLFragment(String url) {
                                    return " href=\"" + url + "\"";
                                }
                            };
                        }
                        this._imageMap = ImageMapUtilities.getImageMap((String)this._imageMapName, (ChartRenderingInfo)info, (ToolTipTagFragmentGenerator)toolTipGenerator, (URLTagFragmentGenerator)urlTagFragmentGenerator);
                    }
                    this._imageData = new NSData(imageStream.toByteArray());
                }
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
                NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
            }
        }
        return this._imageData;
    }

    public String imageMap() {
        this.imageData();
        return this._imageMap;
    }

    public String otherTagString() {
        String map = this.imageMap();
        return map == null ? null : "usemap=\"#" + this._imageMapName + "\"";
    }
}

