/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;

public class ERDerbyPlugIn
extends JDBCPlugIn {
    static final boolean USE_NAMED_CONSTRAINTS = true;
    private static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DRIVER_NAME = "Derby";
    private static final NSTimestampFormatter DATE_FORMATTER = new NSTimestampFormatter("%Y-%m-%d");
    private static final NSTimestampFormatter TIMESTAMP_FORMATTER = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S.%F");
    private static Method _bigDecimalToString = null;

    protected static String quoteTableName(String s) {
        if (s == null) {
            return null;
        }
        int i = s.lastIndexOf(46);
        if (i == -1) {
            return "\"" + s + "\"";
        }
        return "\"" + s.substring(0, i) + "\".\"" + s.substring(i + 1, s.length()) + "\"";
    }

    public ERDerbyPlugIn(JDBCAdaptor adaptor) {
        super(adaptor);
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        return new DerbySynchronizationFactory((EOAdaptor)this.adaptor());
    }

    public String databaseProductName() {
        return DRIVER_NAME;
    }

    public String defaultDriverName() {
        return DRIVER_CLASS_NAME;
    }

    public Class defaultExpressionClass() {
        return DerbyExpression.class;
    }

    public NSDictionary jdbcInfo() {
        NSDictionary jdbcInfo;
        if (this.shouldUseBundledJdbcInfo()) {
            InputStream jdbcInfoStream;
            if (NSLog.debugLoggingAllowedForLevel((int)3)) {
                NSLog.debug.appendln((Object)"Loading jdbcInfo from JDBCInfo.plist as opposed to using the JDBCPlugIn default implementation.");
            }
            if ((jdbcInfoStream = NSBundle.bundleForClass(((Object)((Object)this)).getClass()).inputStreamForResourcePath("JDBCInfo.plist")) == null) {
                throw new IllegalStateException("Unable to find 'JDBCInfo.plist' in this plugin jar.");
            }
            try {
                jdbcInfo = (NSDictionary)NSPropertyListSerialization.propertyListFromData((NSData)new NSData(jdbcInfoStream, 2048), (String)"US-ASCII");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load 'JDBCInfo.plist' from this plugin jar: " + e, e);
            }
        } else {
            jdbcInfo = super.jdbcInfo();
        }
        return jdbcInfo;
    }

    public String name() {
        return DRIVER_NAME;
    }

    protected boolean shouldUseBundledJdbcInfo() {
        boolean shouldUseBundledJdbcInfo = false;
        String url = this.connectionURL();
        if (url != null) {
            shouldUseBundledJdbcInfo = url.toLowerCase().matches(".*(\\?|\\?.*&)useBundledJdbcInfo=(true|yes)(\\&|$)".toLowerCase());
        }
        return shouldUseBundledJdbcInfo;
    }

    public static class DerbySynchronizationFactory
    extends EOSynchronizationFactory {
        public DerbySynchronizationFactory(EOAdaptor adaptor) {
            super(adaptor);
        }

        public NSArray _statementsToDropPrimaryKeyConstraintsOnTableNamed(String tableName) {
            return new NSArray((Object)this._expressionForString("alter table " + tableName + " drop primary key"));
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
            String pkTable = ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName();
            return new NSArray((Object)this._expressionForString("drop table " + pkTable));
        }

        public NSArray dropTableStatementsForEntityGroup(NSArray entityGroup) {
            return new NSArray((Object)this._expressionForString("drop table " + ((EOEntity)entityGroup.objectAtIndex(0)).externalName()));
        }

        boolean isPrimaryKeyAttributes(EOEntity entity, NSArray attributes) {
            boolean result;
            NSArray keys = entity.primaryKeyAttributeNames();
            boolean bl = result = attributes.count() == keys.count();
            if (result) {
                for (int i = 0; i < keys.count() && (result = keys.indexOfObject((Object)((EOAttribute)attributes.objectAtIndex(i)).name()) != -1); ++i) {
                }
            }
            return result;
        }

        public NSArray foreignKeyConstraintStatementsForRelationship(EORelationship relationship) {
            if (!relationship.isToMany() && this.isPrimaryKeyAttributes(relationship.destinationEntity(), relationship.destinationAttributes())) {
                StringBuffer sql = new StringBuffer();
                String tableName = relationship.entity().externalName();
                sql.append("ALTER TABLE ");
                sql.append(ERDerbyPlugIn.quoteTableName(tableName.toUpperCase()));
                sql.append(" ADD");
                StringBuffer constraint = new StringBuffer(" CONSTRAINT \"FOREIGN_KEY_");
                constraint.append(tableName);
                StringBuffer fkSql = new StringBuffer(" FOREIGN KEY (");
                NSArray attributes = relationship.sourceAttributes();
                for (int i = 0; i < attributes.count(); ++i) {
                    constraint.append("_");
                    if (i != 0) {
                        fkSql.append(", ");
                    }
                    fkSql.append("\"");
                    String columnName = ((EOAttribute)attributes.objectAtIndex(i)).columnName();
                    fkSql.append(columnName.toUpperCase());
                    constraint.append(columnName);
                    fkSql.append("\"");
                }
                fkSql.append(") REFERENCES ");
                constraint.append("_");
                String referencedExternalName = relationship.destinationEntity().externalName();
                fkSql.append(ERDerbyPlugIn.quoteTableName(referencedExternalName.toUpperCase()));
                constraint.append(referencedExternalName);
                fkSql.append(" (");
                attributes = relationship.destinationAttributes();
                for (int i = 0; i < attributes.count(); ++i) {
                    constraint.append("_");
                    if (i != 0) {
                        fkSql.append(", ");
                    }
                    fkSql.append("\"");
                    String referencedColumnName = ((EOAttribute)attributes.objectAtIndex(i)).columnName();
                    fkSql.append(referencedColumnName.toUpperCase());
                    constraint.append(referencedColumnName);
                    fkSql.append("\"");
                }
                constraint.append("\"");
                fkSql.append(")");
                sql.append(constraint);
                sql.append(fkSql);
                return new NSArray((Object)this._expressionForString(sql.toString()));
            }
            return NSArray.EmptyArray;
        }

        public NSArray primaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
            String pkTable = ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName();
            return new NSArray((Object)this._expressionForString("create table " + pkTable + " (name char(40) primary key, pk INT)"));
        }

        public NSArray statementsToInsertColumnForAttribute(EOAttribute attribute, NSDictionary options) {
            String clause = this._columnCreationClauseForAttribute(attribute);
            System.out.println("alter table " + attribute.entity().externalName() + " add column " + clause);
            NSArray result = new NSArray((Object)this._expressionForString("alter table " + attribute.entity().externalName() + " add column " + clause));
            System.out.println(result);
            return result;
        }

        public boolean supportsSchemaSynchronization() {
            return true;
        }
    }

    public static class DerbyExpression
    extends JDBCExpression {
        public DerbyExpression(EOEntity entity) {
            super(entity);
        }

        public void addCreateClauseForAttribute(EOAttribute attribute) {
            Object defaultValue;
            StringBuffer sql = new StringBuffer();
            sql.append(attribute.columnName());
            sql.append(" ");
            sql.append(this.columnTypeStringForAttribute(attribute));
            NSDictionary userInfo = attribute.userInfo();
            if (userInfo != null && (defaultValue = userInfo.valueForKey("er.extensions.eoattribute.default")) != null) {
                sql.append(" DEFAULT ");
                sql.append(this.formatValueForAttribute(defaultValue, attribute));
            }
            sql.append(" ");
            sql.append(this.allowsNullClauseForConstraint(attribute.allowsNull()));
            this.appendItemToListString(sql.toString(), this._listString());
        }

        protected boolean enableBooleanQuoting() {
            return false;
        }

        private String fixBigDecimal(BigDecimal value, EOAttribute eoattribute) {
            String result;
            if (System.getProperty("java.version").compareTo("1.5") >= 0) {
                try {
                    if (_bigDecimalToString == null) {
                        _bigDecimalToString = BigDecimal.class.getMethod("toPlainString", null);
                    }
                    result = (String)_bigDecimalToString.invoke((Object)value, (Object[])null);
                }
                catch (IllegalArgumentException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                catch (SecurityException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            } else {
                result = value.toString();
            }
            return result;
        }

        public String formatValueForAttribute(Object obj, EOAttribute eoattribute) {
            String value;
            if (obj instanceof NSData) {
                value = this.sqlStringForData((NSData)obj);
            } else if (obj instanceof NSTimestamp && this.isTimestampAttribute(eoattribute)) {
                value = "'" + TIMESTAMP_FORMATTER.format(obj) + "'";
            } else if (obj instanceof NSTimestamp && this.isDateAttribute(eoattribute)) {
                value = "'" + DATE_FORMATTER.format(obj) + "'";
            } else if (obj instanceof String) {
                value = this.formatStringValue((String)obj);
            } else if (obj instanceof Number) {
                String valueType;
                Object convertedObj;
                value = obj instanceof BigDecimal ? this.fixBigDecimal((BigDecimal)obj, eoattribute) : ((convertedObj = eoattribute.adaptorValueByConvertingAttributeValue(obj)) instanceof Number ? ((valueType = eoattribute.valueType()) == null || "i".equals(valueType) ? String.valueOf(((Number)convertedObj).intValue()) : ("l".equals(valueType) ? String.valueOf(((Number)convertedObj).longValue()) : ("f".equals(valueType) ? String.valueOf(((Number)convertedObj).floatValue()) : ("d".equals(valueType) ? String.valueOf(((Number)convertedObj).doubleValue()) : ("s".equals(valueType) ? String.valueOf(((Number)convertedObj).shortValue()) : convertedObj.toString()))))) : convertedObj.toString());
            } else if (obj instanceof Boolean) {
                value = this.enableBooleanQuoting() ? "'" + ((Boolean)obj).toString() + "'" : ((Boolean)obj).toString();
            } else if (obj instanceof Timestamp) {
                value = "'" + ((Timestamp)obj).toString() + "'";
            } else if (obj == null || obj == NSKeyValueCoding.NullValue) {
                value = "NULL";
            } else {
                try {
                    Object adaptorValue = eoattribute.adaptorValueByConvertingAttributeValue(obj);
                    if (adaptorValue instanceof NSData || adaptorValue instanceof NSTimestamp || adaptorValue instanceof String || adaptorValue instanceof Number || adaptorValue instanceof Boolean) {
                        value = this.formatValueForAttribute(adaptorValue, eoattribute);
                    } else {
                        NSLog.err.appendln((Object)(((Object)((Object)this)).getClass().getName() + ": Can't convert: " + obj + ":" + obj.getClass() + " -> " + adaptorValue + ":" + adaptorValue.getClass()));
                        value = obj.toString();
                    }
                }
                catch (Exception ex) {
                    NSLog.err.appendln((Object)(((Object)((Object)this)).getClass().getName() + ": Exception while converting " + obj.getClass().getName()));
                    NSLog.err.appendln((Throwable)ex);
                    value = obj.toString();
                }
            }
            return value;
        }

        private boolean isDateAttribute(EOAttribute eoattribute) {
            return "D".equals(eoattribute.valueType());
        }

        private boolean isTimestampAttribute(EOAttribute eoattribute) {
            return "T".equals(eoattribute.valueType());
        }
    }
}

