/*
 * Decompiled with CFR 0.152.
 */
package er.fsadaptor;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.fsadaptor.FSQualifierHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class FSAdaptorChannel
extends EOAdaptorChannel {
    public static boolean debug = "YES".equals(System.getProperty("FSAdaptorDebuggingEnabled"));
    private static final String DefaultModelName = "FS.eomodeld";
    private static final String[] TableNames = new String[]{"FSItem", "FSFile", "FSDirectory"};
    private boolean _isOpen = false;
    private NSArray _attributes = null;
    private final NSMutableArray _files = new NSMutableArray();

    public FSAdaptorChannel(EOAdaptorContext aContext) {
        super(aContext);
    }

    private NSMutableArray files() {
        return this._files;
    }

    public NSArray attributesToFetch() {
        return this._attributes;
    }

    public void cancelFetch() {
        this.files().removeAllObjects();
    }

    public void closeChannel() {
        this._isOpen = false;
    }

    public int deleteRowsDescribedByQualifier(EOQualifier aQualifier, EOEntity anEntity) {
        if (aQualifier != null) {
            if (anEntity != null) {
                NSArray someFiles = FSQualifierHandler.filesWithQualifier(aQualifier, this.rootDirectory(anEntity));
                if (someFiles != null && (someFiles = this.filteredArrayWithEntity(someFiles, anEntity)) != null) {
                    int count = someFiles.count();
                    int counter = 0;
                    for (int index = 0; index < count; ++index) {
                        File aFile = (File)someFiles.objectAtIndex(index);
                        if (!aFile.delete()) continue;
                        ++counter;
                    }
                    return counter;
                }
                return 0;
            }
            throw new IllegalArgumentException("FSAdaptorChannel.deleteRowsDescribedByQualifier: null entity.");
        }
        throw new IllegalArgumentException("FSAdaptorChannel.deleteRowsDescribedByQualifier: null qualifier.");
    }

    public NSArray describeResults() {
        return this._attributes;
    }

    public void evaluateExpression(EOSQLExpression anExpression) {
        throw new UnsupportedOperationException("FSAdaptorChannel.evaluateExpression");
    }

    public void executeStoredProcedure(EOStoredProcedure aStoredProcedure, NSDictionary someValues) {
        throw new UnsupportedOperationException("FSAdaptorChannel.executeStoredProcedure");
    }

    public NSMutableDictionary fetchRow() {
        File aFile = (File)this.files().lastObject();
        if (aFile != null) {
            this.files().removeLastObject();
            return this.dictionaryForFileWithAttributes(aFile, this.attributesToFetch());
        }
        return null;
    }

    public void insertRow(NSDictionary aRow, EOEntity anEntity) {
        if (aRow != null) {
            if (anEntity != null) {
                String aPath = (String)aRow.objectForKey((Object)"absolutePath");
                if (aPath != null) {
                    File aFile = new File(aPath);
                    try {
                        if (anEntity.externalName().equals("FSDirectory")) {
                            aFile.mkdirs();
                        } else {
                            aFile.createNewFile();
                        }
                    }
                    catch (Exception anException) {
                        throw new RuntimeException("FSAdaptorChannel.insertRow: " + anException);
                    }
                    return;
                }
                throw new IllegalArgumentException("FSAdaptorChannel.insertRow: null absolutePath.");
            }
            throw new IllegalArgumentException("FSAdaptorChannel.insertRow: null entity.");
        }
        throw new IllegalArgumentException("FSAdaptorChannel.insertRow: null row.");
    }

    public boolean isFetchInProgress() {
        return this.files().count() > 0;
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public void openChannel() {
        this._isOpen = true;
    }

    public NSDictionary returnValuesForLastStoredProcedureInvocation() {
        throw new UnsupportedOperationException("FSAdaptorChannel.returnValuesForLastStoredProcedureInvocation");
    }

    public String rootDirectory(EOEntity entity) {
        String root = (String)entity.model().connectionDictionary().objectForKey((Object)"rootDirectory");
        if (root == null) {
            root = "";
        }
        return root;
    }

    public void selectAttributes(NSArray someAttributes, EOFetchSpecification aFetchSpecification, boolean shouldLock, EOEntity anEntity) {
        NSArray someFiles;
        if (anEntity == null) {
            throw new IllegalArgumentException("FSAdaptorChannel.selectAttributes: null entity.");
        }
        if (someAttributes == null) {
            throw new IllegalArgumentException("FSAdaptorChannel.selectAttributes: null attributes.");
        }
        this.setAttributesToFetch(someAttributes);
        EOQualifier qualifier = null;
        String entityName = anEntity.name();
        if (aFetchSpecification != null) {
            qualifier = aFetchSpecification.qualifier();
        }
        if (debug) {
            System.out.println("*****selectAttributes: " + entityName + "--" + aFetchSpecification.entityName() + "--" + aFetchSpecification);
        }
        if ((someFiles = FSQualifierHandler.filesWithQualifier(qualifier, this.rootDirectory(anEntity))) != null) {
            NSArray someSortOrderings = aFetchSpecification.sortOrderings();
            if (someSortOrderings != null) {
                someFiles = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)someFiles, (NSArray)someSortOrderings);
            }
            if ((someFiles = this.filteredArrayWithEntity(someFiles, anEntity)) != null) {
                this.files().addObjectsFromArray(someFiles);
            }
        }
    }

    public void setAttributesToFetch(NSArray someAttributes) {
        if (someAttributes == null) {
            throw new IllegalArgumentException("FSAdaptorChannel.setAttributesToFetch: null attributes.");
        }
        this._attributes = someAttributes;
    }

    public int updateValuesInRowsDescribedByQualifier(NSDictionary aRow, EOQualifier aQualifier, EOEntity anEntity) {
        if (aRow != null) {
            if (aQualifier != null) {
                if (anEntity != null) {
                    NSArray someFiles = FSQualifierHandler.filesWithQualifier(aQualifier, this.rootDirectory(anEntity));
                    if (someFiles != null && (someFiles = this.filteredArrayWithEntity(someFiles, anEntity)) != null) {
                        int count = someFiles.count();
                        for (int index = 0; index < count; ++index) {
                            File aFile = (File)someFiles.objectAtIndex(index);
                            NSArray someKeys = aRow.allKeys();
                            int keyCount = someKeys.count();
                            for (int keyIndex = 0; keyIndex < keyCount; ++keyIndex) {
                                Object aKey = someKeys.objectAtIndex(keyIndex);
                                EOAttribute anAttribute = anEntity.attributeNamed(aKey.toString());
                                if (anAttribute == null) continue;
                                Object aValue = aRow.objectForKey(aKey);
                                NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)aFile, (Object)aValue, (String)anAttribute.columnName());
                            }
                        }
                        return count;
                    }
                    return 0;
                }
                throw new IllegalArgumentException("FSAdaptorChannel.updateValuesInRowsDescribedByQualifier: null entity.");
            }
            throw new IllegalArgumentException("FSAdaptorChannel.updateValuesInRowsDescribedByQualifier: null qualifier.");
        }
        throw new IllegalArgumentException("FSAdaptorChannel.updateValuesInRowsDescribedByQualifier: null row.");
    }

    private String defaultModelPath() {
        Class<?> aClass = ((Object)((Object)this)).getClass();
        String aClassName = aClass.getName();
        String aResourceName = "/" + aClassName.replace('.', '/') + ".class";
        URL anURL = aClass.getResource(aResourceName);
        if (anURL != null) {
            String aPath = anURL.getFile();
            String aPrefix = "file:/";
            String aSeparator = "!";
            int anIndex = aPath.indexOf(aPrefix);
            if (anIndex != -1) {
                aPath = aPath.substring(anIndex - 1 + aPrefix.length(), aPath.length() - 1);
            }
            if ((anIndex = aPath.indexOf(aSeparator)) != -1) {
                aPath = aPath.substring(0, anIndex);
            }
            File aFile = new File(aPath);
            File aModelFile = new File(new File(aFile.getParent()).getParent() + "/FS", DefaultModelName);
            if (debug) {
                System.out.println(aFile);
            }
            if (debug) {
                System.out.println(aModelFile);
            }
            return aModelFile.getAbsolutePath();
        }
        return null;
    }

    public NSArray describeTableNames() {
        return new NSArray((Object[])TableNames);
    }

    public EOModel describeModelWithTableNames(NSArray anArray) {
        return new EOModel(this.defaultModelPath());
    }

    private NSArray filteredArrayWithEntity(NSArray anArray, EOEntity anEntity) {
        if (anArray != null) {
            if (anEntity != null) {
                String anEntityName = anEntity.externalName();
                if (debug) {
                    System.out.println("filteredArrayWithEntity: " + anEntity.name() + "/" + anEntityName + " --- " + anArray);
                }
                if (!anEntityName.equals("FSItem")) {
                    Boolean isDirectory = Boolean.FALSE;
                    if (anEntityName.equals("FSDirectory")) {
                        isDirectory = Boolean.TRUE;
                    }
                    anArray = EOQualifier.filteredArrayWithQualifier((NSArray)anArray, (EOQualifier)new EOKeyValueQualifier("isDirectory", EOQualifier.QualifierOperatorEqual, (Object)isDirectory));
                }
                if (anArray != null && anArray.count() > 0) {
                    return anArray;
                }
                return null;
            }
            throw new IllegalArgumentException("FSAdaptorChannel.filteredArrayWithEntity: null entity.");
        }
        throw new IllegalArgumentException("FSAdaptorChannel.filteredArrayWithEntity: null array.");
    }

    private NSMutableDictionary dictionaryForFileWithAttributes(File aFile, NSArray someAttributes) {
        if (aFile != null) {
            if (someAttributes != null) {
                NSMutableDictionary aDictionary = new NSMutableDictionary();
                int count = someAttributes.count();
                for (int index = 0; index < count; ++index) {
                    EOAttribute anAttribute = (EOAttribute)someAttributes.objectAtIndex(index);
                    String columnName = anAttribute.columnName();
                    Object aValue = null;
                    if ("content".equals(columnName)) {
                        try {
                            String path = aFile.getAbsolutePath();
                            FileInputStream in = new FileInputStream(path);
                            if (null == in) {
                                throw new RuntimeException("The file '" + path + "' can not be opened.");
                            }
                            int length = ((InputStream)in).available();
                            if (length == 0) {
                                aValue = "";
                            }
                            byte[] buffer = new byte[length];
                            ((InputStream)in).read(buffer);
                            ((InputStream)in).close();
                            aValue = new String(buffer);
                        }
                        catch (IOException ex) {
                            System.err.println("dictionaryForFileWithAttributes : (" + aFile.getName() + ") " + ex);
                        }
                    } else {
                        aValue = "realFile".equals(columnName) ? aFile : NSKeyValueCoding.DefaultImplementation.valueForKey((Object)aFile, (String)columnName);
                    }
                    if (aValue == null) {
                        aValue = NSKeyValueCoding.NullValue;
                    }
                    aDictionary.setObjectForKey(aValue, (Object)anAttribute.name());
                }
                return aDictionary;
            }
            throw new IllegalArgumentException("FSAdaptorChannel.dictionaryForFileWithAttributes: null attributes.");
        }
        throw new IllegalArgumentException("FSAdaptorChannel.dictionaryForFileWithAttributes: null file.");
    }
}

