/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._ideservices;

import com.webobjects._ideservices._IDEProject;
import com.webobjects._ideservices._WOProject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.development.NSProjectBundle;
import com.webobjects.foundation.development.NSResourceType;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _NSProjectBundleIDEProject
implements _IDEProject {
    private NSProjectBundle _bundle;
    private List<Resource> _resources;
    private File _versionFile;
    private long _lastRefreshTime;

    public _NSProjectBundleIDEProject(NSProjectBundle bundle) {
        this._bundle = bundle;
        this._versionFile = new File(this._bundle.projectPath(), ".version");
        if (!this._versionFile.exists()) {
            this._versionFile = new File(this._bundle.projectPath(), "woproject/.version");
            if (!this._versionFile.exists()) {
                this._versionFile = null;
            }
        }
    }

    @Override
    public String projectDir() {
        return this._bundle.bundlePath();
    }

    @Override
    public String projectDirNotNormalized() {
        return this._bundle.bundlePath();
    }

    @Override
    public String languageDir() {
        return null;
    }

    @Override
    public String projectName() {
        return this._bundle.name();
    }

    @Override
    public String projectTypeName() {
        return "NSProjectBundle";
    }

    @Override
    public String languageName() {
        return System.getProperty("user.language");
    }

    @Override
    public void addComponent(String componentDirectoryString, String javaFileString) {
        System.out.println("_NSProjectBundleIDEProject.addComponent: " + componentDirectoryString + "," + javaFileString);
    }

    @Override
    public String pathToBucket(String aKey) {
        System.out.println("_NSProjectBundleIDEProject.pathToBucket: " + aKey);
        return null;
    }

    @Override
    public void addFileKey(String aFile, String aKey) {
        System.out.println("_NSProjectBundleIDEProject.addFileKey: " + aFile + ", " + aKey);
    }

    @Override
    public void openFile(String aFile, int lineNumber, String message) {
        System.out.println("_NSProjectBundleIDEProject.openFile: " + aFile + "," + lineNumber + "," + message);
    }

    @Override
    public String pathForFrameworkNamed(String fwName) {
        System.out.println("_NSProjectBundleIDEProject.pathForFrameworkNamed: " + fwName);
        return null;
    }

    @Override
    public void setPathForFramework(String path, String fwName) {
        System.out.println("_NSProjectBundleIDEProject.setPathForFramework: " + path + "," + fwName);
    }

    @Override
    public synchronized void extractFilesIntoWOProject(_WOProject woProject) {
        boolean shouldRefreshResources;
        boolean bl = shouldRefreshResources = this._resources == null;
        if (shouldRefreshResources) {
            HashSet relativePaths = new HashSet();
            relativePaths.addAll(this._bundle.relativePathForResourceType(NSResourceType.Other));
            LinkedList<Resource> resources = new LinkedList<Resource>();
            for (String relativePath : relativePaths) {
                this.extractFilesIntoWOProject(woProject, relativePath, relativePath, resources);
            }
            this._resources = resources;
            this._lastRefreshTime = System.currentTimeMillis();
        }
        for (Resource resource : this._resources) {
            woProject.addResource(resource.name(), resource.resourcePath(), resource.language());
        }
    }

    protected boolean isBundleFolder(File folder) {
        String name = folder.getName();
        return name.endsWith(".wo") || name.endsWith(".eomodeld");
    }

    protected boolean isIgnoredFolder(File folder) {
        String name = folder.getName();
        return name.equals("CVS") || name.equals(".git") || name.equals(".svn");
    }

    public void extractFilesIntoWOProject(_WOProject woProject, String initialPath, String relativePath, List<Resource> resources) {
        File folder = new File(this._bundle.bundlePath(), relativePath);
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory() && !this.isBundleFolder(file)) {
                    if (!this.isIgnoredFolder(file)) {
                        this.extractFilesIntoWOProject(woProject, initialPath, String.valueOf(relativePath) + File.separator + file.getName(), resources);
                    }
                } else {
                    String resourcePath = file.getPath();
                    String name = NSPathUtilities.lastPathComponent((String)resourcePath);
                    String language = _WOProject.languageFromResourcePath(resourcePath);
                    resources.add(new Resource(name, resourcePath, language));
                    if (initialPath.length() > 0 && relativePath.length() > 0 && initialPath.length() != relativePath.length()) {
                        String subdirName = String.valueOf(relativePath.substring(initialPath.length() + 1)) + File.separator + name;
                        NSArray pathComponents = NSArray.componentsSeparatedByString((String)subdirName, (String)File.separator);
                        if (((String)pathComponents.objectAtIndex(0)).endsWith(".lproj")) {
                            if (pathComponents.count() > 2) {
                                pathComponents = pathComponents.subarrayWithRange(new NSRange(1, pathComponents.count() - 1));
                                subdirName = pathComponents.componentsJoinedByString(File.separator);
                            } else {
                                subdirName = null;
                            }
                        }
                        if (subdirName != null) {
                            resources.add(new Resource(subdirName, resourcePath, language));
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public String ideApplicationName() {
        return this._bundle.getClass().getSimpleName();
    }

    @Override
    public String ideProjectPath() {
        return this._bundle.bundlePath();
    }

    @Override
    public NSArray frameworkBundlePaths() {
        return null;
    }

    @Override
    public NSArray frameworkBundlePathURLs() {
        return null;
    }

    @Override
    public void addFilenameExtensionToListOfKnowns(String anExtension) {
    }

    @Override
    public synchronized void refreshUnderlyingProjectCache() {
        if (this._versionFile != null && this._versionFile.lastModified() > this._lastRefreshTime) {
            this._resources = null;
        } else if (System.currentTimeMillis() - this._lastRefreshTime > NSProperties.longForKeyWithDefault((String)"NSProjectBundleRefreshTime", (long)60000L)) {
            this._resources = null;
        }
    }

    @Override
    public String bundlePath() {
        return this._bundle.bundlePath();
    }

    @Override
    public URL bundlePathURL() {
        return this._bundle.bundlePathURL();
    }

    @Override
    public boolean shouldPreloadResources() {
        return false;
    }

    private static class Resource {
        private String _name;
        private String _resourcePath;
        private String _language;

        public Resource(String name, String resourcePath, String language) {
            this._name = name;
            this._resourcePath = resourcePath;
            this._language = language;
        }

        public String name() {
            return this._name;
        }

        public String resourcePath() {
            return this._resourcePath;
        }

        public String language() {
            return this._language;
        }
    }
}

