/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker.mail;

import java.io.IOException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.log4j.Logger;

public class MailReader
extends Thread {
    private boolean running = true;
    private static final Logger log = Logger.getLogger(MailReader.class);
    private String server;
    private String user;
    private String password;
    private String queueName;

    public MailReader(String queue) {
        super("MailReader");
        this.queueName = queue;
        this.server = this.getProperty(queue, "server");
        this.user = this.getProperty(queue, "user");
        this.password = this.getProperty(queue, "password");
    }

    private String getProperty(String queue, String key, String defaultValue) {
        String propertyKey = "BugTracker." + queue + "." + key;
        if (queue == null) {
            propertyKey = "BugTracker." + key;
        }
        return System.getProperty(propertyKey, defaultValue);
    }

    private String getProperty(String queue, String key) {
        return this.getProperty(queue, key, null);
    }

    public String queueName() {
        return this.queueName;
    }

    public void stopReader() {
        this.running = false;
    }

    public void startReader() {
        this.start();
    }

    private Message readMessages(String server, String user, String password) throws MessagingException, IOException {
        Store store = null;
        Folder folder = null;
        try {
            Properties props = System.getProperties();
            Session session = Session.getDefaultInstance((Properties)props, null);
            String storeName = this.getProperty(null, "mailStore", "imap");
            store = session.getStore(storeName);
            store.connect(server, user, password);
            folder = store.getDefaultFolder();
            if (folder == null) {
                throw new IllegalStateException("No default folder");
            }
            if ((folder = folder.getFolder("INBOX")) == null) {
                throw new IllegalStateException("No " + storeName + " INBOX");
            }
            folder.open(2);
            Message[] messages = folder.getMessages();
            log.debug((Object)("Checking INBOX: " + messages.length));
            for (int i = 0; i < messages.length; ++i) {
                Message m = messages[i];
                Message result = this.processMessage(m);
                if (result == null) continue;
                Message message = result;
                return message;
            }
        }
        catch (AuthenticationFailedException e) {
            log.error((Object)("Mail setup wrong: " + server + ", " + user + ", " + password), (Throwable)e);
            throw e;
        }
        finally {
            if (folder != null && folder.isOpen()) {
                folder.close(true);
            }
            if (store != null && store.isConnected()) {
                store.close();
            }
        }
        return null;
    }

    private Message processMessage(Message message) throws MessagingException, IOException {
        log.info((Object)("Processing mail: " + message.getSubject()));
        Address[] senders = message.getFrom();
        if (senders.length > 0) {
            Address sender = senders[0];
            log.info((Object)sender);
            Object content = message.getContent();
            if (content instanceof Multipart) {
                this.handleMultipart((Multipart)content);
            } else {
                this.handlePart(message);
            }
        }
        return message;
    }

    private void handlePart(Message message) {
    }

    private void handleMultipart(Multipart multipart) {
    }

    public void run() {
        while (this.running) {
            try {
                this.readMessages(this.server, this.user, this.password);
                Thread.sleep(5000L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                this.running = false;
            }
        }
    }
}

