/*
 * Decompiled with CFR 0.152.
 */
package er.calendar;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.calendar.ERCalendarEvent;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;

public class ERPublishCalendarPage
extends WOComponent {
    protected String calendarName;
    protected String calendarTimeZone;
    protected final int maxLineLength = 75;
    public static String newline = System.getProperty("line.separator");
    protected NSMutableArray events = new NSMutableArray();
    public ERCalendarEvent event;
    protected NSTimestamp eventTimestamp;
    protected NSTimestampFormatter dateTimeFormatter;
    protected NSTimestampFormatter dateFormatter;
    protected NSTimestampFormatter utcDateTimeFormatter;
    protected NSTimestampFormatter timeZoneFormatter;

    public ERPublishCalendarPage(WOContext context) {
        super(context);
        this.calendarTimeZone = new NSTimestampFormatter("%Z").format((Object)new NSTimestamp());
        this.dateTimeFormatter = new NSTimestampFormatter("%Y%m%dT%H%M%S");
        this.dateTimeFormatter.setDefaultFormatTimeZone(NSTimeZone.localTimeZone());
        this.dateFormatter = new NSTimestampFormatter("%Y%m%d");
        this.dateFormatter.setDefaultFormatTimeZone(NSTimeZone.localTimeZone());
        this.utcDateTimeFormatter = new NSTimestampFormatter("%Y%m%dT%H%M%SZ");
        this.utcDateTimeFormatter.setDefaultFormatTimeZone(NSTimeZone.timeZoneWithName((String)"UTC", (boolean)false));
        this.timeZoneFormatter = new NSTimestampFormatter("%Z");
        this.timeZoneFormatter.setDefaultFormatTimeZone(NSTimeZone.localTimeZone());
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        this.eventTimestamp = new NSTimestamp();
        aResponse.setContentEncoding("UTF-8");
        super.appendToResponse(aResponse, aContext);
        aResponse.setHeader("text/calendar", "content-type");
        try {
            aResponse.setContent(new NSData(this.foldLongLinesInString(new String(aResponse.content().bytes(), "UTF-8")).getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void addEvent(ERCalendarEvent event) {
        this.events.addObject((Object)event);
    }

    public void addEventsFromArray(NSArray eventsArray) {
        this.events.addObjectsFromArray(eventsArray);
    }

    public void removeEvent(ERCalendarEvent event) {
        this.events.removeObject((Object)event);
    }

    public void removeEventsInArray(NSArray eventsArray) {
        this.events.removeObjectsInArray(eventsArray);
    }

    public NSMutableArray events() {
        return this.events;
    }

    public String calendarName() {
        return this.calendarName;
    }

    public String escapedCalendarName() {
        return this.escapedString(this.calendarName);
    }

    public void setCalendarName(String value) {
        this.calendarName = value;
    }

    public String calendarTimeZone() {
        return this.calendarTimeZone;
    }

    public String escapedCalendarTimeZone() {
        return this.escapedString(this.calendarTimeZone);
    }

    public void setCalendarTimeZone(String value) {
        this.calendarTimeZone = value;
    }

    public String escapedEventStatus() {
        return this.escapedString(this.event.status());
    }

    public String escapedEventSummary() {
        return this.escapedString(this.event.summary());
    }

    public String escapedEventUniqueId() {
        return this.escapedString(this.event.uniqueId());
    }

    public NSTimestamp eventTimestamp() {
        return this.eventTimestamp;
    }

    public String eventRepeatFrequency() {
        switch (this.event.repeatFrequency()) {
            case 1: {
                return "YEARLY";
            }
            case 2: {
                return "MONTHLY";
            }
            case 3: {
                return "WEEKLY";
            }
            case 5: {
                return "DAILY";
            }
            case 11: {
                return "HOURLY";
            }
            case 12: {
                return "MINUTELY";
            }
            case 13: {
                return "SECONDLY";
            }
        }
        return null;
    }

    public Number eventRepeatMonth() {
        GregorianCalendar calendarDate = new GregorianCalendar();
        calendarDate.setTime((Date)this.event.startTime());
        return new Integer(calendarDate.get(2) + 1);
    }

    public String eventRepeatDayOfWeekString() {
        String byDay = "";
        if (this.event.repeatDayOfWeekInMonth() != 0) {
            byDay = new Integer(this.event.repeatDayOfWeekInMonth()).toString();
        }
        switch (this.event.repeatDayOfWeek()) {
            case 1: {
                byDay = byDay + "SU";
                break;
            }
            case 2: {
                byDay = byDay + "MO";
                break;
            }
            case 3: {
                byDay = byDay + "TU";
                break;
            }
            case 4: {
                byDay = byDay + "WE";
                break;
            }
            case 5: {
                byDay = byDay + "TH";
                break;
            }
            case 6: {
                byDay = byDay + "FR";
                break;
            }
            case 7: {
                byDay = byDay + "SA";
            }
        }
        return byDay;
    }

    public String eventRepeatDaysOfMonthString() {
        return this.event.repeatDaysOfMonth().componentsJoinedByString(",");
    }

    public NSTimestampFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public NSTimestampFormatter dateFormatter() {
        return this.dateFormatter;
    }

    public NSTimestampFormatter utcDateTimeFormatter() {
        return this.utcDateTimeFormatter;
    }

    public NSTimestampFormatter timeZoneFormatter() {
        return this.timeZoneFormatter;
    }

    protected String escapedString(String string) {
        StringBuffer escapedString = new StringBuffer(string);
        block4: for (int index = escapedString.length() - 1; index >= 0; --index) {
            switch (escapedString.charAt(index)) {
                case '\"': 
                case ',': 
                case ':': 
                case ';': 
                case '\\': {
                    escapedString.insert(index, '\\');
                    continue block4;
                }
                case '\n': {
                    escapedString.setCharAt(index, 'n');
                    escapedString.insert(index, '\\');
                }
            }
        }
        return escapedString.toString();
    }

    protected String foldLongLinesInString(String content) {
        Enumeration enumerator = NSArray.componentsSeparatedByString((String)content, (String)newline).objectEnumerator();
        NSMutableArray foldedContent = new NSMutableArray();
        while (enumerator.hasMoreElements()) {
            String line = (String)enumerator.nextElement();
            while (line.length() > 75) {
                foldedContent.addObject((Object)line.substring(0, 75));
                line = " " + line.substring(75);
            }
            foldedContent.addObject((Object)line);
        }
        return foldedContent.componentsJoinedByString(newline);
    }
}

