/*
 * Decompiled with CFR 0.152.
 */
package com.meetup.memcached.test;

import com.meetup.memcached.MemcachedClient;
import com.meetup.memcached.SockIOPool;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MemcachedBench {
    private static Logger log = Logger.getLogger((String)MemcachedBench.class.getName());

    public static void main(String[] args) {
        String str;
        int i;
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.OFF);
        int runs = Integer.parseInt(args[0]);
        int start = Integer.parseInt(args[1]);
        String[] serverlist = new String[]{"127.0.0.1:12346"};
        SockIOPool pool = SockIOPool.getInstance("test");
        pool.setServers(serverlist);
        pool.setInitConn(100);
        pool.setMinConn(100);
        pool.setMaxConn(500);
        pool.setMaintSleep(20L);
        pool.setNagle(false);
        pool.initialize();
        MemcachedClient mc = new MemcachedClient("test");
        mc.setCompressEnable(false);
        String keyBase = "testKey";
        String object = "This is a test of an object blah blah es, serialization does not seem to slow things down so much.  The gzip compression is horrible horrible performance, so we only use it for very large objects.  I have not done any heavy benchmarking recently";
        long begin = System.currentTimeMillis();
        for (int i2 = start; i2 < start + runs; ++i2) {
            mc.set(keyBase + i2, object);
        }
        long end = System.currentTimeMillis();
        long time = end - begin;
        System.out.println(runs + " sets: " + time + "ms");
        begin = System.currentTimeMillis();
        for (i = start; i < start + runs; ++i) {
            str = (String)mc.get(keyBase + i);
        }
        end = System.currentTimeMillis();
        time = end - begin;
        System.out.println(runs + " gets: " + time + "ms");
        begin = System.currentTimeMillis();
        for (i = start; i < start + runs; ++i) {
            str = (String)mc.get(keyBase + i);
        }
        end = System.currentTimeMillis();
        time = end - begin;
        System.out.println(runs + " gets again: " + time + "ms");
        String[] keys = new String[runs];
        int j = 0;
        for (int i3 = start; i3 < start + runs; ++i3) {
            keys[j] = keyBase + i3;
            ++j;
        }
        begin = System.currentTimeMillis();
        Map<String, Object> vals = mc.getMulti(keys);
        end = System.currentTimeMillis();
        time = end - begin;
        System.out.println(runs + " getMulti: " + time + "ms");
        begin = System.currentTimeMillis();
        for (int i4 = start; i4 < start + runs; ++i4) {
            mc.delete(keyBase + i4);
        }
        end = System.currentTimeMillis();
        time = end - begin;
        System.out.println(runs + " deletes: " + time + "ms");
        System.out.println(mc.stats());
        SockIOPool.getInstance("test").shutDown();
    }
}

