/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached;

import com.thimbleware.jmemcached.CommandMessage;
import com.thimbleware.jmemcached.Commands;
import com.thimbleware.jmemcached.MCElement;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoderAdapter;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandDecoder
extends MessageDecoderAdapter {
    private static final int THIRTY_DAYS = 2592000;
    public static CharsetDecoder DECODER = Charset.forName("US-ASCII").newDecoder();
    private static final int WORD_BUFFER_INIT_SIZE = 16;
    private static final String SESSION_STATUS = "sessionStatus";

    public final MessageDecoderResult decodable(IoSession session, ByteBuffer in) {
        SessionStatus sessionStatus = (SessionStatus)session.getAttribute(SESSION_STATUS);
        if (sessionStatus != null && sessionStatus.state == SessionState.WAITING_FOR_DATA && in.remaining() < sessionStatus.bytesNeeded + 2) {
            return MessageDecoderResult.NEED_DATA;
        }
        return MessageDecoderResult.OK;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final MessageDecoderResult decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        SessionStatus returnedSessionStatus;
        SessionStatus sessionStatus = (SessionStatus)session.getAttribute(SESSION_STATUS);
        if (sessionStatus != null && sessionStatus.state == SessionState.WAITING_FOR_DATA) {
            if (in.remaining() < sessionStatus.bytesNeeded + 2) {
                return MessageDecoderResult.NEED_DATA;
            }
            byte[] buffer = new byte[sessionStatus.bytesNeeded];
            in.get(buffer);
            String crlf = in.getString(2, DECODER);
            if (!crlf.equals("\r\n")) {
                session.setAttribute(SESSION_STATUS, (Object)new SessionStatus(SessionState.READY));
                return MessageDecoderResult.NOT_OK;
            }
            returnedSessionStatus = this.continueSet(session, out, sessionStatus, buffer);
        } else {
            StringBuffer wordBuffer = new StringBuffer(16);
            ArrayList<String> words = new ArrayList<String>(8);
            in.mark();
            boolean completed = false;
            int i = 0;
            while (in.hasRemaining()) {
                char c = (char)in.get();
                if (c == ' ') {
                    words.add(wordBuffer.toString());
                    wordBuffer = new StringBuffer(16);
                    ++i;
                    continue;
                }
                if (c == '\r' && in.hasRemaining() && in.get() == 10) {
                    if (wordBuffer.length() != 0) {
                        words.add(wordBuffer.toString());
                    }
                    completed = true;
                    break;
                }
                wordBuffer.append(c);
                ++i;
            }
            if (!completed) {
                in.reset();
                return MessageDecoderResult.NEED_DATA;
            }
            returnedSessionStatus = this.processLine(words, session, out);
        }
        if (returnedSessionStatus.state != SessionState.ERROR) {
            session.setAttribute(SESSION_STATUS, (Object)returnedSessionStatus);
            return MessageDecoderResult.OK;
        }
        return MessageDecoderResult.NOT_OK;
    }

    private SessionStatus processLine(List<String> parts, IoSession session, ProtocolDecoderOutput out) {
        CommandMessage cmd = new CommandMessage(parts.get(0).toUpperCase().intern());
        if (cmd.cmd == Commands.ADD || cmd.cmd == Commands.SET || cmd.cmd == Commands.REPLACE || cmd.cmd == Commands.CAS || cmd.cmd == Commands.APPEND || cmd.cmd == Commands.PREPEND) {
            if (parts.size() < 5) {
                return new SessionStatus(SessionState.ERROR);
            }
            int size = Integer.parseInt(parts.get(4));
            cmd.element = new MCElement();
            cmd.element.keystring = parts.get(1);
            cmd.element.flags = parts.get(2);
            cmd.element.expire = Integer.parseInt(parts.get(3));
            if (cmd.element.expire != 0 && cmd.element.expire <= 2592000) {
                cmd.element.expire += this.Now();
            }
            cmd.element.data_length = size;
            if (parts.size() > 5) {
                int noreply;
                int n = noreply = cmd.cmd == Commands.CAS ? 6 : 5;
                if (cmd.cmd == Commands.CAS) {
                    cmd.cas_key = Long.valueOf(parts.get(5));
                }
                if (parts.size() == noreply + 1 && parts.get(noreply).equalsIgnoreCase("noreply")) {
                    cmd.noreply = true;
                }
            }
            return new SessionStatus(SessionState.WAITING_FOR_DATA, size, cmd);
        }
        if (cmd.cmd == Commands.GET || cmd.cmd == Commands.GETS || cmd.cmd == Commands.STATS || cmd.cmd == Commands.QUIT || cmd.cmd == Commands.VERSION) {
            cmd.keys.addAll(parts.subList(1, parts.size()));
            out.write((Object)cmd);
        } else if (cmd.cmd == Commands.INCR || cmd.cmd == Commands.DECR) {
            if (parts.size() < 2 || parts.size() > 3) {
                return new SessionStatus(SessionState.ERROR);
            }
            cmd.keys.add(parts.get(1));
            cmd.keys.add(parts.get(2));
            if (parts.size() == 3 && parts.get(2).equalsIgnoreCase("noreply")) {
                cmd.noreply = true;
            }
            out.write((Object)cmd);
        } else if (cmd.cmd == Commands.DELETE) {
            cmd.keys.add(parts.get(1));
            if (parts.size() >= 2) {
                if (parts.get(parts.size() - 1).equalsIgnoreCase("noreply")) {
                    cmd.noreply = true;
                    if (parts.size() == 4) {
                        cmd.time = Integer.valueOf(parts.get(2));
                    }
                } else if (parts.size() == 3) {
                    cmd.time = Integer.valueOf(parts.get(2));
                }
            }
            out.write((Object)cmd);
        } else if (cmd.cmd == Commands.FLUSH_ALL) {
            if (parts.size() >= 1) {
                if (parts.get(parts.size() - 1).equalsIgnoreCase("noreply")) {
                    cmd.noreply = true;
                    if (parts.size() == 3) {
                        cmd.time = Integer.valueOf(parts.get(1));
                    }
                } else if (parts.size() == 2) {
                    cmd.time = Integer.valueOf(parts.get(1));
                }
            }
            out.write((Object)cmd);
        } else {
            return new SessionStatus(SessionState.ERROR);
        }
        return new SessionStatus(SessionState.READY);
    }

    private SessionStatus continueSet(IoSession session, ProtocolDecoderOutput out, SessionStatus state, byte[] remainder) {
        state.cmd.element.data = remainder;
        out.write((Object)state.cmd);
        return new SessionStatus(SessionState.READY);
    }

    public final int Now() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    final class SessionStatus
    implements Serializable {
        public SessionState state;
        public int bytesNeeded;
        public CommandMessage cmd;

        SessionStatus(SessionState state) {
            this.state = state;
        }

        SessionStatus(SessionState state, int bytesNeeded, CommandMessage cmd) {
            this.state = state;
            this.bytesNeeded = bytesNeeded;
            this.cmd = cmd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SessionState {
        ERROR,
        WAITING_FOR_DATA,
        READY;

    }
}

