/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LRUCache<ID_TYPE, ITEM_TYPE> {
    private final Map<ID_TYPE, CacheEntry<ITEM_TYPE>> items;
    private long size = 0L;
    private final long maximumSize;
    private long ceilingSize;
    private int maximumItems;
    private static final int INITIAL_TABLE_SIZE = 2048;

    public LRUCache(final int maximumItems, final long maximumSize, final long ceilingSize) {
        this.maximumItems = maximumItems;
        this.maximumSize = maximumSize;
        this.ceilingSize = ceilingSize;
        this.items = new LinkedHashMap<ID_TYPE, CacheEntry<ITEM_TYPE>>(2048){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ID_TYPE, CacheEntry<ITEM_TYPE>> eldest) {
                if (maximumSize > 0L && LRUCache.this.size + ceilingSize > maximumSize || maximumItems > 0 && this.size() > maximumItems) {
                    LRUCache.this.size -= eldest.getValue().size;
                    return true;
                }
                return false;
            }
        };
    }

    public boolean has(ID_TYPE aId) {
        if (aId == null) {
            throw new IllegalArgumentException("Id must not be null.");
        }
        return this.items.containsKey(aId);
    }

    public ITEM_TYPE get(ID_TYPE aId) {
        Object result;
        if (aId == null) {
            throw new IllegalArgumentException("Id must not be null.");
        }
        if (this.items.containsKey(aId)) {
            result = this.items.get(aId).item;
            if (result == null) {
                throw new IllegalStateException("Stored item should not be null. Id:" + aId);
            }
        } else {
            return null;
        }
        return result;
    }

    public void put(ID_TYPE aId, ITEM_TYPE aItem, long item_size) {
        if (aId == null) {
            throw new IllegalArgumentException("Id must not be null.");
        }
        if (aItem == null) {
            throw new IllegalArgumentException("Item must not be null.");
        }
        if (this.items.containsKey(aId)) {
            this.size -= this.items.get(aId).size;
        }
        this.items.put(aId, new CacheEntry<ITEM_TYPE>(item_size, aItem));
        this.size += item_size;
    }

    public void remove(ID_TYPE key) {
        CacheEntry<ITEM_TYPE> item = this.items.get(key);
        if (item != null) {
            this.items.remove(key);
            this.size -= item.size;
        }
    }

    public void clear() {
        this.items.clear();
        this.size = 0L;
    }

    public Set<ID_TYPE> keys() {
        return this.items.keySet();
    }

    public long count() {
        return this.items.size();
    }

    public int getMaximumItems() {
        return this.maximumItems;
    }

    public long getSize() {
        return this.size;
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public long getCeilingSize() {
        return this.ceilingSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CacheEntry<ITEM_TYPE> {
        long size;
        ITEM_TYPE item;

        CacheEntry(long size, ITEM_TYPE item) {
            this.size = size;
            this.item = item;
        }
    }
}

