/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CommandMessage;
import com.thimbleware.jmemcached.Commands;
import com.thimbleware.jmemcached.MCElement;
import com.thimbleware.jmemcached.ResponseMessage;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerSessionHandler
implements IoHandler {
    final Logger logger = LoggerFactory.getLogger(ServerSessionHandler.class);
    public String version;
    public int curr_conns;
    public int total_conns;
    public int started;
    public static long bytes_read;
    public static long bytes_written;
    public static long curr_bytes;
    public int idle_limit;
    public boolean verbose;
    public static CharsetEncoder ENCODER;
    protected Cache cache;

    public ServerSessionHandler(Cache cache, String memcachedVersion, boolean verbosity, int idle) {
        this.initStats();
        this.cache = cache;
        this.started = this.Now();
        this.version = memcachedVersion;
        this.verbose = verbosity;
        this.idle_limit = idle;
    }

    public void sessionCreated(IoSession session) {
        int conn = this.total_conns++;
        session.setAttribute("sess_id", (Object)String.valueOf(conn));
        ++this.curr_conns;
        if (this.verbose) {
            this.logger.info(session.getAttribute("sess_id") + " CONNECTED");
        }
    }

    public void sessionOpened(IoSession session) {
        if (this.idle_limit > 0) {
            session.setIdleTime(IdleStatus.BOTH_IDLE, this.idle_limit);
        }
        session.setAttribute("waiting_for", (Object)0);
    }

    public void sessionClosed(IoSession session) {
        --this.curr_conns;
        if (this.verbose) {
            this.logger.info(session.getAttribute("sess_id") + " DIS-CONNECTED");
        }
    }

    public void messageReceived(IoSession session, Object message) throws CharacterCodingException {
        int i;
        CommandMessage command = (CommandMessage)message;
        String cmd = command.cmd;
        int cmdKeysSize = command.keys.size();
        this.cache.processDeleteQueue();
        if (this.verbose) {
            StringBuffer log = new StringBuffer();
            log.append(session.getAttribute("sess_id")).append(" ");
            log.append(cmd);
            if (command.element != null) {
                log.append(" ").append(command.element.keystring);
            }
            for (i = 0; i < cmdKeysSize; ++i) {
                log.append(" ").append(command.keys.get(i));
            }
            this.logger.info(log.toString());
        }
        ResponseMessage r = new ResponseMessage();
        if (cmd == Commands.GET || cmd == Commands.GETS) {
            for (i = 0; i < cmdKeysSize; ++i) {
                MCElement result = this.get(command.keys.get(i));
                if (result == null) continue;
                r.out.putString((CharSequence)("VALUE " + result.keystring + " " + result.flags + " " + result.data_length + (cmd == Commands.GETS ? " " + result.cas_unique : "") + "\r\n"), ENCODER);
                r.out.put(result.data, 0, result.data_length);
                r.out.putString((CharSequence)"\r\n", ENCODER);
            }
            r.out.putString((CharSequence)"END\r\n", ENCODER);
        } else if (cmd == Commands.SET) {
            String ret = this.set(command.element);
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else if (cmd == Commands.CAS) {
            String ret = this.cas(command.cas_key, command.element);
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else if (cmd == Commands.ADD) {
            String ret = this.add(command.element);
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else if (cmd == Commands.REPLACE) {
            String ret = this.replace(command.element);
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else if (cmd == Commands.APPEND) {
            String ret = this.append(command.element);
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else if (cmd == Commands.PREPEND) {
            String ret = this.prepend(command.element);
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else if (cmd == Commands.INCR) {
            String ret = this.get_add(command.keys.get(0), Integer.parseInt(command.keys.get(1)));
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else if (cmd == Commands.DECR) {
            String ret = this.get_add(command.keys.get(0), -1 * Integer.parseInt(command.keys.get(1)));
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else if (cmd == Commands.DELETE) {
            String ret = this.delete(command.keys.get(0), command.time);
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else if (cmd == Commands.STATS) {
            String option = "";
            if (cmdKeysSize > 0) {
                option = command.keys.get(0);
            }
            r.out.putString((CharSequence)this.stat(option), ENCODER);
        } else if (cmd == Commands.VERSION) {
            r.out.putString((CharSequence)"VERSION ", ENCODER);
            r.out.putString((CharSequence)this.version, ENCODER);
            r.out.putString((CharSequence)"\r\n", ENCODER);
        } else if (cmd == Commands.QUIT) {
            session.close();
        } else if (cmd == Commands.FLUSH_ALL) {
            String ret = this.flush_all(command.time);
            if (!command.noreply) {
                r.out.putString((CharSequence)ret, ENCODER);
            }
        } else {
            r.out.putString((CharSequence)"ERROR\r\n", ENCODER);
            this.logger.error("error; unrecognized command: " + cmd);
        }
        session.write((Object)r);
    }

    public void messageSent(IoSession session, Object message) {
        if (this.verbose) {
            this.logger.info(session.getAttribute("sess_id") + " SENT");
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        session.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws CharacterCodingException {
        this.logger.error(session.getAttribute("sess_id") + " EXCEPTION", cause);
        ResponseMessage r = new ResponseMessage();
        r.out.putString((CharSequence)"CLIENT_ERROR\r\n", ENCODER);
        session.write((Object)r);
    }

    protected String delete(String key, int time) {
        return this.getDeleteResponseString(this.cache.delete(key, time));
    }

    private String getDeleteResponseString(Cache.DeleteResponse deleteResponse) {
        if (deleteResponse == Cache.DeleteResponse.DELETED) {
            return "DELETED\r\n";
        }
        return "NOT_FOUND\r\n";
    }

    protected String add(MCElement e) {
        return this.getStoreResponseString(this.cache.add(e));
    }

    protected String getStoreResponseString(Cache.StoreResponse storeResponse) {
        switch (storeResponse) {
            case EXISTS: {
                return "EXISTS\r\n";
            }
            case NOT_FOUND: {
                return "NOT_FOUND\r\n";
            }
            case NOT_STORED: {
                return "NOT_STORED\r\n";
            }
            case STORED: {
                return "STORED\r\n";
            }
        }
        throw new RuntimeException("unknown store response from cache: " + (Object)((Object)storeResponse));
    }

    protected String replace(MCElement e) {
        return this.getStoreResponseString(this.cache.replace(e));
    }

    protected String append(MCElement element) {
        return this.getStoreResponseString(this.cache.append(element));
    }

    protected String prepend(MCElement element) {
        return this.getStoreResponseString(this.cache.prepend(element));
    }

    protected String set(MCElement e) {
        return this.getStoreResponseString(this.cache.set(e));
    }

    protected String cas(Long cas_key, MCElement e) {
        return this.getStoreResponseString(this.cache.cas(cas_key, e));
    }

    protected String get_add(String key, int mod) {
        Integer ret = this.cache.get_add(key, mod);
        if (ret == null) {
            return "NOT_FOUND\r\n";
        }
        return String.valueOf(ret) + "\r\n";
    }

    protected boolean is_there(String key) {
        return this.cache.isThere(key);
    }

    protected MCElement get(String key) {
        return this.cache.get(key);
    }

    protected final int Now() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    protected void initStats() {
        curr_bytes = 0L;
        this.curr_conns = 0;
        this.total_conns = 0;
        bytes_read = 0L;
        bytes_written = 0L;
    }

    protected String stat(String arg) {
        StringBuilder builder = new StringBuilder();
        if (arg.equals("keys")) {
            Iterator<String> itr = this.cache.keys().iterator();
            while (itr.hasNext()) {
                builder.append("STAT key ").append((Object)itr.next()).append("\r\n");
            }
            builder.append("END\r\n");
            return builder.toString();
        }
        builder.append("STAT version ").append(this.version).append("\r\n");
        builder.append("STAT cmd_gets ").append(String.valueOf(this.cache.getGetCmds())).append("\r\n");
        builder.append("STAT cmd_sets ").append(String.valueOf(this.cache.getSetCmds())).append("\r\n");
        builder.append("STAT get_hits ").append(String.valueOf(this.cache.getGetHits())).append("\r\n");
        builder.append("STAT get_misses ").append(String.valueOf(this.cache.getGetMisses())).append("\r\n");
        builder.append("STAT curr_connections ").append(String.valueOf(this.curr_conns)).append("\r\n");
        builder.append("STAT total_connections ").append(String.valueOf(this.total_conns)).append("\r\n");
        builder.append("STAT time ").append(String.valueOf(this.Now())).append("\r\n");
        builder.append("STAT uptime ").append(String.valueOf(this.Now() - this.started)).append("\r\n");
        builder.append("STAT cur_items ").append(String.valueOf(this.cache.getCurrentItems())).append("\r\n");
        builder.append("STAT limit_maxbytes ").append(String.valueOf(this.cache.getLimitMaxBytes())).append("\r\n");
        builder.append("STAT current_bytes ").append(String.valueOf(this.cache.getCurrentBytes())).append("\r\n");
        builder.append("STAT free_bytes ").append(String.valueOf(Runtime.getRuntime().freeMemory())).append("\r\n");
        builder.append("STAT pid 0\r\n");
        builder.append("STAT rusage_user 0:0\r\n");
        builder.append("STAT rusage_system 0:0\r\n");
        builder.append("STAT connection_structures 0\r\n");
        builder.append("STAT bytes_read 0\r\n");
        builder.append("STAT bytes_written 0\r\n");
        builder.append("END\r\n");
        return builder.toString();
    }

    protected boolean flush_all() {
        return this.cache.flush_all();
    }

    protected String flush_all(int expire) {
        return this.cache.flush_all(expire) ? "OK\r\n" : "ERROR\r\n";
    }

    static {
        ENCODER = Charset.forName("US-ASCII").newEncoder();
    }
}

