/*
 * Decompiled with CFR 0.152.
 */
package er.caching;

import com.meetup.memcached.MemcachedClient;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERCachingMap<String, V>
implements Map<String, V> {
    private MemcachedClient _client;

    private synchronized MemcachedClient client() {
        if (this._client == null) {
            this._client = new MemcachedClient();
            this._client.setCompressEnable(false);
            this._client.setCompressThreshold(0L);
        }
        return this._client;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.client().keyExists(key.toString());
    }

    @Override
    public V get(Object key) {
        return (V)this.client().get(key.toString());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public V put(String key, V value) {
        return this.put(key, value, 0L);
    }

    public V put(String key, V value, long timeout) {
        V old = null;
        this.client().set(key.toString(), new Date(System.currentTimeMillis() + timeout));
        return old;
    }

    @Override
    public V remove(Object key) {
        V old = this.get(key);
        this.client().delete(key.toString());
        return old;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> arg0) {
        for (String key : arg0.keySet()) {
            this.put(key, arg0.get(key));
        }
    }

    @Override
    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException("Not supported in memcached");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("Not supported in memcached");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported in memcached");
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        throw new UnsupportedOperationException("Not supported in memcached");
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Not supported in memcached");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("Not supported in memcached");
    }
}

