/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.wotaskd;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOHostUtilities;
import com.webobjects.appserver.xml.WOXMLException;
import com.webobjects.appserver.xml._JavaMonitorCoder;
import com.webobjects.appserver.xml._JavaMonitorDecoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.MSiteConfig;
import com.webobjects.monitor._private.MonitorException;
import com.webobjects.monitor.wotaskd.Application;
import com.webobjects.monitor.wotaskd.LocalMonitor;
import java.net.InetAddress;
import java.util.Enumeration;

public class DirectAction
extends WODirectAction {
    private NSMutableDictionary hostResponse;
    private NSDictionary element;
    private static String _hostName;
    private static Object[] hostQueryKeys;
    private static Object[] appQueryKeys;
    private static Object[] instanceQueryKeys;
    private static NSDictionary successElement;
    private static Object[] errorKeys;
    private static String _accessDenied;
    private static String _invalidPassword;
    private static String _invalidXML;
    private static String _emptyXML;
    private static NSDictionary _argumentNumberCommandError;
    private static NSTimestampFormatter aFormat;

    public DirectAction(WORequest aRequest) {
        super(aRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOActionResults monitorRequestAction() {
        NSArray globalArray;
        NSDictionary requestDict;
        Application theApplication = (Application)WOApplication.application();
        MSiteConfig aConfig = theApplication.siteConfig();
        WORequest aRequest = this.request();
        WOResponse aResponse = theApplication.createResponseInContext(null);
        if (aRequest.isUsingWebServer()) {
            NSLog.debug.appendln((Object)"Attempt to call DirectAction: monitorRequestAction through Web server");
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x400000L)) {
                NSLog.debug.appendln((Object)aRequest.contentString());
            }
            aResponse.setStatus(403);
            aResponse.appendContentString(_accessDenied);
            return aResponse;
        }
        theApplication._lock.startReading();
        try {
            String passwordHeader = aRequest.headerForKey((Object)"password");
            if (!aConfig.comparePasswordWithPassword(passwordHeader)) {
                NSLog.debug.appendln((Object)"Attempt to call DirectAction: monitorRequestAction with incorrect password.");
                aResponse.setStatus(403);
                aResponse.appendContentString(_invalidPassword);
                WOResponse wOResponse = aResponse;
                return wOResponse;
            }
        }
        finally {
            theApplication._lock.endReading();
        }
        try {
            requestDict = (NSDictionary)new _JavaMonitorDecoder().decodeRootObject(aRequest.content());
        }
        catch (WOXMLException wxe) {
            NSLog.err.appendln((Object)"Wotaskd monitorRequestAction: Error parsing request");
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
                NSLog.debug.appendln((Object)("Wotaskd monitorRequestAction: " + aRequest.contentString()));
            }
            aResponse.appendContentString(_invalidXML);
            return aResponse;
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"\n@@@@@ monitorRequestAction received request from Monitor");
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("@@@@@ monitorRequestAction requestDict: " + requestDict + "\n"));
        }
        NSMutableDictionary monitorResponse = new NSMutableDictionary();
        NSMutableArray errorResponse = new NSMutableArray();
        NSDictionary updateWotaskdDict = (NSDictionary)requestDict.valueForKey("updateWotaskd");
        NSArray commandWotaskdArray = (NSArray)requestDict.valueForKey("commandWotaskd");
        String queryWotaskdString = (String)requestDict.valueForKey("queryWotaskd");
        if (updateWotaskdDict != null) {
            theApplication._lock.startWriting();
            try {
                NSMutableDictionary updateWotaskdResponse = new NSMutableDictionary(2);
                String clearString = (String)updateWotaskdDict.valueForKey("clear");
                NSDictionary overwriteDict = (NSDictionary)updateWotaskdDict.valueForKey("overwrite");
                NSDictionary syncDict = (NSDictionary)updateWotaskdDict.valueForKey("sync");
                NSDictionary removeDict = (NSDictionary)updateWotaskdDict.valueForKey("remove");
                NSDictionary addDict = (NSDictionary)updateWotaskdDict.valueForKey("add");
                NSDictionary configureDict = (NSDictionary)updateWotaskdDict.valueForKey("configure");
                if (clearString != null) {
                    this.stopAllInstances();
                    ((Application)WOApplication.application()).setSiteConfig(new MSiteConfig(null));
                    updateWotaskdResponse.takeValueForKey((Object)successElement, "clear");
                } else if (overwriteDict != null) {
                    this.stopAllInstances();
                    ((Application)WOApplication.application()).setSiteConfig(new MSiteConfig((NSDictionary)overwriteDict.valueForKey("SiteConfig")));
                    updateWotaskdResponse.takeValueForKey((Object)successElement, "overwrite");
                } else if (syncDict != null) {
                    NSDictionary newConfig = (NSDictionary)syncDict.valueForKey("SiteConfig");
                    this.syncSiteConfig(newConfig);
                } else {
                    NSDictionary anInst;
                    NSMutableArray instanceArrayResponse;
                    NSDictionary anApp;
                    NSMutableArray applicationArrayResponse;
                    NSDictionary aHost;
                    Enumeration e;
                    NSMutableArray hostArrayResponse;
                    NSArray instanceArray;
                    NSArray applicationArray;
                    NSArray hostArray;
                    if (removeDict != null) {
                        String name;
                        NSMutableDictionary removeResponse = new NSMutableDictionary(1);
                        hostArray = (NSArray)removeDict.valueForKey("hostArray");
                        applicationArray = (NSArray)removeDict.valueForKey("applicationArray");
                        instanceArray = (NSArray)removeDict.valueForKey("instanceArray");
                        if (hostArray != null) {
                            hostArrayResponse = new NSMutableArray(hostArray.count());
                            e = hostArray.objectEnumerator();
                            while (e.hasMoreElements()) {
                                aHost = (NSDictionary)e.nextElement();
                                name = (String)aHost.valueForKey("name");
                                MHost anMHost = aConfig.hostWithName(name);
                                if (anMHost == null) {
                                    this.element = new NSDictionary(new Object[]{Boolean.FALSE, _hostName + ": Host " + name + " not found; REMOVE failed"}, errorKeys);
                                    hostArrayResponse.addObject((Object)this.element);
                                    continue;
                                }
                                if (anMHost == aConfig.localHost()) {
                                    this.stopAllInstances();
                                    ((Application)WOApplication.application()).setSiteConfig(new MSiteConfig(null));
                                } else {
                                    aConfig.removeHost_W(anMHost);
                                }
                                hostArrayResponse.addObject((Object)successElement);
                            }
                            removeResponse.takeValueForKey((Object)hostArrayResponse, "hostArray");
                        }
                        if (applicationArray != null) {
                            applicationArrayResponse = new NSMutableArray(applicationArray.count());
                            e = applicationArray.objectEnumerator();
                            while (e.hasMoreElements()) {
                                anApp = (NSDictionary)e.nextElement();
                                name = (String)anApp.valueForKey("name");
                                MApplication anMApplication = aConfig.applicationWithName(name);
                                if (anMApplication == null) {
                                    this.element = new NSDictionary(new Object[]{Boolean.FALSE, _hostName + ": Application " + name + " not found; REMOVE failed"}, errorKeys);
                                    applicationArrayResponse.addObject((Object)this.element);
                                    continue;
                                }
                                aConfig.removeApplication_W(aConfig.applicationWithName(name));
                                applicationArrayResponse.addObject((Object)successElement);
                            }
                            removeResponse.takeValueForKey((Object)applicationArrayResponse, "applicationArray");
                        }
                        if (instanceArray != null) {
                            instanceArrayResponse = new NSMutableArray(instanceArray.count());
                            e = instanceArray.objectEnumerator();
                            while (e.hasMoreElements()) {
                                Integer port;
                                anInst = (NSDictionary)e.nextElement();
                                String hostName = (String)anInst.valueForKey("hostName");
                                MInstance anMInstance = aConfig.instanceWithHostnameAndPort(hostName, port = (Integer)anInst.valueForKey("port"));
                                if (anMInstance == null) {
                                    this.element = new NSDictionary(new Object[]{Boolean.FALSE, _hostName + ": Instance " + hostName + "-" + port + " not found; REMOVE failed"}, errorKeys);
                                    instanceArrayResponse.addObject((Object)this.element);
                                    continue;
                                }
                                aConfig.removeInstance_W(anMInstance);
                                instanceArrayResponse.addObject((Object)successElement);
                            }
                            removeResponse.takeValueForKey((Object)instanceArrayResponse, "instanceArray");
                        }
                        updateWotaskdResponse.takeValueForKey((Object)removeResponse, "remove");
                    }
                    if (addDict != null) {
                        NSMutableDictionary addResponse = new NSMutableDictionary(1);
                        hostArray = (NSArray)addDict.valueForKey("hostArray");
                        applicationArray = (NSArray)addDict.valueForKey("applicationArray");
                        instanceArray = (NSArray)addDict.valueForKey("instanceArray");
                        if (hostArray != null) {
                            hostArrayResponse = new NSMutableArray(hostArray.count());
                            e = hostArray.objectEnumerator();
                            while (e.hasMoreElements()) {
                                aHost = (NSDictionary)e.nextElement();
                                aConfig.addHost_W(new MHost(aHost, aConfig));
                                hostArrayResponse.addObject((Object)successElement);
                            }
                            addResponse.takeValueForKey((Object)hostArrayResponse, "hostArray");
                        }
                        if (applicationArray != null) {
                            applicationArrayResponse = new NSMutableArray(applicationArray.count());
                            e = applicationArray.objectEnumerator();
                            while (e.hasMoreElements()) {
                                anApp = (NSDictionary)e.nextElement();
                                aConfig.addApplication_W(new MApplication(anApp, aConfig));
                                applicationArrayResponse.addObject((Object)successElement);
                            }
                            addResponse.takeValueForKey((Object)applicationArrayResponse, "applicationArray");
                        }
                        if (instanceArray != null) {
                            instanceArrayResponse = new NSMutableArray(instanceArray.count());
                            e = instanceArray.objectEnumerator();
                            while (e.hasMoreElements()) {
                                anInst = (NSDictionary)e.nextElement();
                                aConfig.addInstance_W(new MInstance(anInst, aConfig));
                                instanceArrayResponse.addObject((Object)successElement);
                            }
                            addResponse.takeValueForKey((Object)instanceArrayResponse, "instanceArray");
                        }
                        updateWotaskdResponse.takeValueForKey((Object)addResponse, "add");
                    }
                    if (configureDict != null) {
                        String name;
                        Enumeration e2;
                        NSMutableDictionary configureResponse = new NSMutableDictionary(2);
                        NSDictionary siteDict = (NSDictionary)configureDict.valueForKey("site");
                        NSArray hostArray2 = (NSArray)configureDict.valueForKey("hostArray");
                        NSArray applicationArray2 = (NSArray)configureDict.valueForKey("applicationArray");
                        NSArray instanceArray2 = (NSArray)configureDict.valueForKey("instanceArray");
                        if (siteDict != null) {
                            aConfig.updateValues(siteDict);
                            configureResponse.takeValueForKey((Object)successElement, "site");
                        }
                        if (hostArray2 != null) {
                            NSMutableArray hostArrayResponse2 = new NSMutableArray(hostArray2.count());
                            e2 = hostArray2.objectEnumerator();
                            while (e2.hasMoreElements()) {
                                NSDictionary aHost2 = (NSDictionary)e2.nextElement();
                                name = (String)aHost2.valueForKey("name");
                                MHost anMHost = aConfig.hostWithName(name);
                                if (anMHost == null) {
                                    this.element = new NSDictionary(new Object[]{Boolean.FALSE, _hostName + ": Host " + name + " not found; UPDATE failed"}, errorKeys);
                                    hostArrayResponse2.addObject((Object)this.element);
                                    continue;
                                }
                                anMHost.updateValues(aHost2);
                                hostArrayResponse2.addObject((Object)successElement);
                            }
                            configureResponse.takeValueForKey((Object)hostArrayResponse2, "hostArray");
                        }
                        if (applicationArray2 != null) {
                            NSMutableArray applicationArrayResponse2 = new NSMutableArray(applicationArray2.count());
                            e2 = applicationArray2.objectEnumerator();
                            while (e2.hasMoreElements()) {
                                NSDictionary anApp2 = (NSDictionary)e2.nextElement();
                                name = (String)anApp2.valueForKey("name");
                                MApplication anMApplication = aConfig.applicationWithName(name);
                                if (anMApplication == null) {
                                    name = (String)anApp2.valueForKey("oldname");
                                    anMApplication = aConfig.applicationWithName(name);
                                }
                                if (anMApplication == null) {
                                    this.element = new NSDictionary(new Object[]{Boolean.FALSE, _hostName + ": Application " + name + " not found; UPDATE failed"}, errorKeys);
                                    applicationArrayResponse2.addObject((Object)this.element);
                                    continue;
                                }
                                anMApplication.updateValues(anApp2);
                                applicationArrayResponse2.addObject((Object)successElement);
                            }
                            configureResponse.takeValueForKey((Object)applicationArrayResponse2, "applicationArray");
                        }
                        if (instanceArray2 != null) {
                            NSMutableArray instanceArrayResponse2 = new NSMutableArray(instanceArray2.count());
                            e2 = instanceArray2.objectEnumerator();
                            while (e2.hasMoreElements()) {
                                Integer port;
                                NSDictionary anInst2 = (NSDictionary)e2.nextElement();
                                String hostName = (String)anInst2.valueForKey("hostName");
                                MInstance anMInstance = aConfig.instanceWithHostnameAndPort(hostName, port = (Integer)anInst2.valueForKey("port"));
                                if (anMInstance == null) {
                                    port = (Integer)anInst2.valueForKey("oldport");
                                    anMInstance = aConfig.instanceWithHostnameAndPort(hostName, port);
                                }
                                if (anMInstance == null) {
                                    this.element = new NSDictionary(new Object[]{Boolean.FALSE, _hostName + ": Instance " + hostName + "-" + port + " not found; UPDATE failed"}, errorKeys);
                                    instanceArrayResponse2.addObject((Object)this.element);
                                    continue;
                                }
                                anMInstance.updateValues(anInst2);
                                instanceArrayResponse2.addObject((Object)successElement);
                            }
                            configureResponse.takeValueForKey((Object)instanceArrayResponse2, "instanceArray");
                        }
                        updateWotaskdResponse.takeValueForKey((Object)configureResponse, "configure");
                    }
                }
                monitorResponse.takeValueForKey((Object)updateWotaskdResponse, "updateWotaskdResponse");
            }
            finally {
                theApplication._lock.endWriting();
            }
        }
        if (commandWotaskdArray != null) {
            int instArrayCount = commandWotaskdArray.count();
            NSMutableArray commandWotaskdResponse = new NSMutableArray(instArrayCount);
            if (instArrayCount < 2) {
                commandWotaskdResponse.addObject((Object)_argumentNumberCommandError);
            } else {
                String command = (String)commandWotaskdArray.objectAtIndex(0);
                if (command.equals("START") || command.equals("CLEAR") || command.equals("STOP") || command.equals("REFUSE") || command.equals("ACCEPT") || command.equals("QUIT")) {
                    commandWotaskdResponse.addObject((Object)successElement);
                } else {
                    this.element = new NSDictionary(new Object[]{Boolean.FALSE, _hostName + " - INTERNAL ERROR: Invalid Command " + command}, errorKeys);
                    commandWotaskdResponse.addObject((Object)this.element);
                }
                for (int i = 1; i < instArrayCount; ++i) {
                    NSDictionary instDict = (NSDictionary)commandWotaskdArray.objectAtIndex(i);
                    String hostName = (String)instDict.valueForKey("hostName");
                    Integer port = (Integer)instDict.valueForKey("port");
                    theApplication._lock.startReading();
                    try {
                        MInstance anInstance = aConfig.instanceWithHostnameAndPort(hostName, port);
                        if (anInstance != null) {
                            if (anInstance.isLocal_W()) {
                                if (command.equals("START")) {
                                    String errorMsg = theApplication.localMonitor().startInstance(anInstance);
                                    if (errorMsg == null) continue;
                                    this.element = new NSDictionary(new Object[]{Boolean.FALSE, errorMsg}, errorKeys);
                                    commandWotaskdResponse.addObject((Object)this.element);
                                    continue;
                                }
                                if (command.equals("CLEAR")) {
                                    anInstance.removeAllDeaths();
                                    commandWotaskdResponse.addObject((Object)successElement);
                                    continue;
                                }
                                try {
                                    if (command.equals("STOP")) {
                                        if (theApplication.localMonitor().terminateInstance(anInstance) == null) {
                                            throw new MonitorException("No response to STOP " + anInstance.displayName());
                                        }
                                    } else if (command.equals("REFUSE")) {
                                        if (theApplication.localMonitor().stopInstance(anInstance) == null) {
                                            throw new MonitorException("No response to REFUSE " + anInstance.displayName());
                                        }
                                    } else if (command.equals("ACCEPT")) {
                                        if (theApplication.localMonitor().setAcceptInstance(anInstance) == null) {
                                            throw new MonitorException("No response to ACCEPT " + anInstance.displayName());
                                        }
                                        anInstance.cancelForceQuitTask();
                                    } else if (command.equals("QUIT")) {
                                        anInstance.setShouldDie(true);
                                    }
                                    commandWotaskdResponse.addObject((Object)successElement);
                                }
                                catch (MonitorException me) {
                                    this.element = new NSDictionary(new Object[]{Boolean.FALSE, me.getMessage()}, errorKeys);
                                    commandWotaskdResponse.addObject((Object)this.element);
                                }
                                continue;
                            }
                            commandWotaskdResponse.addObject((Object)successElement);
                            continue;
                        }
                        this.element = new NSDictionary(new Object[]{Boolean.FALSE, _hostName + ": No instance found for Host " + hostName + " and Port: " + port + "; " + command + " failed"}, errorKeys);
                        commandWotaskdResponse.addObject((Object)this.element);
                        continue;
                    }
                    finally {
                        theApplication._lock.endReading();
                    }
                }
            }
            monitorResponse.takeValueForKey((Object)commandWotaskdResponse, "commandWotaskdResponse");
        }
        if (queryWotaskdString != null) {
            NSMutableDictionary queryWotaskdResponse = new NSMutableDictionary(1);
            if (queryWotaskdString.equals("SITE")) {
                theApplication._lock.startReading();
                try {
                    queryWotaskdResponse.takeValueForKey((Object)aConfig.dictionaryForArchive(), "SiteConfig");
                }
                finally {
                    theApplication._lock.endReading();
                }
            }
            if (queryWotaskdString.equals("HOST")) {
                if (this.hostResponse == null) {
                    Integer runningInstances = new Integer(0);
                    String processorType = System.getProperties().getProperty("os.arch");
                    String operatingSystem = System.getProperties().getProperty("os.name") + " " + System.getProperties().getProperty("os.version");
                    this.hostResponse = new NSMutableDictionary(new Object[]{runningInstances, processorType, operatingSystem}, hostQueryKeys);
                }
                theApplication._lock.startReading();
                try {
                    if (aConfig.localHost() != null) {
                        this.hostResponse.takeValueForKey((Object)aConfig.localHost().runningInstancesCount_W(), "runningInstances");
                    } else {
                        this.hostResponse.takeValueForKey((Object)_NSUtilities.IntegerForInt((int)0), "runningInstances");
                    }
                }
                finally {
                    theApplication._lock.endReading();
                }
                queryWotaskdResponse.takeValueForKey((Object)this.hostResponse, "hostResponse");
            } else if (queryWotaskdString.equals("APPLICATION")) {
                NSMutableArray applicationResponse = null;
                theApplication._lock.startReading();
                try {
                    NSMutableArray appArray = aConfig.applicationArray();
                    int appArrayCount = appArray.count();
                    applicationResponse = new NSMutableArray(appArrayCount);
                    for (int i = 0; i < appArrayCount; ++i) {
                        MApplication anApp = (MApplication)appArray.objectAtIndex(i);
                        String name = anApp.name();
                        Integer runningInstances = anApp.runningInstancesCount_W();
                        NSDictionary elementApp = new NSDictionary(new Object[]{name, runningInstances}, appQueryKeys);
                        applicationResponse.addObject((Object)elementApp);
                    }
                }
                finally {
                    theApplication._lock.endReading();
                }
                queryWotaskdResponse.takeValueForKey((Object)applicationResponse, "applicationResponse");
            } else if (queryWotaskdString.equals("INSTANCE")) {
                NSMutableArray instanceResponse = null;
                theApplication._lock.startReading();
                try {
                    NSArray instanceArray = aConfig.localHost() != null ? aConfig.localHost().instanceArray() : NSArray.EmptyArray;
                    int instanceArrayCount = instanceArray.count();
                    instanceResponse = new NSMutableArray(instanceArrayCount);
                    NSMutableArray runningInstanceArray = new NSMutableArray();
                    Enumeration e = instanceArray.objectEnumerator();
                    while (e.hasMoreElements()) {
                        MInstance anInst = (MInstance)e.nextElement();
                        if (!anInst.isRunning_W()) continue;
                        runningInstanceArray.addObject((Object)anInst);
                    }
                    this.getStatisticsForInstanceArray((NSArray)runningInstanceArray, errorResponse);
                    for (int i = 0; i < instanceArrayCount; ++i) {
                        MInstance anInstance = (MInstance)instanceArray.objectAtIndex(i);
                        String error = anInstance.statisticsError();
                        if (error != null) {
                            errorResponse.addObject((Object)error);
                            anInstance.resetStatisticsError();
                        }
                        String applicationName = anInstance.applicationName();
                        Integer id = anInstance.id();
                        String host = anInstance.hostName();
                        Integer port = anInstance.port();
                        String runningState = MObject.stateArray[anInstance.state];
                        NSDictionary statistics = anInstance.statistics();
                        Boolean refusingNewSessions = anInstance.isRefusingNewSessions() ? Boolean.TRUE : Boolean.FALSE;
                        NSMutableArray deaths = anInstance.deaths();
                        String nextShutdown = anInstance.nextScheduledShutdownString();
                        NSDictionary elementInst = new NSDictionary(new Object[]{applicationName, id, host, port, runningState, refusingNewSessions, statistics, deaths, nextShutdown}, instanceQueryKeys);
                        instanceResponse.addObject((Object)elementInst);
                    }
                }
                finally {
                    theApplication._lock.endReading();
                }
                queryWotaskdResponse.takeValueForKey((Object)instanceResponse, "instanceResponse");
            } else {
                errorResponse.addObject((Object)(_hostName + ": Unrecognized Query: " + queryWotaskdString));
            }
            monitorResponse.takeValueForKey((Object)queryWotaskdResponse, "queryWotaskdResponse");
        }
        if ((globalArray = theApplication.siteConfig().globalErrorDictionary.allValues()) != null && globalArray.count() > 0) {
            errorResponse.addObjectsFromArray(globalArray);
            theApplication.siteConfig().globalErrorDictionary = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        }
        if (errorResponse.count() != 0) {
            monitorResponse.takeValueForKey((Object)errorResponse, "errorResponse");
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"@@@@@ monitorRequestAction returning response to Monitor");
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("@@@@@ monitorRequestAction responseDict: " + monitorResponse + "\n"));
        }
        aResponse.appendContentString(new _JavaMonitorCoder().encodeRootObjectForKey((Object)monitorResponse, "monitorResponse"));
        return aResponse;
    }

    private void getStatisticsForInstanceArray(NSArray instArray, NSMutableArray errorResponse) {
        final LocalMonitor localMonitor = ((Application)WOApplication.application()).localMonitor();
        final NSArray instanceArray = instArray;
        int theCount = instanceArray.count();
        if (theCount == 0) {
            return;
        }
        Thread[] workers = new Thread[theCount];
        final WOResponse[] responses = new WOResponse[theCount];
        int i = 0;
        while (i < theCount) {
            final int j = i++;
            Runnable work = new Runnable(){

                public void run() {
                    try {
                        responses[j] = localMonitor.queryInstance((MInstance)instanceArray.objectAtIndex(j));
                    }
                    catch (MonitorException me) {
                        MInstance badInstance = (MInstance)instanceArray.objectAtIndex(j);
                        if (!badInstance.isRunning_W() && NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x400000L)) {
                            NSLog.debug.appendln((Object)("Exception getting Statistics for instance: " + ((MInstance)instanceArray.objectAtIndex(j)).displayName()));
                        }
                        if (badInstance.isRunning_W()) {
                            badInstance.setStatisticsError(me.getMessage());
                        }
                        responses[j] = null;
                    }
                }
            };
            workers[j] = new Thread(work);
            workers[j].start();
        }
        try {
            for (i = 0; i < theCount; ++i) {
                workers[i].join();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        for (i = 0; i < theCount; ++i) {
            WOResponse aResponse = responses[i];
            MInstance anInstance = (MInstance)instArray.objectAtIndex(i);
            if (aResponse != null) {
                anInstance.updateRegistration(new NSTimestamp());
                if (aResponse.headerForKey((Object)"x-webobjects-refusenewsessions") != null) {
                    anInstance.setRefusingNewSessions(true);
                } else {
                    anInstance.setRefusingNewSessions(false);
                }
                NSDictionary instanceResponse = null;
                NSData responseContent = aResponse.content();
                try {
                    instanceResponse = (NSDictionary)new _JavaMonitorDecoder().decodeRootObject(responseContent);
                }
                catch (WOXMLException wxe) {
                    try {
                        Object o = NSPropertyListSerialization.propertyListFromString((String)new String(responseContent.bytes()));
                        errorResponse.addObject((Object)(anInstance.displayName() + " is probably an older application that doesn't conform to the current Monitor Protocol. Please update and restart the instance."));
                        NSLog.err.appendln((Object)("Got old-style response from instance: " + anInstance.displayName()));
                    }
                    catch (Throwable t) {
                        NSLog.err.appendln((Object)("Wotaskd getStatisticsForInstanceArray: Error parsing: " + new String(responseContent.bytes()) + " from " + anInstance.displayName()));
                    }
                    continue;
                }
                catch (NullPointerException npe) {
                    NSLog.err.appendln((Object)("Wotaskd getStatisticsForInstanceArray: No content returned from " + anInstance.displayName()));
                    continue;
                }
                NSArray queryInstanceError = (NSArray)instanceResponse.valueForKey("errorResponse");
                if (queryInstanceError != null) {
                    anInstance.setStatisticsError(queryInstanceError.componentsJoinedByString(", "));
                    continue;
                }
                String queryInstanceResponse = (String)instanceResponse.valueForKey("queryInstanceResponse");
                if (queryInstanceResponse == null) continue;
                try {
                    NSDictionary statistics = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)queryInstanceResponse);
                    NSMutableDictionary newStats = new NSMutableDictionary(5);
                    newStats.takeValueForKey((Object)((String)statistics.valueForKey("StartedAt")), "startedAt");
                    NSDictionary tempDict = (NSDictionary)statistics.valueForKey("Transactions");
                    newStats.takeValueForKey((Object)((String)tempDict.valueForKey("Transactions")), "transactions");
                    newStats.takeValueForKey((Object)((String)tempDict.valueForKey("Avg. Transaction Time")), "avgTransactionTime");
                    newStats.takeValueForKey((Object)((String)tempDict.valueForKey("Avg. Idle Time")), "averageIdlePeriod");
                    tempDict = (NSDictionary)statistics.valueForKey("Sessions");
                    newStats.takeValueForKey((Object)((String)tempDict.valueForKey("Current Active Sessions")), "activeSessions");
                    anInstance.setStatistics((NSDictionary)newStats);
                }
                catch (Exception e) {
                    NSLog.err.appendln((Object)("Wotaskd getStatisticsForInstanceArray: Error parsing PList: " + queryInstanceResponse + " from " + anInstance.displayName()));
                }
                continue;
            }
            if (!anInstance.isRunning_M()) continue;
            anInstance.setStatisticsError("No statistics for " + anInstance.displayName());
        }
    }

    private void syncSiteConfig(NSDictionary config) {
        Enumeration e;
        Enumeration e2;
        Enumeration e3;
        NSDictionary newConfig = config;
        Application theApplication = (Application)WOApplication.application();
        MSiteConfig aConfig = theApplication.siteConfig();
        NSDictionary siteDict = (NSDictionary)config.valueForKey("site");
        NSArray hostArray = (NSArray)config.valueForKey("hostArray");
        NSArray applicationArray = (NSArray)config.valueForKey("applicationArray");
        NSArray instanceArray = (NSArray)config.valueForKey("instanceArray");
        if (siteDict != null) {
            aConfig.updateValues(siteDict);
        }
        NSMutableArray currentHosts = new NSMutableArray((NSArray)aConfig.hostArray());
        if (hostArray != null) {
            e3 = hostArray.objectEnumerator();
            while (e3.hasMoreElements()) {
                NSDictionary aHost = (NSDictionary)e3.nextElement();
                String name = (String)aHost.valueForKey("name");
                MHost anMHost = aConfig.hostWithName(name);
                if (anMHost == null) {
                    aConfig.addHost_W(new MHost(aHost, aConfig));
                    continue;
                }
                anMHost.updateValues(aHost);
                currentHosts.removeObject((Object)anMHost);
            }
        }
        e3 = currentHosts.objectEnumerator();
        while (e3.hasMoreElements()) {
            MHost anMHost = (MHost)e3.nextElement();
            if (anMHost == aConfig.localHost()) {
                this.stopAllInstances();
                ((Application)WOApplication.application()).setSiteConfig(new MSiteConfig(null));
                break;
            }
            aConfig.removeHost_W(anMHost);
        }
        NSMutableArray currentApplications = new NSMutableArray((NSArray)aConfig.applicationArray());
        if (applicationArray != null) {
            e2 = applicationArray.objectEnumerator();
            while (e2.hasMoreElements()) {
                NSDictionary anApp = (NSDictionary)e2.nextElement();
                String name = (String)anApp.valueForKey("name");
                MApplication anMApplication = aConfig.applicationWithName(name);
                if (anMApplication == null) {
                    name = (String)anApp.valueForKey("oldname");
                    anMApplication = aConfig.applicationWithName(name);
                }
                if (anMApplication == null) {
                    aConfig.addApplication_W(new MApplication(anApp, aConfig));
                    continue;
                }
                anMApplication.updateValues(anApp);
                currentApplications.removeObject((Object)anMApplication);
            }
        }
        e2 = currentApplications.objectEnumerator();
        while (e2.hasMoreElements()) {
            aConfig.removeApplication_W((MApplication)e2.nextElement());
        }
        NSMutableArray currentInstances = new NSMutableArray((NSArray)aConfig.instanceArray());
        if (instanceArray != null) {
            e = instanceArray.objectEnumerator();
            while (e.hasMoreElements()) {
                Integer port;
                NSDictionary anInst = (NSDictionary)e.nextElement();
                String hostName = (String)anInst.valueForKey("hostName");
                MInstance anMInstance = aConfig.instanceWithHostnameAndPort(hostName, port = (Integer)anInst.valueForKey("port"));
                if (anMInstance == null) {
                    port = (Integer)anInst.valueForKey("oldport");
                    anMInstance = aConfig.instanceWithHostnameAndPort(hostName, port);
                }
                if (anMInstance == null) {
                    aConfig.addInstance_W(new MInstance(anInst, aConfig));
                    continue;
                }
                anMInstance.updateValues(anInst);
                currentInstances.removeObject((Object)anMInstance);
            }
        }
        e = currentInstances.objectEnumerator();
        while (e.hasMoreElements()) {
            aConfig.removeInstance_W((MInstance)e.nextElement());
        }
    }

    private void stopAllInstances() {
        final LocalMonitor localMonitor = ((Application)WOApplication.application()).localMonitor();
        NSMutableArray instanceArray = ((Application)WOApplication.application()).siteConfig().instanceArray();
        int theCount = instanceArray.count();
        if (theCount == 0) {
            return;
        }
        Thread[] workers = new Thread[theCount];
        int i = 0;
        while (i < theCount) {
            int j = i++;
            Runnable work = new Runnable((NSArray)instanceArray, j){
                final /* synthetic */ NSArray val$instanceArray;
                final /* synthetic */ int val$j;
                {
                    this.val$instanceArray = nSArray;
                    this.val$j = n;
                }

                public void run() {
                    try {
                        localMonitor.stopInstance((MInstance)this.val$instanceArray.objectAtIndex(this.val$j));
                    }
                    catch (MonitorException monitorException) {
                        // empty catch block
                    }
                }
            };
            workers[j] = new Thread(work);
            workers[j].start();
        }
        try {
            for (i = 0; i < theCount; ++i) {
                workers[i].join();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOActionResults defaultAction() {
        Application theApplication = (Application)WOApplication.application();
        WOResponse aResponse = theApplication.createResponseInContext(null);
        WORequest aRequest = this.request();
        MSiteConfig aConfig = theApplication.siteConfig();
        theApplication._lock.startReading();
        try {
            String passwordHeader = aRequest.headerForKey((Object)"password");
            if (!aConfig.comparePasswordWithPassword(passwordHeader)) {
                NSLog.debug.appendln((Object)"Attempt to call Direct Action: defaultAction with incorrect password.");
                aResponse.setStatus(403);
                aResponse.appendContentString("Attempt to call Direct Action: defaultAction on wotaskd with incorrect password.");
                WOResponse wOResponse = aResponse;
                return wOResponse;
            }
            aResponse.appendContentString("<html><head><title>Wotaskd for WebObjects 5</title></head><body>");
            aResponse.appendContentString("<center><b>Wotaskd for WebObjects 5: " + _hostName + "</b></center>");
            aResponse.appendContentString("<br><br><hr><br>Site Config as written to disk<br><hr><br><pre>");
            aResponse.appendContentString(WOMessage.stringByEscapingHTMLString((String)aConfig.generateSiteConfigXML()));
            aResponse.appendContentString("</pre><br><br><hr><br>Adaptor Config as sent to Local WOAdaptors - All Running Applications and Instances<br><hr><br><pre>");
            aResponse.appendContentString(WOMessage.stringByEscapingHTMLString((String)aConfig.generateAdaptorConfigXML(true, true)));
            aResponse.appendContentString("</pre><br><br><br><br>Adaptor Config as sent to remote WOAdaptors - All Registered and Running Applications and Instances<br><hr><br><pre>");
            aResponse.appendContentString(WOMessage.stringByEscapingHTMLString((String)aConfig.generateAdaptorConfigXML(true, false)));
            aResponse.appendContentString("</pre><br><br><hr><br>Adaptor Config as written to disk - All Registered Applications and Instances<br><hr><br><pre>");
            aResponse.appendContentString(WOMessage.stringByEscapingHTMLString((String)aConfig.generateAdaptorConfigXML(false, false)));
            aResponse.appendContentString("</pre><br><br><hr><br>Properties of this wotaskd<br><hr><br><pre>");
            aResponse.appendContentString("The Configuration Directory is: " + MSiteConfig.configDirectoryPath());
            aResponse.appendContentString("<br>");
            if (((Application)WOApplication.application()).shouldWriteAdaptorConfig()) {
                aResponse.appendContentString("Wotaskd is writing WOConfig.xml to disk");
            } else {
                aResponse.appendContentString("Wotaskd is NOT writing WOConfig.xml to disk");
            }
            aResponse.appendContentString("<br>");
            aResponse.appendContentString("The multicast address is: " + ((Application)WOApplication.application()).multicastAddress());
            aResponse.appendContentString("<br>");
            aResponse.appendContentString("This wotaskd is running on Port: " + WOApplication.application().port());
            aResponse.appendContentString("<br>");
            if (((Application)WOApplication.application()).shouldRespondToMulticast()) {
                aResponse.appendContentString("Wotaskd is responding to Multicast");
            } else {
                aResponse.appendContentString("Wotaskd is NOT responding to Multicast");
            }
            aResponse.appendContentString("<br>");
            aResponse.appendContentString("WOAssumeApplicationIsDeadMultiplier is " + aConfig._appIsDeadMultiplier / 1000);
            aResponse.appendContentString("<br>");
            aResponse.appendContentString("The System Properties are: ");
            aResponse.appendContentString(WOMessage.stringByEscapingHTMLString((String)System.getProperties().toString()));
            aResponse.appendContentString("</pre><br><br></body></html>");
        }
        finally {
            theApplication._lock.endReading();
        }
        return aResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse woconfigAction() {
        String xml;
        Application theApplication = (Application)WOApplication.application();
        WORequest aRequest = this.request();
        boolean shouldIncludeUnregisteredInstances = WOHostUtilities.isAnyLocalInetAddress((InetAddress)aRequest._originatingAddress(), (boolean)false);
        theApplication._lock.startReading();
        try {
            xml = ((Application)WOApplication.application()).siteConfig().generateAdaptorConfigXML(true, shouldIncludeUnregisteredInstances);
        }
        finally {
            theApplication._lock.endReading();
        }
        WOResponse aResponse = WOApplication.application().createResponseInContext(null);
        aResponse.appendContentString(xml);
        aResponse.setHeader("text/xml", "content-type");
        aResponse.setHeader(aFormat.format((Object)new NSTimestamp()), "Last-Modified");
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("woConfigAction returned: " + xml));
        }
        return aResponse;
    }

    public WOActionResults findPortAction() {
        Application theApplication = (Application)WOApplication.application();
        WOResponse aResponse = theApplication.createResponseInContext(null);
        WORequest aRequest = this.request();
        String portString = null;
        if (WOHostUtilities.isAnyLocalInetAddress((InetAddress)aRequest._originatingAddress(), (boolean)false)) {
            String anAppName = this.request().stringFormValueForKey("appName");
            portString = theApplication.localMonitor().portForUnregisteredAppNamed(anAppName);
        }
        if (portString == null) {
            portString = "-1";
        }
        aResponse.appendContentString(portString);
        return aResponse;
    }

    static {
        aFormat = null;
        _hostName = WOApplication.application().host();
        hostQueryKeys = new Object[]{"runningInstances", "processorType", "operatingSystem"};
        appQueryKeys = new Object[]{"name", "runningInstances"};
        instanceQueryKeys = new Object[]{"applicationName", "id", "host", "port", "runningState", "refusingNewSessions", "statistics", "deaths", "nextShutdown"};
        successElement = new NSDictionary(new Object[]{Boolean.TRUE}, new Object[]{"success"});
        errorKeys = new Object[]{"success", "errorMessage"};
        _accessDenied = new _JavaMonitorCoder().encodeRootObjectForKey((Object)new NSDictionary((Object)new NSArray((Object)(_hostName + ": wotaskd may not be accessed through a Web server - Access Denied")), (Object)"errorResponse"), "monitorResponse");
        _invalidPassword = new _JavaMonitorCoder().encodeRootObjectForKey((Object)new NSDictionary((Object)new NSArray((Object)(_hostName + ": Invalid Password - Access Denied")), (Object)"errorResponse"), "monitorResponse");
        _invalidXML = new _JavaMonitorCoder().encodeRootObjectForKey((Object)new NSDictionary((Object)new NSArray((Object)(_hostName + " - INTERNAL ERROR: Request from Monitor was Invalid")), (Object)"errorResponse"), "monitorResponse");
        _emptyXML = new _JavaMonitorCoder().encodeRootObjectForKey((Object)new NSDictionary((Object)new NSArray((Object)(_hostName + " - INTERNAL ERROR: Request from Monitor was Empty")), (Object)"errorResponse"), "monitorResponse");
        _argumentNumberCommandError = new NSDictionary(new Object[]{Boolean.FALSE, _hostName + " - INTERNAL ERROR: Not enough elements: Need 'commandString' + 'arrayOfInstances'"}, errorKeys);
        aFormat = new NSTimestampFormatter("%a, %d %b %Y %H:%M:%S GMT");
        aFormat.setDefaultFormatTimeZone(NSTimeZone.timeZoneWithName((String)"GMT", (boolean)true));
    }
}

