/*
 * Decompiled with CFR 0.152.
 */
package webobjectsexamples.businesslogic.movies.common;

import webobjectsexamples.businesslogic.movies.common._Voting;

public class Voting
extends _Voting {
    private static final long serialVersionUID = 7584225995972371006L;
    public static final String MovieKey = "movie";
    public static final String NumberOfVotesKey = "numberOfVotes";
    public static final String RunningAverageKey = "runningAverage";

    public Number getNumberOfVotes() {
        Number numberOfVotes = (Number)this.storedValueForKey(NumberOfVotesKey);
        return numberOfVotes != null ? (Number)numberOfVotes : (Number)new Integer(0);
    }

    public void setNumberOfVotes(Number value) {
        this.takeStoredValueForKey(value, NumberOfVotesKey);
    }

    public Number getRunningAverage() {
        Number runningAverage = (Number)this.storedValueForKey(RunningAverageKey);
        return runningAverage != null ? (Number)runningAverage : (Number)new Double(0.0);
    }

    public void setRunningAverage(Number value) {
        this.takeStoredValueForKey(value, RunningAverageKey);
    }

    public void addVote(int vote) {
        if (vote >= 0 && vote <= 10) {
            int numberOfVotes = this.getNumberOfVotes().intValue();
            double total = this.getRunningAverage().doubleValue() * (double)numberOfVotes + (double)vote;
            this.setNumberOfVotes(new Integer(++numberOfVotes));
            this.setRunningAverage(new Double(total / (double)numberOfVotes));
        }
    }
}

